/***************************************************************************
                            kde_KIntNumInput.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KINTNUMINPUT
#define KDE_KINTNUMINPUT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 KIntNumInput combines a @ref QSpinBox and optionally a @ref QSlider
 with a label to make an easy to use control for setting some integer
 parameter. This is especially nice for configuration dialogs,
 which can have many such combinated controls.

 The slider is created only when the user specifies a range
 for the control using the setRange function with the slider
 parameter set to "true".

 A special feature of KIntNumInput, designed specifically for
 the situation when there are several KIntNumInputs in a column,
 is that you can specify what portion of the control is taken by the
 QSpinBox (the remaining portion is used by the slider). This makes
 it very simple to have all the sliders in a column be the same size.

 It uses @ref KIntValidator validator class. KIntNumInput enforces the
 value to be in the given range, and can display it in any base
 between 2 and 36.

 @version $Id: kde_KIntNumInput.h,v 1.3 2002/02/21 00:43:10 rdale Exp $
 
 @short An input widget for integer numbers, consisting of a spinbox and a slider.

*/

/** 
 Constructs an input control for integer values
 with base 10 and initial value 0.
     
*/
kde_KIntNumInput * kde_new_KIntNumInput(qt_QWidget * parent, char* name);

/** 
 Constructor
 It constructs a QSpinBox that allows the input of integer numbers
 in the range of -INT_MAX to +INT_MAX. To set a descriptive label,
 use setLabel(). To enforce the value being in a range and optionally to
 attach a slider to it, use setRange().

*/
kde_KIntNumInput * kde_new_KIntNumInput1(int value, qt_QWidget * parent, int base, char* name);

/** 
 Constructor

 the difference to the one above is the "below" parameter. It tells
 this instance that it is visually put below some other KNumInput widget.
 Note that these two KNumInput's need not to have the same parent widget
 or be in the same layout group.
 The effect is that it'll adjust it's layout in correspondence
 with the layout of the other KNumInput's (you can build an arbitary long
 chain).

*/
kde_KIntNumInput * kde_new_KIntNumInput2(kde_KNumInput* below, int value, qt_QWidget * parent, int base, char* name);

/** 
 Destructor

     
*/
void kde_del_KIntNumInput( kde_KIntNumInput* p );

/** 

*/
int kde_KIntNumInput_value(kde_KIntNumInput* instPointer);

/** 

*/
qt_QString * kde_KIntNumInput_suffix(kde_KIntNumInput* instPointer);

/** 

*/
qt_QString * kde_KIntNumInput_prefix(kde_KIntNumInput* instPointer);

/** 

*/
qt_QString * kde_KIntNumInput_specialValueText(kde_KIntNumInput* instPointer);

/** 

*/
void kde_KIntNumInput_setRange(kde_KIntNumInput* instPointer,int min, int max, int step, int slider);

/** 
 Sets the minimum value.
     
*/
void kde_KIntNumInput_setMinValue(kde_KIntNumInput* instPointer,int min);

/** 

*/
int kde_KIntNumInput_minValue(kde_KIntNumInput* instPointer);

/** 
 Sets the maximum value.
     
*/
void kde_KIntNumInput_setMaxValue(kde_KIntNumInput* instPointer,int max);

/** 

*/
int kde_KIntNumInput_maxValue(kde_KIntNumInput* instPointer);

/** 
 Sets the special value text. If set, the SpinBox will display
 this text instead of the numeric value whenever the current
 value is equal to minVal(). Typically this is used for indicating
 that the choice has a special (default) meaning.
     
*/
void kde_KIntNumInput_setSpecialValueText(kde_KIntNumInput* instPointer,qt_QString * text);

/** 
 This method returns the minimum size necessary to display the
 control. The minimum size is enough to show all the labels
 in the current font (font change may invalidate the return value).

*/
qt_QSize * kde_KIntNumInput_minimumSizeHint(kde_KIntNumInput* instPointer);

/** 
 Sets the value of the control.
     
*/
void kde_KIntNumInput_setValue(kde_KIntNumInput* instPointer,int arg1);

/** 
 Sets the suffix to @p suffix.
 Use QString::null to disable this feature.
 Formatting has to be provided (e.g. a space separator between the
 prepended @p value and the suffix's text has to be provided
 as the first character in the suffix).

*/
void kde_KIntNumInput_setSuffix(kde_KIntNumInput* instPointer,qt_QString * suffix);

/** 
 Sets the prefix to @p prefix.
 Use QString::null to disable this feature.
 Formatting has to be provided (see above).

*/
void kde_KIntNumInput_setPrefix(kde_KIntNumInput* instPointer,qt_QString * prefix);

/** 
 sets focus to the edit widget and marks all text in if mark == true

     
*/
void kde_KIntNumInput_setEditFocus(kde_KIntNumInput* instPointer,int mark);

#endif
