/***************************************************************************
                            kde_KKeyDialog.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KKEYDIALOG
#define KDE_KKEYDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 The KKeyDialog class is used for configuring dictionaries of key/action
 associations for KAccel and KGlobalAccel. It uses the KKeyChooser widget
 and offers buttons to set all keys to defaults and invoke on-line help.

 Three static methods are supplied which provide the most convienient interface
 to the dialog. For example you could use KAccel and KKeyDialog like this

 <pre>
 KAccel keys;

 keys.insertItem( i18n( "Zoom in" ), "Zoom in", "+" );
 keys.connectItem( "Zoom in", myWindow, SLOT( zoomIn() ) );

 keys.connectItem( KAccel::Print, myWindow, SLOT( print() ) );

 keys.readSettings();

 if( KKeyDialog::configureKeys( &keys ) ) {
	      ...
 }
 </pre>

 This will also implicitly save the settings. If you don't want this,
 you can call

 <pre>
 if( KKeyDialog::configureKeys( &keys, false ) ) { // do not save settings
	      ...
 }
 </pre>

 For XML-UI applications, this is much simpler. All you need to do is
 <pre>
 KKeyDialog::configureKeys(actionCollection(), xmlFile());
 </pre>

 @author Nicolas Hadacek <hadacek@via.ecp.fr>
 
 @version $Id: kde_KKeyDialog.h,v 1.3 2002/02/21 00:43:11 rdale Exp $

 @short Dialog for configuration of @ref KAccel and @ref KGlobalAccel.

*/
kde_KKeyDialog * kde_new_KKeyDialog(int bAllowLetterShortcuts, qt_QWidget * parent, char* name);
void kde_del_KKeyDialog( kde_KKeyDialog* p );
int kde_KKeyDialog_insert(kde_KKeyDialog* instPointer,kde_KActionCollection* arg1);
int kde_KKeyDialog_configure(kde_KKeyDialog* instPointer,int bSaveSettings);
void kde_KKeyDialog_commitChanges(kde_KKeyDialog* instPointer);

/** 
 Pops up a modal dialog for configuring key settings. The dialog is initialized
 from a @ref KAccelBase object, and the modifications are written to that object
 when the dialog is closed.

*/
int kde_KKeyDialog_configure1( kde_KAccel* keys, qt_QWidget * parent, int bSaveSettings);
int kde_KKeyDialog_configure2( kde_KGlobalAccel* keys, qt_QWidget * parent, int bSaveSettings);

/** 
 Pops up a modal dialog for configuring key settings. The dialog is initialized
 from an action collection (for XMLGUI based applications).

*/
int kde_KKeyDialog_configure3( kde_KActionCollection* coll, qt_QWidget * parent, int bSaveSettings);
int kde_KKeyDialog_configureKeys( kde_KAccel* keys, int save_settings, qt_QWidget * parent);
int kde_KKeyDialog_configureKeys1( kde_KGlobalAccel* keys, int save_settings, qt_QWidget * parent);
int kde_KKeyDialog_configureKeys2( kde_KActionCollection* coll, qt_QString * arg1, int save_settings, qt_QWidget * parent);

#endif
