/***************************************************************************
                            kde_KPasswordDialog.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPASSWORDDIALOG
#define KDE_KPASSWORDDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This dialog asks the user to enter a password. The functions you're 
 probably interested in are the static methods, @ref #getPassword() and
 @ref #getNewPassword().

 <pre>
 QCString password;
 int result = KPasswordDialog::getPassword(password, i18n("Password"));
 if (result == KPasswordDialog::Accepted)
     use(password);
 </pre>

 Keeping passwords in memory can be a potential security hole. You should
 handle this situation with care.

 @author Geert Jansen <jansen@kde.org>
 
 @short A password input dialog.

*/
#define KPASSWORDDIALOG_Password	0
#define KPASSWORDDIALOG_NewPassword	1

/** 
 Constructs a password dialog.

*/
kde_KPasswordDialog * kde_new_KPasswordDialog(int type, int enableKeep, int extraBttn, qt_QWidget * parent, char* name);

/** 

 possibility to specify a parent. May be removed in KDE 4.0
     
*/
kde_KPasswordDialog * kde_new_KPasswordDialog1(int type, qt_QString * prompt, int enableKeep, int extraBttn);

/** 
 Destructs the password dialog.
     
*/
void kde_del_KPasswordDialog( kde_KPasswordDialog* p );

/** 
 Sets the password prompt.
     
*/
void kde_KPasswordDialog_setPrompt(kde_KPasswordDialog* instPointer,qt_QString * prompt);

/** 
 Returns the password prompt.
     
*/
qt_QString * kde_KPasswordDialog_prompt(kde_KPasswordDialog* instPointer);

/** 
 Adds a line of information to the dialog.
     
*/
void kde_KPasswordDialog_addLine(kde_KPasswordDialog* instPointer,qt_QString * key, qt_QString * value);

/**  
 Returns the password entered. The memory is freed in the destructor,
 so you should make a copy.
     
*/
char* kde_KPasswordDialog_password(kde_KPasswordDialog* instPointer);

/**  Returns true if the user wants to keep the password. 
*/
int kde_KPasswordDialog_keep(kde_KPasswordDialog* instPointer);

/** 
 Pops up the dialog, asks the user for a password, and returns it.

*/
int kde_KPasswordDialog_getPassword( qt_QCString* password, qt_QString * prompt, int* keep);

/**  
 Pops up the dialog, asks the user for a password and returns it. The
 user has to enter the password twice to make sure it was entered
 correctly.

*/
int kde_KPasswordDialog_getNewPassword( qt_QCString* password, qt_QString * prompt);

/**  Static helper funtion that disables core dumps. 
*/
void kde_KPasswordDialog_disableCoreDumps( );

/**  Virtual function that can be overridden to provide password
 checking in derived classes. It should return @p true if the
 password is valid, @p false otherwise. 
*/
int kde_KPasswordDialog_checkPassword(kde_KPasswordDialog* instPointer,char* arg1);
void kde_KPasswordDialog_slotOk(kde_KPasswordDialog* instPointer);
void kde_KPasswordDialog_slotCancel(kde_KPasswordDialog* instPointer);
void kde_KPasswordDialog_slotKeep(kde_KPasswordDialog* instPointer,int arg1);

#endif
