/***************************************************************************
                            kde_NodeIterator.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_NODEITERATOR
#define KDE_NODEITERATOR

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 NodeIterators are used to step through a set of nodes, e.g. the set
 of nodes in a NodeList, the document subtree governed by a
 particular node, the results of a query, or any other set of nodes.
 The set of nodes to be iterated is determined by the implementation
 of the NodeIterator. DOM Level 2 specifies a single NodeIterator
 implementation for document-order traversal of a document subtree.
 Instances of these iterators are created by calling
 DocumentTraversal.createNodeIterator().

  Any Iterator that returns nodes may implement the <code>
 NodeIterator </code> interface. Users and vendor libraries may also
 choose to create Iterators that implement the <code> NodeIterator
 </code> interface.

 
 @short 
 NodeIterators are used to step through a set of nodes, e.
*/
kde_NodeIterator * kde_new_NodeIterator();
kde_NodeIterator * kde_new_NodeIterator1(kde_NodeIterator* other);
void kde_del_NodeIterator( kde_NodeIterator* p );

/** 
 The root node of the NodeIterator, as specified when it was created.
     
*/
kde_DOMNode* kde_NodeIterator_root(kde_NodeIterator* instPointer);

/** 
 This attribute determines which node types are presented via the
 iterator. The available set of constants is defined in the NodeFilter
 interface. Nodes not accepted by whatToShow will be skipped, but their
 children may still be considered. Note that this skip takes precedence
 over the filter, if any.
    
*/
unsigned long kde_NodeIterator_whatToShow(kde_NodeIterator* instPointer);

/** 
 The NodeFilter used to screen nodes.
     
*/
kde_NodeFilter* kde_NodeIterator_filter(kde_NodeIterator* instPointer);

/** 
 The value of this flag determines whether the children of entity
 reference nodes are visible to the iterator. If false, they and
 their descendents will be rejected. Note that this rejection takes
 precedence over whatToShow and the filter. Also note that this is
 currently the only situation where NodeIterators may reject a complete
 subtree rather than skipping individual nodes.

 To produce a view of the document that has entity references expanded
 and does not expose the entity reference node itself, use the whatToShow
 flags to hide the entity reference node and set expandEntityReferences to
 true when creating the iterator. To produce a view of the document that
 has entity reference nodes but no entity expansion, use the whatToShow
 flags to show the entity reference node and set expandEntityReferences to
 false.
     
*/
int kde_NodeIterator_expandEntityReferences(kde_NodeIterator* instPointer);

/** 
 Returns the next node in the set and advances the position of
 the Iterator in the set. After a NodeIterator is created, the
 first call to nextNode() returns the first node in the set.

     
*/
kde_DOMNode* kde_NodeIterator_nextNode(kde_NodeIterator* instPointer);

/** 
 Returns the previous node in the set and moves the position of
 the Iterator backwards in the set.

     
*/
kde_DOMNode* kde_NodeIterator_previousNode(kde_NodeIterator* instPointer);

/** 
 Detaches the NodeIterator from the set which it iterated over,
 releasing any computational resources and placing the iterator in the
 INVALID state. After detach has been invoked, calls to nextNode or
 previousNode will raise the exception INVALID_STATE_ERR.
     
*/
void kde_NodeIterator_detach(kde_NodeIterator* instPointer);

/** 

 not part of the DOM
     
*/
//kde_NodeIteratorImpl* kde_NodeIterator_handle(kde_NodeIterator* instPointer);
int kde_NodeIterator_isNull(kde_NodeIterator* instPointer);

#endif
