/***************************************************************************
                            CSSPrimitiveValue.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The <code> CSSPrimitiveValue </code> interface represents a single
 <a href="http://www.w3.org/TR/REC-CSS2/syndata.html#values"> CSS
 value </a> . This interface may be used to determine the value of a
 specific style property currently set in a block or to set a
 specific style properties explicitly within the block. An instance
 of this interface can be obtained from the <code>
 getPropertyCSSValue </code> method of the <code>
 CSSStyleDeclaration </code> interface.

 
 @short 
 The <code> CSSPrimitiveValue </code> interface represents a single
 <a href="http://www.
*/
public class CSSPrimitiveValue extends CSSValue  {
	protected CSSPrimitiveValue(Class dummy){super((Class) null);}

	private native void newCSSPrimitiveValue();
	public CSSPrimitiveValue() {
		super((Class) null);
		newCSSPrimitiveValue();
	}
	private native void newCSSPrimitiveValue( CSSPrimitiveValue other);
	public CSSPrimitiveValue( CSSPrimitiveValue other) {
		super((Class) null);
		newCSSPrimitiveValue( other);
	}
	private native void newCSSPrimitiveValue( CSSValue other);
	public CSSPrimitiveValue( CSSValue other) {
		super((Class) null);
		newCSSPrimitiveValue( other);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 The type of the value as defined by the constants specified
 above.

     
*/
	public native short primitiveType();

/** 
 A method to set the float value with a specified unit. If the
 property attached with this value can not accept the specified
 unit or the float value, the value will be unchanged and a
 <code> DOMException </code> will be raised.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this property is
 readonly.

     
*/
	public native void setFloatValue( short unitType, float floatValue);

/** 
 This method is used to get a float value in a specified unit.
 If this CSS value doesn't contain a float value or can't be
 converted into the specified unit, a <code> DOMException
 </code> is raised.

     
*/
	public native float getFloatValue( short unitType);

/** 
 A method to set the string value with a specified unit. If the
 property attached to this value can't accept the specified unit
 or the string value, the value will be unchanged and a <code>
 DOMException </code> will be raised.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this property is
 readonly.

     
*/
	public native void setStringValue( short stringType, String stringValue);

/** 
 This method is used to get the string value in a specified
 unit. If the CSS value doesn't contain a string value, a <code>
 DOMException </code> is raised.

     
*/
	public native String getStringValue();

/** 
 This method is used to get the Counter value. If this CSS value
 doesn't contain a counter value, a <code> DOMException </code>
 is raised. Modification to the corresponding style property can
 be achieved using the <code> Counter </code> interface.

     
*/
	public native Counter getCounterValue();

/** 
 This method is used to get the Rect value. If this CSS value
 doesn't contain a rect value, a <code> DOMException </code> is
 raised. Modification to the corresponding style property can be
 achieved using the <code> Rect </code> interface.

     
*/
	public native Rect getRectValue();

/** 
 This method is used to get the RGB color. If this CSS value
 doesn't contain a RGB color value, a <code> DOMException
 </code> is raised. Modification to the corresponding style
 property can be achieved using the <code> RGBColor </code>
 interface.

     
*/
	public native RGBColor getRGBColorValue();
	public static final int CSS_UNKNOWN = 0;
	public static final int CSS_NUMBER = 1;
	public static final int CSS_PERCENTAGE = 2;
	public static final int CSS_EMS = 3;
	public static final int CSS_EXS = 4;
	public static final int CSS_PX = 5;
	public static final int CSS_CM = 6;
	public static final int CSS_MM = 7;
	public static final int CSS_IN = 8;
	public static final int CSS_PT = 9;
	public static final int CSS_PC = 10;
	public static final int CSS_DEG = 11;
	public static final int CSS_RAD = 12;
	public static final int CSS_GRAD = 13;
	public static final int CSS_MS = 14;
	public static final int CSS_S = 15;
	public static final int CSS_HZ = 16;
	public static final int CSS_KHZ = 17;
	public static final int CSS_DIMENSION = 18;
	public static final int CSS_STRING = 19;
	public static final int CSS_URI = 20;
	public static final int CSS_IDENT = 21;
	public static final int CSS_ATTR = 22;
	public static final int CSS_COUNTER = 23;
	public static final int CSS_RECT = 24;
	public static final int CSS_RGBCOLOR = 25;
}
