/***************************************************************************
                            KImageIO.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Interface to the KDE Image IO plugin architecture.

 This library allows KDE applications to read and write images in a
 variety of formats, transparently via the {@link QImage} and {@link QPixmap} load
 and save methods.

 The image processing backends are written as image handlers compatible
 with the {@link QImageIO} handler format. The backends are loaded on demand
 when a particular format is requested.

 Currently supported formats include:

 Simply call the {@link KImageIO#registerFormats} static method declared
 in kimgageio.h.

 <pre>
	#include<qpixmap.h>
 	#include<kimgio.h>

	int main( String[] args )
	{
		....
		KImageIO.registerFormats();

		...	// start main program
	}
 </pre>

 @author Sirtaj Singh Kang

 @version $Id: KImageIO.java,v 1.5 2002/01/31 04:48:57 rdale Exp $
 
 @short 
 Interface to the KDE Image IO plugin architecture.
*/
public class  KImageIO implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KImageIO(Class dummy){}


/** 
  Registers all KImageIO supported formats.
   
*/
	public static native void registerFormats();

/** 
  Checks if a special type is supported for writing.
   
*/
	public static native boolean canWrite( String type);

/** 
  Checks if a special type is supported for reading.
   
*/
	public static native boolean canRead( String type);

/** 
 Returns a list of all KImageIO supported formats. 

*/
	public static native ArrayList types( int mode);

/** 
 Returns a list of patterns of all KImageIO supported formats. 

 These patterns can be passed to {@link KFileDialog#getOpenFileName}
 or {@link KFileDialog#getSaveFileName}, for example.

*/
	public static native String pattern( int mode);
	public static native String pattern();

/** 
  Returns the suffix of an image type.
   
*/
	public static native String suffix( String type);

/** 
  Returns the type of given filename.
   
*/
	public static native String type( String filename);

/** 
  Returns a list of MIME types for all KImageIO supported formats. 

*/
	public static native ArrayList mimeTypes( int _mode);

/** 
 Test to see whether a MIME type is supported to reading/writing.

*/
	public static native boolean isSupported( String _mimeType, int _mode);
	public static native boolean isSupported( String _mimeType);

/** 
 Returns the MIME type of <code>_filename.</code>

*/
	public static native String mimeType( String _filename);
	public static final int Reading = 0;
	public static final int Writing = 1;
}
