/***************************************************************************
                            KLibrary.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 KLibrary allows you to look up symbols of the shared library.

 See {@link KLibrarySignals} for signals emitted by KLibrary.

 See {@link KLibraryEventHandling} for event handlers to override in subclasses of KLibrary.

 @author Torben Weis <weis@kde.org>
 
 @short Represents a dynamically loaded library.

*/
public class KLibrary extends QObject  {
	protected KLibrary(Class dummy){super((Class) null);}

	private native void newKLibrary( String libname, String filename, int handle);

/** 

 Don't create KLibrary objects on your own. Instead use {@link KLibLoader}.
     
*/
	public KLibrary( String libname, String filename, int handle) {
		super((Class) null);
		newKLibrary( libname, filename, handle);
	}

/** 

*/
	public native String name();

/** 

*/
	public native String fileName();

/** 

*/
	public native KLibFactory factory();

/** 
 Looks up a symbol from the library. This is a very low level
 function that you usually don't want to use.
     
*/
	public native int symbol( String name);

/** 
 Unloads the library. 
 This typically results in the deletion of this object. You should
 not reference its pointer after calling this function.
     
*/
	public native void unload();
}
