/***************************************************************************
                            KPrinter.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class is the main interface to access the KDE print framework. It allows KDE
 applications to easily access the print system, through an interface that is compatible
 with {@link QPrinter}. So that the porting of an existing application should be as easy as
 replacing any occurence of {@link QPrinter} by KPrinter. However applications that explicitly
 used the {@link QPrintDialog} class must be changed to the standard KPrinter way of accessing
 the print dialog.

 Basically, a KDE application will use the KPrinter object as a paint device, and will draw
 on it using {@link QPainter}. In a standard application, the use of the KPrinter class will
 look like this:
 <pre>
 #include <kprinter.h>
 #include <qpainter.h>

 void MyClass.doPrint()
 {
   KPrinter printer;

   // do some printer initialization
   printer.setFullPage( true );

   // initialize the printer using the print dialog
   if ( printer.setup( this ) )
   {
     // create a painter to paint on the printer object
     QPainter painter;

     // start painting
     painter.begin( &printer );
     <do something>
     // stop painting, this will automatically send the print data to the printer
     painter.end();
   }
 }
 </pre>

 The KPrinter interface also allows some more advanced possibilities, like the customization
 of the print dialog to integrate application specific print options. This is done by subclassing
 {@link KPrintDialogPage} and adding the page using {@link #addDialogPage}.

 @author Michael Goffioul

 @short The central interface class to access the KDE print system.

*/
public class KPrinter implements  QtSupport, QPaintDeviceInterface {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KPrinter(Class dummy){}

	private native void newKPrinter( boolean restore, int m);

/** 
 Constructor. This also restores/saves the state from a previous KPrinter object created within
 the same application run, if <code>restore</code> is true. Setting <code>restore</code> to false may
 be useful if you want an independant/clean KPrinter object.

*/
	public KPrinter( boolean restore, int m) {
		newKPrinter( restore, m);
	}
	private native void newKPrinter();
	public KPrinter() {
		newKPrinter();
	}

/** 
 Destructor. This also saves the current KPrinter state for future printing.
	 
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 See {@link QPrinter#newPage}.
	 
*/
	public native boolean newPage();

/** 
 See {@link QPrinter#abort}.
	 
*/
	public native boolean abort();

/** 
 See {@link QPrinter#aborted}
	 
*/
	public native boolean aborted();

/** 
 See {@link QPrinter#outputToFile}.
	 
*/
	public native boolean outputToFile();

/** 
 See {@link QPrinter#setOutputToFile}.
	 
*/
	public native void setOutputToFile( boolean arg1);

/** 
 See {@link QPrinter#outputFileName}.
	 
*/
	public native String outputFileName();

/** 
 See {@link QPrinter#setOutputFileName}.
	 
*/
	public native void setOutputFileName( String arg1);

/** 
 See {@link QPrinter#docName}.
	 
*/
	public native String docName();

/** 
 See {@link QPrinter#setDocName}.
	 
*/
	public native void setDocName( String arg1);

/** 
 See {@link QPrinter#creator}.
	 
*/
	public native String creator();

/** 
 See {@link QPrinter#setCreator}.
	 
*/
	public native void setCreator( String arg1);

/** 
 See {@link QPrinter#fullPage}.
	 
*/
	public native boolean fullPage();

/** 
 See {@link QPrinter#setFullPage}.
	 
*/
	public native void setFullPage( boolean arg1);

/** 
 See {@link QPrinter#colorMode}.
	 
*/
	public native int colorMode();

/** 
 See {@link QPrinter#setColorMode}.
	 
*/
	public native void setColorMode( int arg1);

/** 
 See {@link QPrinter#numCopies}.
	 
*/
	public native int numCopies();

/** 
 See {@link QPrinter#setNumCopies}.
	 
*/
	public native void setNumCopies( int n);

/** 
 See {@link QPrinter#orientation}.
	 
*/
	public native int orientation();

/** 
 See {@link QPrinter#setOrientation}.
	 
*/
	public native void setOrientation( int arg1);

/** 
 See {@link QPrinter#pageOrder}.
	 
*/
	public native int pageOrder();

/** 
 See {@link QPrinter#setPageOrder}.
	 
*/
	public native void setPageOrder( int arg1);

/** 
 Returns the collate status of the current KPrinter.
	 
*/
	public native int collate();

/** 
 Sets the collate status for the current KPrinter to <code>type.</code>
	 
*/
	public native void setCollate( int type);

/** 
 See {@link QPrinter#minPage}.
	 
*/
	public native int minPage();

/** 
 See {@link QPrinter#maxPage}.
	 
*/
	public native int maxPage();

/** 
 See {@link QPrinter#setMinMax}.
	 
*/
	public native void setMinMax( int arg1, int arg2);

/** 
 Returns the first page to be printed.

 should use {@link #pageList} instead, which takes into account all options: collate,
 page order, ranges, page set, ...

*/
	public native int fromPage();

/** 
 Returns the last page to be printed.

 should use {@link #pageList} instead, which takes into account all options: collate,
 page order, ranges, page set, ...

*/
	public native int toPage();

/** 
 Sets the first and last page to be printed. See {@link QPrinter#setFromTo}.
	 
*/
	public native void setFromTo( int arg1, int arg2);

/** 
 See {@link QPrinter#pageSize}.
	 
*/
	public native int pageSize();

/** 
 See {@link QPrinter#setPageSize}.
	 
*/
	public native void setPageSize( int arg1);

/** 
 See {@link QPrinter#printerName}.
	 
*/
	public native String printerName();

/** 
 See {@link QPrinter#setPrinterName}.
	 
*/
	public native void setPrinterName( String arg1);

/** 
 Returns the print program as set by {@link #setPrintProgram} or by the print dialog
 if a special printer has been selected.

*/
	public native String printProgram();

/** 
 Sets the command line to use when printing. This function is useful
 when using a KPrinter object without the print dialog, to control what
 to print and how to do it. The command line may contain the following
 tags:

   prt.setOutputToFile( true );
   prt.setOutputFileName( filename );
   prt.setPrintProgram( "gs -sDEVICE=png256 -sPAPERSIZE=%psl -sOutputFile=%out %in" );

   QPainter painter( &prt );
   doPaint( &painter );
 }
 </pre>

*/
	public native void setPrintProgram( String cmd);

/** 
 See {@link QPrinter#printerSelectionOption}. Unused.
	 
*/
	public native String printerSelectionOption();

/** 
 See {@link QPrinter#setPrinterSelectionOption}. Unused
	 
*/
	public native void setPrinterSelectionOption( String arg1);

/** 
 Returns the current page number.

*/
	public native int currentPage();

/** 
 Sets the current page number. This page number will be used if the user
 selected "current page" in the print dialog. This option will only be
 enabled if the application does page selection itself and the application
 has called {@link #setCurrentPage} before opening the print dialog:
 <pre>
 MyClass.MyClass()
 {
   // declares my application able to do page selection
   KPrinter.setPageSelection( KPrinter.ApplicationSide );
 }

 void MyClass.doPrint()
 {
   KPrinter printer;

   printer.setCurrentPage( mycurrentpage );
   if ( printer.setup( this ) )
   {
     QValueList<int> pages = printer.pageList();
     // print the pages
     ...
   }
 }
 </pre>

*/
	public native void setCurrentPage( int p);
	public native void setCurrentPage();

/** 
 Returns the page set of the current KPrinter object.
	 
*/
	public native int pageSet();

/** 
 Sets up the KPrinter object using the print dialog, returns true if the user clicked OK.

*/
	public native boolean setup( QWidget parent, String caption, boolean forceExpand);
	public native boolean setup();

/** 
 See {@link QPrinter#margins}.
	 
*/
	public native QSize margins();

/** 
 Not used yet.
	 
*/
	public native void setMargins( QSize m);

/** 
 Returns the real page size in points. Some print system (like CUPS) allows to customize the
 page size through printer description files (PPD). The size returned corresponds to this
 size.

*/
	public native QSize realPageSize();

/** 
 Sets the real page size. For internal use only.

*/
	public native void setRealPageSize( QSize p);

/** 
 Returns the page list to be printed, correpsonding to the options selected by the user. This
 takes into account collate, page order, page set, ranges, ... This is useful when the
 application does page selection itself.

*/
	public native int[] pageList();

/** 
 Sets the KPrinter object to preview mode if <code>on</code> is true. In this mode, nothing will be
 printed but only a preview dialog will be popped up with the single "Close" action. Using
 this mode, any application can easily implement a preview action:
 <pre>
 void MyClass:doPreview()
 {
   // use a "clean" KPrinter object (independant from previous print jobs),
   // this is not necessary, it depends on the application
   KPrinter prt( false );
   prt.setPreviewOnly( true );

   QPainter painter( &prt );
   doPrint( &painter );
 }
 </pre>

*/
	public native void setPreviewOnly( boolean on);

/** 
 Returns the preview-only state for this KPrinter object.

*/
	public native boolean previewOnly();

/** 
 For internal use only.
	 
*/
//	public native KPrinterImpl* implementation();

/** 
 Prints the files given in argument. This will first filter the files accorsing to the filtering
 options selected by the user in the print dialog, then send the filtered files to the printer
 with the print options selected. This function is called automatically when calling
 {@link QPainter#end} for a painter object constructed on KPrinter. In normal use, you don't need
 this use this fucntion explicitely.
	 
*/
	public native boolean printFiles( String[] files, boolean removeafter);
	public native boolean printFiles( String[] files);

/** 
 The KPrinter object stores all its settings in an internal {@link QMap} structure on {@link String}. This allows to store any property. This method allows an application to access
 any print option from the KPrinter object, using the option name. For example if your
 application add a customized page to the print dialog, this page will saves its settings
 into the KPrinter object using this QMap<String,String> structure. After showing the
 print dialog, your application can then access these options using this method. The
 custom option name should follow the form "kde-appname-optionname".
 <pre>
 void MyClass.doPrint()
 {
   KPrinter prt;

   // add my custom page
   prt.addDialogPage( new MyDialogPage() );

   // open print dialog
   if ( prt.setup( this ) )
   {
      String fntname = prt.option( "kde-myapp-fontname" );
      ...
      do_something;
      ...
   }
 }
 </pre>

*/
	public native String option( String key);

/** 
 Adds or modifies an option in the KPrinter object. You probably don't need to use this function
 explicitely. This will be done implicitely for example when reimplementing {@link KPrintDialogPage#getOptions}.

*/
	public native void setOption( String key, String value);

/** 
 Returns the complete set of print options from the KPrinter object. For internal use.

*/
	public native String options();

/** 
 Sets the option set in one operation. This method has some side effects like merging
 the internal map with the one given in argument, but only for option in the form
 "kde-...". For internal use only.

*/
	public native void setOptions( String arg1, String opts);

/** 
 For internal use only. Does a similar job as {@link #setOption}, except that all possible
 internal printers are initialized with the option if it has the form "kde-...".

*/
	public native void initOptions( String arg1, String opts);

/** 
 Returns the search name of the printer selected by the user. Each printer is identified by
 a unique name. This method is mainly used for state restoration. For internal use.

*/
	public native String searchName();

/** 
 Sets the search name of the KPrinter object. For internal use.

*/
	public native void setSearchName( String n);

/** 
 Returns the last error message issued by the print system. Unimplemented yet.

*/
	public native String errorMessage();

/** 
 Sets the last error message. For internal use.

*/
	public native void setErrorMessage( String msg);

/** 
 Configure the KPrinter object to be used with the printer named
 <code>prname.</code> After the call, the KPrinter object can be used without
 the need to call the print dialog. If <code>prname</code> is empty, then the
 KPrinter object is configured for the default printer. If <code>prname</code>
 corresponds to a pseudo-printer which needs an output file, a file
 dialog will be used. In that case, providing a parent widget for
 that dialog in <code>parent</code> may be useful.

*/
	public native boolean autoConfigure( String prname, QWidget parent);
	public native boolean autoConfigure();

/** 
 Set the default document filename. This filename will be used as the
 default basename for the output file, instead of the default "print".
 For exmaple, by using setDocFileName("my_document"), the default
 output file will be $HOME/my_document.ps.

*/
	public native void setDocFileName( String filename);

/** 
 Get the default document filename, that is the default basename used for
 the output file.

*/
	public native String docFileName();

/** 
 Adds a customized page to the print dialog. The pages will appear in a tab widget in the
 bottom half of the dialog, along with the standard "Copies" page. The page must be created
 and added each time you want open a print dialog with {@link #setup}. If you correctly
 reimplemented {@link KPrintDialogPage#setOptions}, the settings will be restored from call
 to call, you don't have to worry about state saving/restoration.

*/
//	public static native void addDialogPage( KPrintDialogPage arg1);

/** 
 Sets the page selection mode of the application. If needed, call this method somewhere at
 the beginning of your code. The default value is <code>SystemSide.</code>

*/
	public static native void setPageSelection( int arg1);

/** 
 Returns the page selection mode of the current application.

*/
	public static native int pageSelection();

/** 
 Sets the application type concerning the print dialog. You probably don't want to use it.
 For internal use only.

*/
	public static native void setApplicationType( int type);

/** 
 Returns the application type concerning the print dialog. For internal use only.

*/
	public static native int applicationType();

/** 
 Adds a standard page to the print dialog. This is not useful yet as there's only one
 standard page defines <code>CopiesPage.</code>

*/
	public static native void addStandardPage( int p);

/** 
 Removes a standard page from the print dialog. If your application doesn't want a
 standard page in the dialog, simply call this method with the correct identifier.
 By default, the print dialog includes the <code>CopiesPage</code> page.

*/
	public static native void removeStandardPage( int p);
//	protected native boolean cmd( int arg1, QPainter arg2, QPDevCmdParam arg3);
	protected native int metric( int arg1);
	protected native void translateQtOptions();
	protected native void loadSettings();
	protected native void saveSettings();
	protected native void preparePrinting();
	protected native void finishPrinting();
	protected native void reload();
	protected native void init( boolean restore, int m);
	protected native void init();
	
	public native int devType();
	public native boolean isExtDev();
	public native boolean paintingActive();
//	public native void setResolution( int arg1);
//	public native int resolution();
	
	public static final int CopiesPage = 0x01;
	public static final int FilesPage = 0x02;
	public static final int Custom = 0x10;
	public static final int ApplicationSide = 0x01;
	public static final int SystemSide = 0x02;
	public static final int Dialog = 0x00;
	public static final int StandAlone = 0x01;
	public static final int StandAlonePersistent = 0x02;
	public static final int AllPages = 0x00;
	public static final int OddPages = 0x01;
	public static final int EvenPages = 0x02;
	public static final int Collate = 0x00;
	public static final int Uncollate = 0x01;
	public static final int GrayScale = QPrinter.GrayScale;
	public static final int Color = QPrinter.Color;
	public static final int Portrait = QPrinter.Portrait;
	public static final int Landscape = QPrinter.Landscape;
	public static final int FirstPageFirst = QPrinter.FirstPageFirst;
	public static final int LastPageFirst = QPrinter.LastPageFirst;
	public static final int A4 = QPrinter.A4;
	public static final int B5 = QPrinter.B5;
	public static final int Letter = QPrinter.Letter;
	public static final int Legal = QPrinter.Legal;
	public static final int Executive = QPrinter.Executive;
	public static final int A0 = QPrinter.A0;
	public static final int A1 = QPrinter.A1;
	public static final int A2 = QPrinter.A2;
	public static final int A3 = QPrinter.A3;
	public static final int A5 = QPrinter.A5;
	public static final int A6 = QPrinter.A6;
	public static final int A7 = QPrinter.A7;
	public static final int A8 = QPrinter.A8;
	public static final int A9 = QPrinter.A9;
	public static final int B0 = QPrinter.B0;
	public static final int B1 = QPrinter.B1;
	public static final int B10 = QPrinter.B10;
	public static final int B2 = QPrinter.B2;
	public static final int B3 = QPrinter.B3;
	public static final int B4 = QPrinter.B4;
	public static final int B6 = QPrinter.B6;
	public static final int B7 = QPrinter.B7;
	public static final int B8 = QPrinter.B8;
	public static final int B9 = QPrinter.B9;
	public static final int C5E = QPrinter.C5E;
	public static final int Comm10E = QPrinter.Comm10E;
	public static final int DLE = QPrinter.DLE;
	public static final int Folio = QPrinter.Folio;
	public static final int Ledger = QPrinter.Ledger;
	public static final int Tabloid = QPrinter.Tabloid;
	public static final int NPageSize = QPrinter.NPageSize;
}
