/***************************************************************************
                            KRandomSequence.java -  description
                             -------------------
    begin                : Tue Jan 29 14:56:40 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Tue Jan 29 14:56:40 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A class to create a pseudo-random sequence

 Given a seed number, this class will produce a sequence of
 pseudo-random numbers.  This would typically be used in
 applications like games.

 In general, you should instantiate a KRandomSequence object and
 pass along your seed number in the constructor.  From then on,
 simply call {@link getDouble} or {@link getLong} to obtain the next
 number in the sequence.

 @author Sean Harmer <sh@astro.keele.ac.uk>
 
 @short 
 A class to create a pseudo-random sequence

*/
public class  KRandomSequence implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KRandomSequence(Class dummy){}

	private native void newKRandomSequence( long lngSeed);

/** 
 Creates a pseudo-random sequence based on the seed lngSeed.

 If lngSeed is 0, the sequence is initialized with a value from
 kapp.random().

 A Pseudo-random sequence is different for each seed but can be 
 reproduced by starting the sequence with the same seed.

 If you need a single value which needs to be unpredictable, 
 you need to use kapp.random() instead.

   
*/
	public KRandomSequence( long lngSeed) {
		newKRandomSequence( lngSeed);
	}
	private native void newKRandomSequence();
	public KRandomSequence() {
		newKRandomSequence();
	}

/** 
 Standard destructor
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	private native void newKRandomSequence( KRandomSequence a);

/** 
 Copy constructor
   
*/
	public KRandomSequence( KRandomSequence a) {
		newKRandomSequence( a);
	}

/** 
 Restart the sequence based on lngSeed
   
*/
	public native void setSeed( long lngSeed);
	public native void setSeed();

/** 
 Get the next number from the pseudo-random sequence

*/
	public native double getDouble();

/** 
 Get the next number from the pseudo-random sequence

*/
	public native long getLong( long max);

/** 
 Get a boolean from the pseudo-random sequence

*/
	public native boolean getBool();

/** 
 Put a list in random order

*/
//	public native void randomize( QGList list);

/** 
 Modulate the random sequence. 

 If S(i) is the sequence of numbers that will follow 
 given the current state after calling modulate(i), 
 then S(i) != S(j) for i != j and   
      S(i) == S(j) for i == j.

 This can be usefull in game situation where "undo" restores
 the state of the random sequence. If the game modulates the
 random sequence with the move chosen by the player, the 
 random sequence will be identical whenever the player "redo"-s 
 his or hers original move, but different when the player 
 chooses another move.

 With this scenario "undo" can no longer be used to repeat a 
 certain move over and over again until the computer reacts 
 with a favourable response or to predict the response for a 
 certain move based on the response to another move.
   
*/
	public native void modulate( int i);
}
