/***************************************************************************
                            KXMLGUIFactory.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KXMLGUIFactory, together with {@link KXMLGUIClient} objects, can be used to create
 a GUI of container widgets (like menus, toolbars, etc.) and container items
 (menu items, toolbar buttons, etc.) from an XML document and action objects.

 Each {@link KXMLGUIClient} represents a part of the GUI, composed from containers and
 actions. KXMLGUIFactory takes care of building (with the help of a {@link KXMLGUIBuilder})
 and merging the GUI from an unlimited number of clients.

 Each client provides XML through a {@link QDomDocument} and actions through a
 {@link KActionCollection} . The XML document contains the rules for how to merge the
 GUI.

 KXMLGUIFactory processes the DOM tree provided by a client and plugs in the client's actions,
 according to the XML and the merging rules of previously inserted clients. Container widgets
 are built via a {@link KXMLGUIBuilder} , which has to be provided with the KXMLGUIFactory constructor.
 
 See {@link KXMLGUIFactorySignals} for signals emitted by KXMLGUIFactory.

 See {@link KXMLGUIFactoryEventHandling} for event handlers to override in subclasses of KXMLGUIFactory.

 @short 
 KXMLGUIFactory, together with @ref KXMLGUIClient objects, can be used to create
 a GUI of container widgets (like menus, toolbars, etc.
*/
public class KXMLGUIFactory extends QObject  {
	protected KXMLGUIFactory(Class dummy){super((Class) null);}

	private native void newKXMLGUIFactory( KXMLGUIBuilderInterface builder, QObject parent, String name);

/** 
 Constructs a KXMLGUIFactory. The provided <code>builder</code> {@link KXMLGUIBuilder} will be called
 for creating and removing container widgets, when clients are added/removed from the GUI.

 Note that the ownership of the given KXMLGUIBuilder object won't be transferred to this
 KXMLGUIFactory, so you have to take care of deleting it properly.
   
*/
	public KXMLGUIFactory( KXMLGUIBuilderInterface builder, QObject parent, String name) {
		super((Class) null);
		newKXMLGUIFactory( builder, parent, name);
	}
	private native void newKXMLGUIFactory( KXMLGUIBuilderInterface builder);
	public KXMLGUIFactory( KXMLGUIBuilderInterface builder) {
		super((Class) null);
		newKXMLGUIFactory( builder);
	}

/** 
 Destructor
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Creates the GUI described by the QDomDocument of the client,
 using the client's actions, and merges it with the previously
 created GUI.
 This also means that the order in which clients are added to the factory
 is relevant; assuming that your application supports plugins, you should
 first add your application to the factory and then the plugin, so that the
 plugin's UI is merged into the UI of your application, and not the other
 way round.
   
*/
	public native void addClient( KXMLGUIClientInterface client);

/** 
 Removes the GUI described by the client, by unplugging all
 provided actions and removing all owned containers (and storing
 container state information in the given client)
   
*/
	public native void removeClient( KXMLGUIClientInterface client);
//	public native void plugActionList( KXMLGUIClientInterface client, String name, KActionPtrList actionList);
	public native void unplugActionList( KXMLGUIClientInterface client, String name);

/** 
 Returns a list of all clients currently added to this factory
   
*/
//	public native QPtrList<KXMLGUIClient> clients();

/** 
 Use this method to get access to a container widget with the name specified with <code>containerName</code>
 and which is owned by the <code>client.</code> The container name is specified with a "name" attribute in the
 XML document.

 This function is particularly useful for getting hold of a popupmenu defined in an XMLUI file.
 For instance:
 QPopupMenu popup = static_cast<QPopupMenu>(factory().container("my_popup",this))
 where "my_popup" is the name of the menu in the XMLUI file, and
 "this" is XMLGUIClient which owns the popupmenu (e.g. the mainwindow, or the part, or the plugin...)

 This method may return null if no container with the given name exists or is not owned by the client.
   
*/
	public native QWidget container( String containerName, KXMLGUIClientInterface client, boolean useTagName);
	public native QWidget container( String containerName, KXMLGUIClientInterface client);
//	public native QPtrList<QWidget> containers( String tagName);

/** 
 Use this method to free all memory allocated by the KXMLGUIFactory. This deletes the internal node
 tree and therefore resets the internal state of the class. Please note that the actual GUI is
 NOT touched at all, meaning no containers are deleted nor any actions unplugged. That is
 something you have to do on your own. So use this method only if you know what you are doing :-)

 (also note that this will call {@link KXMLGUIClient#setFactory} for all inserted clients)
   
*/
	public native void reset();

/** 
 Use this method to free all memory allocated by the KXMLGUIFactory for a specific container,
 including all child containers and actions. This deletes the internal node subtree for the
 specified container. The actual GUI is not touched, no containers are deleted or any actions
 unplugged. Use this method only if you know what you are doing :-)

 (also note that this will call {@link KXMLGUIClient#setFactory} for all clients of the
 container)
   
*/
	public native void resetContainer( String containerName, boolean useTagName);
	public native void resetContainer( String containerName);
	public static native String readConfigFile( String filename, boolean never_null, KInstanceInterface instance);
	public static native String readConfigFile( String filename, boolean never_null);
	public static native String readConfigFile( String filename, KInstanceInterface instance);
	public static native String readConfigFile( String filename);
	public static native boolean saveConfigFile( QDomDocument doc, String filename, KInstanceInterface instance);
	public static native boolean saveConfigFile( QDomDocument doc, String filename);
	public static native String documentToXML( QDomDocument doc);
	public static native String elementToXML( QDomElement elem);

/** 
 Removes all QDomComment objects from the specified node and all its children.
   
*/
	public static native void removeDOMComments( QDomNode node);
}
