/***************************************************************************
                            Range.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
*/
public class  Range implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected Range(Class dummy){}

	private native void newRange();
	public Range() {
		newRange();
	}
	private native void newRange( DOMDocument rootContainer);
	public Range( DOMDocument rootContainer) {
		newRange( rootContainer);
	}
	private native void newRange( Range other);
	public Range( Range other) {
		newRange( other);
	}
	private native void newRange( DOMNode startContainer, long startOffset, DOMNode endContainer, long endOffset);
	public Range( DOMNode startContainer, long startOffset, DOMNode endContainer, long endOffset) {
		newRange( startContainer, startOffset, endContainer, endOffset);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Node within which the range begins

     
*/
	public native DOMNode startContainer();

/** 
 Offset within the starting node of the range.

     
*/
	public native long startOffset();

/** 
 Node within which the range ends

     
*/
	public native DOMNode endContainer();

/** 
 Offset within the ending node of the range.

     
*/
	public native long endOffset();

/** 
 TRUE if the range is collapsed

     
*/
	public native boolean collapsed();

/** 
 Gets the common ancestor container of the range's two end-points.
 Also sets it.

     
*/
	public native DOMNode commonAncestorContainer();

/** 
 Sets the attributes describing the start of the range.

  INVALID_NODE_TYPE_ERR: Raised if <code> refNode </code> or an
 ancestor of <code> refNode </code> is an Attr, Entity,
 Notation, or DocumentType node.

  If an offset is out-of-bounds, should it just be fixed up or
 should an exception be raised.

     
*/
	public native void setStart( DOMNode refNode, long offset);

/** 
 Sets the attributes describing the end of a range.

  INVALID_NODE_TYPE_ERR: Raised if <code> refNode </code> or an
 ancestor of <code> refNode </code> is an Attr, Entity,
 Notation, or DocumentType node.

     
*/
	public native void setEnd( DOMNode refNode, long offset);

/** 
 Sets the start position to be before a node

     
*/
	public native void setStartBefore( DOMNode refNode);

/** 
 Sets the start position to be after a node

     
*/
	public native void setStartAfter( DOMNode refNode);

/** 
 Sets the end position to be before a node.

     
*/
	public native void setEndBefore( DOMNode refNode);

/** 
 Sets the end of a range to be after a node

     
*/
	public native void setEndAfter( DOMNode refNode);

/** 
 Collapse a range onto one of its end-points

     
*/
	public native void collapse( boolean toStart);

/** 
 Select a node and its contents

     
*/
	public native void selectNode( DOMNode refNode);

/** 
 Select the contents within a node

     
*/
	public native void selectNodeContents( DOMNode refNode);

/** 
 Compare the end-points of two ranges in a document.

     
*/
	public native short compareBoundaryPoints( int how, Range sourceRange);

/** 

 not part of the DOM

 Compare the boundary-points of a range.

 Return true if the startContainer is before the endContainer,
 or if they are equal.
 Return false if the startContainer is after the endContainer.

     
*/
	public native boolean boundaryPointsValid();

/** 
 Removes the contents of a range from the containing document or
 document fragment without returning a reference to the removed
 content.

     
*/
	public native void deleteContents();

/** 
 Moves the contents of a range from the containing document or
 document fragment to a new DocumentFragment.

  HIERARCHY_REQUEST_ERR: Raised if a DocumentType node would be
 extracted into the new DocumentFragment.

     
*/
	public native DocumentFragment extractContents();

/** 
 Duplicates the contents of a range

     
*/
	public native DocumentFragment cloneContents();

/** 
 Inserts a node into the document or document fragment at the
 start of the range.

  WRONG_DOCUMENT_ERR: Raised if <code> newNode </code> and the
 container of the start of the Range were not created from the
 same document.

  HIERARCHY_REQUEST_ERR: Raised if the container of the start of
 the Range is of a type that does not allow children of the type
 of <code> newNode </code> or if <code> newNode </code> is an
 ancestor of the container .

     
*/
	public native void insertNode( DOMNode newNode);

/** 
 Reparents the contents of the range to the given node and
 inserts the node at the position of the start of the range.

  WRONG_DOCUMENT_ERR: Raised if <code> newParent </code> and the
 container of the start of the Range were not created from the
 same document.

  HIERARCHY_REQUEST_ERR: Raised if the container of the start of
 the Range is of a type that does not allow children of the type
 of <code> newParent </code> or if <code> newParent </code> is
 an ancestor of the container or if <code> node </code> would
 end up with a child node of a type not allowed by the type of
 <code> node </code> .

  INVALID_NODE_TYPE_ERR: Raised if <code> node </code> is an
 Attr, Entity, DocumentType, Notation, Document, or
 DocumentFragment node.

     
*/
	public native void surroundContents( DOMNode newParent);

/** 
 Produces a new range whose end-points are equal to the
 end-points of the range.

     
*/
	public native Range cloneRange();

/** 
 Returns the contents of a range as a string.

     
*/
	public native String toString();

/** 

     
*/
	public native String toHTML();

/** 
 Called to indicate that the range is no longer in use and that
 the implementation may relinquish any resources associated with
 this range. Subsequent calls to any methods or attribute getters
 on this range will result in a DOMException being thrown with an
 error code of INVALID_STATE_ERR.

     
*/
	public native void detach();

/** 
 not part of the DOM
 TRUE if the range is detached

     
*/
	public native boolean isDetached();

/** 

 not part of the DOM
     
*/
//	public native RangeImpl handle();
	public native boolean isNull();
	public static final int START_TO_START = 0;
	public static final int START_TO_END = 1;
	public static final int END_TO_END = 2;
	public static final int END_TO_START = 3;
}
