/***************************************************************************
                            HTMLAreaElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLAREAELEMENT_H
#define HTMLAREAELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Client-side image map area definition. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html edef]-AREA">
 AREA element definition </a> in HTML 4.0.

 
 @short 
 Client-side image map area definition.
*/

@interface HTMLAreaElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 A single character access key to give access to the form
 control. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-accesskey">
 accesskey attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) accessKey;

/** 
 see @ref accessKey
     
*/
- setAccessKey: (NSString *)arg1;

/** 
 Alternate text for user agents not rendering the normal content
 of this element. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-alt">
 alt attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) alt;

/** 
 see @ref alt
     
*/
- setAlt: (NSString *)arg1;

/** 
 Comma-separated list of lengths, defining an active region
 geometry. See also <code> shape </code> for the shape of the
 region. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-coords">
 coords attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) coords;

/** 
 see @ref coords
     
*/
- setCoords: (NSString *)arg1;

/** 
 The URI of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-href">
 href attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) href;

/** 
 see @ref href
     
*/
- setHref: (NSString *)arg1;

/** 
 Specifies that this area is inactive, i.e., has no associated
 action. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-nohref">
 nohref attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) noHref;

/** 
 see @ref noHref
     
*/
- setNoHref: (BOOL)arg1;

/** 
 The shape of the active area. The coordinates are given by
 <code> coords </code> . See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-shape">
 shape attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) shape;

/** 
 see @ref shape
     
*/
- setShape: (NSString *)arg1;

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
- (long) tabIndex;

/** 
 see @ref tabIndex
     
*/
- setTabIndex: (long)arg1;

/** 
 Frame to render the resource in. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-target">
 target attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) target;

/** 
 see @ref target
     
*/
- setTarget: (NSString *)arg1;
@end

#endif
