/***************************************************************************
                            KArchiveEntry.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KARCHIVEENTRY_H
#define KARCHIVEENTRY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**


 @short Base class for the archive-file's directory structure.

*/

@class KArchive;

@interface  KArchiveEntry : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- initWithArchive: (KArchive*)archive name: (NSString *)name access: (int)access date: (int)date user: (NSString *)user group: (NSString *)group symlink: (NSString *)symlink;
- (void) dealloc;

/** 
 Creation date of the file.
     
*/
- (NSDate *) datetime;
- (int) date;

/** 
 Name of the file without path.
     
*/
- (NSString *) name;

/** 
 The permissions and mode flags as returned by the -stat function
 in st_mode.
     
*/
- (long) permissions;

/** 
 User who created the file.
     
*/
- (NSString *) user;

/** 
 Group of the user who created the file.
     
*/
- (NSString *) group;

/** 
 Symlink if there is one
     
*/
- (NSString *) symlink;

/** 

*/
- (BOOL) isFile;

/** 

*/
- (BOOL) isDirectory;
- (KArchive*) archive;
@end

#endif
