/***************************************************************************
                            KDirLister.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDIRLISTER_H
#define KDIRLISTER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 The dir lister deals with the kiojob used to list and update a directory
 and has signals for the user of this class (e.g. konqueror view or
 kdesktop) to create/destroy its items when asked.

 This class is independent from the graphical representation of the dir
 (icon container, tree view, ...) and it stores the items (as KFileItems).

 Typical usage :
 Create an instance.
 Connect to at least update, clear, newItem, and deleteItem.
 Call openURL - the signals will be called.
 Reuse the instance when opening a new url (openURL).
 Destroy the instance when not needed anymore (usually destructor).

 Advanced usage : call openURL with _keep = true to list directories
 without forgetting the ones previously read (e.g. for a tree view)

 @short Helper class for the kiojob used to list and update a directory.
 
*/

@class KURL;
@class KFileItem;

@interface KDirLister : QObject 

/** 
 Create a directory lister.
   
*/
- initWithBOOL: (BOOL)_delayedMimeTypes;
- init;

/** 
 Destroy the directory lister.
   
*/
- (void) dealloc;

/** 
 Run the directory lister on the given url.

 This method causes KDirLister to emit _all_ the items of @p _url, in any case.
 Depending on @p _keep either -clear or clear( const KURL & ) will be
 emitted first.

 The @ref -newItems signal may be emitted more than once to supply you
 with KFileItems, up until the signal @ref -completed is emitted
 (and @ref -isFinished returns true).
   
*/
- (BOOL) openURL: (KURL*)_url _keep: (BOOL)_keep _reload: (BOOL)_reload;
- (BOOL) openURL: (KURL*)_url ;

/** 
 Stop listing all directories currently being listed.

 Emits @ref -canceled if there was at least one job running.
 Emits @ref canceled( const KURL& ) for each stopped job if
 there are at least two dirctories being watched by KDirLister.
   
*/
- stop;

/** 
 Stop listing the given directory.

 Emits @ref -canceled if the killed job was the last running one.
 Emits @ref canceled( const KURL& ) for the killed job if
 there are at least two directories being watched by KDirLister.
 No signal is emitted if there was no job running for @p _url.

*/
- stop: (KURL*)_url;

/** 

*/
- (BOOL) autoUpdate;

/** 
 Enable/disable automatic directory updating, when a directory changes
 (using KDirWatch).
   
*/
- setAutoUpdate: (BOOL)enable;

/** 
 Error handling.
   
*/
- (BOOL) autoErrorHandlingEnabled;
- setAutoErrorHandlingEnabled: (BOOL)enable parent: (QWidget *)parent;

/** 

*/
- (BOOL) showingDotFiles;

/** 
 Changes the "is viewing dot files" setting.
 Calls @ref -updateDirectory if setting changed
   
*/
- setShowingDotFiles: (BOOL)_showDotFiles;

/** 

*/
- (BOOL) dirOnlyMode;

/** 
 Call this with @p dirsOnly == true to list only directories
   
*/
- setDirOnlyMode: (BOOL)dirsOnly;

/** 

*/
- (KURL*) url;

/** 
 actually emit the changes made with setShowingDotFiles, setDirOnlyMode,
 setNameFilter and setMimeFilter.
   
*/
- emitChanges;

/** 
 Update the directory @p _dir. This method causes KDirLister to _only_ emit
 the items of @p _dir that actually changed compared to the current state in the
 cache and updates the cache.

 The current implementation calls updateDirectory automatically for
 local files, using KDirWatch (if -autoUpdate is true), but it might be
 useful to force an update manually.

*/
- updateDirectory: (KURL*)_dir;

/** 
 Returns true if no io operation is currently in progress.
   
*/
- (BOOL) isFinished;

/** 

*/
- (KFileItem*) rootItem;

/** 
 Find an item by its URL

*/
- (KFileItem*) findByURL: (KURL*)_url;
- (KFileItem*) find: (KURL*)_url;

/** 
 Find an item by its name

*/
- (KFileItem*) findByName: (NSString *)name;

/** 
 Set a name filter to only list items matching this name, e.g. "*.cpp".

 You can set more than one filter by separating them with whitespace, e.g
 "*.cpp *.h".
 Call setNameFilter( -[QString null]) to disable filtering.
 Note: the direcory is not automatically reloaded.

*/
- setNameFilter: (NSString *)arg1;

/** 

*/
- (NSString *) nameFilter;

/** 
 Set mime-based filter to only list items matching the given mimetypes

 NOTE: setting the filter does not automatically reload direcory.
 Also calling this function will not affect any named filter already set.

*/
- setMimeFilter: (NSArray *)arg1;

/** 
 Clears the mime based filter.

*/
- clearMimeFilter;

/** 

*/
- (NSArray *) mimeFilters;

/** 

*/
- (BOOL) matchesFilterWithName: (NSString *)name;

/** 

*/
- (BOOL) matchesMimeFilterWithName: (NSString *)mime;

/** 
 Called for every new item before emitting @ref -newItems.

*/
- (BOOL) matchesFilter: (KFileItem*)arg1;
- (BOOL) matchesMimeFilter: (KFileItem*)arg1;

/** 
 Checks if an url is malformed or not and displays an error message 
 if it is and autoErrorHandling is set to true. 

*/
- (BOOL) validURL: (KURL*)arg1;
- virtual_hook: (int)identifier data: (void*)data;
@end

/** Override these methods in subclasses of KDirLister to customise event handling behaviour */
@protocol KDirListerEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
