/***************************************************************************
                            KMessageBox.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSAGEBOX_H
#define KMESSAGEBOX_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Easy message dialog box.

 Provides convenience functions for some i18n'ed standard dialogs.

 The text in message boxes is wrapped automatically. The text may either
 be plaintext or richtext. If the text is plaintext, a newline-character
 may be used to indicate the end of a paragraph.

 @author Waldo Bastian (bastian@kde.org)

 @version $Id: KMessageBox.h,v 1.4 2002/03/23 11:01:20 rdale Exp $
  
 @short 
 Easy message dialog box.
*/

@class QWidget;
@class KGuiItem;

@interface  KMessageBox : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Display a simple "question" dialog.

 To be used for questions like "Do you have a printer?"

 The default button is "Yes". Pressing "Esc" selects "No".
  
*/
+ (int) questionYesNo: (QWidget *)parent text: (NSString *)text caption: (NSString *)caption buttonYes: (KGuiItem*)buttonYes buttonNo: (KGuiItem*)buttonNo dontAskAgainName: (NSString *)dontAskAgainName options: (int)options;
+ (int) questionYesNo: (QWidget *)parent text: (NSString *)text ;

/** 
 Display a simple "question" dialog.

 To be used for questions like "Do you want to discard the message or save it for later?",

 The default button is "Yes". Pressing "Esc" selects "Cancel".

 NOTE: The cancel button will always have the i18n'ed text '&Cancel'.
  
*/
+ (int) questionYesNoCancel: (QWidget *)parent text: (NSString *)text caption: (NSString *)caption buttonYes: (KGuiItem*)buttonYes buttonNo: (KGuiItem*)buttonNo dontAskAgainName: (NSString *)dontAskAgainName options: (int)options;
+ (int) questionYesNoCancel: (QWidget *)parent text: (NSString *)text ;

/** 
 Display a "question" dialog with a listbox to show information to the user

 To be used for questions like "Do you really want to delete these files?"
 And show the user exactly which files are going to be deleted in case
 he presses "Yes"

 The default button is "Yes". Pressing "Esc" selects "No".
  
*/
+ (int) questionYesNoList: (QWidget *)parent text: (NSString *)text strlist: (NSArray *)strlist caption: (NSString *)caption buttonYes: (KGuiItem*)buttonYes buttonNo: (KGuiItem*)buttonNo dontAskAgainName: (NSString *)dontAskAgainName options: (int)options;
+ (int) questionYesNoList: (QWidget *)parent text: (NSString *)text strlist: (NSArray *)strlist ;

/** 
 Display a "warning" dialog.

 To be used for questions "Shall I update your configuration?"
 The text should explain the implication of both options.

 The default button is "No". Pressing "Esc" selects "No".
  
*/
+ (int) warningYesNo: (QWidget *)parent text: (NSString *)text caption: (NSString *)caption buttonYes: (KGuiItem*)buttonYes buttonNo: (KGuiItem*)buttonNo dontAskAgainName: (NSString *)dontAskAgainName options: (int)options;
+ (int) warningYesNo: (QWidget *)parent text: (NSString *)text ;

/** 
 Display a "warning" dialog.

 The second button always has the text "Cancel".

 To be used for questions like "You are about to Print. Are you sure?"
 the continueButton should then be labeled "Print".

 The default button is buttonContinue. Pressing "Esc" selects "Cancel".
  
*/
+ (int) warningContinueCancel: (QWidget *)parent text: (NSString *)text caption: (NSString *)caption buttonContinue: (KGuiItem*)buttonContinue dontAskAgainName: (NSString *)dontAskAgainName options: (int)options;
+ (int) warningContinueCancel: (QWidget *)parent text: (NSString *)text ;

/** 
 Display a "warning" dialog with a listbox to show information to the user.

 The second button always has the text "Cancel".

 To be used for questions like "You are about to Print. Are you sure?"
 the continueButton should then be labeled "Print".

 The default button is buttonContinue. Pressing "Esc" selects "Cancel".
  
*/
+ (int) warningContinueCancelList: (QWidget *)parent text: (NSString *)text strlist: (NSArray *)strlist caption: (NSString *)caption buttonContinue: (KGuiItem*)buttonContinue dontAskAgainName: (NSString *)dontAskAgainName options: (int)options;
+ (int) warningContinueCancelList: (QWidget *)parent text: (NSString *)text strlist: (NSArray *)strlist ;

/** 
 Display a Yes/No/Cancel "warning" dialog.

 To be used for questions "Do you want to save your changes?"
 The text should explain the implication of choosing 'No'.

 The default button is "Yes". Pressing "Esc" selects "Cancel"

 NOTE: The cancel button will always have the i18n'ed text '&Cancel'.
  
*/
+ (int) warningYesNoCancel: (QWidget *)parent text: (NSString *)text caption: (NSString *)caption buttonYes: (KGuiItem*)buttonYes buttonNo: (KGuiItem*)buttonNo dontAskAgainName: (NSString *)dontAskAgainName options: (int)options;
+ (int) warningYesNoCancel: (QWidget *)parent text: (NSString *)text ;

/** 
 Display an "Error" dialog.

 Your program messed up and now it's time to inform the user.
 To be used for important things like "Sorry, I deleted your hard disk."

 If your program detects the action specified by the user is somehow
 not allowed, this should never be reported with -error. Use -sorry
 instead to explain to the user that this action is not allowed. 

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
+ error: (QWidget *)parent text: (NSString *)text caption: (NSString *)caption options: (int)options;
+ error: (QWidget *)parent text: (NSString *)text ;

/** 
 Displays an "Error" dialog with a "Details >>" button.

 Your program messed up and now it's time to inform the user.
 To be used for important things like "Sorry, I deleted your hard disk."

 The @p details message can conatin additional information about
 the problem and can be shown on request to advanced/interested users.

 If your program detects the action specified by the user is somehow
 not allowed, this should never be reported with -error. Use -sorry
 instead to explain to the user that this action is not allowed.

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
+ detailedError: (QWidget *)parent text: (NSString *)text details: (NSString *)details caption: (NSString *)caption options: (int)options;
+ detailedError: (QWidget *)parent text: (NSString *)text details: (NSString *)details ;

/** 
 Like @ref detailedError

 This function will return immediately, the messagebox will be shown
 once the application enters an event loop and no other messagebox
 is being shown.

 Note that if the parent gets deleted, the messagebox will not be
 shown.
   
*/
+ queuedDetailedError: (QWidget *)parent text: (NSString *)text details: (NSString *)details caption: (NSString *)caption;
+ queuedDetailedError: (QWidget *)parent text: (NSString *)text details: (NSString *)details ;

/** 
 Display an "Sorry" dialog.

 Either your program messed up and asks for understanding
 or your user did something stupid.

 To be used for small problems like
 "Sorry, I can't find the file you specified."

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The ok button will always have the i18n'ed text '&OK'.
  
*/
+ sorry: (QWidget *)parent text: (NSString *)text caption: (NSString *)caption options: (int)options;
+ sorry: (QWidget *)parent text: (NSString *)text ;

/** 
 Displays a "Sorry" dialog with a "Details >>" button.

 Either your program messed up and asks for understanding
 or your user did something stupid.

 To be used for small problems like 
 "Sorry, I can't find the file you specified."

 And then @p details can contain something like
 "foobar.txt was not found in any of
  the following directories:
  /usr/bin,/usr/local/bin,/usr/sbin"

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The ok button will always have the i18n'ed text '&OK'.
  
*/
+ detailedSorry: (QWidget *)parent text: (NSString *)text details: (NSString *)details caption: (NSString *)caption options: (int)options;
+ detailedSorry: (QWidget *)parent text: (NSString *)text details: (NSString *)details ;

/** 
 Display an "Information" dialog.

 Your program wants to tell the user something.
 To be used for things like:
 "Your bookmarks have been rearranged."

 The default button is "&OK". Pressing "Esc" selects the OK-button.

  NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
+ information: (QWidget *)parent text: (NSString *)text caption: (NSString *)caption dontShowAgainName: (NSString *)dontShowAgainName options: (int)options;
+ information: (QWidget *)parent text: (NSString *)text ;

/** 
 Enable all messages which have been turned off with the
 @p dontShowAgainName feature of the information dialog.
   
*/
+ enableAllMessages;

/** 
 Display an "About" dialog.

 Your program wants to show some general information about the application
 like the authors's names and email addresses.

 The default button is "&OK".

  NOTE: The ok button will always have the i18n'ed text '&OK'.
   
*/
+ about: (QWidget *)parent text: (NSString *)text caption: (NSString *)caption options: (int)options;
+ about: (QWidget *)parent text: (NSString *)text ;

/** 
 Alternate method to show a messagebox:

*/
+ (int) messageBox: (QWidget *)parent type: (int)type text: (NSString *)text caption: (NSString *)caption buttonYes: (KGuiItem*)buttonYes buttonNo: (KGuiItem*)buttonNo options: (int)options;
+ (int) messageBox: (QWidget *)parent type: (int)type text: (NSString *)text ;
+ queuedMessageBox: (QWidget *)parent type: (int)type text: (NSString *)text caption: (NSString *)caption;
+ queuedMessageBox: (QWidget *)parent type: (int)type text: (NSString *)text ;
+ (int) Ok;
+ (int) Cancel;
+ (int) Yes;
+ (int) No;
+ (int) Continue;
+ (int) QuestionYesNo;
+ (int) WarningYesNo;
+ (int) WarningContinueCancel;
+ (int) WarningYesNoCancel;
+ (int) Information;
+ (int) Sorry;
+ (int) Error;
+ (int) QuestionYesNoCancel;
+ (int) Notify;
+ (int) AllowLink;
@end

#endif
