/***************************************************************************
                            QCanvas.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QCANVAS_H
#define QCANVAS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>
#include <qtobjc/QPainter.h>

@class QCanvasItem;
@class QPixmap;
@class QCanvasView;

@class QCanvasItemList; 

@interface QCanvas : QObject 
- initWithObject: (QObject *)parent name: (NSString *)name;
- init;
- initWithInt: (int)w h: (int)h;
- initWithPixmap: (QPixmap *)p h: (int)h v: (int)v tilewidth: (int)tilewidth tileheight: (int)tileheight;
- (void) dealloc;
- setTiles: (QPixmap *)tiles h: (int)h v: (int)v tilewidth: (int)tilewidth tileheight: (int)tileheight;
- setBackgroundPixmap: (QPixmap *)p;
- (QPixmap*) backgroundPixmap;
- setBackgroundColor: (QColor *)c;
- (QColor*) backgroundColor;
- setTile: (int)x y: (int)y tilenum: (int)tilenum;
- (int) tile: (int)x y: (int)y;
- (int) tilesHorizontally;
- (int) tilesVertically;
- (int) tileWidth;
- (int) tileHeight;
- resize: (int)width height: (int)height;
- (int) width;
- (int) height;
- (QSize*) size;
- (QRect*) rect;
- (BOOL) onCanvas: (int)x y: (int)y;
- (BOOL) onCanvas: (QPoint*)p;
- (BOOL) validChunk: (int)x y: (int)y;
- (BOOL) validChunk: (QPoint*)p;
- (int) chunkSize;
- retune: (int)chunksize maxclusters: (int)maxclusters;
- retune: (int)chunksize ;
- (BOOL) sameChunk: (int)x1 y1: (int)y1 x2: (int)x2 y2: (int)y2;
- setChangedChunk: (int)i j: (int)j;
- setChangedChunkContaining: (int)x y: (int)y;
- setAllChanged;
- setChanged: (QRect*)area;
- setUnchanged: (QRect*)area;
- addItemToChunk: (QCanvasItem*)arg1 i: (int)i j: (int)j;
- removeItemFromChunk: (QCanvasItem*)arg1 i: (int)i j: (int)j;
- addItemToChunkContaining: (QCanvasItem*)arg1 x: (int)x y: (int)y;
- removeItemFromChunkContaining: (QCanvasItem*)arg1 x: (int)x y: (int)y;
//- (QCanvasItemList*) allItems;
//- (QCanvasItemList*) collisions: (QPoint*)arg1;
//- (QCanvasItemList*) collisions: (QRect*)arg1;
//- (QCanvasItemList*) collisions: (QPointArray*)pa item: (QCanvasItem*)item exact: (BOOL)exact;
- drawArea: (QRect*)arg1 p: (QPainter *)p double_buffer: (BOOL)double_buffer;
- drawArea: (QRect*)arg1 p: (QPainter *)p ;
- addView: (QCanvasView*)arg1;
- removeView: (QCanvasView*)arg1;
- drawCanvasArea: (QRect*)arg1 p: (QPainter *)p double_buffer: (BOOL)double_buffer;
- drawCanvasArea: (QRect*)arg1 ;
- drawViewArea: (QCanvasView*)view p: (QPainter *)p r: (QRect*)r dbuf: (BOOL)dbuf;
- addCanvasItem: (QCanvasItem*)arg1;
- addAnimation: (QCanvasItem*)arg1;
- removeCanvasItem: (QCanvasItem*)arg1;
- removeAnimation: (QCanvasItem*)arg1;
- setAdvancePeriod: (int)ms;
- setUpdatePeriod: (int)ms;
- setDoubleBuffering: (BOOL)y;
- advance;
- update;
- drawBackground: (QPainter*)arg1 area: (QRect*)area;
- drawForeground: (QPainter*)arg1 area: (QRect*)area;
@end

/** Override these methods in subclasses of QCanvas to customise event handling behaviour */
@protocol QCanvasEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
