/*****************************************************************

Copyright (c) 2000-2001 the noatun authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIAB\ILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef KABOODLEPART_H
#define KABOODLEPART_H

#include <kparts/part.h>
#include <kurl.h>
#include <kaction.h>
#include <kstdaction.h>
#include <qwidget.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qevent.h>

#include "videoembed.h"
#include "kaboodle_factory.h"
#include "controls.h"
#include "player.h"

class QButton;
class QLabel;

class KaboodlePart : public KParts::ReadOnlyPart
{
Q_OBJECT

public:
	KaboodlePart(QWidget *parent, const char *name, bool showButtons = false, bool viaBrowser = false);
	virtual ~KaboodlePart();
	
	virtual bool openFile();

	/**
	 * automatically play a file after opening it
	 */
	bool autoPlay(void);
	void setAutoPlay(bool);

	/**
	 * if we opened a file on the command line, quit after playing it
	 */
	bool quitAfterPlaying(void);
	void setQuitAfterPlaying(bool);

	bool checkQuit(void);

	void openFile(const KURL &url);
	void setLooping(bool value);
	
	Player *player;

public slots:
	void playerPlaying();
	void playerStopped();
	void playerPaused();
	void playerTimeout();
	void playerOpened(const KURL &);
	void playerFinished();

	void sliderMoved(int);
	void skipToWrapper(int);

	void embedVideo(int);
	
signals:
	void skipTo(unsigned long);

private slots:
	void stop();
	void loop();
	void loopingChange(bool b);
	
	void updateTitle();
	void handleLengthString(const QString &text);
	
private:
	void updateTicks(void);

	KaboodleBrowserExtension *extension;
	KURL lastEmitted;
	
	L33tSlider *slider;
	QLabel *elapsedLabel;
	
	QHBox *box;
	VideoEmbed *videoEmbed;
	KAction *playAction, *pauseAction, *stopAction;
	QButton *playButton, *pauseButton, *stopButton;
	KToggleAction *loopAction;
};

#endif
