/****************************************************************************
    Implementation of QXEmbed class

   Copyright (C) 1999-2000 Troll Tech AS

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*****************************************************************************/

#include <kdebug.h>
#include <klocale.h>

#include <qapplication.h>
#include <qevent.h>
#include <qlabel.h>
#include <qlayout.h>

#include "videoembed.moc"

bool VideoEmbed::eventFilter(QObject *, QEvent *e)
{
	QEvent::Type t = e->type();

	if(t != QEvent::MouseMove && t != QEvent::Timer && t <= QEvent::User)
	{
		switch(e->type())
		{
			case QEvent::FocusIn:
                break;

			case QEvent::FocusOut:
                break;

			case QEvent::Leave:
                /* check to see if we are entering the activex-control somehow... */
                break;

			case QEvent::Enter:
                break;

			case QEvent::WindowActivate:
    	        break;

			case QEvent::WindowDeactivate:
				break;

			default:
				break;
		}
	}

	return false;
}

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

VideoEmbed::VideoEmbed(QWidget *parent, const char *name, WFlags f)
	: QWidget(parent, name, f)
{
	setBackgroundColor(QColor("black"));
    window = 0;
}

VideoEmbed::~VideoEmbed()
{
	if(window != 0)
	{
		XUnmapWindow(qt_xdisplay(), window);
		XReparentWindow(qt_xdisplay(), window, qt_xrootwin(), 0, 0);
        QApplication::flushX();
    }
}
void VideoEmbed::resizeEvent(QResizeEvent *e)
{
	QWidget::resizeEvent(e);

	if(window != 0)
		XResizeWindow(qt_xdisplay(), window, e->size().width(), e->size().height());
}

bool VideoEmbed::event(QEvent *e)
{
	switch(e->type())
	{
		case QEvent::ShowWindowRequest:
			XMapRaised(qt_xdisplay(), window);
			break;
		
		default:
			break;
	}

	return QWidget::event(e);
}

void VideoEmbed::focusInEvent(QFocusEvent *)
{
	if(!window)
		return;

	XEvent ev;
	memset(&ev, 0, sizeof(ev));
	ev.xfocus.type = FocusIn;
	ev.xfocus.window = window;

	XSendEvent(qt_xdisplay(), window, true, NoEventMask, &ev);
}

void VideoEmbed::focusOutEvent(QFocusEvent *)
{
	if(!window)
		return;

	XEvent ev;
	memset(&ev, 0, sizeof(ev));
	ev.xfocus.type = FocusOut;
	ev.xfocus.window = window;
	XSendEvent(qt_xdisplay(), window, true, NoEventMask, &ev);
}

void VideoEmbed::embed(WId w)
{
	if(w == 0)
	{
		setBackgroundColor(QColor("grey"));
  		return;
	}
	window = w;

	setBackgroundMode(NoBackground);

	// first withdraw the window
	XWithdrawWindow(qt_xdisplay(), window, qt_xscreen());
	QApplication::flushX();

	// make sure we will receive destroy notifications for the embedded window.
	XWindowAttributes xwattr;
	XGetWindowAttributes(qt_xdisplay(), winId(), &xwattr);
	XSelectInput(qt_xdisplay(), winId(), SubstructureNotifyMask | xwattr.your_event_mask);

	// now reparent the window to be swallowed by the VideoEmbed widget
	XReparentWindow(qt_xdisplay(), window, winId(), 0, 0);

	// and add it to the save set in case this window gets destroyed before
	XAddToSaveSet(qt_xdisplay(), window);
	
	QApplication::syncX();

	// now resize it
	XResizeWindow(qt_xdisplay(), window, width(), height());
	XMapRaised(qt_xdisplay(), window);

	setFocus();
}

bool VideoEmbed::focusNextPrevChild(bool next)
{
	if(window)
		return false;
	else
		return QWidget::focusNextPrevChild(next);
}

bool VideoEmbed::x11Event(XEvent *e)
{
	switch(e->type)
	{
		case DestroyNotify:
			if(e->xdestroywindow.window == window)
				window = 0;
			break;

		default:
			break;
	}

	return false;
}

QSizePolicy VideoEmbed::sizePolicy() const
{
	return QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
}

QSize VideoEmbed::sizeHint() const
{
	return minimumSizeHint();
}

QSize VideoEmbed::minimumSizeHint() const
{
	if(window)
	{
		XSizeHints size;
		long msize;
		if(XGetWMNormalHints(qt_xdisplay(), window, &size, &msize) && (size.flags & PMinSize))
			return QSize(size.min_width, size.min_height);
	}

	return QSize(0, 0);
}
