/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>

#include "koncd.h"
#include "kstartuplogo.h"
#include "version.h"

static const char *description = I18N_NOOP("<b>KOnCD</b> is an frontend to different cd programs with following features: <br>"
				"- Copies and master CDs on-the-fly.<br>"
    				"- Creates data and bootable CDs.<br>"
				"- Creates audio CDs from wav, mp3 or ogg files.<br>"
				"- Rips CDs to cda, wav, mp3 or ogg files.<br>"
				"- It supports multisession, blanking on CD-RW, <i>disc-at-once</i> mode,<br>"
				"the <i>burn-proof</i> technology and <i>CD-TEXT</i> !<br><br>"
				"Have fun with it !<br><br>" );

static KCmdLineOptions options[] = {
  { 0, 0, 0 }
};

int main(int argc, char *argv[]) {

   KAboutData aboutData("koncd", I18N_NOOP("KOnCD"), KONCD_VERSION, I18N_NOOP( description ),
   			KAboutData::License_GPL, "(C) Copyright 2000-2001 Kai Heitkamp", 0, "http://www.koncd.org", "submit@bugs.kde.org");

 	aboutData.addAuthor("Kai Heitkamp", I18N_NOOP( "Maintainer & core development" ), "kai@kde.org", "http://www.koncd.org");
	aboutData.addCredit("Holger Freyther", I18N_NOOP( "Some contributions for the gui" ), "freyther@yahoo.com", "http://kwebsuite.sf.net");
	aboutData.addCredit("Tobias Jakobs", I18N_NOOP( "KOnCD startlogo design & artwork" ), "tobias.jakobs@web.de");

	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options );

	KApplication a;

	KConfig* config = kapp->config();
	config->setGroup("General Options");

	//Show startuplogo
	KStartupLogo *start_logo = 0L;
	if ( ! config->readBoolEntry("DisableStartlogo" ) ) {
		start_logo = new KStartupLogo();
		start_logo->show();
	}

	KOnCD *koncd = new KOnCD(0, "KOnCD");
	a.setMainWidget( koncd );

	  if ( ! config->readBoolEntry("DisableStartlogo" ) ) {

	  if ( start_logo ) {
	    start_logo->raise();
	    start_logo->setHideEnabled( true );
	    QApplication::flushX();
	  }

		sleep( 3 );
		if ( start_logo ) delete start_logo;
	}

	koncd->show();

	return a.exec();
}
