#include <noatun/engine.h>
#include <noatun/player.h>
#include <noatun/app.h>

#include <qlayout.h>

#include <kglobalaccel.h>
#include <kkeydialog.h>
#include <klocale.h>

#include "keyz.h"

extern "C"
{
	Plugin *create_plugin()
	{
		return new Keyz();
	}
}

KGlobalAccel * Keyz::s_accel = 0L;

Keyz::Keyz() : QObject( 0L, "Keyz" ), Plugin()
{
	NOATUNPLUGINC(Keyz);
	Player *player = napp->player();

	if ( !s_accel )
	{
		s_accel = new KGlobalAccel( this );
		s_accel->insert( "PlayPause", i18n("Play/Pause"), QString::null,
			CTRL+ALT+Key_P, KKey::QtWIN+CTRL+Key_P,
			player, SLOT( playpause() ));
		s_accel->insert( "Stop", i18n("Stop playing"), QString::null,
			CTRL+ALT+Key_S, KKey::QtWIN+CTRL+Key_S,
			player, SLOT( stop() ));
		s_accel->insert( "Back", i18n("Back"), QString::null,
			CTRL+ALT+Key_Left, KKey::QtWIN+CTRL+Key_Left,
			player, SLOT( back() ));
		s_accel->insert( "Forward", i18n("Forward"), QString::null,
			CTRL+ALT+Key_Right, KKey::QtWIN+CTRL+Key_Right,
			player, SLOT( forward() ));
		s_accel->insert( "Playlist", i18n("Show Playlist"), QString::null,
			CTRL+ALT+Key_L, KKey::QtWIN+CTRL+Key_L,
			player, SLOT( toggleListView() ));
		s_accel->insert( "OpenFile", i18n("Open file to play"), QString::null,
			CTRL+ALT+Key_O, KKey::QtWIN+CTRL+Key_O,
			napp, SLOT( fileOpen() ));
		s_accel->insert( "Effects", i18n("Effects configuration"), QString::null,
			CTRL+ALT+Key_E, KKey::QtWIN+CTRL+Key_E,
			napp, SLOT( effectView() ));
		s_accel->insert( "Preferences", i18n("Preferences"), QString::null,
			CTRL+ALT+Key_F, KKey::QtWIN+CTRL+Key_F,
			napp, SLOT( preferences() ));
		s_accel->insert( "VolumeUp", i18n("Volume up"), QString::null,
			CTRL+ALT+SHIFT+Key_Up, KKey::QtWIN+CTRL+SHIFT+Key_Up,
			this, SLOT( slotVolumeUp() ));
		s_accel->insert( "VolumeDown", i18n("Volume Down"), QString::null,
			CTRL+ALT+SHIFT+Key_Down, KKey::QtWIN+CTRL+SHIFT+Key_Down,
			this, SLOT( slotVolumeDown() ));
		s_accel->insert( "SeekForward", i18n("Seek forward"), QString::null,
			CTRL+ALT+SHIFT+Key_Right, KKey::QtWIN+CTRL+SHIFT+Key_Right,
			this, SLOT( slotForward() ));
		s_accel->insert( "SeekBackward", i18n("Seek backward"), QString::null,
			CTRL+ALT+SHIFT+Key_Left, KKey::QtWIN+CTRL+SHIFT+Key_Left,
			this, SLOT( slotBackward() ));

		s_accel->readSettings();
		s_accel->updateConnections();
	}

	new KeyzPrefs(this);
}

Keyz::~Keyz()
{
}

void Keyz::slotVolumeUp()
{
	int vol = napp->player()->volume();
	if ( vol >= 100 )
		return;

	napp->player()->setVolume( vol + 4 );
}

void Keyz::slotVolumeDown()
{
	int vol = napp->player()->volume();
	if ( vol <= 0 )
		return;

	napp->player()->setVolume( vol - 4 );
}

void Keyz::slotForward()
{
	napp->player()->skipTo( QMIN(napp->player()->getLength(), napp->player()->getTime() + 3000) ); // + 3 seconds
}

void Keyz::slotBackward()
{
	napp->player()->skipTo( QMAX( 0, napp->player()->getTime() - 3000 )); // - 3 seconds
}

///////////////////////////////////////////////////////////////////

KeyzPrefs::KeyzPrefs( QObject *parent ) :
	CModule( i18n("Keyz"), i18n("Shortcut Configuration"), "key_bindings", parent )
{
	QVBoxLayout *layout = new QVBoxLayout( this );
	m_chooser = new KKeyChooser( Keyz::accel(), this );
	layout->addWidget( m_chooser );
}

void KeyzPrefs::save()
{
	m_chooser->commitChanges();
	Keyz::accel()->updateConnections();
	Keyz::accel()->writeSettings();
}

#include "keyz.moc"
