/* 
 * Waterfall Spectrum Analyzer Widget
 * Copyright (C) 2001 Tomi Manninen <oh2bns@sral.fi>
 *
 * Based on the Spectrum Widget by Thomas Sailer <sailer@ife.ee.ethz.ch>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __WATERFALL_H__
#define __WATERFALL_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define WATERFALL(obj)		GTK_CHECK_CAST(obj, waterfall_get_type(), Waterfall)
#define WATERFALL_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, waterfall_get_type(), WaterfallClass)
#define IS_WATERFALL(obj)	GTK_CHECK_TYPE(obj, waterfall_get_type())

typedef struct _Waterfall	Waterfall;
typedef struct _WaterfallClass	WaterfallClass;

#define WATERFALL_WIDTH		512
#define WATERFALL_HEIGHT	96
#define	WATERFALL_SIZE		(WATERFALL_WIDTH * WATERFALL_HEIGHT)

struct _Waterfall 
{
	GtkWidget widget;

	guint idlefunc;

	GdkGC *pointer1_gc;
	GdkColor pointer1col;
	GdkGC *pointer2_gc;
	GdkColor pointer2col;

	GdkPixmap *pixmap;

	/* markers */
	gint pointer1;
	gint pointer2;
	gint width;
	gboolean center;

	gfloat start;
	gfloat stop;

	guchar buf[2 * WATERFALL_SIZE];
	guchar *ptr;
};

struct _WaterfallClass
{
	GtkWidgetClass parent_class;
};


guint waterfall_get_type(void);
GtkWidget *waterfall_new(const char *name, void *dummy0, void *dummy1, unsigned int dummy2, unsigned int dummy3);
void waterfall_setdata(Waterfall *spec, unsigned char *data);
void waterfall_setmarker1(Waterfall *spec, gint pointer);
void waterfall_setmarker2(Waterfall *spec, gint pointer);
void waterfall_setwidth(Waterfall *spec, gint width);
void waterfall_setcenter(Waterfall *spec, gboolean center);
void waterfall_setfreqs(Waterfall *spec, gfloat start, gfloat stop);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WATERFALL_H__ */
