	/* ------------------------------------------------------------
 	*      get trx info  (file: QRG)
 	*
 	*--------------------------------------------------------------*/

#include "gettxinfo.h"
#include <curses.h>

  int gettxinfo(void)
  {

  extern int bandinx;
  extern int qrg_string[];
  extern float freq;
  extern int trx_control;
  extern float bandfrequency[];

static  char inputbuffer[20];
static  int qrg;

static  FILE *fp;

  if (trx_control != 1)
  	return(0);

  if  ( (fp = fopen("QRG","r"))  == NULL){
		qrg = 0;
		freq = 0.0;
		return(-1);     /* no QRG file present */
	}
	inputbuffer[0] = 0;
	inputbuffer[1] = 0;
	
	fread (inputbuffer, sizeof(char), 8,  fp);
		
	fclose(fp);
	
    freq = atof(inputbuffer);
    qrg = (int) atof(inputbuffer);
	
    qrg_string[7] = '\0';
	
	switch (qrg)
	{
	  case 1800 ... 1900 :{
	  	bandinx = 0;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	  case 3500 ... 3800 :{
	  	bandinx = 1;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	   case 7000 ... 7100 : {
	  	bandinx = 2;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 10100 ... 10150 : {
	  	bandinx = 3;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 14000 ... 14350 : {
	  	bandinx = 4;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 18068 ... 18168 : {
	  	bandinx = 5;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 21000 ... 21450 : {
	  	bandinx = 6;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 24890 ... 24990 : {
	  	bandinx = 7;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	    case 28000 ... 29700 : {
	  	bandinx = 8;
	  	bandfrequency[bandinx] = freq;
	  	break;
	 }
	
	
	}

   return(0);
  }

