/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "p3dapp.h"

#include "getopt.h"

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

#ifdef WIN32

#include <windows.h>
#include <winsock.h>

#else

/* libxml includes */
#include <tree.h>
#include <parser.h>

#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "simd.h"

/* ---------------------------------------------------------------------- */
  
GtkWidget *specwindow, *scopewindow, *receivewindow, *srcselwidget, *fileselwidget;

/* ---------------------------------------------------------------------- */

struct modulator *modchain = &p3dmodulator;
struct demodulator *demodchain = &p3ddemodulator;

/* ---------------------------------------------------------------------- */

#ifdef WIN32

#define REGISTRYPATH "SOFTWARE\\HB9JNX\\P3D"
#define REGISTRYKEY  HKEY_LOCAL_MACHINE

int xml_setprop(const char *typname, const char *propname, const char *data)
{
        char name[256];
        HKEY key;
        DWORD err;

	snprintf(name, sizeof(name), "%s\\%s", REGISTRYPATH, typname);
        if ((err = RegCreateKeyEx(REGISTRYKEY, name, 0, "", REG_OPTION_NON_VOLATILE,
                                        KEY_WRITE, NULL, &key, NULL)) != ERROR_SUCCESS) {
                g_printerr("RegCreateKeyEx(%s) returned 0x%lx\n", name, err);
                return -1;
        }
        err = RegSetValueEx(key, propname, 0, REG_SZ, data, strlen(data)+1);
        RegCloseKey(key);
        if (err != ERROR_SUCCESS) {
                g_printerr("RegSetValueEx(%s,%s) returned 0x%lx\n", propname, data, err);
                return -1;
        }
        return 0;
}

int xml_getprop(const char *typname, const char *propname, char *buf, unsigned int bufsz)
{
        HKEY key;
        DWORD err, vtype, len;
        char name[256];

        buf[0] = 0;
                snprintf(name, sizeof(name), "%s\\%s", REGISTRYPATH, typname);
        if ((err = RegCreateKeyEx(REGISTRYKEY, name, 0, "", REG_OPTION_NON_VOLATILE,
                                  KEY_READ, NULL, &key, NULL)) != ERROR_SUCCESS) {
                g_printerr("RegCreateKeyEx(%s) returned 0x%lx\n", name, err);
                return -1;
        }
        len = bufsz;
        err = RegQueryValueEx(key, propname, NULL, &vtype, buf, &len);
        RegCloseKey(key);
        if (len >= bufsz)
                len = bufsz-1;
        buf[len] = 0;
        if (err != ERROR_SUCCESS) {
                g_printerr("RegQueryValueEx(%s) returned 0x%lx\n", propname, err);
                return -1;
        }
        if (vtype != REG_SZ)
                return -1;
       return len;
}

#else /* WIN32 */

static xmlDocPtr doc = NULL;
static const char *cfgfile = "/tmp/p3d.conf";

static xmlNodePtr propnode(const char *typname, int create)
{
        xmlNodePtr node2;

        for (node2 = doc->root->childs; node2; node2 = node2->next) {
                if (!node2->name || strcmp(node2->name, typname))
                        continue;
                return node2;
        }
        if (!create)
                return NULL;
        return xmlNewChild(doc->root, NULL, typname, NULL);
}

int xml_setprop(const char *typname, const char *propname, const char *data)
{
        xmlNodePtr node = propnode(typname, 1);
        if (!node)
                return -1;
        xmlSetProp(node, propname, data);
        return 0;
}

int xml_getprop(const char *typname, const char *propname, char *buf, unsigned int bufsz)
{
        xmlNodePtr node = propnode(typname, 0);
        const char *cp;
        
        buf[0] = 0;
        if (!node)
                return -1;
        if (!(cp = xmlGetProp(node, propname)))
                return -1;
        strncpy(buf, cp, bufsz);
        buf[bufsz-1] = 0;
        return strlen(buf);
}

#endif /* WIN32 */

/* ---------------------------------------------------------------------- */

int main (int argc, char *argv[])
{
        static const struct option long_options[] = {
		{ 0, 0, 0, 0 }
        };
        int c, err = 0;
        unsigned int verblevel = 10, tosyslog = 0, simd = 1;
#ifdef WIN32
	WORD wVersionRequested;
        WSADATA wsaData;
#else
        char cfgfilestore[128], *cp;
#endif
        

#ifdef ENABLE_NLS
	bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain(PACKAGE);
#endif

	gtk_set_locale();
	gtk_init(&argc, &argv);

	add_pixmap_directory(PACKAGE_DATA_DIR "/pixmaps");
	add_pixmap_directory(PACKAGE_SOURCE_DIR "/pixmaps");

	specwindow = create_specwindow();
	scopewindow = create_scopewindow();
	receivewindow = create_receivewindow();
	srcselwidget = create_audiosrcselwindow();
	fileselwidget = create_audiofileselwindow();

	{
		GtkWidget *w;
		GtkStyle *st;
		GdkFont *font = gdk_font_load("-*-courier-medium-r-normal-*-*-120-*-*-m-*-*-*");
		if (!font) {
			g_printerr("Cannot load courier\n");
		} else {
			w = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(receivewindow), "packetraw"));
			st = gtk_style_copy(w->style);
			gtk_style_unref(w->style);
			gdk_font_unref(st->font);
			gdk_font_ref(font);
			st->font = font;
			gtk_style_ref(st);
			w->style = st;
			w = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(receivewindow), "packetcooked"));
			gtk_style_unref(w->style);
			gtk_style_ref(st);
			w->style = st;
		}
	}

        while ((c = getopt_long(argc, argv, "v:sS", long_options, NULL)) != EOF) {
                switch (c) {
                case 'v':
                        verblevel = strtoul(optarg, NULL, 0);
                        break;

                case 's':
                        tosyslog = 1;
                        break;

                case 'S':
                        simd = 0;
                        break;

                default:
                        err++;
                        break;
                }
        }
        if (err) {
                fprintf(stderr, "usage: [<configfile>]\n");
                exit(1);
        }
        loginit(verblevel, tosyslog);
        initsimd(simd);
        ioinit_filein();
        ioinit_soundcard();
#ifdef WIN32
	wVersionRequested = MAKEWORD(1, 1);
        if (WSAStartup(wVersionRequested, &wsaData)) {
		g_printerr("P3D: Win32 Socket startup failed\n");
		exit(1);
	}
	if (LOBYTE(wsaData.wVersion) != 1 || HIBYTE(wsaData.wVersion) != 1) {
		g_printerr("P3D: Win32 Socket version 1.1 not supported\n");
                WSACleanup();
		exit(1);
	}
#else /* WIN32 */
        if (optind < argc)
                cfgfile = argv[optind];
        else if ((cp = getenv("HOME"))) {
                snprintf(cfgfilestore, sizeof(cfgfilestore), "%s/.p3d.conf", cp);
                cfgfile = cfgfilestore;
        }                
        doc = xmlParseFile(cfgfile);
        if (doc && (!doc->root || !doc->root->name || strcmp(doc->root->name, "modem"))) {
                g_printerr("P3D Config: Invalid configuration file %s\n", cfgfile);
                exit(1);
        }
        if (!doc && (doc = xmlNewDoc("1.0")))
                doc->root = xmlNewDocNode(doc, NULL, "modem", NULL);
        if (!doc || !doc->root) {
                g_printerr("P3D Config: out of memory\n");
                exit(1);
        }
#endif /* WIN32 */
	do_source_select();
	gtk_main();
#ifdef WIN32
#else /* WIN32 */
        if (!xmlSaveFile(cfgfile, doc)) 
		g_printerr("P3D Config: error saving configuration file %s\n", cfgfile);
        xmlFreeDoc(doc);
#endif /* WIN32 */
	diag_stop();
#ifdef WIN32
	WSACleanup();
#endif /* WIN32 */
	return 0;
}

