/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __screenpageimpl_h__
#define __screenpageimpl_h__

#include "screenpage.h"
#include "kxpage.h"
#include "kxdata.h"

class NewResolutionDialog;
class TuneResolutionDialog;

class ScreenPage : public ScreenPageBase, public KXPage
{
    Q_OBJECT
    Q_PROPERTY( QString quickHelp READ quickHelp )
  public:
    ScreenPage( QWidget *parent, const char *name = 0 );
    virtual ~ScreenPage();

    QString quickHelp() const;

    // reimplemented from KXPage
    virtual void load();
    virtual void save();

    static bool checkCompatibility( const KXModeData &mode, const KXMonitorData &monitor,
                                    const KXVideoCardData &card );
    static bool checkVideoMemory( const KXVideoCardData &card, const QSize &resolution,
                                  int colorDepth );

  protected slots:
    void slotNewResolution();
    void slotTuneResolution();
    void slotTestResolution();

  signals:
    void enableForward( bool );
    void changed();
    void status( const QString & );

  private slots:
    void setupRefreshCombo();
    void setupColorCombo();
    void setupVirtualCombo();

  private:
    bool createModeList();
    void sortModes();
    void setupModeControls();
    
    KXModeData selectedMode();
    int selectedColorDepth();

    void selectCurrentMode();

    QSize stringToResolution(const QString &res);
    QString resolutionToString(const QSize &res);

    QString colorDepthToString( int depth );
    int stringToColorDepth( const QString &str );

    KXModeDataList m_modes;

    NewResolutionDialog   *m_newDialog;
    TuneResolutionDialog  *m_tuneDialog;
};

#endif
