#ifndef COMMON_INTER_H
#define COMMON_INTER_H

#include "generic/ghighscores.h"

#include "lib/mp_simple_interface.h"
#include "base/inter.h"
#include "types.h"
#include "board.h"


class Field;

class Interface : public MPSimpleInterface, public BaseInterface
{
 Q_OBJECT
 public:
	Interface(const MPGameInfo &, QWidget *parent);

 public slots:
    void normalGame();
    void arcadeGame();

 private:
	QMemArray<ClientPlayData> data;
    QValueList<KExtHighscores::Score> gameOverData;
    Field *_firstField;

    enum Action { Nb_Actions = 6 };
    static const ActionData ACTION_DATA[Nb_Actions];
    static const int KEYCODE_ONE[Nb_Actions];
    static const int KEYCODE_TWO[Nb_Actions];

	MPBoard *newBoard(uint);
    void setInitData(uint player, ServerInitData &);
	uint prev(uint i) const;
	uint next(uint i) const;
    void resizeGameOverData(uint size);

    void _readGameOverData(QDataStream &s);
	void _sendGameOverData(QDataStream &s);
	void _firstInit() {}
	void _treatInit();
	void _init(bool server);
	void _showGameOverData(bool server);
	bool _readPlayData();
	void _sendPlayData();

    void _start() { MPSimpleInterface::start(); }
    void _pause() { MPSimpleInterface::pause(); }
    bool _isPaused() const { return MPSimpleInterface::isPaused(); }
};

#endif
