//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMPOLYNOM_H
#define PMPOLYNOM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmsolidobject.h"
#include "pmvector.h"

/**
 * Class for povray polynoms.
 */ 

class PMPolynom : public PMSolidObject
{
   typedef PMSolidObject Base;
public:
   /** Creates an empty PMPolynom */
   PMPolynom( );
   /** deletes the PMPolynom */
   virtual ~PMPolynom( );

   /** */
   virtual PMObject* newObject( ) const { return new PMPolynom( ); }
   /** */
   virtual QString className( ) const { return QString( "polynom" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTPolynom; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   /** */
   virtual QString pixmap( ) const { return QString( "pmpolynom" ); }
   /** Returns a new @ref PMPolynomEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** */
   virtual void restoreMemento( PMMemento* s );
   
   /** */
   int polynomOrder( ) const { return m_order; }
   /** Sets the polynom order */
   void setPolynomOrder( int order );
   /** Returns the coefficients. */
   PMVector coefficients( ) const { return m_coefficients; }
   /** Sets the coefficients. */
   void setCoefficients( const PMVector& p );
   /** Returns the sturm flag */
   bool sturm( ) const { return m_sturm; }
   /** Sets the sturm flag */
   void setSturm( bool s );
private:
   enum PMPolynomMementoID { PMOrderID, PMCoefficientsID, PMSturmID };
   int m_order;
   PMVector m_coefficients;
   bool m_sturm;
};

#endif
