/*
    simplestringlisteditor.h

    A simple widget to edit a list of strings.
    Copyright (c) 2001 Marc Mutz <mutz@kde.org>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License,
    version 2.0, as published by the Free Software Foundation.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, US
*/

#ifndef _SIMPLESTRINGLISTEDITOR_H_
#define _SIMPLESTRINGLISTEDITOR_H_

#include <qwidget.h>
#include <qstringlist.h>
#include <qstring.h>

class QListBox;
class QPushButton;

//
//
// SimpleStringListEditor (a listbox with "add..." and "remove" buttons)
//
//

class SimpleStringListEditor : public QWidget {
  Q_OBJECT
public:
  enum ButtonCode {
    None = 0x00, Add = 0x01,
    Remove = 0x02, Modify = 0x04,
    Up = 0x08, Down = 0x10,
    All = Add|Remove|Modify|Up|Down,
    Unsorted = Add|Remove|Modify
  };

  /** Constructor. Populates the list with @p strings. */
  SimpleStringListEditor( QWidget * parent=0, const char * name=0,
			  ButtonCode buttons=Unsorted,
			  const QString & addLabel=QString::null,
			  const QString & removeLabel=QString::null,
			  const QString & modifyLabel=QString::null,
			  const QString & addDialogLabel=QString::null );

  /** Sets the list of strings displayed to @p strings */
  void setStringList( const QStringList & strings );
  /** Adds @p strings to the list of displayed strings */
  void appendStringList( const QStringList & strings );
  /** Retrieves the current list of strings */
  QStringList stringList() const;

  /** Sets the text of button @p button to @p text */
  void setButtonText( ButtonCode button, const QString & text );

signals:
  /** Connected slots can alter the argument to be added or set the
      argument to QString::null to suppress adding.
  */
  void aboutToAdd(QString&);

protected slots:
  void slotAdd();
  void slotRemove();
  void slotModify();
  void slotUp();
  void slotDown();

  void slotSelectionChanged();

protected:
  QListBox      *mListBox;
  QPushButton   *mAddButton;
  QPushButton   *mRemoveButton;
  QPushButton   *mModifyButton;
  QPushButton   *mUpButton;
  QPushButton   *mDownButton;
  const QString mAddDialogLabel;
};




#endif // _SIMPLESTRINGLISTEDITOR_H_
