/***************************************************************************
                          reportview.h  -  description
                             -------------------
    begin                : Sun Oct 15 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef REPORTVIEW_H
#define REPORTVIEW_H

#include <kdialogbase.h>
#include <qstringlist.h>

class KHTMLPart;

/**This is the main report generated for the user.
  *@author Ian Reinhart Geiser
  */

class reportView : public KDialogBase {
    Q_OBJECT

public:
    reportView(QString reportLocation);
    ~reportView();
    
    void render();
    void setLocation( QString location );
    void setTemp( QString temp );
    void setDewPoint( QString dewpoint );
    void setRelHumidity( QString relhumidity );
    void setHeatIndex( QString heatIndex );
    void setWindChill( QString windchill );
    void setWind( QString wind );
    void setDate( QString date );
    void setPressure( QString pressure );
    void setCover( QStringList cover );
    void setWeather( QStringList weather );
    void setWeatherIcon( const QString &icon );

private:
    KHTMLPart *theReport;
    QString locationCode;
    QString currentTemp;
    QString currentDewPoint;
    QString currentRelHumidity;
    QString currentHeatIndex;
    QString currentWindChill;
    QString currentTime;
    QString currentPressure;
    QString currentWind;
    QString currentDate;
    QStringList currentCover;
    QStringList currentWeather;
    QString currentIcon;
};

#endif
