/* GnomeICU
 * Copyright (C) 1998-2002 Jeremy Wise
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**** Emoticon themes handling ****/

#include "common.h"
#include "gnomeicu.h"
#include "emoticons.h"

#include <gtk/gtk.h>
#include <string.h>

GSList *Emoticons;

static gboolean emoticon_themes_initialized = FALSE;

/*** Local functions ***/
GdkPixbuf *init_one_emoticon (gchar * icon_name);
GdkPixbuf *init_one_emoticon_theme (gchar *icon_name, gchar *theme);

/*** Global functions ***/
gchar *make_emoticon_path_theme (const gchar * file_name, const gchar * theme_name)
{
	gchar *file;
        gchar *tname = NULL;

	if (theme_name == NULL) {
          tname = preferences_get_string (PREFS_GNOMEICU_EMOTICON_THEMES);
          theme_name = tname;
        }

	/* Local themes */
	file =
	    g_strconcat (g_get_home_dir (), "/.icq/emoticons/", theme_name, "/",
			 file_name, NULL);

	if (!g_file_test ((file), G_FILE_TEST_EXISTS)) {   /* Local theme does not exist */
		/* Global themes */
		gchar *theme_path = GNOMEICU_DATADIR "/gnomeicu/emoticons/";

		g_free (file);
		file =
		    g_strconcat (theme_path, theme_name, "/", file_name, NULL);

		if (!g_file_test ((file), G_FILE_TEST_EXISTS)) {	/* Theme does not exist, use Default */
			g_free (file);
			file =
			    g_strconcat (theme_path, "Default/", file_name,
					 NULL);

			if (!g_file_test ((file), G_FILE_TEST_EXISTS)) {	/* Nothing exists */
				g_free (file);
				file = NULL;
			}
		}
	}

        g_free (tname);

	return file;
}

gchar *make_emoticon_path (gchar * file_name)
{
	return make_emoticon_path_theme (file_name, NULL);
}

GdkPixbuf *init_one_emoticon (gchar * icon_name)
{
	GdkPixbuf *im = NULL;
	gchar *icon_filename;

	icon_filename = make_emoticon_path (icon_name);
	
	if (icon_filename)
		im = gdk_pixbuf_new_from_file (icon_filename, NULL);

	g_free (icon_filename);
	return im;
}

GdkPixbuf *init_one_emoticon_theme (gchar * icon_name, gchar *theme)
{
	GdkPixbuf *im = NULL;
	gchar *icon_filename;

	icon_filename = make_emoticon_path_theme (icon_name, theme);
	
	if (icon_filename)
		im = gdk_pixbuf_new_from_file (icon_filename, NULL);

	g_free (icon_filename);
	return im;
}

static void
emoticon_themes_load (void)
{
	gchar *index_filename;
	gchar *buf;
	GError *error;
	gchar **lines, **aline;
	gint cx, cy;
	GdkPixbuf *pixbuf;
        gchar *string;

#ifdef TRACE_FUNCTION
	g_print ("emoticons_init\n");
#endif

        string = preferences_get_string (PREFS_GNOMEICU_EMOTICON_THEMES);
        if (!strcmp (string, "None")) {
          g_free (string);
          return;
        }
        g_free (string);

	index_filename = make_emoticon_path ("emoticon-data");

	Emoticons = NULL;

	if (g_file_get_contents (index_filename, &buf, NULL, &error)) {
		lines = g_strsplit (buf, "\n", 0);
		for (cx = 0; lines[cx] != NULL; cx++) {
			if (lines[cx] && lines[cx][0] != '\0') {
				aline = g_strsplit (lines[cx], "\t", 0);
				pixbuf = init_one_emoticon (aline[0]);
				if (pixbuf) {
					for (cy = 1; aline[cy] != NULL; cy++) {
						if (aline[cy] && aline[cy][0] != '\0') {
							Emoticon *e = g_new0(Emoticon, 1);
							e->string = g_strdup (aline[cy]);
							e->pixbuf = pixbuf;
							Emoticons = g_slist_append (Emoticons, e);
						}
					}
				}
				g_strfreev (aline);
			}
		}
		g_strfreev (lines);
	}

	g_free (index_filename);

	index_filename = make_emoticon_path_theme ("emoticon-data", "Always");

	if (g_file_get_contents (index_filename, &buf, NULL, &error)) {
		lines = g_strsplit (buf, "\n", 0);
		for (cx = 0; lines[cx] != NULL; cx++) {
			if (lines[cx] && lines[cx][0] != '\0') {
				aline = g_strsplit (lines[cx], "\t", 0);
				pixbuf = init_one_emoticon_theme (aline[0], "Always");
				if (pixbuf) {
					for (cy = 1; aline[cy] != NULL; cy++) {
						if (aline[cy] && aline[cy][0] != '\0') {
							Emoticon *e = g_new0(Emoticon, 1);
							e->string = g_strdup (aline[cy]);
							e->pixbuf = pixbuf;
							Emoticons = g_slist_append (Emoticons, e);
						}
					}
				}
				g_strfreev (aline);
			}
		}
		g_strfreev (lines);
	}

	g_free (index_filename);
}

void
emoticon_themes_refresh (void)
{
  emoticon_themes_load ();
}

void
emoticon_themes_init (void)
{
  if (emoticon_themes_initialized)
    return;

  emoticon_themes_load ();
  preferences_watch_key (PREFS_GNOMEICU_EMOTICON_THEMES,
                         emoticon_themes_refresh);

  emoticon_themes_initialized = TRUE;
}
