/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmrotate.h"
#include "pmrotateedit.h"

#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"
#include "pmrotatecontrolpoint.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <klocale.h>
#include <qdom.h>

const PMVector rotateDefault = PMVector( 0, 0, 0 );

PMRotate::PMRotate( )
      : Base( )
{
}

PMRotate::~PMRotate( )
{
}

QString PMRotate::description( ) const
{
   return i18n( "rotate" );
}

void PMRotate::serialize( PMOutputDevice& dev ) const
{
   QString vector;
   QTextStream str( &vector, IO_WriteOnly );
   int i;
   bool z[3];
   
   for( i = 0; i < 3; i++ )
      z[i] = approxZero( m_rotate[i] );
   if( !z[0] && z[1] && z[2] )
   {
      str << "x*";
      i = 0;
   }
   else if( z[0] && !z[1] && z[2] )
   {
      str << "y*";
      i = 1;
   }
   else if( z[0] && z[1] && !z[2] )
   {
      str << "z*";
      i = 2;
   }

   if( i < 3 )
   {
      if( m_rotate[i] > 0 )
         str << m_rotate[i];
      else
         str << "(" << m_rotate[i] << ")";
   }
   else
   {
      str << '<';
      for( i = 0; i < 3; i++ )
      {
         if( i > 0 )
            str << ", ";
         str << m_rotate[i];
      }
      str << '>';
   }

   dev.writeLine( "rotate " + vector );
}

void PMRotate::serialize( QDomElement& e, QDomDocument& /*doc*/ ) const
{
   e.setAttribute( "value", m_rotate.serializeXML( ) );
}

void PMRotate::readAttributes( const PMXMLHelper& h )
{
   m_rotate = h.vectorAttribute( "value", rotateDefault );
}

bool PMRotate::isA( PMObjectType t ) const
{
   if( t == PMTRotate )
      return true;
   return Base::isA( t );
}

void PMRotate::setRotation( const PMVector& p )
{
   if( p != m_rotate )
   {
      if( m_pMemento )
      {
         m_pMemento->addData( PMTRotate, PMRotationID, m_rotate );
         m_pMemento->setViewStructureChanged( );
      }         
      m_rotate = p;
      m_rotate.resize( 3 );
   }
}

PMDialogEditBase* PMRotate::editWidget( QWidget* parent ) const
{
   return new PMRotateEdit( parent );
}

void PMRotate::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTRotate )
      {
         switch( data->valueID( ) )
         {
            case PMRotationID:
               setRotation( data->vectorData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMRotate::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}

PMMatrix PMRotate::transformationMatrix( ) const
{
   return PMMatrix::rotation( deg2Rad( m_rotate[0] ), deg2Rad( m_rotate[1] ),
                              deg2Rad( m_rotate[2] ) );
}

void PMRotate::controlPoints( PMControlPointList& list )
{
   list.append( new PMRotateControlPoint( m_rotate, PMRotationID ) );
}

void PMRotate::controlPointsChanged( PMControlPointList& list )
{
   PMControlPoint* p;

   for( p = list.first( ); p; p = list.next( ) )
   {
      if( p->changed( ) )
      {
         switch( p->id( ) )
         {
            case PMRotationID:
               setRotation( ( ( PMRotateControlPoint* ) p )->rotation( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMRotate::controlPointsChanged\n";
               break;
         }
      }
   }
}
