/***************************************************************************
                          startupwindow.cpp  -  description
                             -------------------
    begin                : Sam Aug 17 2002
    copyright            : (C) 2002 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "startupwindow.h"

#include <qcheckbox.h>
#include <qfile.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtextstream.h>

#include <kaboutdata.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>
#include <kseparator.h>
#include <kstandarddirs.h>
#include <kstdguiitem.h>
#include <ktextbrowser.h>
#include <ktip.h>
#include <kstandarddirs.h>

#include <kdebug.h>

StartUpWindow::StartUpWindow(QWidget *parent, const char *name ) : KDialog/*QWidget*/(parent,name) {
kdDebug()<<"StartUpWindow::StartUpWindow(QWidget *"<<parent<<", const char *"<<name<<" )"<<endl;

	_database = new KTipDatabase( /*locate("data", QString("kderec/tips") )*/ );

	setCaption( i18n( "Startup-Information / First Tutorial" ) );

	setMinimumWidth( 500 );
	setMinimumHeight( 300 );

	QVBoxLayout *vbox = new QVBoxLayout(this, marginHint(), spacingHint());

	/**
	 * Parent is 0L when TipDialog is used as a mainWidget. This should
	 * be the case only in ktip, so let's use the ktip layout.
	 */
	bool isTipDialog = true; //(parent != 0);

kdDebug()<<"StartUpWindow::isTipDialog = "<<isTipDialog<<endl;

#if 0
	if (isTipDialog)
	{
		QHBoxLayout *pl = new QHBoxLayout(vbox, 0, 0);

		QLabel *bulb = new QLabel(this);
		bulb->setPixmap(locate("data", "kdeui/pics/ktip-bulb.png"));
		pl->addWidget(bulb);

		QLabel *titlePane = new QLabel(this);
		titlePane->setBackgroundPixmap(locate("data", "kdeui/pics/ktip-background.png"));
		titlePane->setText(i18n("Did you know...?\n"));
		titlePane->setFont(QFont(KGlobalSettings::generalFont().family(), 20,  QFont::Bold));
		titlePane->setAlignment(QLabel::AlignCenter);
		pl->addWidget(titlePane, 100);
	}
#endif

	QHBox *hbox = new QHBox(this);
	hbox->setSpacing(0);
	hbox->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	vbox->addWidget(hbox);

	QHBox *tl = new QHBox(hbox);
	tl->setMargin(7);
	tl->setBackgroundColor(QColor(49, 121, 172));

	QHBox *topLeft = new QHBox(tl);
	topLeft->setMargin(15);
	QColor bgColor(213, 222, 238);
	topLeft->setBackgroundColor(bgColor);

	_tipText = new KTextBrowser(topLeft);
	_tipText->mimeSourceFactory()->addFilePath(KGlobal::dirs()->findResourceDir("data", "kdewizard/pics")+"kdewizard/pics/");
	_tipText->setFrameStyle(QFrame::NoFrame | QFrame::Plain);
	_tipText->setHScrollBarMode(QScrollView::AlwaysOff);
	QStringList icons = KGlobal::dirs()->resourceDirs("icon");
	QStringList::Iterator it;
	for (it = icons.begin(); it != icons.end(); ++it)
	    _tipText->mimeSourceFactory()->addFilePath(*it);

#if 0
	if (!isTipDialog)
	{
		QLabel *l = new QLabel(hbox);
		l->setPixmap(locate("data", "kdewizard/pics/wizard_small.png"));
		l->setBackgroundColor(QColor(49, 121, 172));
		l->setAlignment(Qt::AlignRight | Qt::AlignBottom);

		resize(550, 230);
		QSize sh = size();
		QRect rect = KApplication::desktop()->screenGeometry();
		move(rect.x() + (rect.width() - sh.width())/2,
		        rect.y() + (rect.height() - sh.height())/2);
	}
#endif

	KSeparator* sep = new KSeparator( KSeparator::HLine, this);
	vbox->addWidget(sep);

	QHBoxLayout *hbox2 = new QHBoxLayout(vbox, 4);

	_tipOnStart = new QCheckBox(i18n("&Show tips on startup"), this);
	hbox2->addWidget(_tipOnStart, 1);

	KPushButton *prev = new KPushButton( KStdGuiItem::back(
	        KStdGuiItem::UseRTL ), this );
	prev->setText( i18n("&Previous") );
	hbox2->addWidget(prev);

	KPushButton *next = new KPushButton( KStdGuiItem::forward(
	        KStdGuiItem::UseRTL ), this );
	next->setText( i18n("&Next") );
	hbox2->addWidget(next);

	KPushButton *ok = new KPushButton(KStdGuiItem::close(), this);
	ok->setDefault(true);
	hbox2->addWidget(ok);

	KConfigGroup config(kapp->config(), "TipOfDay");
	_tipOnStart->setChecked(config.readBoolEntry("RunOnStart", true));

	connect(next, SIGNAL(clicked()), this, SLOT(nextTip()));
	connect(prev, SIGNAL(clicked()), this, SLOT(prevTip()));
	connect(ok, SIGNAL(clicked()), this, SLOT(close()));
	connect(_tipOnStart, SIGNAL(toggled(bool)), this, SLOT(showOnStart(bool)));

	ok->setFocus();

	nextTip();
}

StartUpWindow::~StartUpWindow(){
kdDebug()<<"StartUpWindow::~StartUpWindow()"<<endl;
}

void StartUpWindow::showOnStart(bool on){
	emit sShowOnStart(on);
}

void StartUpWindow::prevTip()
{
	_database->prevTip();
	_tipText->setText(QString::fromLatin1("<qt text=\"%1\" bgcolor=\"%2\">%3</qt>").arg(QColor(0, 0, 0).name()).arg(QColor(213, 222, 238).name()).arg(i18n(_database->tip().utf8())));
}

void StartUpWindow::nextTip()
{
	_database->nextTip();
	_tipText->setText(QString::fromLatin1("<qt text=\"%1\" bgcolor=\"%2\">%3</qt>").arg(QColor(0, 0, 0).name()).arg(QColor(213, 222, 238).name()).arg(i18n(_database->tip().utf8())));
}

#include "startupwindow.moc"

// for Matthias Kretz ;-)
// vim:sw=4:ts=4
