/* $Id: reportmain.cpp,v 1.3 2002/05/02 23:11:45 nhasan Exp $ */

#include <stdlib.h>
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <dcopclient.h>
#include "reportview.h"

int main (int argc, char *argv[])
{
	KLocale::setMainCatalogue("kdelibs");
	KAboutData aboutdata("reportview", I18N_NOOP("KDE"),
				"0.8", I18N_NOOP("Default weather report for KWeatherService"),
				KAboutData::License_GPL, "(C) 2002, Ian Reinhart Geiser");
	aboutdata.addAuthor("Ian Reinhart Geiser",I18N_NOOP("Developer"),"geiseri@kde.org");
	aboutdata.addAuthor("Nadeem Hasan",I18N_NOOP("Developer"),"nhasan@kde.org");

	KCmdLineArgs::init( argc, argv, &aboutdata );
	// KCmdLineArgs::addCmdLineOptions( options );
	KApplication app(argc, argv, "client", false);
	DCOPClient *client = app.dcopClient();
	client->attach();
	QString error = "";
	QCString appID = "";
	if (!client->isApplicationRegistered("kweatherservice"))
			{
				if(KApplication::startServiceByName("kweatherservice",QStringList(), &error, &appID ))
				{
					kdDebug() << "Starting kweatherservice failed with message: " << error << endl;
					exit(0);
				}
	}
	// actually grab the desired weather report
	
	// do the report
	QString reportLocation = "";
	reportView *theReport = new reportView(reportLocation);
	// Nadeem where did the report code go?
	
	//
	theReport->render();
	theReport->show();
	return app.exec();
}
