/*
  Digital signature methods.
*/
#ifndef _MAGICK_SIGNATURE_H
#define _MAGICK_SIGNATURE_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/*
  Define declarations.
*/
#define SignatureSize  64

/*
  Typedef declarations.
*/
typedef struct _SignatureInfo
{   
  unsigned long
    digest[8],
    low_order,
    high_order;

  long
    offset;

  unsigned int
    lsb_first;

  unsigned char
    message[SignatureSize];
} SignatureInfo;

/*
  Method declarations.
*/
extern MagickExport double
  GetRandomValue(void);

extern MagickExport unsigned int
  SignatureImage(Image *);

extern MagickExport void
  DestroyRandomReservoir(void),
  DistillRandomEvent(const unsigned char *,const size_t),
  FinalizeSignature(SignatureInfo *),
  GetRandomKey(unsigned char *,const size_t),
  GetSignatureInfo(SignatureInfo *),
  TransformSignature(SignatureInfo *),
  UpdateSignature(SignatureInfo *,const unsigned char *,const size_t);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
