#ifndef MODINITTOOLS_TABLES_H
#define MODINITTOOLS_TABLES_H

/* Taken from the 2.5.49 kernel, with the kernel specific fields removed */
struct pci_device_id {
	unsigned int vendor, device;		/* Vendor and device ID or PCI_ANY_ID */
	unsigned int subvendor, subdevice;	/* Subsystem ID's or PCI_ANY_ID */
	unsigned int class, class_mask;		/* (class,subclass,prog-if) triplet */
};
#define PCI_DEVICE_SIZE32 (6 * 4 + 4)
#define PCI_DEVICE_SIZE64 (6 * 4 + 8)

struct usb_device_id {
	/* which fields to match against? */
	unsigned short	match_flags;

	/* Used for product specific matches; range is inclusive */
	unsigned short	idVendor;
	unsigned short	idProduct;
	unsigned short	bcdDevice_lo;
	unsigned short	bcdDevice_hi;

	/* Used for device class matches */
	unsigned char	bDeviceClass;
	unsigned char	bDeviceSubClass;
	unsigned char	bDeviceProtocol;

	/* Used for interface class matches */
	unsigned char	bInterfaceClass;
	unsigned char	bInterfaceSubClass;
	unsigned char	bInterfaceProtocol;

};
#define USB_DEVICE_SIZE32 (5 * 2 + 6 * 1 + 4)
#define USB_DEVICE_SIZE64 (5 * 2 + 6 * 1 + 8)

struct ieee1394_device_id {
	unsigned int match_flags;
	unsigned int vendor_id;
	unsigned int model_id;
	unsigned int specifier_id;
	unsigned int version;
};
#define IEEE1394_DEVICE_SIZE32 (5 * 4 + 4)
#define IEEE1394_DEVICE_SIZE64 (5 * 4 + 4 /*padding*/ + 8)

struct ccw_device_id {
	unsigned short match_flags;	/* which fields to match against */

	unsigned short cu_type;		/* control unit type     */
	unsigned short dev_type;	/* device type           */
	unsigned char  cu_model;	/* control unit model    */
	unsigned char  dev_model;	/* device model          */
};
#define CCW_DEVICE_SIZE32 (3 * 2 + 2 * 1 + 4)
#define CCW_DEVICE_SIZE64 (3 * 2 + 2 * 1 + 8)

/* Functions provided by tables.c */
struct module;
void output_usb_table(struct module *modules, FILE *out);
void output_ieee1394_table(struct module *modules, FILE *out);
void output_pci_table(struct module *modules, FILE *out);
void output_ccw_table(struct module *modules, FILE *out);

#endif /* MODINITTOOLS_TABLES_H */
