/*****************************************************************************\
  models.cpp : Printer model mapping

  Copyright (c) 1996 - 2001, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/


#include "models.h"

APDK_BEGIN_NAMESPACE

extern void HP_strcat(char* str1, const char* str2);

// ordered list used by DevIDtoPT
// this and following list must match
/*! Do not use DevIDMap - it is going away in the next version.
\depricated
*/
PRINTER_TYPE DevIDMap[MAX_ID_STRING]={
eDJ400,     // DJ 400
eDJ540,     // DJ 540
eDJ600,     // DJ 600
eDJ6xxPhoto,    // DJ 610
eDJ630,     // DJ 630
eDJ6xxPhoto,    // DJ 640
eDJ630, // eAP2xxx,     // DJ 656 - HP Bolt
eDJ6xxPhoto,    // DJ 690
eDJ6xx,     // DJ 660
eDJ6xx,     // DJ 670
eDJ6xx,     // DJ 680
eDJ6xx,     // DJ 6xx
eDJ8xx,     // DJ 810
eDJ8x5,     // DJ 825
eDJ8xx,     // DJ 830
eDJ8x5,     // DJ 845
eDJ8xx,     // DJ 840
eDJ850,     // DJ 850
eDJ850,     // DJ 870
eDJ8xx,     // DJ 880
eDJ890,     // DJ 890
eDJ8xx,     // DJ 895
eDJ9xx,     // DJ 916 - Thriftway Lite (Europe)
eDJ9xx,     // DJ 920 - Thriftway Lite
eDJ9xx,     // DJ 930
eDJ9xx,     // DJ 94x
eDJ9xx,     // DJ 950
eDJ9xxVIP,  // DJ 960
eDJ9xx,     // DJ 970
eDJ9xxVIP,  // DJ 980
eDJ9xxVIP,  // DJ 990, 995 (Jeeni)
eDJ3320,    // DJ 3320 - Crossbow
eDJ3320,    // DJ 3420 - Crossbow
eDJ3320,    // DJ 3325 - Crossbow
eDJ9xx,     // DJ 3810 - Subway
eDJ9xx,     // DJ 3816 - Subway
eDJ9xx,     // DJ 3820 - Subway
eDJ9xx,     // DJ 3822 - Subway
eDJ9xxVIP,  // DJ 6122 - Churchill
eDJ9xxVIP,  // DJ 6127 - FDR
eDJ6xx,     // e-printer
eAP2xxx,    // Apollo P-22
eAP21xx,    // Apollo P2000U
eAP2560,    // Apollo P2500/2600
eDJ350,     // DJ 350
eDJGenericVIP,  // DJ 450
eDJ9xx,     // PS P1000
eDJ9xx,     // PS P1100
eDJ9xxVIP,  // PS 1215
eDJ9xxVIP,  // PS 1218
eDJ9xxVIP,  // PS 1115
eDJ9xxVIP,  // PS 1315
ePSP100,    // PS 100
ePSP100,    // PS 130 - Underdog - like AtomAnt
ePSP100,    // PS 230
eDJGenericVIP,  // PS 7150 - Twister
eDJGenericVIP,  // PS 7350 - Dorothy
eDJGenericVIP,  // PS 7345 - Dorothy
eDJGenericVIP,  // PS 7550
eDJ9xx,     // DJ 1120 - Young Einstein
eDJ9xx,     // DJ 1125 - Young Einstein
eDJ9xx,     // DJ 1220 - Escher
eDJ9xxVIP,  // DJ 2200, 2230, 2250, 2280 - Nobel
eDJ9xxVIP,  // CP 1160 - Jupiter Pro
eDJ9xxVIP,  // CP 1700 - Euler
eDJGenericVIP,   // DJ 5550 - Newport
eDJGenericVIP,   // DJ 5551 - Hayakuna Newport Japan version
eLJMono,	// LaserJet 5P
eLJColor,	// Color Lasers
eLJMono,
eDJ3320,    // PSC 1100
eDJ3320,    // PSC 1200
eDJ9xx,     // OJ 5000 - Cyclone+
eLJColor,   // BJ 3000 - Maxwell
};

/*! Do not use ModelString it is going away in the next version.
\depricated
*/
char *ModelString[MAX_ID_STRING] = {
"HP DeskJet 4",
"DESKJET 540",
"DESKJET 600",
"DESKJET 61",
"DESKJET 63",
"DESKJET 64",
"DESKJET 65",
"DESKJET 69",
"DESKJET 66",
"DESKJET 67",
"DESKJET 68",
"DESKJET 6",
"DESKJET 81",
"DESKJET 825",
"DESKJET 83",
"DESKJET 845",
"DESKJET 84",
"DESKJET 85",
"DESKJET 87",
"DESKJET 88",
"DESKJET 890",
"DESKJET 895",
"DESKJET 91",
"DESKJET 92",
"DESKJET 93",
"DESKJET 94",
"DESKJET 95",
"DESKJET 96",
"DESKJET 97",
"DESKJET 98",
"DESKJET 99",
"deskjet 3320",
"deskjet 3420",
"deskjet 3325",
"DESKJET 3810", // subway
"DESKJET 3816", // subway
"DESKJET 3820", // subway
"DESKJET 3822", // subway
"deskjet 6122", // Churchill
"deskjet 6127", // FDR
"e-printer e20",
"APOLLO P-22",
"P-2000U",  // yes, the P-2100 report itself as a P-2000
"APOLLO P2500/2600",
"DESKJET 350",
"dj450",    // Portable printer
"PHOTOSMART P1000",
"PHOTOSMART P1100",
"PHOTOSMART 1215",
"PHOTOSMART 1218",
"PHOTOSMART 1115",
"PHOTOSMART 1315",
"PHOTOSMART 100",
"PHOTOSMART 130",
"PHOTOSMART 230",
"photosmart 7150",
"photosmart 7350",
"photosmart 7345",
"photosmart 7550",
"DESKJET 1120",
"DESKJET 1125",
"DESKJET 1220",
"HP BUSINESS INKJET 22",
"cp1160",
"cp1700",
"deskjet 5550",
"deskjet 5551",
"HP LaserJet",
"hp color LaserJet",
"hp LaserJet 1150",
"psc 1100 series",
"psc 1200 series",
"officejet 5100 series",
"hp business inkjet 3000",
};


PRINTER_TYPE BuiltIn[]={    // must match PRINTER_TYPE enum order
#ifdef APDK_DJ400
    eDJ400,
#endif
#ifdef APDK_DJ540
    eDJ540,
#endif
#ifdef APDK_DJ600
    eDJ600,
#endif
#ifdef APDK_DJ6xx
    eDJ6xx,
#endif
#ifdef APDK_DJ6xxPhoto
    eDJ6xxPhoto,
#endif
#ifdef APDK_DJ8xx
    eDJ8xx,
#endif
#ifdef APDK_DJ850
    eDJ850,
#endif
#ifdef APDK_DJ890
    eDJ890,
#endif
#ifdef APDK_DJ9xx
    eDJ9xx,
#endif
#ifdef APDK_DJ9xxVIP
    eDJ9xxVIP,
#endif
#ifdef APDK_DJ3320
    eDJ3320,
#endif
#ifdef APDK_DJ630
    eDJ630,
#endif
#ifdef APDK_APOLLO2XXX
    eAP2xxx,
#endif
#ifdef APDK_APOLLO21XX
    eAP21xx,
#endif
#ifdef APDK_APOLLO2560
    eAP2560,
#endif
#ifdef APDK_DJ350
    eDJ350,
#endif
#ifdef APDK_DJ8x5
    eDJ8x5,
#endif
#ifdef APDK_PSP100
    ePSP100,
#endif
#ifdef APDK_DJGENERICVIP
    eDJGenericVIP,
#endif
#ifdef APDK_LJMONO
	eLJMono,
#endif
#ifdef APDK_LJCOLOR
	eLJColor,
#endif
#ifdef APDK_PSCRIPT
	ePScript,
#endif
};

unsigned int BuiltInSize =

#ifdef APDK_DJ400
    1 +
#endif
#ifdef APDK_DJ540
    1 +
#endif
#ifdef APDK_DJ600
    1 +
#endif
#ifdef APDK_DJ6xx
    1 +
#endif
#ifdef APDK_DJ6xxPhoto
    1 +
#endif
#ifdef APDK_DJ8xx
    1 +
#endif
#ifdef APDK_DJ850
    1 +
#endif
#ifdef APDK_DJ890
    1 +
#endif
#ifdef APDK_DJ9xx
    1 +
#endif
#ifdef APDK_DJ9xxVIP
    1 +
#endif

#ifdef APDK_DJ3320
    1 +
#endif

#ifdef APDK_DJ8x5
    1 +
#endif
#ifdef APDK_DJ630
    1 +
#endif
#ifdef APDK_APOLLO2XXX
    1 +
#endif
#ifdef APDK_APOLLO21XX
    1 +
#endif
#ifdef APDK_APOLLO2560
    1 +
#endif
#ifdef APDK_DJ350
    1 +
#endif
#ifdef APDK_PSP100
    1 +
#endif
#ifdef APDK_DJGENERICVIP
    1 +
#endif
#ifdef APDK_LJMONO
	1 +
#endif
#ifdef APDK_LJCOLOR
	1 +
#endif
#ifdef APDK_PSCRIPT
	1 +
#endif
    0
    ;

unsigned int modelbits()
{
    unsigned int bits=0;

#ifdef APDK_DJ400
        bits = bits | 0x800000;
#endif
#ifdef APDK_DJ540
        bits = bits | 0x400000;
#endif
#ifdef APDK_DJ600
        bits = bits | 0x200000;
#endif
#ifdef APDK_DJ6xx
        bits = bits | 0x100000;
#endif
#ifdef APDK_DJ6xxPhoto
        bits = bits | 0x80000;
#endif
#ifdef APDK_DJ8xx
        bits = bits | 0x40000;
#endif
#ifdef  APDK_DJ9xx
        bits = bits | 0x20000;
#endif
#ifdef APDK_DJ9xxVIP
        bits = bits | 0x10000;
#endif
#ifdef APDK_DJ630
        bits = bits | 0x8000;
#endif
#ifdef APDK_APOLLO2XXX
        bits = bits | 0x4000;
#endif
#ifdef APDK_APOLLO21XX
        bits = bits | 0x2000;
#endif
#ifdef APDK_APOLLO2560
        bits = bits | 0x1000;
#endif
#ifdef APDK_DJ350
        bits = bits | 0x800;
#endif
#ifdef APDK_DJ8x5
        bits = bits | 0x400;
#endif
#ifdef APDK_PSP100
        bits = bits | 0x200;
#endif

#ifdef APDK_DJ3320
        bits = bits | 0x100;
#endif

#ifdef APDK_DJGENERICVIP
        bits = bits | 0x80;
#endif
#ifdef APDK_LJMONO
		bits = bits | 0x40;
#endif
#ifdef APDK_LJCOLOR
		bits = bits | 0x20;
#endif
#ifdef APDK_PSCRIPT
		bits = bits | 0x10;
#endif
#ifdef APDK_DJ850
      bits = bits | 0x8;
#endif
#ifdef APDK_DJ890
      bits = bits | 0x4;
#endif
        return bits;
}

char mresult[300];
char* modelresult()
{
    mresult[0] = '\0';

#ifdef APDK_DJ400
        HP_strcat(mresult,ModelName[eDJ400]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ540
        HP_strcat(mresult,ModelName[eDJ540]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ600
        HP_strcat(mresult,ModelName[eDJ600]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ6xx
        HP_strcat(mresult,ModelName[eDJ6xx]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ6xxPhoto
        HP_strcat(mresult,ModelName[eDJ6xxPhoto]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ8xx
        HP_strcat(mresult,ModelName[eDJ8xx]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ8x5
        HP_strcat(mresult,ModelName[eDJ8x5]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ850
        HP_strcat(mresult,ModelName[eDJ850]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ890
        HP_strcat(mresult,ModelName[eDJ890]); HP_strcat(mresult," ");
#endif
#ifdef  APDK_DJ9xx
        HP_strcat(mresult,ModelName[eDJ9xx]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ9xxVIP
        HP_strcat(mresult,ModelName[eDJ9xxVIP]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ3320
        HP_strcat (mresult, ModelName[eDJ3320]); HP_strcat (mresult, " ");
#endif
#ifdef APDK_DJ630
        HP_strcat(mresult,ModelName[eDJ630]); HP_strcat(mresult," ");
#endif
#ifdef APDK_APOLLO2XXX
        HP_strcat(mresult,ModelName[eAP2xxx]); HP_strcat(mresult," ");
#endif
#ifdef APDK_APOLLO21XX
        HP_strcat(mresult,ModelName[eAP21xx]); HP_strcat(mresult," ");
#endif
#ifdef APDK_APOLLO2560
        HP_strcat(mresult,ModelName[eAP2560]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJ350
        HP_strcat(mresult,ModelName[eDJ350]); HP_strcat(mresult," ");
#endif
#ifdef APDK_PSP100
        HP_strcat(mresult,ModelName[ePSP100]); HP_strcat(mresult," ");
#endif
#ifdef APDK_DJGENERICVIP
        HP_strcat(mresult,ModelName[eDJGenericVIP]); HP_strcat(mresult," ");
#endif
#ifdef APDK_LJMONO
        HP_strcat(mresult,ModelName[eLJMono]); HP_strcat(mresult," ");
#endif
#ifdef APDK_LJCOLOR
        HP_strcat (mresult, ModelName[eLJColor]); HP_strcat(mresult," ");
#endif
#ifdef APDK_PSCRIPT
		HP_strcat (mresult, ModelName[ePScript]); HP_strcat (mresult, " ");
#endif
    return mresult;
}

APDK_END_NAMESPACE

