#
# Sample site configuration for Pmakefiles used by Pmake/Customs
# $Id: config.mk,v 1.30 1998/04/04 18:30:20 stolcke Exp $ ICSI (Berkeley)
#
# Compiler defaults
# These are used in customs/Makefile, lib/lst/Makefile, and lib/sprite/Makefile
# 
# The following variables are conveniently set here:
#
#	CC		compiler command
#	OPTIMIZE	optimize/debug flags
#	TARG_NAME	name for use in object subdirectories $(TARG_NAME).md
#
#	others		to override installation points etc.
#	
#
#ifdef sun
# ifdef SVR4
CC		= gcc
OPTIMIZE	= -g -O #-finline-functions
# ifdef i86pc
TARG_NAME	= i86pc-sunos5
# else
TARG_NAME	= sun4-sunos5
# endif
# elifdef SYSV
#  System V compatible compilation on Sun -- force with pmake -DSYSV
CC		= /usr/5bin/cc
# elifdef sparc
#CC		= cc
#OPTIMIZE	= -O # -g
# Sun C - yuck!
#SCDIR		= /usr/local/lang/SC2.0.1
#CC		= LM_LICENSE_FILE=$(SCDIR)/SunTech_License/license.dat \
		  $(SCDIR)/acc
OPTIMIZE	= -fast
# gcc2 wins !!!
CC		= gcc -pipe
OPTIMIZE	= -g -O #-finline-functions
STATICFLAG	= -static
PUREFLAG	= #-Xlinker -n -Xlinker -Bdynamic
PUREFLAG	= 
TARG_NAME	= sun4
# elifdef mc68000
CC		= gcc -pipe -msoft-float
OPTIMIZE	= -g -O -finline-functions
STATICFLAG	= -static
PUREFLAG	= #-Xlinker -n -Xlinker -Bdynamic
TARG_NAME	= sun3
# endif
#elifdef mips
# ifdef sgi
CC		:= $(CC) -xansi -D__STDC__
GROUP		= sys		# gid 0 in IRIX
#  ifdef SVR4
#   if exists(/usr/lib32/mips3)
TARG_NAME	= iris-irix6
CC		= cc -n32
LDFLAGS		= $(.LIBS:N-L/usr/lib)
#   else
TARG_NAME	= iris-irix5
#   endif
#  else
TARG_NAME	= iris
#  endif
# else
CC		:= $(CC)
TARG_NAME	= mips
# endif
OPTIMIZE	= -g3 -O
#elifdef alpha
CC		:= $(CC) -std1
OPTIMIZE	= -g3 -O
TARG_NAME	= alpha
#elifdef vax
CC		= gcc
OPTIMIZE	= -g -O -fstrength-reduce -finline-functions
TARG_NAME	= vax
#elifdef NeXT
CC		:= $(CC) -pipe
OPTIMIZE	= -g -O -fstrength-reduce -finline-functions
INSTALL		= install -c -u
GROUP		= wheel		# NeXT doesn't have group system
TARG_NAME	= next
#elifdef hpux
CC		:= $(CC)
OPTIMIZE	= -O # -g 
TARG_NAME	= hppa
#elifdef linux
TARG_NAME	= i686-linux
#endif

##########################
# Some things to fix up the default installation for customs
# This is strictly site-dependent!
##########################

#
# These override defaults in common.mk and should match the values
# chosen in makefile for the first pmake build.
#
#DESTDIR		=
#BINDIR		= /usr/local/bin
#LIBDIR		= /usr/local/lib/pmake
#
# These override default install locations in customs/Makefile.
#
#ETCDIR		= /usr/local/etc
#USRLIBDIR	= /usr/local/lib
#INCLUDEDIR	= /usr/local/include/customs

#
# Ultrix man doesn't understand MANPATH, so everything has to go into /usr/man
#
#ifdef ultrix
MANDIR = $(DESTDIR)/usr/man
MANEXT1 = l
MANEXT8 = l
#endif

#
# Use local install if available
#
#if exists(/usr/local/etc/install)
INSTALL		= /usr/local/etc/install -c
#endif

# Strip binaries?
# (I have heard that Solaris /usr/ucb/install will
# produce corrupted binaries when given the -s option.)
#STRIP		= #-s

