/*
 *  Copyright (C) 2003 Crispin Flowerday
 *
 *  Derived from galeon-stop-button.c:
 *      Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libgnome/gnome-i18n.h>
#include "gul-gobject-misc.h"
#include "galeon-marshal.h"
#include "gul-tb-button.h"
#include "gul-gui.h"
#include "gul-string.h"
#include "galeon-fullscreen-button.h"
#include "galeon-shell.h"
#include "pixbuf-cache.h"
#include <gtk/gtkstock.h>
#include <string.h>

#define NOT_IMPLEMENTED g_warning ("not implemented: " G_STRLOC);
//#define DEBUG_MSG(x) g_print x
#define DEBUG_MSG(x)

/**
 * Private data
 */
struct _GaleonFullscreenButtonPrivate 
{
	GulTbButton *widget;
	gboolean fullscreen;
	gboolean ignore_toggle_event;
};

/**
 * Private functions, only availble from this file
 */
static void		galeon_fullscreen_button_class_init		(GaleonFullscreenButtonClass *klass);
static void		galeon_fullscreen_button_init			(GaleonFullscreenButton *tb);
static void		galeon_fullscreen_button_finalize_impl		(GObject *o);
static GtkWidget *	galeon_fullscreen_button_get_widget_impl	(GulTbItem *i);
static GdkPixbuf *	galeon_fullscreen_button_get_icon_impl		(GulTbItem *i);
static gchar *		galeon_fullscreen_button_get_name_human_impl	(GulTbItem *i);
static gchar *		galeon_fullscreen_button_to_string_impl		(GulTbItem *i);
static GulTbItem *	galeon_fullscreen_button_clone_impl		(GulTbItem *i);
static void		galeon_fullscreen_button_parse_properties_impl	(GulTbItem *i, const gchar *props);
static void		galeon_fullscreen_button_clicked_cb		(GtkWidget *w, GaleonFullscreenButton *b);


static gpointer gul_tb_item_class;

/**
 * TbiFullscreen object
 */

MAKE_GET_TYPE (galeon_fullscreen_button, "GaleonFullscreenButton", GaleonFullscreenButton,
	       galeon_fullscreen_button_class_init, 
	       galeon_fullscreen_button_init, GALEON_TYPE_TBI);

static void
galeon_fullscreen_button_class_init (GaleonFullscreenButtonClass *klass)
{
	G_OBJECT_CLASS (klass)->finalize = galeon_fullscreen_button_finalize_impl;
	
	GUL_TB_ITEM_CLASS (klass)->get_widget = galeon_fullscreen_button_get_widget_impl;
	GUL_TB_ITEM_CLASS (klass)->get_icon = galeon_fullscreen_button_get_icon_impl;
	GUL_TB_ITEM_CLASS (klass)->get_name_human = galeon_fullscreen_button_get_name_human_impl;
	GUL_TB_ITEM_CLASS (klass)->to_string = galeon_fullscreen_button_to_string_impl;
	GUL_TB_ITEM_CLASS (klass)->clone = galeon_fullscreen_button_clone_impl;
	GUL_TB_ITEM_CLASS (klass)->parse_properties = galeon_fullscreen_button_parse_properties_impl;

	gul_tb_item_class = g_type_class_peek_parent (klass);
}

static void 
galeon_fullscreen_button_init (GaleonFullscreenButton *tbi)
{
	GaleonFullscreenButtonPrivate *p = g_new0 (GaleonFullscreenButtonPrivate, 1);
	tbi->priv = p;
	p->fullscreen = FALSE;
	p->ignore_toggle_event = FALSE;
}

GaleonFullscreenButton *
galeon_fullscreen_button_new (void)
{
	GaleonFullscreenButton *ret = g_object_new (GALEON_TYPE_FULLSCREEN_BUTTON, NULL);
	return ret;
}

static void
galeon_fullscreen_button_finalize_impl (GObject *o)
{
	GaleonFullscreenButton *it = GALEON_FULLSCREEN_BUTTON (o);
	GaleonFullscreenButtonPrivate *p = it->priv;

	if (p->widget)
	{
		g_object_unref (p->widget);
	}

	g_free (p);
	
	DEBUG_MSG (("GaleonFullscreenButton finalized\n"));
	
	G_OBJECT_CLASS (gul_tb_item_class)->finalize (o);
}


static GaleonWindow *
galeon_fullscreen_button_get_window (GaleonFullscreenButton *b)
{
	GaleonWindow *window;

	window = galeon_tbi_get_window (GALEON_TBI (b));
	g_return_val_if_fail (window != NULL, NULL);

	return window;
}


static GtkWidget *
galeon_fullscreen_button_get_widget_impl (GulTbItem *i)
{
	GaleonFullscreenButton *iz = GALEON_FULLSCREEN_BUTTON (i);
	GaleonFullscreenButtonPrivate *p = iz->priv;

	if (!p->widget)
	{
		p->widget = gul_tb_button_new ();
		g_object_ref (p->widget);
		gtk_object_sink (GTK_OBJECT (p->widget));

		gul_tb_button_set_use_toggle_button (p->widget);
		gul_tb_button_set_label (p->widget, GALEON_STOCK_FULLSCREEN);
		gul_tb_button_set_tooltip_text (p->widget, _("Toggle fullscreen mode"));
		gul_tb_button_set_priority (p->widget, FALSE);
		gul_tb_button_set_show_arrow (p->widget, FALSE);
		gul_tb_button_set_sensitivity (p->widget, TRUE);
		gul_tb_button_set_use_stock (p->widget, TRUE);

		gtk_widget_show (GTK_WIDGET (p->widget));

		gtk_toggle_button_set_active 
			(GTK_TOGGLE_BUTTON(gul_tb_button_get_button (p->widget)), p->fullscreen);

		g_signal_connect (gul_tb_button_get_button (p->widget), "toggled",
				  G_CALLBACK (galeon_fullscreen_button_clicked_cb), i);
	}

	return GTK_WIDGET (p->widget);
}

static GdkPixbuf *
galeon_fullscreen_button_get_icon_impl (GulTbItem *i)
{
	static GdkPixbuf *pb_fullscreen = NULL;

	if (!pb_fullscreen)
	{
		/* what's the easier way? */
		GtkWidget *b = gtk_button_new ();
		pb_fullscreen = gtk_widget_render_icon (b,
						GALEON_STOCK_FULLSCREEN,
						GTK_ICON_SIZE_SMALL_TOOLBAR,
						NULL);
		gtk_widget_destroy (b);
	}

	return g_object_ref (pb_fullscreen);
}

static gchar *
galeon_fullscreen_button_get_name_human_impl (GulTbItem *i)
{
	return g_strdup (_("Fullscreen"));
}

static gchar *
galeon_fullscreen_button_to_string_impl (GulTbItem *i)
{
	/* if it had any properties, the string should include them */

	return g_strdup_printf ("%s=fullscreen_button", i->id);
}

static GulTbItem *
galeon_fullscreen_button_clone_impl (GulTbItem *i)
{
	GulTbItem *ret = GUL_TB_ITEM (galeon_fullscreen_button_new ());

	gul_tb_item_set_id (ret, i->id);

	return ret;
}

static void
galeon_fullscreen_button_parse_properties_impl (GulTbItem *it, const gchar *props)
{
	/* we have no properties */
}

void
galeon_fullscreen_button_set_fullscreen(GaleonFullscreenButton *b, gboolean s)
{
	GaleonFullscreenButtonPrivate *p = b->priv;
	p->fullscreen = s;
	if (p->widget)
	{
		p->ignore_toggle_event = TRUE;
		gtk_toggle_button_set_active 
			(GTK_TOGGLE_BUTTON(gul_tb_button_get_button (p->widget)), s);
		p->ignore_toggle_event = FALSE;
	}
	else
	{
		galeon_fullscreen_button_get_widget_impl (GUL_TB_ITEM (b));
	}
}


static void
galeon_fullscreen_button_clicked_cb (GtkWidget *w, GaleonFullscreenButton *b)
{
	GaleonWindow *window = galeon_fullscreen_button_get_window (b);
	if (b->priv->ignore_toggle_event) return;

	galeon_window_toggle_fullscreen( window );
}
