/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __gul_tbi_favicon_h
#define __gul_tbi_favicon_h

#include "gul-toolbar-item.h"

/* object forward declarations */

typedef struct _GulTbiFavicon GulTbiFavicon;
typedef struct _GulTbiFaviconClass GulTbiFaviconClass;
typedef struct _GulTbiFaviconPrivate GulTbiFaviconPrivate;

/**
 * TbiFavicon object
 */

#define GUL_TYPE_TBI_FAVICON		(gul_tbi_favicon_get_type())
#define GUL_TBI_FAVICON(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), GUL_TYPE_TBI_FAVICON,\
					 GulTbiFavicon))
#define GUL_TBI_FAVICON_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), GUL_TYPE_TBI_FAVICON,\
					 GulTbiFaviconClass))
#define GUL_IS_TBI_FAVICON(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), GUL_TYPE_TBI_FAVICON))
#define GUL_IS_TBI_FAVICON_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), GUL_TYPE_TBI_FAVICON))
#define GUL_TBI_FAVICON_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), GUL_TYPE_TBI_FAVICON,\
					 GulTbiFaviconClass))

struct _GulTbiFaviconClass 
{
	GulTbItemClass parent_class;
	
};

/* Remember: fields are public read-only */
struct _GulTbiFavicon
{
	GulTbItem parent_object;

	GulTbiFaviconPrivate *priv;
};

/* this class is abstract */

GType		gul_tbi_favicon_get_type		(void);
GulTbiFavicon *	gul_tbi_favicon_new			(void);

#endif
