#ifndef _IMAGES_H_
#define _IMAGES_H_ 1
#include <lilo.h>
#include <qwidget.h>
#include <qmultilineedit.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qvbox.h>
#include "EditWidget.h"
class Images:public QWidget
{
	Q_OBJECT
public:
	Images(liloconf *l=0, QWidget *parent=0, const char *name=0);
	~Images();
	void setCfg(liloconf *l) { lilo=l; };
    void makeReadOnly();
public slots:
	void update();
	void saveChanges();
private slots:
	void probeClicked();
	void dfltClicked();
	void detailsClicked();
	void checkClicked();
	void addKrnlClicked();
	void addOSClicked();
	void removeClicked();
	void imageSelected(const QString &i);
signals:
	void configChanged();
private:
	liloconf	*lilo;
	QString		previous;
	QString		current;
	QHBoxLayout	*layout;
	QListBox	*images;
	QVBox		*parameters;
	EditWidget	*image;
	EditWidget	*label;
	EditWidget	*root;
	EditWidget	*initrd;
	EditWidget	*append;
	QVBox		*actions;
	QPushButton	*dflt;
	QPushButton	*details;
	QPushButton	*probe;
	QPushButton	*check;
	QPushButton	*addKrnl;
	QPushButton	*addOS;
	QPushButton	*remove;
};
#endif
