/*
 *	$Id: cdeclient.h,v 1.4.2.2 2003/07/04 18:19:15 fredrik Exp $
 *	
 *	CDE KWin client - emulates the look and feel
 *	of dtwm, the CDE window manager.
 *	
 *	Copyright (c) 2000-2001, 2002
 *		Chris Lee       <lee@azsites.com>
 *		Lennart Kudling <kudling@kde.org>
 *      	Fredrik Hglund <fredrik@kde.org>
 *
 *	Originally based on the KStep client.
 *	
 *	Distributed under the terms of the BSD license.	
 */

#ifndef __CDECLIENT_H
#define __CDECLIENT_H

#include <qbutton.h>
#include <qbitmap.h>
#include <kpixmap.h>
#include <kwin/client.h>
#include <kwin/kwinbutton.h>

class QLabel;
class QBoxLayout;
class QVBoxLayout;
class QSpacerItem;

namespace CDE {

using namespace KWinInternal;

class CdeClient;

enum Buttons { BtnMenu=0, BtnHelp, BtnIconify, BtnMax, BtnClose, BtnCount };

class CdeButton : public KWinButton
{
public:
    CdeButton( CdeClient* parent=0, const char* name=0, int btnType=0,
               const QString& tip=NULL );
    void reset();

protected:
    virtual void drawButton( QPainter *p );

private:
    int m_btnType;
    Client* m_parent;
};

class CdeClient : public Client
{
    Q_OBJECT
public:
    CdeClient( Workspace* ws, WId w, QWidget* parent=0, const char* name=0 );
    ~CdeClient() {};

protected:
    void resizeEvent( QResizeEvent* );
    void paintEvent( QPaintEvent* );
    void addClientButtons( const QString& );
    void mouseDoubleClickEvent( QMouseEvent* );
    void mousePressEvent( QMouseEvent* );
    void mouseReleaseEvent( QMouseEvent* );
    void captionChange( const QString& );
    void maximizeChange( bool m );
    void activeChange( bool );
    MousePosition mousePosition( const QPoint& p ) const;

protected slots:
    void menuButtonPressed();
    void menuButtonReleased(); 

private:
    CdeButton* button[BtnCount];
    QVBoxLayout* mainLayout;
    QBoxLayout*  titleLayout;
    QSpacerItem* titlebar;
    bool titlebarPressed;
    bool closing;
};

}

#endif

