//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMGLVIEWCONNECTOR_H
#define PMGLVIEWCONNECTOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>
#include <qptrlist.h>

#include "pmcontrolpoint.h"
#include "pmmatrix.h"
#include "pmobjectaction.h"

class PMPart;
class PMGLView;
class PMObject;
class KAction;
class KToggleAction;
class KActionMenu;
class KListAction;
class PMCameraID;
class PMControlPointID;

/**
 * Connector between the @ref PMPart and @ref PMGLViews.
 *
 * Manages all gl views for one document and the
 * control points for efficiency reasons.
 */
class PMGLViewConnector : public QObject
{
   Q_OBJECT
public:
   /** Constructor */
   PMGLViewConnector( PMPart* part, QObject* parent = 0, const char* name = 0 );
   /** Destructor */
   ~PMGLViewConnector( );
   /** Adds the gl view */
   void addGLView( PMGLView* v );
   /** Returns the current control point list */
   const PMControlPointList& controlPoints( ) const { return m_controlPoints; }
   /** Returns the current transformation matrix */
   const PMMatrix& transformation( ) const { return m_activeTransformation; }

public slots:
   /** Called when an object is changed.
    * @see PMPart::objectChanged( ) */
   void slotObjectChanged( PMObject* obj, const int mode, QObject* sender );
   /** Called when the control point selection is changed */
   void slotControlPointSelectionChanged( QObject* sender );
   /** Clears all data */
   void slotClear( );
   /** Toggles the action "Translate view" */
   void slotTranslateView( );
   /** Toggles the action "Scale view" */
   void slotScaleView( );
   /** Called when a glview gets the focus */
   void slotViewActivated( PMGLView* view );
   void slotCamerasMenuAboutToShow( );
   void slotCamera( int id );
   void slotPosX( );
   void slotNegX( );
   void slotPosY( );
   void slotNegY( );
   void slotPosZ( );
   void slotNegZ( );
   void slotControlPointsMenuAboutToShow( );
   void slotControlPoint( int id );
   /** Repaints all views */
   void slotRepaint( );
   /** Snaps the selected control points to the grid */
   void slotSnapToGrid( );
   void slotContextMenuAboutToShow( );
   void slotObjectAction( );
   /** Called when a gl view is destroyed */
   void removeGLView( PMGLView* v );

signals:
   /** Emitted when the control points have changed */
   void newControlPoints( const PMControlPointList& list, const PMMatrix& t );
   /** Emitted in slotObjectChanged. PMGLViews connect to this signal.
    *
    * The reason for this extra signal is: The slot slotObjectChanged has
    * to be called before PMGLView::slotObjectChanged. */
   void glViewObjectChanged( PMObject* obj, const int mode, QObject* sender );
   /** Emitted when the control point selection is changed */
   void controlPointSelectionChanged( QObject* sender );
   /** Emitted when the PMGLViews have to stop rendering */
   void stopRendering( );

private:
   /** Pointer to the part */
   PMPart* m_pPart;
   /** List of all gl views */
   QPtrList<PMGLView> m_GLViews;

   KToggleAction* m_pTranslateViewAction;
   KToggleAction* m_pScaleViewAction;
   KActionMenu* m_pCamerasAction;
   KActionMenu* m_pControlPointsAction;
   KAction* m_pViewPosXAction;
   KAction* m_pViewNegXAction;
   KAction* m_pViewPosYAction;
   KAction* m_pViewNegYAction;
   KAction* m_pViewPosZAction;
   KAction* m_pViewNegZAction;
   QPtrList<PMCameraID> m_cameraIDs;
   KAction* m_pRepaintAction;
   KAction* m_pSnapToGridAction;

   QPtrList<PMObjectAction> m_objectActions;
   bool m_bScale, m_bTranslate;

   /** Control points of the active object */
   PMControlPointList m_controlPoints;
   QPtrList<PMControlPointID> m_controlPointIDs;
   bool m_controlPointsMenuUpToDate;
   /** The active object */
   PMObject* m_pActiveObject;
   /** The transformation of the active object */
   PMMatrix m_activeTransformation;
   /** The active view */
   PMGLView* m_pActiveView;
};


#endif
