//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMLISTPATTERN_H
#define PMLISTPATTERN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmcompositeobject.h"
#include "pmvector.h"

/**
 * Base class for povray lists.
 */ 

class PMListPattern : public PMCompositeObject
{
   typedef PMCompositeObject Base;
public:
   /** The type of the pigment list */
   enum PMListType { ListPatternChecker, ListPatternBrick, ListPatternHexagon };
   /** Creates a PMListPattern */
   PMListPattern( );
   /** deletes the PMListPattern */
   virtual ~PMListPattern( );

   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   
   /** Returns a new @ref PMListPatternEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;

   /** Returns the color list type */
   PMListType listType( ) const { return m_listType; }
   /** Returns the brick size */
   PMVector brickSize( ) const { return m_brickSize; }
   /** Returns the mortar size */
   double mortar( ) const { return m_mortar; }

   /** Sets the list type */
   void setListType( PMListType l );
   /** Sets the brick size */
   void setBrickSize( const PMVector& n );
   /** Sets the mortar size */
   void setMortar( double n );
   
   /** */
   virtual void restoreMemento( PMMemento* s );
   
   /** Returns the list object type */
   virtual PMObjectType listObjectType( ) const = 0;
   
private:
   /** IDs for @ref PMMementoData */
   enum PMListPatternMementoID { PMListTypeID, PMBrickSizeID, PMMortarID };
   /** List type */
   PMListType m_listType;
   /** Brick Size */
   PMVector m_brickSize;
   /** Mortar Size */
   double m_mortar;
};

/**
 * Class for texture lists
 */

class PMTextureList : public PMListPattern
{
public:
   typedef PMListPattern Base;
   /** Creates a texture list */
   PMTextureList( );
   /** Deletes the texture list */
   virtual ~PMTextureList( );

   /** */
   virtual PMObject* newObject( ) const { return new PMTextureList( ); }
   /** */
   virtual QString className( ) const { return QString( "texturelist" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTTextureList; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmtexturelist" ); }
   /** Returns the list object type */
   virtual PMObjectType listObjectType( ) const { return PMTTexture; }
};

/**
 * Class for pigment lists
 */

class PMPigmentList : public PMListPattern
{
public:
   typedef PMListPattern Base;
   /** Creates a pigment list */
   PMPigmentList( );
   /** Deletes the pigment list */
   virtual ~PMPigmentList( );

   /** */
   virtual PMObject* newObject( ) const { return new PMPigmentList( ); }
   /** */
   virtual QString className( ) const { return QString( "pigmentlist" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTPigmentList; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmpigmentlist" ); }
   /** Returns the list object type */
   virtual PMObjectType listObjectType( ) const { return PMTPigment; }
};

/**
 * Class for color lists
 */

class PMColorList : public PMListPattern
{
public:
   typedef PMListPattern Base;
   /** Creates a color list */
   PMColorList( );
   /** Deletes the color list */
   virtual ~PMColorList( );

   /** */
   virtual PMObject* newObject( ) const { return new PMColorList( ); }
   /** */
   virtual QString className( ) const { return QString( "colorlist" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTColorList; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmcolorlist" ); }
   /** Returns the list object type */
   virtual PMObjectType listObjectType( ) const { return PMTSolidColor; }
};

/**
 * Class for density lists
 */

class PMDensityList : public PMListPattern
{
public:
   typedef PMListPattern Base;
   /** Creates a density list */
   PMDensityList( );
   /** Deletes the density list */
   virtual ~PMDensityList( );

   /** */
   virtual PMObject* newObject( ) const { return new PMDensityList( ); }
   /** */
   virtual QString className( ) const { return QString( "densitylist" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTDensityList; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmdensitylist" ); }
   /** Returns the list object type */
   virtual PMObjectType listObjectType( ) const { return PMTDensity; }
};

/**
 * Class for normal lists
 */

class PMNormalList : public PMListPattern
{
public:
   typedef PMListPattern Base;
   /** Creates a normal list */
   PMNormalList( );
   /** Deletes the normal list */
   virtual ~PMNormalList( );

   /** */
   virtual PMObject* newObject( ) const { return new PMNormalList( ); }
   /** */
   virtual QString className( ) const { return QString( "normallist" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTNormalList; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   
   /** Returns a new @ref PMListPatternEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;

   /** */
   virtual QString pixmap( ) const { return QString( "pmnormallist" ); }
   /** Returns the list object type */
   virtual PMObjectType listObjectType( ) const { return PMTNormal; }

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;

   /** */
   virtual void restoreMemento( PMMemento* s );

   /** Returns the normal's depth */
   double depth( ) const { return m_depth; }
   /** Sets the normal's depth */
   void setDepth( double d );

private:
   /** IDs for @ref PMMementoData */
   enum PMNormalListMementoID { PMDepthID };
   /** Normal Depth */
   double m_depth;
};

#endif
