//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMOBJECTLINK_H
#define PMOBJECTLINK_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmsolidobject.h"
#include "pmdeclare.h"

/**
 * Class for links of graphical objects.
 */ 
class PMObjectLink : public PMSolidObject
{
   typedef PMSolidObject Base;
public:
   /** Creates an empty PMObjectLink */
   PMObjectLink( );
   /** deletes the PMObjectLink */
   virtual ~PMObjectLink( );

   /** */
   virtual PMObject* newObject( ) const { return new PMObjectLink( ); }
   /** */
   virtual QString className( ) const { return QString( "objectlink" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTObjectLink; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   
   /** */
   virtual PMDeclare* linkedObject( ) const { return m_pLinkedObject; }
   /** Sets the linked object. Returns true if successful */
   bool setLinkedObject( PMDeclare* o );
   
   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   /** Returns a new @ref PMObjectLinkEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmobjectlink" ); }
   
   /** */
   virtual void restoreMemento( PMMemento* s );
private:
   /** IDs for @ref PMMementoData */
   enum PMObjectLinkMementoID { PMLinkedObjectID };
   PMDeclare* m_pLinkedObject;
};

#endif
