
#ifndef __REG_H__
#define __REG_H__

typedef struct
{
    char *app;			/* program name */
    char *arg;			/* arguments/options */
    char *sfx;			/* suffix */
    int len;			/* suffix length */
}
reg, reg_t;

void reg_build_list(void);

void reg_add_suffix(char *sfx, char *prog, char *args);
char *reg_app_by_file(char *file);
reg_t *reg_prog_by_file(char *file);
reg_t *reg_prog_by_suffix(char *sfx);
GList *reg_app_list(void);
GList *reg_app_list_free(GList *);
int reg_save(void);

/* FIXME: make DEF_APP a dynamic configurable option: */
#define DEF_APP		"gvim"

#endif
