
/* Copyright (c) 2015-2023 Valve Corporation
 * Copyright (c) 2015-2023 LunarG, Inc.
 * Copyright (c) 2015-2017, 2019 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Lenny Komow <lenny@lunarg.com>
 * Author: Joey Bzdek <joey@lunarg.com>
 * Author: Shannon McPherson <shannon@lunarg.com>
 * Author: David Pinedo <david@lunarg.com>
 * Author: Charles Giessen <charles@lunarg.com>
 */

/*
 * This file is generated from the Khronos Vulkan XML API Registry.
 */


#include "api_dump_json.h"

#include "api_dump_video_json.h"

//=========================== Type Implementations ==========================//

void dump_json_uint64_t(uint64_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_size_t(size_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_char(char object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_float(float object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_int64_t(int64_t object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_double(double object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}

//========================= Basetype Implementations ========================//

void dump_json_VkBool32(VkBool32 object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_VkDeviceAddress(VkDeviceAddress object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_VkDeviceSize(VkDeviceSize object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_VkFlags(VkFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_VkSampleMask(VkSampleMask object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
void dump_json_VkFlags64(VkFlags64 object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_json_MTLDevice_id(MTLDevice_id object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
#endif // VK_USE_PLATFORM_METAL_EXT
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_json_MTLCommandQueue_id(MTLCommandQueue_id object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
#endif // VK_USE_PLATFORM_METAL_EXT
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_json_MTLBuffer_id(MTLBuffer_id object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
#endif // VK_USE_PLATFORM_METAL_EXT
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_json_MTLTexture_id(MTLTexture_id object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
#endif // VK_USE_PLATFORM_METAL_EXT
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_json_IOSurfaceRef(IOSurfaceRef object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
#endif // VK_USE_PLATFORM_METAL_EXT
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_json_MTLSharedEvent_id(MTLSharedEvent_id object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
#endif // VK_USE_PLATFORM_METAL_EXT
void dump_json_VkRemoteAddressNV(VkRemoteAddressNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}


#if defined(VK_USE_PLATFORM_ANDROID_KHR)
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
void dump_json_ANativeWindow(const ANativeWindow* object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
void dump_json_AHardwareBuffer(const AHardwareBuffer* object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR


#if defined(VK_USE_PLATFORM_METAL_EXT)
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_json_CAMetalLayer(CAMetalLayer object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << "\"" << object << "\"";
}
#endif
#endif // VK_USE_PLATFORM_METAL_EXT

//======================= System Type Implementations =======================//

#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_json_DWORD(const DWORD object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_XLIB_KHR)
void dump_json_Display(const Display* object, const ApiDumpSettings& settings, int indents)
{
    OutputAddressJSON(settings, object);
    settings.stream() << "\n";
}
#endif // VK_USE_PLATFORM_XLIB_KHR
#if defined(VK_USE_PLATFORM_GGP)
void dump_json_GgpFrameToken(const GgpFrameToken object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_GGP
#if defined(VK_USE_PLATFORM_GGP)
void dump_json_GgpStreamDescriptor(const GgpStreamDescriptor object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_GGP
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_json_HANDLE(const HANDLE object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_json_HINSTANCE(const HINSTANCE object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_json_HMONITOR(const HMONITOR object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_json_HWND(const HWND object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_DIRECTFB_EXT)
void dump_json_IDirectFB(const IDirectFB object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#if defined(VK_USE_PLATFORM_DIRECTFB_EXT)
void dump_json_IDirectFBSurface(const IDirectFBSurface object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_json_LPCWSTR(const LPCWSTR object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_json_SECURITY_ATTRIBUTES(const SECURITY_ATTRIBUTES* object, const ApiDumpSettings& settings, int indents)
{
    OutputAddressJSON(settings, object);
    settings.stream() << "\n";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_XLIB_KHR)
void dump_json_VisualID(const VisualID object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_XLIB_KHR
#if defined(VK_USE_PLATFORM_XLIB_KHR)
void dump_json_Window(const Window object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_XLIB_KHR
#if defined(VK_USE_PLATFORM_SCREEN_QNX)
void dump_json__screen_buffer(const _screen_buffer* object, const ApiDumpSettings& settings, int indents)
{
    OutputAddressJSON(settings, object);
    settings.stream() << "\n";
}
#endif // VK_USE_PLATFORM_SCREEN_QNX
#if defined(VK_USE_PLATFORM_SCREEN_QNX)
void dump_json__screen_context(const _screen_context* object, const ApiDumpSettings& settings, int indents)
{
    OutputAddressJSON(settings, object);
    settings.stream() << "\n";
}
#endif // VK_USE_PLATFORM_SCREEN_QNX
#if defined(VK_USE_PLATFORM_SCREEN_QNX)
void dump_json__screen_window(const _screen_window* object, const ApiDumpSettings& settings, int indents)
{
    OutputAddressJSON(settings, object);
    settings.stream() << "\n";
}
#endif // VK_USE_PLATFORM_SCREEN_QNX
#if defined(VK_USE_PLATFORM_WAYLAND_KHR)
void dump_json_wl_display(const wl_display* object, const ApiDumpSettings& settings, int indents)
{
    OutputAddressJSON(settings, object);
    settings.stream() << "\n";
}
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#if defined(VK_USE_PLATFORM_WAYLAND_KHR)
void dump_json_wl_surface(const wl_surface* object, const ApiDumpSettings& settings, int indents)
{
    OutputAddressJSON(settings, object);
    settings.stream() << "\n";
}
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#if defined(VK_USE_PLATFORM_XCB_KHR)
void dump_json_xcb_connection_t(const xcb_connection_t* object, const ApiDumpSettings& settings, int indents)
{
    OutputAddressJSON(settings, object);
    settings.stream() << "\n";
}
#endif // VK_USE_PLATFORM_XCB_KHR
#if defined(VK_USE_PLATFORM_XCB_KHR)
void dump_json_xcb_visualid_t(const xcb_visualid_t object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_XCB_KHR
#if defined(VK_USE_PLATFORM_XCB_KHR)
void dump_json_xcb_window_t(const xcb_window_t object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_XCB_KHR
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_json_zx_handle_t(const zx_handle_t object, const ApiDumpSettings& settings, int indents)
{
    if (settings.showAddress())
        settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
#endif // VK_USE_PLATFORM_FUCHSIA

//========================== Handle Implementations =========================//

void dump_json_VkBuffer(const VkBuffer object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkImage(const VkImage object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkInstance(const VkInstance object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkPhysicalDevice(const VkPhysicalDevice object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDevice(const VkDevice object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkQueue(const VkQueue object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkSemaphore(const VkSemaphore object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkCommandBuffer(const VkCommandBuffer object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkFence(const VkFence object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDeviceMemory(const VkDeviceMemory object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkEvent(const VkEvent object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkQueryPool(const VkQueryPool object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkBufferView(const VkBufferView object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkImageView(const VkImageView object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkShaderModule(const VkShaderModule object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkPipelineCache(const VkPipelineCache object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkPipelineLayout(const VkPipelineLayout object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkPipeline(const VkPipeline object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkRenderPass(const VkRenderPass object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDescriptorSetLayout(const VkDescriptorSetLayout object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkSampler(const VkSampler object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDescriptorSet(const VkDescriptorSet object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDescriptorPool(const VkDescriptorPool object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkFramebuffer(const VkFramebuffer object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkCommandPool(const VkCommandPool object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkSamplerYcbcrConversion(const VkSamplerYcbcrConversion object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDescriptorUpdateTemplate(const VkDescriptorUpdateTemplate object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkPrivateDataSlot(const VkPrivateDataSlot object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkSurfaceKHR(const VkSurfaceKHR object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkSwapchainKHR(const VkSwapchainKHR object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDisplayKHR(const VkDisplayKHR object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDisplayModeKHR(const VkDisplayModeKHR object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDebugReportCallbackEXT(const VkDebugReportCallbackEXT object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkVideoSessionKHR(const VkVideoSessionKHR object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkVideoSessionParametersKHR(const VkVideoSessionParametersKHR object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkCuModuleNVX(const VkCuModuleNVX object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkCuFunctionNVX(const VkCuFunctionNVX object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDebugUtilsMessengerEXT(const VkDebugUtilsMessengerEXT object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkAccelerationStructureKHR(const VkAccelerationStructureKHR object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkDeferredOperationKHR(const VkDeferredOperationKHR object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkValidationCacheEXT(const VkValidationCacheEXT object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkAccelerationStructureNV(const VkAccelerationStructureNV object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkPerformanceConfigurationINTEL(const VkPerformanceConfigurationINTEL object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkIndirectCommandsLayoutNV(const VkIndirectCommandsLayoutNV object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_json_VkCudaModuleNV(const VkCudaModuleNV object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_json_VkCudaFunctionNV(const VkCudaFunctionNV object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_json_VkBufferCollectionFUCHSIA(const VkBufferCollectionFUCHSIA object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
#endif // VK_USE_PLATFORM_FUCHSIA
void dump_json_VkMicromapEXT(const VkMicromapEXT object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkOpticalFlowSessionNV(const VkOpticalFlowSessionNV object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkShaderEXT(const VkShaderEXT object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkPipelineBinaryKHR(const VkPipelineBinaryKHR object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkExternalComputeQueueNV(const VkExternalComputeQueueNV object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkIndirectExecutionSetEXT(const VkIndirectExecutionSetEXT object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}
void dump_json_VkIndirectCommandsLayoutEXT(const VkIndirectCommandsLayoutEXT object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress()) {
        settings.stream() << "\"" << object << "\"";
    } else {
        settings.stream() << "\"address\"";
    }
}

//=========================== Enum Implementations ==========================//

void dump_json_VkResult(VkResult object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SUCCESS\"";
        break;
    case 1:
        settings.stream() << "\"VK_NOT_READY\"";
        break;
    case 2:
        settings.stream() << "\"VK_TIMEOUT\"";
        break;
    case 3:
        settings.stream() << "\"VK_EVENT_SET\"";
        break;
    case 4:
        settings.stream() << "\"VK_EVENT_RESET\"";
        break;
    case 5:
        settings.stream() << "\"VK_INCOMPLETE\"";
        break;
    case -1:
        settings.stream() << "\"VK_ERROR_OUT_OF_HOST_MEMORY\"";
        break;
    case -2:
        settings.stream() << "\"VK_ERROR_OUT_OF_DEVICE_MEMORY\"";
        break;
    case -3:
        settings.stream() << "\"VK_ERROR_INITIALIZATION_FAILED\"";
        break;
    case -4:
        settings.stream() << "\"VK_ERROR_DEVICE_LOST\"";
        break;
    case -5:
        settings.stream() << "\"VK_ERROR_MEMORY_MAP_FAILED\"";
        break;
    case -6:
        settings.stream() << "\"VK_ERROR_LAYER_NOT_PRESENT\"";
        break;
    case -7:
        settings.stream() << "\"VK_ERROR_EXTENSION_NOT_PRESENT\"";
        break;
    case -8:
        settings.stream() << "\"VK_ERROR_FEATURE_NOT_PRESENT\"";
        break;
    case -9:
        settings.stream() << "\"VK_ERROR_INCOMPATIBLE_DRIVER\"";
        break;
    case -10:
        settings.stream() << "\"VK_ERROR_TOO_MANY_OBJECTS\"";
        break;
    case -11:
        settings.stream() << "\"VK_ERROR_FORMAT_NOT_SUPPORTED\"";
        break;
    case -12:
        settings.stream() << "\"VK_ERROR_FRAGMENTED_POOL\"";
        break;
    case -13:
        settings.stream() << "\"VK_ERROR_UNKNOWN\"";
        break;
    case -1000069000:
        settings.stream() << "\"VK_ERROR_OUT_OF_POOL_MEMORY\"";
        break;
    case -1000072003:
        settings.stream() << "\"VK_ERROR_INVALID_EXTERNAL_HANDLE\"";
        break;
    case -1000161000:
        settings.stream() << "\"VK_ERROR_FRAGMENTATION\"";
        break;
    case -1000257000:
        settings.stream() << "\"VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS\"";
        break;
    case 1000297000:
        settings.stream() << "\"VK_PIPELINE_COMPILE_REQUIRED\"";
        break;
    case -1000174001:
        settings.stream() << "\"VK_ERROR_NOT_PERMITTED\"";
        break;
    case -1000000000:
        settings.stream() << "\"VK_ERROR_SURFACE_LOST_KHR\"";
        break;
    case -1000000001:
        settings.stream() << "\"VK_ERROR_NATIVE_WINDOW_IN_USE_KHR\"";
        break;
    case 1000001003:
        settings.stream() << "\"VK_SUBOPTIMAL_KHR\"";
        break;
    case -1000001004:
        settings.stream() << "\"VK_ERROR_OUT_OF_DATE_KHR\"";
        break;
    case -1000003001:
        settings.stream() << "\"VK_ERROR_INCOMPATIBLE_DISPLAY_KHR\"";
        break;
    case -1000011001:
        settings.stream() << "\"VK_ERROR_VALIDATION_FAILED_EXT\"";
        break;
    case -1000012000:
        settings.stream() << "\"VK_ERROR_INVALID_SHADER_NV\"";
        break;
    case -1000023000:
        settings.stream() << "\"VK_ERROR_IMAGE_USAGE_NOT_SUPPORTED_KHR\"";
        break;
    case -1000023001:
        settings.stream() << "\"VK_ERROR_VIDEO_PICTURE_LAYOUT_NOT_SUPPORTED_KHR\"";
        break;
    case -1000023002:
        settings.stream() << "\"VK_ERROR_VIDEO_PROFILE_OPERATION_NOT_SUPPORTED_KHR\"";
        break;
    case -1000023003:
        settings.stream() << "\"VK_ERROR_VIDEO_PROFILE_FORMAT_NOT_SUPPORTED_KHR\"";
        break;
    case -1000023004:
        settings.stream() << "\"VK_ERROR_VIDEO_PROFILE_CODEC_NOT_SUPPORTED_KHR\"";
        break;
    case -1000023005:
        settings.stream() << "\"VK_ERROR_VIDEO_STD_VERSION_NOT_SUPPORTED_KHR\"";
        break;
    case -1000158000:
        settings.stream() << "\"VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT\"";
        break;
    case -1000255000:
        settings.stream() << "\"VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT\"";
        break;
    case 1000268000:
        settings.stream() << "\"VK_THREAD_IDLE_KHR\"";
        break;
    case 1000268001:
        settings.stream() << "\"VK_THREAD_DONE_KHR\"";
        break;
    case 1000268002:
        settings.stream() << "\"VK_OPERATION_DEFERRED_KHR\"";
        break;
    case 1000268003:
        settings.stream() << "\"VK_OPERATION_NOT_DEFERRED_KHR\"";
        break;
    case -1000299000:
        settings.stream() << "\"VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR\"";
        break;
    case -1000338000:
        settings.stream() << "\"VK_ERROR_COMPRESSION_EXHAUSTED_EXT\"";
        break;
    case 1000482000:
        settings.stream() << "\"VK_INCOMPATIBLE_SHADER_BINARY_EXT\"";
        break;
    case 1000483000:
        settings.stream() << "\"VK_PIPELINE_BINARY_MISSING_KHR\"";
        break;
    case -1000483000:
        settings.stream() << "\"VK_ERROR_NOT_ENOUGH_SPACE_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkStructureType(VkStructureType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_STRUCTURE_TYPE_APPLICATION_INFO\"";
        break;
    case 1:
        settings.stream() << "\"VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO\"";
        break;
    case 2:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO\"";
        break;
    case 3:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO\"";
        break;
    case 4:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBMIT_INFO\"";
        break;
    case 5:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO\"";
        break;
    case 6:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE\"";
        break;
    case 7:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_SPARSE_INFO\"";
        break;
    case 8:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FENCE_CREATE_INFO\"";
        break;
    case 9:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO\"";
        break;
    case 10:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EVENT_CREATE_INFO\"";
        break;
    case 11:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO\"";
        break;
    case 12:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO\"";
        break;
    case 13:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO\"";
        break;
    case 14:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO\"";
        break;
    case 15:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO\"";
        break;
    case 16:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO\"";
        break;
    case 17:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO\"";
        break;
    case 18:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO\"";
        break;
    case 19:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO\"";
        break;
    case 20:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO\"";
        break;
    case 21:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO\"";
        break;
    case 22:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO\"";
        break;
    case 23:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO\"";
        break;
    case 24:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO\"";
        break;
    case 25:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO\"";
        break;
    case 26:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO\"";
        break;
    case 27:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO\"";
        break;
    case 28:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO\"";
        break;
    case 29:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO\"";
        break;
    case 30:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO\"";
        break;
    case 31:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO\"";
        break;
    case 32:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO\"";
        break;
    case 33:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO\"";
        break;
    case 34:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO\"";
        break;
    case 35:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET\"";
        break;
    case 36:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET\"";
        break;
    case 37:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO\"";
        break;
    case 38:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO\"";
        break;
    case 39:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO\"";
        break;
    case 40:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO\"";
        break;
    case 41:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO\"";
        break;
    case 42:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO\"";
        break;
    case 43:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO\"";
        break;
    case 44:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER\"";
        break;
    case 45:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER\"";
        break;
    case 46:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_BARRIER\"";
        break;
    case 47:
        settings.stream() << "\"VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO\"";
        break;
    case 48:
        settings.stream() << "\"VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO\"";
        break;
    case 1000094000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES\"";
        break;
    case 1000157000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO\"";
        break;
    case 1000157001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO\"";
        break;
    case 1000083000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES\"";
        break;
    case 1000127000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS\"";
        break;
    case 1000127001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO\"";
        break;
    case 1000060000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO\"";
        break;
    case 1000060003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO\"";
        break;
    case 1000060004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO\"";
        break;
    case 1000060005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO\"";
        break;
    case 1000060006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO\"";
        break;
    case 1000060013:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO\"";
        break;
    case 1000060014:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO\"";
        break;
    case 1000070000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES\"";
        break;
    case 1000070001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO\"";
        break;
    case 1000146000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2\"";
        break;
    case 1000146001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2\"";
        break;
    case 1000146002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2\"";
        break;
    case 1000146003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2\"";
        break;
    case 1000146004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2\"";
        break;
    case 1000059000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2\"";
        break;
    case 1000059001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2\"";
        break;
    case 1000059002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2\"";
        break;
    case 1000059003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2\"";
        break;
    case 1000059004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2\"";
        break;
    case 1000059005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2\"";
        break;
    case 1000059006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2\"";
        break;
    case 1000059007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2\"";
        break;
    case 1000059008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2\"";
        break;
    case 1000117000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES\"";
        break;
    case 1000117001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO\"";
        break;
    case 1000117002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO\"";
        break;
    case 1000117003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO\"";
        break;
    case 1000053000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO\"";
        break;
    case 1000053001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES\"";
        break;
    case 1000053002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES\"";
        break;
    case 1000120000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES\"";
        break;
    case 1000145000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO\"";
        break;
    case 1000145001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES\"";
        break;
    case 1000145002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES\"";
        break;
    case 1000145003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2\"";
        break;
    case 1000156000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO\"";
        break;
    case 1000156001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO\"";
        break;
    case 1000156002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO\"";
        break;
    case 1000156003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO\"";
        break;
    case 1000156004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES\"";
        break;
    case 1000156005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES\"";
        break;
    case 1000085000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO\"";
        break;
    case 1000071000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO\"";
        break;
    case 1000071001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES\"";
        break;
    case 1000071002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO\"";
        break;
    case 1000071003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES\"";
        break;
    case 1000071004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES\"";
        break;
    case 1000072000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO\"";
        break;
    case 1000072001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO\"";
        break;
    case 1000072002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO\"";
        break;
    case 1000112000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO\"";
        break;
    case 1000112001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES\"";
        break;
    case 1000113000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO\"";
        break;
    case 1000077000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO\"";
        break;
    case 1000076000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO\"";
        break;
    case 1000076001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES\"";
        break;
    case 1000168000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES\"";
        break;
    case 1000168001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT\"";
        break;
    case 1000063000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES\"";
        break;
    case 49:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES\"";
        break;
    case 50:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES\"";
        break;
    case 51:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES\"";
        break;
    case 52:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES\"";
        break;
    case 1000147000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO\"";
        break;
    case 1000109000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2\"";
        break;
    case 1000109001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2\"";
        break;
    case 1000109002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2\"";
        break;
    case 1000109003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2\"";
        break;
    case 1000109004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2\"";
        break;
    case 1000109005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO\"";
        break;
    case 1000109006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBPASS_END_INFO\"";
        break;
    case 1000177000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES\"";
        break;
    case 1000196000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES\"";
        break;
    case 1000180000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES\"";
        break;
    case 1000082000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES\"";
        break;
    case 1000197000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES\"";
        break;
    case 1000161000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO\"";
        break;
    case 1000161001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES\"";
        break;
    case 1000161002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES\"";
        break;
    case 1000161003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO\"";
        break;
    case 1000161004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT\"";
        break;
    case 1000199000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES\"";
        break;
    case 1000199001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE\"";
        break;
    case 1000221000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES\"";
        break;
    case 1000246000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO\"";
        break;
    case 1000130000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES\"";
        break;
    case 1000130001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO\"";
        break;
    case 1000211000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES\"";
        break;
    case 1000108000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES\"";
        break;
    case 1000108001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO\"";
        break;
    case 1000108002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO\"";
        break;
    case 1000108003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO\"";
        break;
    case 1000253000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES\"";
        break;
    case 1000175000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES\"";
        break;
    case 1000241000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES\"";
        break;
    case 1000241001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT\"";
        break;
    case 1000241002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT\"";
        break;
    case 1000261000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES\"";
        break;
    case 1000207000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES\"";
        break;
    case 1000207001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES\"";
        break;
    case 1000207002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO\"";
        break;
    case 1000207003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO\"";
        break;
    case 1000207004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO\"";
        break;
    case 1000207005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO\"";
        break;
    case 1000257000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES\"";
        break;
    case 1000244001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO\"";
        break;
    case 1000257002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO\"";
        break;
    case 1000257003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO\"";
        break;
    case 1000257004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO\"";
        break;
    case 53:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES\"";
        break;
    case 54:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES\"";
        break;
    case 1000192000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO\"";
        break;
    case 1000215000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES\"";
        break;
    case 1000245000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES\"";
        break;
    case 1000276000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES\"";
        break;
    case 1000295000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES\"";
        break;
    case 1000295001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO\"";
        break;
    case 1000295002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO\"";
        break;
    case 1000297000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES\"";
        break;
    case 1000314000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_BARRIER_2\"";
        break;
    case 1000314001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2\"";
        break;
    case 1000314002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2\"";
        break;
    case 1000314003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEPENDENCY_INFO\"";
        break;
    case 1000314004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBMIT_INFO_2\"";
        break;
    case 1000314005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO\"";
        break;
    case 1000314006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO\"";
        break;
    case 1000314007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES\"";
        break;
    case 1000325000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES\"";
        break;
    case 1000335000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES\"";
        break;
    case 1000337000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2\"";
        break;
    case 1000337001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2\"";
        break;
    case 1000337002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2\"";
        break;
    case 1000337003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2\"";
        break;
    case 1000337004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2\"";
        break;
    case 1000337005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2\"";
        break;
    case 1000337006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_COPY_2\"";
        break;
    case 1000337007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_COPY_2\"";
        break;
    case 1000337008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_BLIT_2\"";
        break;
    case 1000337009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2\"";
        break;
    case 1000337010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2\"";
        break;
    case 1000225000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES\"";
        break;
    case 1000225001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO\"";
        break;
    case 1000225002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES\"";
        break;
    case 1000138000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES\"";
        break;
    case 1000138001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES\"";
        break;
    case 1000138002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK\"";
        break;
    case 1000138003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO\"";
        break;
    case 1000066000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES\"";
        break;
    case 1000044000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDERING_INFO\"";
        break;
    case 1000044001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO\"";
        break;
    case 1000044002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO\"";
        break;
    case 1000044003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES\"";
        break;
    case 1000044004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO\"";
        break;
    case 1000280000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES\"";
        break;
    case 1000280001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES\"";
        break;
    case 1000281001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES\"";
        break;
    case 1000360000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3\"";
        break;
    case 1000413000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES\"";
        break;
    case 1000413001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES\"";
        break;
    case 1000413002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS\"";
        break;
    case 1000413003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS\"";
        break;
    case 55:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES\"";
        break;
    case 56:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES\"";
        break;
    case 1000174000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO\"";
        break;
    case 1000388000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES\"";
        break;
    case 1000388001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES\"";
        break;
    case 1000416000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES\"";
        break;
    case 1000528000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES\"";
        break;
    case 1000544000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES\"";
        break;
    case 1000259000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES\"";
        break;
    case 1000259001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO\"";
        break;
    case 1000259002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES\"";
        break;
    case 1000525000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES\"";
        break;
    case 1000190001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO\"";
        break;
    case 1000190002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES\"";
        break;
    case 1000265000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES\"";
        break;
    case 1000271000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_MAP_INFO\"";
        break;
    case 1000271001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_UNMAP_INFO\"";
        break;
    case 1000470000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES\"";
        break;
    case 1000470001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES\"";
        break;
    case 1000470003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDERING_AREA_INFO\"";
        break;
    case 1000470004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO\"";
        break;
    case 1000338002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2\"";
        break;
    case 1000338003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2\"";
        break;
    case 1000470005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO\"";
        break;
    case 1000470006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO\"";
        break;
    case 1000080000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES\"";
        break;
    case 1000232000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES\"";
        break;
    case 1000232001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO\"";
        break;
    case 1000232002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO\"";
        break;
    case 1000545000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES\"";
        break;
    case 1000545001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES\"";
        break;
    case 1000545002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS\"";
        break;
    case 1000545003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO\"";
        break;
    case 1000545004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PUSH_CONSTANTS_INFO\"";
        break;
    case 1000545005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_INFO\"";
        break;
    case 1000545006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_WITH_TEMPLATE_INFO\"";
        break;
    case 1000466000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES\"";
        break;
    case 1000068000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO\"";
        break;
    case 1000068001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES\"";
        break;
    case 1000068002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES\"";
        break;
    case 1000270000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES\"";
        break;
    case 1000270001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES\"";
        break;
    case 1000270002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY\"";
        break;
    case 1000270003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_TO_MEMORY_COPY\"";
        break;
    case 1000270004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO\"";
        break;
    case 1000270005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO\"";
        break;
    case 1000270006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO\"";
        break;
    case 1000270007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO\"";
        break;
    case 1000270008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE\"";
        break;
    case 1000270009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY\"";
        break;
    case 1000001000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR\"";
        break;
    case 1000001001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PRESENT_INFO_KHR\"";
        break;
    case 1000060007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR\"";
        break;
    case 1000060008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR\"";
        break;
    case 1000060009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR\"";
        break;
    case 1000060010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR\"";
        break;
    case 1000060011:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR\"";
        break;
    case 1000060012:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR\"";
        break;
    case 1000002000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR\"";
        break;
    case 1000002001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR\"";
        break;
    case 1000003000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR\"";
        break;
    case 1000004000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR\"";
        break;
    case 1000005000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR\"";
        break;
    case 1000006000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR\"";
        break;
    case 1000008000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR\"";
        break;
    case 1000009000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR\"";
        break;
    case 1000010000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID\"";
        break;
    case 1000010001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SWAPCHAIN_IMAGE_CREATE_INFO_ANDROID\"";
        break;
    case 1000010002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENTATION_PROPERTIES_ANDROID\"";
        break;
    case 1000011000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT\"";
        break;
    case 1000018000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD\"";
        break;
    case 1000022000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT\"";
        break;
    case 1000022001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT\"";
        break;
    case 1000022002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT\"";
        break;
    case 1000023000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR\"";
        break;
    case 1000023001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR\"";
        break;
    case 1000023002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR\"";
        break;
    case 1000023003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR\"";
        break;
    case 1000023004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR\"";
        break;
    case 1000023005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR\"";
        break;
    case 1000023006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR\"";
        break;
    case 1000023007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR\"";
        break;
    case 1000023008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR\"";
        break;
    case 1000023009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR\"";
        break;
    case 1000023010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR\"";
        break;
    case 1000023011:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR\"";
        break;
    case 1000023012:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR\"";
        break;
    case 1000023013:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR\"";
        break;
    case 1000023014:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR\"";
        break;
    case 1000023015:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR\"";
        break;
    case 1000023016:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR\"";
        break;
    case 1000024000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR\"";
        break;
    case 1000024001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR\"";
        break;
    case 1000024002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR\"";
        break;
    case 1000026000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV\"";
        break;
    case 1000026001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV\"";
        break;
    case 1000026002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV\"";
        break;
    case 1000028000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT\"";
        break;
    case 1000028001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT\"";
        break;
    case 1000028002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT\"";
        break;
    case 1000029000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX\"";
        break;
    case 1000029001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX\"";
        break;
    case 1000029002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX\"";
        break;
    case 1000029004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CU_MODULE_TEXTURING_MODE_CREATE_INFO_NVX\"";
        break;
    case 1000030000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX\"";
        break;
    case 1000030001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX\"";
        break;
    case 1000038000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_KHR\"";
        break;
    case 1000038001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR\"";
        break;
    case 1000038002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR\"";
        break;
    case 1000038003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PICTURE_INFO_KHR\"";
        break;
    case 1000038004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_KHR\"";
        break;
    case 1000038005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR\"";
        break;
    case 1000038006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_GOP_REMAINING_FRAME_INFO_KHR\"";
        break;
    case 1000038007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_KHR\"";
        break;
    case 1000038008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_KHR\"";
        break;
    case 1000038009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_KHR\"";
        break;
    case 1000038010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_KHR\"";
        break;
    case 1000038011:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUALITY_LEVEL_PROPERTIES_KHR\"";
        break;
    case 1000038012:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_GET_INFO_KHR\"";
        break;
    case 1000038013:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_FEEDBACK_INFO_KHR\"";
        break;
    case 1000039000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_KHR\"";
        break;
    case 1000039001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR\"";
        break;
    case 1000039002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR\"";
        break;
    case 1000039003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PICTURE_INFO_KHR\"";
        break;
    case 1000039004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_KHR\"";
        break;
    case 1000039005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR\"";
        break;
    case 1000039006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_GOP_REMAINING_FRAME_INFO_KHR\"";
        break;
    case 1000039007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_KHR\"";
        break;
    case 1000039009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_KHR\"";
        break;
    case 1000039010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_KHR\"";
        break;
    case 1000039011:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_CREATE_INFO_KHR\"";
        break;
    case 1000039012:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUALITY_LEVEL_PROPERTIES_KHR\"";
        break;
    case 1000039013:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_GET_INFO_KHR\"";
        break;
    case 1000039014:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_FEEDBACK_INFO_KHR\"";
        break;
    case 1000040000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR\"";
        break;
    case 1000040001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR\"";
        break;
    case 1000040003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR\"";
        break;
    case 1000040004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR\"";
        break;
    case 1000040005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR\"";
        break;
    case 1000040006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR\"";
        break;
    case 1000041000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD\"";
        break;
    case 1000049000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP\"";
        break;
    case 1000050000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV\"";
        break;
    case 1000051000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PRIVATE_VENDOR_INFO_PLACEHOLDER_OFFSET_0_NV\"";
        break;
    case 1000056000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV\"";
        break;
    case 1000056001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV\"";
        break;
    case 1000057000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV\"";
        break;
    case 1000057001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV\"";
        break;
    case 1000058000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV\"";
        break;
    case 1000061000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT\"";
        break;
    case 1000062000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN\"";
        break;
    case 1000067000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT\"";
        break;
    case 1000067001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT\"";
        break;
    case 1000073000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR\"";
        break;
    case 1000073001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR\"";
        break;
    case 1000073002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR\"";
        break;
    case 1000073003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR\"";
        break;
    case 1000074000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR\"";
        break;
    case 1000074001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR\"";
        break;
    case 1000074002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR\"";
        break;
    case 1000075000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR\"";
        break;
    case 1000078000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR\"";
        break;
    case 1000078001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR\"";
        break;
    case 1000078002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR\"";
        break;
    case 1000078003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR\"";
        break;
    case 1000079000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR\"";
        break;
    case 1000079001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR\"";
        break;
    case 1000081000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT\"";
        break;
    case 1000081001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT\"";
        break;
    case 1000081002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT\"";
        break;
    case 1000084000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR\"";
        break;
    case 1000087000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV\"";
        break;
    case 1000090000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT\"";
        break;
    case 1000091000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT\"";
        break;
    case 1000091001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT\"";
        break;
    case 1000091002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT\"";
        break;
    case 1000091003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT\"";
        break;
    case 1000092000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE\"";
        break;
    case 1000097000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX\"";
        break;
    case 1000044009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX\"";
        break;
    case 1000098000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV\"";
        break;
    case 1000099000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT\"";
        break;
    case 1000099001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT\"";
        break;
    case 1000101000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT\"";
        break;
    case 1000101001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT\"";
        break;
    case 1000102000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT\"";
        break;
    case 1000102001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT\"";
        break;
    case 1000105000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_HDR_METADATA_EXT\"";
        break;
    case 1000110000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG\"";
        break;
    case 1000111000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR\"";
        break;
    case 1000114000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR\"";
        break;
    case 1000114001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR\"";
        break;
    case 1000114002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR\"";
        break;
    case 1000115000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR\"";
        break;
    case 1000115001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR\"";
        break;
    case 1000116000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR\"";
        break;
    case 1000116001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR\"";
        break;
    case 1000116002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR\"";
        break;
    case 1000116003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR\"";
        break;
    case 1000116004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR\"";
        break;
    case 1000116005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR\"";
        break;
    case 1000116006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR\"";
        break;
    case 1000119000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR\"";
        break;
    case 1000119001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR\"";
        break;
    case 1000119002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR\"";
        break;
    case 1000121000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR\"";
        break;
    case 1000121001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR\"";
        break;
    case 1000121002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR\"";
        break;
    case 1000121003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR\"";
        break;
    case 1000121004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR\"";
        break;
    case 1000122000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK\"";
        break;
    case 1000123000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK\"";
        break;
    case 1000128000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT\"";
        break;
    case 1000128001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT\"";
        break;
    case 1000128002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT\"";
        break;
    case 1000128003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT\"";
        break;
    case 1000128004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT\"";
        break;
    case 1000129000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID\"";
        break;
    case 1000129001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID\"";
        break;
    case 1000129002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID\"";
        break;
    case 1000129003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID\"";
        break;
    case 1000129004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID\"";
        break;
    case 1000129005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID\"";
        break;
    case 1000129006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID\"";
        break;
    case 1000134000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_FEATURES_AMDX\"";
        break;
    case 1000134001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_PROPERTIES_AMDX\"";
        break;
    case 1000134002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_SCRATCH_SIZE_AMDX\"";
        break;
    case 1000134003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_CREATE_INFO_AMDX\"";
        break;
    case 1000134004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_NODE_CREATE_INFO_AMDX\"";
        break;
    case 1000044008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD\"";
        break;
    case 1000141000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_BFLOAT16_FEATURES_KHR\"";
        break;
    case 1000143000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT\"";
        break;
    case 1000143001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT\"";
        break;
    case 1000143002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT\"";
        break;
    case 1000143003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT\"";
        break;
    case 1000143004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT\"";
        break;
    case 1000148000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT\"";
        break;
    case 1000148001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT\"";
        break;
    case 1000148002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT\"";
        break;
    case 1000149000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV\"";
        break;
    case 1000150007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR\"";
        break;
    case 1000150000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR\"";
        break;
    case 1000150002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR\"";
        break;
    case 1000150003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR\"";
        break;
    case 1000150004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR\"";
        break;
    case 1000150005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR\"";
        break;
    case 1000150006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR\"";
        break;
    case 1000150009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR\"";
        break;
    case 1000150010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR\"";
        break;
    case 1000150011:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR\"";
        break;
    case 1000150012:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR\"";
        break;
    case 1000150013:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR\"";
        break;
    case 1000150014:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR\"";
        break;
    case 1000150017:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR\"";
        break;
    case 1000150020:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR\"";
        break;
    case 1000347000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR\"";
        break;
    case 1000347001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR\"";
        break;
    case 1000150015:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR\"";
        break;
    case 1000150016:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR\"";
        break;
    case 1000150018:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR\"";
        break;
    case 1000348013:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR\"";
        break;
    case 1000152000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV\"";
        break;
    case 1000154000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV\"";
        break;
    case 1000154001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV\"";
        break;
    case 1000158000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT\"";
        break;
    case 1000158002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT\"";
        break;
    case 1000158003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT\"";
        break;
    case 1000158004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT\"";
        break;
    case 1000158005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT\"";
        break;
    case 1000158006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT\"";
        break;
    case 1000160000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT\"";
        break;
    case 1000160001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT\"";
        break;
    case 1000163000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR\"";
        break;
    case 1000163001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR\"";
        break;
    case 1000164000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV\"";
        break;
    case 1000164001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV\"";
        break;
    case 1000164002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV\"";
        break;
    case 1000164005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV\"";
        break;
    case 1000165000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV\"";
        break;
    case 1000165001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV\"";
        break;
    case 1000165003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GEOMETRY_NV\"";
        break;
    case 1000165004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV\"";
        break;
    case 1000165005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV\"";
        break;
    case 1000165006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV\"";
        break;
    case 1000165007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV\"";
        break;
    case 1000165008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV\"";
        break;
    case 1000165009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV\"";
        break;
    case 1000165011:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV\"";
        break;
    case 1000165012:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV\"";
        break;
    case 1000166000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV\"";
        break;
    case 1000166001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV\"";
        break;
    case 1000170000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT\"";
        break;
    case 1000170001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT\"";
        break;
    case 1000178000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT\"";
        break;
    case 1000178001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT\"";
        break;
    case 1000178002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT\"";
        break;
    case 1000181000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR\"";
        break;
    case 1000183000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD\"";
        break;
    case 1000185000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD\"";
        break;
    case 1000187000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR\"";
        break;
    case 1000187001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR\"";
        break;
    case 1000187002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR\"";
        break;
    case 1000187003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR\"";
        break;
    case 1000187004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR\"";
        break;
    case 1000187005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR\"";
        break;
    case 1000189000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD\"";
        break;
    case 1000190000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT\"";
        break;
    case 1000191000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP\"";
        break;
    case 1000202000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV\"";
        break;
    case 1000202001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV\"";
        break;
    case 1000204000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV\"";
        break;
    case 1000205000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV\"";
        break;
    case 1000205002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV\"";
        break;
    case 1000206000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV\"";
        break;
    case 1000206001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV\"";
        break;
    case 1000314008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV\"";
        break;
    case 1000314009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV\"";
        break;
    case 1000209000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL\"";
        break;
    case 1000210000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL\"";
        break;
    case 1000210001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL\"";
        break;
    case 1000210002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL\"";
        break;
    case 1000210003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL\"";
        break;
    case 1000210004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL\"";
        break;
    case 1000210005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL\"";
        break;
    case 1000212000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT\"";
        break;
    case 1000213000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD\"";
        break;
    case 1000213001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD\"";
        break;
    case 1000214000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA\"";
        break;
    case 1000217000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT\"";
        break;
    case 1000218000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT\"";
        break;
    case 1000218001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT\"";
        break;
    case 1000218002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT\"";
        break;
    case 1000044007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT\"";
        break;
    case 1000226000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR\"";
        break;
    case 1000226001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR\"";
        break;
    case 1000226002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR\"";
        break;
    case 1000226003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR\"";
        break;
    case 1000226004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR\"";
        break;
    case 1000044006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR\"";
        break;
    case 1000227000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD\"";
        break;
    case 1000229000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD\"";
        break;
    case 1000234000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT\"";
        break;
    case 1000235000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR\"";
        break;
    case 1000237000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT\"";
        break;
    case 1000238000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT\"";
        break;
    case 1000238001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT\"";
        break;
    case 1000239000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR\"";
        break;
    case 1000240000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV\"";
        break;
    case 1000244000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT\"";
        break;
    case 1000244002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT\"";
        break;
    case 1000247000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT\"";
        break;
    case 1000248000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR\"";
        break;
    case 1000249000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV\"";
        break;
    case 1000249001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV\"";
        break;
    case 1000249002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV\"";
        break;
    case 1000250000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV\"";
        break;
    case 1000250001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV\"";
        break;
    case 1000250002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV\"";
        break;
    case 1000251000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT\"";
        break;
    case 1000252000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT\"";
        break;
    case 1000254000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT\"";
        break;
    case 1000254001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT\"";
        break;
    case 1000254002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT\"";
        break;
    case 1000255000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT\"";
        break;
    case 1000255002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT\"";
        break;
    case 1000255001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT\"";
        break;
    case 1000256000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT\"";
        break;
    case 1000260000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT\"";
        break;
    case 1000267000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT\"";
        break;
    case 1000269000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR\"";
        break;
    case 1000269001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR\"";
        break;
    case 1000269002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR\"";
        break;
    case 1000269003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR\"";
        break;
    case 1000269004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR\"";
        break;
    case 1000269005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR\"";
        break;
    case 1000272000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_FEATURES_EXT\"";
        break;
    case 1000272001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_PROPERTIES_EXT\"";
        break;
    case 1000272002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_MAP_PLACED_INFO_EXT\"";
        break;
    case 1000273000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT\"";
        break;
    case 1000274000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_EXT\"";
        break;
    case 1000274001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_EXT\"";
        break;
    case 1000274002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_COMPATIBILITY_EXT\"";
        break;
    case 1000275000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT\"";
        break;
    case 1000275001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT\"";
        break;
    case 1000275002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT\"";
        break;
    case 1000275003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT\"";
        break;
    case 1000275004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT\"";
        break;
    case 1000275005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RELEASE_SWAPCHAIN_IMAGES_INFO_EXT\"";
        break;
    case 1000277000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV\"";
        break;
    case 1000277001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV\"";
        break;
    case 1000277002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV\"";
        break;
    case 1000277003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV\"";
        break;
    case 1000277004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV\"";
        break;
    case 1000277005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV\"";
        break;
    case 1000277006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV\"";
        break;
    case 1000277007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV\"";
        break;
    case 1000278000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV\"";
        break;
    case 1000278001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV\"";
        break;
    case 1000281000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT\"";
        break;
    case 1000282000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM\"";
        break;
    case 1000282001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM\"";
        break;
    case 1000283000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT\"";
        break;
    case 1000283001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEPTH_BIAS_INFO_EXT\"";
        break;
    case 1000283002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT\"";
        break;
    case 1000284000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT\"";
        break;
    case 1000284001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT\"";
        break;
    case 1000284002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT\"";
        break;
    case 1000286000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT\"";
        break;
    case 1000286001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT\"";
        break;
    case 1000287000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT\"";
        break;
    case 1000287001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT\"";
        break;
    case 1000287002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT\"";
        break;
    case 1000290000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR\"";
        break;
    case 1000292000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV\"";
        break;
    case 1000292001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_BARRIER_NV\"";
        break;
    case 1000292002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV\"";
        break;
    case 1000294000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PRESENT_ID_KHR\"";
        break;
    case 1000294001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR\"";
        break;
    case 1000299000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR\"";
        break;
    case 1000299001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR\"";
        break;
    case 1000299002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR\"";
        break;
    case 1000299003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR\"";
        break;
    case 1000299004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR\"";
        break;
    case 1000299005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUERY_POOL_VIDEO_ENCODE_FEEDBACK_CREATE_INFO_KHR\"";
        break;
    case 1000299006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR\"";
        break;
    case 1000299007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_PROPERTIES_KHR\"";
        break;
    case 1000299008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR\"";
        break;
    case 1000299009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_GET_INFO_KHR\"";
        break;
    case 1000299010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_FEEDBACK_INFO_KHR\"";
        break;
    case 1000300000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV\"";
        break;
    case 1000300001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV\"";
        break;
    case 1000307000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CUDA_MODULE_CREATE_INFO_NV\"";
        break;
    case 1000307001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CUDA_FUNCTION_CREATE_INFO_NV\"";
        break;
    case 1000307002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CUDA_LAUNCH_INFO_NV\"";
        break;
    case 1000307003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_FEATURES_NV\"";
        break;
    case 1000307004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_PROPERTIES_NV\"";
        break;
    case 1000308000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_REFRESH_OBJECT_LIST_KHR\"";
        break;
    case 1000309000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_SHADING_FEATURES_QCOM\"";
        break;
    case 1000309001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_SHADING_PROPERTIES_QCOM\"";
        break;
    case 1000309002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_TILE_SHADING_CREATE_INFO_QCOM\"";
        break;
    case 1000309003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PER_TILE_BEGIN_INFO_QCOM\"";
        break;
    case 1000309004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PER_TILE_END_INFO_QCOM\"";
        break;
    case 1000309005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPATCH_TILE_INFO_QCOM\"";
        break;
    case 1000310000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_QUERY_LOW_LATENCY_SUPPORT_NV\"";
        break;
    case 1000311000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT\"";
        break;
    case 1000311001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECTS_INFO_EXT\"";
        break;
    case 1000311002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_METAL_DEVICE_INFO_EXT\"";
        break;
    case 1000311003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT\"";
        break;
    case 1000311004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT\"";
        break;
    case 1000311005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_METAL_BUFFER_INFO_EXT\"";
        break;
    case 1000311006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT\"";
        break;
    case 1000311007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT\"";
        break;
    case 1000311008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT\"";
        break;
    case 1000311009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT\"";
        break;
    case 1000311010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_METAL_SHARED_EVENT_INFO_EXT\"";
        break;
    case 1000311011:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT\"";
        break;
    case 1000316000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_PROPERTIES_EXT\"";
        break;
    case 1000316001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_DENSITY_MAP_PROPERTIES_EXT\"";
        break;
    case 1000316002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT\"";
        break;
    case 1000316003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_ADDRESS_INFO_EXT\"";
        break;
    case 1000316004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_GET_INFO_EXT\"";
        break;
    case 1000316005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT\"";
        break;
    case 1000316006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT\"";
        break;
    case 1000316007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_EXT\"";
        break;
    case 1000316008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT\"";
        break;
    case 1000316010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT\"";
        break;
    case 1000316011:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_INFO_EXT\"";
        break;
    case 1000316012:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT\"";
        break;
    case 1000316009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT\"";
        break;
    case 1000320000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT\"";
        break;
    case 1000320001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT\"";
        break;
    case 1000320002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT\"";
        break;
    case 1000321000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD\"";
        break;
    case 1000203000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR\"";
        break;
    case 1000322000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR\"";
        break;
    case 1000323000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR\"";
        break;
    case 1000326000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV\"";
        break;
    case 1000326001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV\"";
        break;
    case 1000326002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV\"";
        break;
    case 1000327000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV\"";
        break;
    case 1000327001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV\"";
        break;
    case 1000327002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV\"";
        break;
    case 1000328000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT\"";
        break;
    case 1000328001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT\"";
        break;
    case 1000330000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT\"";
        break;
    case 1000332000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT\"";
        break;
    case 1000332001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT\"";
        break;
    case 1000333000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM\"";
        break;
    case 1000336000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR\"";
        break;
    case 1000338000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT\"";
        break;
    case 1000338001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT\"";
        break;
    case 1000338004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT\"";
        break;
    case 1000339000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT\"";
        break;
    case 1000340000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT\"";
        break;
    case 1000341000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT\"";
        break;
    case 1000341001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT\"";
        break;
    case 1000341002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT\"";
        break;
    case 1000344000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT\"";
        break;
    case 1000346000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT\"";
        break;
    case 1000352000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT\"";
        break;
    case 1000352001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT\"";
        break;
    case 1000352002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT\"";
        break;
    case 1000353000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT\"";
        break;
    case 1000354000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT\"";
        break;
    case 1000354001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT\"";
        break;
    case 1000355000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT\"";
        break;
    case 1000355001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT\"";
        break;
    case 1000356000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT\"";
        break;
    case 1000361000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_MODE_FIFO_LATEST_READY_FEATURES_EXT\"";
        break;
    case 1000364000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA\"";
        break;
    case 1000364001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA\"";
        break;
    case 1000364002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA\"";
        break;
    case 1000365000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA\"";
        break;
    case 1000365001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA\"";
        break;
    case 1000366000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA\"";
        break;
    case 1000366001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA\"";
        break;
    case 1000366002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA\"";
        break;
    case 1000366003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA\"";
        break;
    case 1000366004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA\"";
        break;
    case 1000366005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA\"";
        break;
    case 1000366006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA\"";
        break;
    case 1000366007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA\"";
        break;
    case 1000366008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SYSMEM_COLOR_SPACE_FUCHSIA\"";
        break;
    case 1000366009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA\"";
        break;
    case 1000369000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI\"";
        break;
    case 1000369001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI\"";
        break;
    case 1000369002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI\"";
        break;
    case 1000370000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI\"";
        break;
    case 1000371000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV\"";
        break;
    case 1000371001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV\"";
        break;
    case 1000372000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_PROPERTIES_IDENTIFIER_EXT\"";
        break;
    case 1000372001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT\"";
        break;
    case 1000373000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_FENCE_SCI_SYNC_INFO_NV\"";
        break;
    case 1000373001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_FENCE_SCI_SYNC_INFO_NV\"";
        break;
    case 1000373002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FENCE_GET_SCI_SYNC_INFO_NV\"";
        break;
    case 1000373003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SCI_SYNC_ATTRIBUTES_INFO_NV\"";
        break;
    case 1000373004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_SCI_SYNC_INFO_NV\"";
        break;
    case 1000373005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_SCI_SYNC_INFO_NV\"";
        break;
    case 1000373006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_GET_SCI_SYNC_INFO_NV\"";
        break;
    case 1000373007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SCI_SYNC_FEATURES_NV\"";
        break;
    case 1000374000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_MEMORY_SCI_BUF_INFO_NV\"";
        break;
    case 1000374001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXPORT_MEMORY_SCI_BUF_INFO_NV\"";
        break;
    case 1000374002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_GET_SCI_BUF_INFO_NV\"";
        break;
    case 1000374003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_SCI_BUF_PROPERTIES_NV\"";
        break;
    case 1000374004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_SCI_BUF_FEATURES_NV\"";
        break;
    case 1000375000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT\"";
        break;
    case 1000375001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT\"";
        break;
    case 1000376000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT\"";
        break;
    case 1000376001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SUBPASS_RESOLVE_PERFORMANCE_QUERY_EXT\"";
        break;
    case 1000376002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT\"";
        break;
    case 1000377000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT\"";
        break;
    case 1000378000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX\"";
        break;
    case 1000381000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT\"";
        break;
    case 1000381001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT\"";
        break;
    case 1000382000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT\"";
        break;
    case 1000386000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR\"";
        break;
    case 1000391000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT\"";
        break;
    case 1000391001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT\"";
        break;
    case 1000392000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT\"";
        break;
    case 1000392001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT\"";
        break;
    case 1000393000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT\"";
        break;
    case 1000395000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT\"";
        break;
    case 1000395001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_PROPERTIES_EXT\"";
        break;
    case 1000396000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MICROMAP_BUILD_INFO_EXT\"";
        break;
    case 1000396001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MICROMAP_VERSION_INFO_EXT\"";
        break;
    case 1000396002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT\"";
        break;
    case 1000396003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT\"";
        break;
    case 1000396004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT\"";
        break;
    case 1000396005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT\"";
        break;
    case 1000396006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT\"";
        break;
    case 1000396007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MICROMAP_CREATE_INFO_EXT\"";
        break;
    case 1000396008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MICROMAP_BUILD_SIZES_INFO_EXT\"";
        break;
    case 1000396009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT\"";
        break;
    case 1000397000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_FEATURES_NV\"";
        break;
    case 1000397001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_PROPERTIES_NV\"";
        break;
    case 1000397002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_DISPLACEMENT_MICROMAP_NV\"";
        break;
    case 1000404000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI\"";
        break;
    case 1000404001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI\"";
        break;
    case 1000404002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_VRS_FEATURES_HUAWEI\"";
        break;
    case 1000411000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT\"";
        break;
    case 1000411001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT\"";
        break;
    case 1000412000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT\"";
        break;
    case 1000415000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_ARM\"";
        break;
    case 1000417000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM\"";
        break;
    case 1000417001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM\"";
        break;
    case 1000417002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_PROPERTIES_ARM\"";
        break;
    case 1000418000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT\"";
        break;
    case 1000418001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_VIEW_SLICED_CREATE_INFO_EXT\"";
        break;
    case 1000420000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE\"";
        break;
    case 1000420001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE\"";
        break;
    case 1000420002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE\"";
        break;
    case 1000422000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT\"";
        break;
    case 1000424000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM\"";
        break;
    case 1000424001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_PROPERTIES_ARM\"";
        break;
    case 1000424002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_BEGIN_INFO_ARM\"";
        break;
    case 1000424003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_INFO_ARM\"";
        break;
    case 1000424004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_SUBMIT_INFO_ARM\"";
        break;
    case 1000426000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV\"";
        break;
    case 1000426001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_NV\"";
        break;
    case 1000427000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV\"";
        break;
    case 1000427001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_NV\"";
        break;
    case 1000428000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV\"";
        break;
    case 1000428001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV\"";
        break;
    case 1000428002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_INDIRECT_DEVICE_ADDRESS_INFO_NV\"";
        break;
    case 1000429008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_LINEAR_SWEPT_SPHERES_FEATURES_NV\"";
        break;
    case 1000429009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_LINEAR_SWEPT_SPHERES_DATA_NV\"";
        break;
    case 1000429010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_SPHERES_DATA_NV\"";
        break;
    case 1000430000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV\"";
        break;
    case 1000434000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR\"";
        break;
    case 1000435000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_APPLICATION_PARAMETERS_EXT\"";
        break;
    case 1000437000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT\"";
        break;
    case 1000440000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM\"";
        break;
    case 1000440001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM\"";
        break;
    case 1000440002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM\"";
        break;
    case 1000451000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT\"";
        break;
    case 1000451001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT\"";
        break;
    case 1000453000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT\"";
        break;
    case 1000455000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT\"";
        break;
    case 1000455001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT\"";
        break;
    case 1000458000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT\"";
        break;
    case 1000458001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT\"";
        break;
    case 1000458002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT\"";
        break;
    case 1000458003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT\"";
        break;
    case 1000459000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG\"";
        break;
    case 1000459001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG\"";
        break;
    case 1000462000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT\"";
        break;
    case 1000462001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT\"";
        break;
    case 1000462002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT\"";
        break;
    case 1000462003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SHADER_MODULE_IDENTIFIER_EXT\"";
        break;
    case 1000342000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT\"";
        break;
    case 1000464000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV\"";
        break;
    case 1000464001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV\"";
        break;
    case 1000464002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV\"";
        break;
    case 1000464003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_PROPERTIES_NV\"";
        break;
    case 1000464004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_INFO_NV\"";
        break;
    case 1000464005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_OPTICAL_FLOW_EXECUTE_INFO_NV\"";
        break;
    case 1000464010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV\"";
        break;
    case 1000465000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT\"";
        break;
    case 1000468000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_FEATURES_ANDROID\"";
        break;
    case 1000468001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID\"";
        break;
    case 1000468002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_RESOLVE_PROPERTIES_ANDROID\"";
        break;
    case 1000476000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ANTI_LAG_FEATURES_AMD\"";
        break;
    case 1000476001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ANTI_LAG_DATA_AMD\"";
        break;
    case 1000476002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_ANTI_LAG_PRESENTATION_INFO_AMD\"";
        break;
    case 1000481000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR\"";
        break;
    case 1000482000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT\"";
        break;
    case 1000482001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_PROPERTIES_EXT\"";
        break;
    case 1000482002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SHADER_CREATE_INFO_EXT\"";
        break;
    case 1000483000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_FEATURES_KHR\"";
        break;
    case 1000483001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_BINARY_CREATE_INFO_KHR\"";
        break;
    case 1000483002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_BINARY_INFO_KHR\"";
        break;
    case 1000483003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_BINARY_KEY_KHR\"";
        break;
    case 1000483004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_PROPERTIES_KHR\"";
        break;
    case 1000483005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RELEASE_CAPTURED_PIPELINE_DATA_INFO_KHR\"";
        break;
    case 1000483006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_BINARY_DATA_INFO_KHR\"";
        break;
    case 1000483007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_CREATE_INFO_KHR\"";
        break;
    case 1000483008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DEVICE_PIPELINE_BINARY_INTERNAL_CACHE_CONTROL_KHR\"";
        break;
    case 1000483009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_BINARY_HANDLES_INFO_KHR\"";
        break;
    case 1000484000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM\"";
        break;
    case 1000484001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_TILE_PROPERTIES_QCOM\"";
        break;
    case 1000485000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC\"";
        break;
    case 1000485001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC\"";
        break;
    case 1000488000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM\"";
        break;
    case 1000489000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_SCI_SYNC_POOL_CREATE_INFO_NV\"";
        break;
    case 1000489001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SEMAPHORE_SCI_SYNC_CREATE_INFO_NV\"";
        break;
    case 1000489002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SCI_SYNC_2_FEATURES_NV\"";
        break;
    case 1000490000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV\"";
        break;
    case 1000490001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV\"";
        break;
    case 1000491000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_FEATURES_NV\"";
        break;
    case 1000491001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_PROPERTIES_NV\"";
        break;
    case 1000491002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COOPERATIVE_VECTOR_PROPERTIES_NV\"";
        break;
    case 1000491004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CONVERT_COOPERATIVE_VECTOR_MATRIX_INFO_NV\"";
        break;
    case 1000492000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV\"";
        break;
    case 1000492001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_PROPERTIES_NV\"";
        break;
    case 1000351000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT\"";
        break;
    case 1000351002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT\"";
        break;
    case 1000495000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT\"";
        break;
    case 1000495001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_PROPERTIES_EXT\"";
        break;
    case 1000496000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_LAYER_SETTINGS_CREATE_INFO_EXT\"";
        break;
    case 1000497000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM\"";
        break;
    case 1000497001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM\"";
        break;
    case 1000498000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT\"";
        break;
    case 1000499000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT\"";
        break;
    case 1000505000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_LATENCY_SLEEP_MODE_INFO_NV\"";
        break;
    case 1000505001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_LATENCY_SLEEP_INFO_NV\"";
        break;
    case 1000505002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SET_LATENCY_MARKER_INFO_NV\"";
        break;
    case 1000505003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GET_LATENCY_MARKER_INFO_NV\"";
        break;
    case 1000505004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_LATENCY_TIMINGS_FRAME_REPORT_NV\"";
        break;
    case 1000505005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_LATENCY_SUBMISSION_PRESENT_ID_NV\"";
        break;
    case 1000505006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_OUT_OF_BAND_QUEUE_TYPE_INFO_NV\"";
        break;
    case 1000505007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SWAPCHAIN_LATENCY_CREATE_INFO_NV\"";
        break;
    case 1000505008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_LATENCY_SURFACE_CAPABILITIES_NV\"";
        break;
    case 1000506000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR\"";
        break;
    case 1000506001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_KHR\"";
        break;
    case 1000506002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_KHR\"";
        break;
    case 1000510000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM\"";
        break;
    case 1000510001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM\"";
        break;
    case 1000201000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR\"";
        break;
    case 1000511000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR\"";
        break;
    case 1000512000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_CAPABILITIES_KHR\"";
        break;
    case 1000512001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PICTURE_INFO_KHR\"";
        break;
    case 1000512003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR\"";
        break;
    case 1000512004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR\"";
        break;
    case 1000512005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_DPB_SLOT_INFO_KHR\"";
        break;
    case 1000513000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_CAPABILITIES_KHR\"";
        break;
    case 1000513001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR\"";
        break;
    case 1000513002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PICTURE_INFO_KHR\"";
        break;
    case 1000513003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_DPB_SLOT_INFO_KHR\"";
        break;
    case 1000513004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_AV1_FEATURES_KHR\"";
        break;
    case 1000513005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PROFILE_INFO_KHR\"";
        break;
    case 1000513006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_INFO_KHR\"";
        break;
    case 1000513007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_LAYER_INFO_KHR\"";
        break;
    case 1000513008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUALITY_LEVEL_PROPERTIES_KHR\"";
        break;
    case 1000513009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_CREATE_INFO_KHR\"";
        break;
    case 1000513010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_GOP_REMAINING_FRAME_INFO_KHR\"";
        break;
    case 1000515000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR\"";
        break;
    case 1000515001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_INLINE_QUERY_INFO_KHR\"";
        break;
    case 1000516000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV\"";
        break;
    case 1000518000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM\"";
        break;
    case 1000518001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_PROPERTIES_QCOM\"";
        break;
    case 1000518002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_BLOCK_MATCH_WINDOW_CREATE_INFO_QCOM\"";
        break;
    case 1000519000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_CUBIC_WEIGHTS_CREATE_INFO_QCOM\"";
        break;
    case 1000519001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM\"";
        break;
    case 1000519002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM\"";
        break;
    case 1000520000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM\"";
        break;
    case 1000520001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_YCBCR_DEGAMMA_CREATE_INFO_QCOM\"";
        break;
    case 1000521000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM\"";
        break;
    case 1000524000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT\"";
        break;
    case 1000529000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SCREEN_BUFFER_PROPERTIES_QNX\"";
        break;
    case 1000529001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SCREEN_BUFFER_FORMAT_PROPERTIES_QNX\"";
        break;
    case 1000529002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_SCREEN_BUFFER_INFO_QNX\"";
        break;
    case 1000529003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_QNX\"";
        break;
    case 1000529004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_SCREEN_BUFFER_FEATURES_QNX\"";
        break;
    case 1000530000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_DRIVER_PROPERTIES_MSFT\"";
        break;
    case 1000184000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR\"";
        break;
    case 1000545007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SET_DESCRIPTOR_BUFFER_OFFSETS_INFO_EXT\"";
        break;
    case 1000545008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_BUFFER_EMBEDDED_SAMPLERS_INFO_EXT\"";
        break;
    case 1000546000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV\"";
        break;
    case 1000547000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_MEMORY_HEAP_FEATURES_QCOM\"";
        break;
    case 1000547001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_MEMORY_HEAP_PROPERTIES_QCOM\"";
        break;
    case 1000547002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_TILE_MEMORY_REQUIREMENTS_QCOM\"";
        break;
    case 1000547003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_TILE_MEMORY_BIND_INFO_QCOM\"";
        break;
    case 1000547004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_TILE_MEMORY_SIZE_INFO_QCOM\"";
        break;
    case 1000551000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_SURFACE_STEREO_CREATE_INFO_NV\"";
        break;
    case 1000551001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_DISPLAY_MODE_STEREO_PROPERTIES_NV\"";
        break;
    case 1000553000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_CAPABILITIES_KHR\"";
        break;
    case 1000553001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_FORMAT_QUANTIZATION_MAP_PROPERTIES_KHR\"";
        break;
    case 1000553002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_INFO_KHR\"";
        break;
    case 1000553005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_SESSION_PARAMETERS_CREATE_INFO_KHR\"";
        break;
    case 1000553009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUANTIZATION_MAP_FEATURES_KHR\"";
        break;
    case 1000553003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUANTIZATION_MAP_CAPABILITIES_KHR\"";
        break;
    case 1000553004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUANTIZATION_MAP_CAPABILITIES_KHR\"";
        break;
    case 1000553006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_FORMAT_H265_QUANTIZATION_MAP_PROPERTIES_KHR\"";
        break;
    case 1000553007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUANTIZATION_MAP_CAPABILITIES_KHR\"";
        break;
    case 1000553008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_FORMAT_AV1_QUANTIZATION_MAP_PROPERTIES_KHR\"";
        break;
    case 1000555000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAW_ACCESS_CHAINS_FEATURES_NV\"";
        break;
    case 1000556000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DEVICE_CREATE_INFO_NV\"";
        break;
    case 1000556001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_CREATE_INFO_NV\"";
        break;
    case 1000556002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DATA_PARAMS_NV\"";
        break;
    case 1000556003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_COMPUTE_QUEUE_PROPERTIES_NV\"";
        break;
    case 1000558000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR\"";
        break;
    case 1000559000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMMAND_BUFFER_INHERITANCE_FEATURES_NV\"";
        break;
    case 1000562000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR\"";
        break;
    case 1000562001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR\"";
        break;
    case 1000562002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_LIST_KHR\"";
        break;
    case 1000562003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_KHR\"";
        break;
    case 1000562004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_VULKAN_PROPERTIES_KHR\"";
        break;
    case 1000563000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT16_VECTOR_FEATURES_NV\"";
        break;
    case 1000564000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT\"";
        break;
    case 1000568000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_VALIDATION_FEATURES_NV\"";
        break;
    case 1000569000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_FEATURES_NV\"";
        break;
    case 1000569001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_PROPERTIES_NV\"";
        break;
    case 1000569002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_CLUSTERS_BOTTOM_LEVEL_INPUT_NV\"";
        break;
    case 1000569003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_TRIANGLE_CLUSTER_INPUT_NV\"";
        break;
    case 1000569004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_MOVE_OBJECTS_INPUT_NV\"";
        break;
    case 1000569005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_INPUT_INFO_NV\"";
        break;
    case 1000569006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_COMMANDS_INFO_NV\"";
        break;
    case 1000569007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CLUSTER_ACCELERATION_STRUCTURE_CREATE_INFO_NV\"";
        break;
    case 1000570000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_FEATURES_NV\"";
        break;
    case 1000570001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_PROPERTIES_NV\"";
        break;
    case 1000570002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_PARTITIONED_ACCELERATION_STRUCTURE_NV\"";
        break;
    case 1000570003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCES_INPUT_NV\"";
        break;
    case 1000570004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_BUILD_PARTITIONED_ACCELERATION_STRUCTURE_INFO_NV\"";
        break;
    case 1000570005:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_FLAGS_NV\"";
        break;
    case 1000572000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_EXT\"";
        break;
    case 1000572001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_EXT\"";
        break;
    case 1000572002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_EXT\"";
        break;
    case 1000572003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_CREATE_INFO_EXT\"";
        break;
    case 1000572004:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_EXT\"";
        break;
    case 1000572006:
        settings.stream() << "\"VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_EXT\"";
        break;
    case 1000572007:
        settings.stream() << "\"VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_EXT\"";
        break;
    case 1000572008:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_PIPELINE_EXT\"";
        break;
    case 1000572009:
        settings.stream() << "\"VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_SHADER_EXT\"";
        break;
    case 1000572010:
        settings.stream() << "\"VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_PIPELINE_INFO_EXT\"";
        break;
    case 1000572011:
        settings.stream() << "\"VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_INFO_EXT\"";
        break;
    case 1000572012:
        settings.stream() << "\"VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_LAYOUT_INFO_EXT\"";
        break;
    case 1000572013:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GENERATED_COMMANDS_PIPELINE_INFO_EXT\"";
        break;
    case 1000572014:
        settings.stream() << "\"VK_STRUCTURE_TYPE_GENERATED_COMMANDS_SHADER_INFO_EXT\"";
        break;
    case 1000574000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_8_FEATURES_KHR\"";
        break;
    case 1000574002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_BARRIER_ACCESS_FLAGS_3_KHR\"";
        break;
    case 1000575000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_FEATURES_MESA\"";
        break;
    case 1000575001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_PROPERTIES_MESA\"";
        break;
    case 1000575002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMAGE_ALIGNMENT_CONTROL_CREATE_INFO_MESA\"";
        break;
    case 1000582000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT\"";
        break;
    case 1000582001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLAMP_CONTROL_CREATE_INFO_EXT\"";
        break;
    case 1000586000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_2_FEATURES_KHR\"";
        break;
    case 1000586001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_INLINE_SESSION_PARAMETERS_INFO_KHR\"";
        break;
    case 1000586002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_INLINE_SESSION_PARAMETERS_INFO_KHR\"";
        break;
    case 1000586003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_INLINE_SESSION_PARAMETERS_INFO_KHR\"";
        break;
    case 1000590000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HDR_VIVID_FEATURES_HUAWEI\"";
        break;
    case 1000590001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_HDR_VIVID_DYNAMIC_METADATA_HUAWEI\"";
        break;
    case 1000593000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV\"";
        break;
    case 1000593001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_FLEXIBLE_DIMENSIONS_PROPERTIES_NV\"";
        break;
    case 1000593002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_PROPERTIES_NV\"";
        break;
    case 1000596000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_OPACITY_MICROMAP_FEATURES_ARM\"";
        break;
    case 1000602000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_IMPORT_MEMORY_METAL_HANDLE_INFO_EXT\"";
        break;
    case 1000602001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_METAL_HANDLE_PROPERTIES_EXT\"";
        break;
    case 1000602002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_MEMORY_GET_METAL_HANDLE_INFO_EXT\"";
        break;
    case 1000421000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR\"";
        break;
    case 1000608000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_ROBUSTNESS_FEATURES_EXT\"";
        break;
    case 1000613000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_SET_PRESENT_CONFIG_NV\"";
        break;
    case 1000613001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_METERING_FEATURES_NV\"";
        break;
    case 1000425000:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_EXT\"";
        break;
    case 1000425001:
        settings.stream() << "\"VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_EXT\"";
        break;
    case 1000425002:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_EXT\"";
        break;
    case 1000619003:
        settings.stream() << "\"VK_STRUCTURE_TYPE_RENDERING_END_INFO_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPipelineCacheHeaderVersion(VkPipelineCacheHeaderVersion object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "\"VK_PIPELINE_CACHE_HEADER_VERSION_ONE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkImageLayout(VkImageLayout object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_IMAGE_LAYOUT_UNDEFINED\"";
        break;
    case 1:
        settings.stream() << "\"VK_IMAGE_LAYOUT_GENERAL\"";
        break;
    case 2:
        settings.stream() << "\"VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL\"";
        break;
    case 3:
        settings.stream() << "\"VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL\"";
        break;
    case 4:
        settings.stream() << "\"VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL\"";
        break;
    case 5:
        settings.stream() << "\"VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL\"";
        break;
    case 6:
        settings.stream() << "\"VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL\"";
        break;
    case 7:
        settings.stream() << "\"VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL\"";
        break;
    case 8:
        settings.stream() << "\"VK_IMAGE_LAYOUT_PREINITIALIZED\"";
        break;
    case 1000117000:
        settings.stream() << "\"VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL\"";
        break;
    case 1000117001:
        settings.stream() << "\"VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL\"";
        break;
    case 1000241000:
        settings.stream() << "\"VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL\"";
        break;
    case 1000241001:
        settings.stream() << "\"VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL\"";
        break;
    case 1000241002:
        settings.stream() << "\"VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL\"";
        break;
    case 1000241003:
        settings.stream() << "\"VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL\"";
        break;
    case 1000314000:
        settings.stream() << "\"VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL\"";
        break;
    case 1000314001:
        settings.stream() << "\"VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL\"";
        break;
    case 1000232000:
        settings.stream() << "\"VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ\"";
        break;
    case 1000001002:
        settings.stream() << "\"VK_IMAGE_LAYOUT_PRESENT_SRC_KHR\"";
        break;
    case 1000024000:
        settings.stream() << "\"VK_IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR\"";
        break;
    case 1000024001:
        settings.stream() << "\"VK_IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR\"";
        break;
    case 1000024002:
        settings.stream() << "\"VK_IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR\"";
        break;
    case 1000111000:
        settings.stream() << "\"VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR\"";
        break;
    case 1000218000:
        settings.stream() << "\"VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT\"";
        break;
    case 1000164003:
        settings.stream() << "\"VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR\"";
        break;
    case 1000299000:
        settings.stream() << "\"VK_IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR\"";
        break;
    case 1000299001:
        settings.stream() << "\"VK_IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR\"";
        break;
    case 1000299002:
        settings.stream() << "\"VK_IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR\"";
        break;
    case 1000339000:
        settings.stream() << "\"VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT\"";
        break;
    case 1000553000:
        settings.stream() << "\"VK_IMAGE_LAYOUT_VIDEO_ENCODE_QUANTIZATION_MAP_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkObjectType(VkObjectType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_OBJECT_TYPE_UNKNOWN\"";
        break;
    case 1:
        settings.stream() << "\"VK_OBJECT_TYPE_INSTANCE\"";
        break;
    case 2:
        settings.stream() << "\"VK_OBJECT_TYPE_PHYSICAL_DEVICE\"";
        break;
    case 3:
        settings.stream() << "\"VK_OBJECT_TYPE_DEVICE\"";
        break;
    case 4:
        settings.stream() << "\"VK_OBJECT_TYPE_QUEUE\"";
        break;
    case 5:
        settings.stream() << "\"VK_OBJECT_TYPE_SEMAPHORE\"";
        break;
    case 6:
        settings.stream() << "\"VK_OBJECT_TYPE_COMMAND_BUFFER\"";
        break;
    case 7:
        settings.stream() << "\"VK_OBJECT_TYPE_FENCE\"";
        break;
    case 8:
        settings.stream() << "\"VK_OBJECT_TYPE_DEVICE_MEMORY\"";
        break;
    case 9:
        settings.stream() << "\"VK_OBJECT_TYPE_BUFFER\"";
        break;
    case 10:
        settings.stream() << "\"VK_OBJECT_TYPE_IMAGE\"";
        break;
    case 11:
        settings.stream() << "\"VK_OBJECT_TYPE_EVENT\"";
        break;
    case 12:
        settings.stream() << "\"VK_OBJECT_TYPE_QUERY_POOL\"";
        break;
    case 13:
        settings.stream() << "\"VK_OBJECT_TYPE_BUFFER_VIEW\"";
        break;
    case 14:
        settings.stream() << "\"VK_OBJECT_TYPE_IMAGE_VIEW\"";
        break;
    case 15:
        settings.stream() << "\"VK_OBJECT_TYPE_SHADER_MODULE\"";
        break;
    case 16:
        settings.stream() << "\"VK_OBJECT_TYPE_PIPELINE_CACHE\"";
        break;
    case 17:
        settings.stream() << "\"VK_OBJECT_TYPE_PIPELINE_LAYOUT\"";
        break;
    case 18:
        settings.stream() << "\"VK_OBJECT_TYPE_RENDER_PASS\"";
        break;
    case 19:
        settings.stream() << "\"VK_OBJECT_TYPE_PIPELINE\"";
        break;
    case 20:
        settings.stream() << "\"VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT\"";
        break;
    case 21:
        settings.stream() << "\"VK_OBJECT_TYPE_SAMPLER\"";
        break;
    case 22:
        settings.stream() << "\"VK_OBJECT_TYPE_DESCRIPTOR_POOL\"";
        break;
    case 23:
        settings.stream() << "\"VK_OBJECT_TYPE_DESCRIPTOR_SET\"";
        break;
    case 24:
        settings.stream() << "\"VK_OBJECT_TYPE_FRAMEBUFFER\"";
        break;
    case 25:
        settings.stream() << "\"VK_OBJECT_TYPE_COMMAND_POOL\"";
        break;
    case 1000156000:
        settings.stream() << "\"VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION\"";
        break;
    case 1000085000:
        settings.stream() << "\"VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE\"";
        break;
    case 1000295000:
        settings.stream() << "\"VK_OBJECT_TYPE_PRIVATE_DATA_SLOT\"";
        break;
    case 1000000000:
        settings.stream() << "\"VK_OBJECT_TYPE_SURFACE_KHR\"";
        break;
    case 1000001000:
        settings.stream() << "\"VK_OBJECT_TYPE_SWAPCHAIN_KHR\"";
        break;
    case 1000002000:
        settings.stream() << "\"VK_OBJECT_TYPE_DISPLAY_KHR\"";
        break;
    case 1000002001:
        settings.stream() << "\"VK_OBJECT_TYPE_DISPLAY_MODE_KHR\"";
        break;
    case 1000011000:
        settings.stream() << "\"VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT\"";
        break;
    case 1000023000:
        settings.stream() << "\"VK_OBJECT_TYPE_VIDEO_SESSION_KHR\"";
        break;
    case 1000023001:
        settings.stream() << "\"VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR\"";
        break;
    case 1000029000:
        settings.stream() << "\"VK_OBJECT_TYPE_CU_MODULE_NVX\"";
        break;
    case 1000029001:
        settings.stream() << "\"VK_OBJECT_TYPE_CU_FUNCTION_NVX\"";
        break;
    case 1000128000:
        settings.stream() << "\"VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT\"";
        break;
    case 1000150000:
        settings.stream() << "\"VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR\"";
        break;
    case 1000160000:
        settings.stream() << "\"VK_OBJECT_TYPE_VALIDATION_CACHE_EXT\"";
        break;
    case 1000165000:
        settings.stream() << "\"VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV\"";
        break;
    case 1000210000:
        settings.stream() << "\"VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL\"";
        break;
    case 1000268000:
        settings.stream() << "\"VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR\"";
        break;
    case 1000277000:
        settings.stream() << "\"VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV\"";
        break;
    case 1000307000:
        settings.stream() << "\"VK_OBJECT_TYPE_CUDA_MODULE_NV\"";
        break;
    case 1000307001:
        settings.stream() << "\"VK_OBJECT_TYPE_CUDA_FUNCTION_NV\"";
        break;
    case 1000366000:
        settings.stream() << "\"VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA\"";
        break;
    case 1000396000:
        settings.stream() << "\"VK_OBJECT_TYPE_MICROMAP_EXT\"";
        break;
    case 1000464000:
        settings.stream() << "\"VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV\"";
        break;
    case 1000482000:
        settings.stream() << "\"VK_OBJECT_TYPE_SHADER_EXT\"";
        break;
    case 1000483000:
        settings.stream() << "\"VK_OBJECT_TYPE_PIPELINE_BINARY_KHR\"";
        break;
    case 1000489000:
        settings.stream() << "\"VK_OBJECT_TYPE_SEMAPHORE_SCI_SYNC_POOL_NV\"";
        break;
    case 1000556000:
        settings.stream() << "\"VK_OBJECT_TYPE_EXTERNAL_COMPUTE_QUEUE_NV\"";
        break;
    case 1000572000:
        settings.stream() << "\"VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_EXT\"";
        break;
    case 1000572001:
        settings.stream() << "\"VK_OBJECT_TYPE_INDIRECT_EXECUTION_SET_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkVendorId(VkVendorId object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0x10000:
        settings.stream() << "\"VK_VENDOR_ID_KHRONOS\"";
        break;
    case 0x10001:
        settings.stream() << "\"VK_VENDOR_ID_VIV\"";
        break;
    case 0x10002:
        settings.stream() << "\"VK_VENDOR_ID_VSI\"";
        break;
    case 0x10003:
        settings.stream() << "\"VK_VENDOR_ID_KAZAN\"";
        break;
    case 0x10004:
        settings.stream() << "\"VK_VENDOR_ID_CODEPLAY\"";
        break;
    case 0x10005:
        settings.stream() << "\"VK_VENDOR_ID_MESA\"";
        break;
    case 0x10006:
        settings.stream() << "\"VK_VENDOR_ID_POCL\"";
        break;
    case 0x10007:
        settings.stream() << "\"VK_VENDOR_ID_MOBILEYE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkSystemAllocationScope(VkSystemAllocationScope object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SYSTEM_ALLOCATION_SCOPE_COMMAND\"";
        break;
    case 1:
        settings.stream() << "\"VK_SYSTEM_ALLOCATION_SCOPE_OBJECT\"";
        break;
    case 2:
        settings.stream() << "\"VK_SYSTEM_ALLOCATION_SCOPE_CACHE\"";
        break;
    case 3:
        settings.stream() << "\"VK_SYSTEM_ALLOCATION_SCOPE_DEVICE\"";
        break;
    case 4:
        settings.stream() << "\"VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkInternalAllocationType(VkInternalAllocationType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkFormat(VkFormat object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_FORMAT_UNDEFINED\"";
        break;
    case 1:
        settings.stream() << "\"VK_FORMAT_R4G4_UNORM_PACK8\"";
        break;
    case 2:
        settings.stream() << "\"VK_FORMAT_R4G4B4A4_UNORM_PACK16\"";
        break;
    case 3:
        settings.stream() << "\"VK_FORMAT_B4G4R4A4_UNORM_PACK16\"";
        break;
    case 4:
        settings.stream() << "\"VK_FORMAT_R5G6B5_UNORM_PACK16\"";
        break;
    case 5:
        settings.stream() << "\"VK_FORMAT_B5G6R5_UNORM_PACK16\"";
        break;
    case 6:
        settings.stream() << "\"VK_FORMAT_R5G5B5A1_UNORM_PACK16\"";
        break;
    case 7:
        settings.stream() << "\"VK_FORMAT_B5G5R5A1_UNORM_PACK16\"";
        break;
    case 8:
        settings.stream() << "\"VK_FORMAT_A1R5G5B5_UNORM_PACK16\"";
        break;
    case 9:
        settings.stream() << "\"VK_FORMAT_R8_UNORM\"";
        break;
    case 10:
        settings.stream() << "\"VK_FORMAT_R8_SNORM\"";
        break;
    case 11:
        settings.stream() << "\"VK_FORMAT_R8_USCALED\"";
        break;
    case 12:
        settings.stream() << "\"VK_FORMAT_R8_SSCALED\"";
        break;
    case 13:
        settings.stream() << "\"VK_FORMAT_R8_UINT\"";
        break;
    case 14:
        settings.stream() << "\"VK_FORMAT_R8_SINT\"";
        break;
    case 15:
        settings.stream() << "\"VK_FORMAT_R8_SRGB\"";
        break;
    case 16:
        settings.stream() << "\"VK_FORMAT_R8G8_UNORM\"";
        break;
    case 17:
        settings.stream() << "\"VK_FORMAT_R8G8_SNORM\"";
        break;
    case 18:
        settings.stream() << "\"VK_FORMAT_R8G8_USCALED\"";
        break;
    case 19:
        settings.stream() << "\"VK_FORMAT_R8G8_SSCALED\"";
        break;
    case 20:
        settings.stream() << "\"VK_FORMAT_R8G8_UINT\"";
        break;
    case 21:
        settings.stream() << "\"VK_FORMAT_R8G8_SINT\"";
        break;
    case 22:
        settings.stream() << "\"VK_FORMAT_R8G8_SRGB\"";
        break;
    case 23:
        settings.stream() << "\"VK_FORMAT_R8G8B8_UNORM\"";
        break;
    case 24:
        settings.stream() << "\"VK_FORMAT_R8G8B8_SNORM\"";
        break;
    case 25:
        settings.stream() << "\"VK_FORMAT_R8G8B8_USCALED\"";
        break;
    case 26:
        settings.stream() << "\"VK_FORMAT_R8G8B8_SSCALED\"";
        break;
    case 27:
        settings.stream() << "\"VK_FORMAT_R8G8B8_UINT\"";
        break;
    case 28:
        settings.stream() << "\"VK_FORMAT_R8G8B8_SINT\"";
        break;
    case 29:
        settings.stream() << "\"VK_FORMAT_R8G8B8_SRGB\"";
        break;
    case 30:
        settings.stream() << "\"VK_FORMAT_B8G8R8_UNORM\"";
        break;
    case 31:
        settings.stream() << "\"VK_FORMAT_B8G8R8_SNORM\"";
        break;
    case 32:
        settings.stream() << "\"VK_FORMAT_B8G8R8_USCALED\"";
        break;
    case 33:
        settings.stream() << "\"VK_FORMAT_B8G8R8_SSCALED\"";
        break;
    case 34:
        settings.stream() << "\"VK_FORMAT_B8G8R8_UINT\"";
        break;
    case 35:
        settings.stream() << "\"VK_FORMAT_B8G8R8_SINT\"";
        break;
    case 36:
        settings.stream() << "\"VK_FORMAT_B8G8R8_SRGB\"";
        break;
    case 37:
        settings.stream() << "\"VK_FORMAT_R8G8B8A8_UNORM\"";
        break;
    case 38:
        settings.stream() << "\"VK_FORMAT_R8G8B8A8_SNORM\"";
        break;
    case 39:
        settings.stream() << "\"VK_FORMAT_R8G8B8A8_USCALED\"";
        break;
    case 40:
        settings.stream() << "\"VK_FORMAT_R8G8B8A8_SSCALED\"";
        break;
    case 41:
        settings.stream() << "\"VK_FORMAT_R8G8B8A8_UINT\"";
        break;
    case 42:
        settings.stream() << "\"VK_FORMAT_R8G8B8A8_SINT\"";
        break;
    case 43:
        settings.stream() << "\"VK_FORMAT_R8G8B8A8_SRGB\"";
        break;
    case 44:
        settings.stream() << "\"VK_FORMAT_B8G8R8A8_UNORM\"";
        break;
    case 45:
        settings.stream() << "\"VK_FORMAT_B8G8R8A8_SNORM\"";
        break;
    case 46:
        settings.stream() << "\"VK_FORMAT_B8G8R8A8_USCALED\"";
        break;
    case 47:
        settings.stream() << "\"VK_FORMAT_B8G8R8A8_SSCALED\"";
        break;
    case 48:
        settings.stream() << "\"VK_FORMAT_B8G8R8A8_UINT\"";
        break;
    case 49:
        settings.stream() << "\"VK_FORMAT_B8G8R8A8_SINT\"";
        break;
    case 50:
        settings.stream() << "\"VK_FORMAT_B8G8R8A8_SRGB\"";
        break;
    case 51:
        settings.stream() << "\"VK_FORMAT_A8B8G8R8_UNORM_PACK32\"";
        break;
    case 52:
        settings.stream() << "\"VK_FORMAT_A8B8G8R8_SNORM_PACK32\"";
        break;
    case 53:
        settings.stream() << "\"VK_FORMAT_A8B8G8R8_USCALED_PACK32\"";
        break;
    case 54:
        settings.stream() << "\"VK_FORMAT_A8B8G8R8_SSCALED_PACK32\"";
        break;
    case 55:
        settings.stream() << "\"VK_FORMAT_A8B8G8R8_UINT_PACK32\"";
        break;
    case 56:
        settings.stream() << "\"VK_FORMAT_A8B8G8R8_SINT_PACK32\"";
        break;
    case 57:
        settings.stream() << "\"VK_FORMAT_A8B8G8R8_SRGB_PACK32\"";
        break;
    case 58:
        settings.stream() << "\"VK_FORMAT_A2R10G10B10_UNORM_PACK32\"";
        break;
    case 59:
        settings.stream() << "\"VK_FORMAT_A2R10G10B10_SNORM_PACK32\"";
        break;
    case 60:
        settings.stream() << "\"VK_FORMAT_A2R10G10B10_USCALED_PACK32\"";
        break;
    case 61:
        settings.stream() << "\"VK_FORMAT_A2R10G10B10_SSCALED_PACK32\"";
        break;
    case 62:
        settings.stream() << "\"VK_FORMAT_A2R10G10B10_UINT_PACK32\"";
        break;
    case 63:
        settings.stream() << "\"VK_FORMAT_A2R10G10B10_SINT_PACK32\"";
        break;
    case 64:
        settings.stream() << "\"VK_FORMAT_A2B10G10R10_UNORM_PACK32\"";
        break;
    case 65:
        settings.stream() << "\"VK_FORMAT_A2B10G10R10_SNORM_PACK32\"";
        break;
    case 66:
        settings.stream() << "\"VK_FORMAT_A2B10G10R10_USCALED_PACK32\"";
        break;
    case 67:
        settings.stream() << "\"VK_FORMAT_A2B10G10R10_SSCALED_PACK32\"";
        break;
    case 68:
        settings.stream() << "\"VK_FORMAT_A2B10G10R10_UINT_PACK32\"";
        break;
    case 69:
        settings.stream() << "\"VK_FORMAT_A2B10G10R10_SINT_PACK32\"";
        break;
    case 70:
        settings.stream() << "\"VK_FORMAT_R16_UNORM\"";
        break;
    case 71:
        settings.stream() << "\"VK_FORMAT_R16_SNORM\"";
        break;
    case 72:
        settings.stream() << "\"VK_FORMAT_R16_USCALED\"";
        break;
    case 73:
        settings.stream() << "\"VK_FORMAT_R16_SSCALED\"";
        break;
    case 74:
        settings.stream() << "\"VK_FORMAT_R16_UINT\"";
        break;
    case 75:
        settings.stream() << "\"VK_FORMAT_R16_SINT\"";
        break;
    case 76:
        settings.stream() << "\"VK_FORMAT_R16_SFLOAT\"";
        break;
    case 77:
        settings.stream() << "\"VK_FORMAT_R16G16_UNORM\"";
        break;
    case 78:
        settings.stream() << "\"VK_FORMAT_R16G16_SNORM\"";
        break;
    case 79:
        settings.stream() << "\"VK_FORMAT_R16G16_USCALED\"";
        break;
    case 80:
        settings.stream() << "\"VK_FORMAT_R16G16_SSCALED\"";
        break;
    case 81:
        settings.stream() << "\"VK_FORMAT_R16G16_UINT\"";
        break;
    case 82:
        settings.stream() << "\"VK_FORMAT_R16G16_SINT\"";
        break;
    case 83:
        settings.stream() << "\"VK_FORMAT_R16G16_SFLOAT\"";
        break;
    case 84:
        settings.stream() << "\"VK_FORMAT_R16G16B16_UNORM\"";
        break;
    case 85:
        settings.stream() << "\"VK_FORMAT_R16G16B16_SNORM\"";
        break;
    case 86:
        settings.stream() << "\"VK_FORMAT_R16G16B16_USCALED\"";
        break;
    case 87:
        settings.stream() << "\"VK_FORMAT_R16G16B16_SSCALED\"";
        break;
    case 88:
        settings.stream() << "\"VK_FORMAT_R16G16B16_UINT\"";
        break;
    case 89:
        settings.stream() << "\"VK_FORMAT_R16G16B16_SINT\"";
        break;
    case 90:
        settings.stream() << "\"VK_FORMAT_R16G16B16_SFLOAT\"";
        break;
    case 91:
        settings.stream() << "\"VK_FORMAT_R16G16B16A16_UNORM\"";
        break;
    case 92:
        settings.stream() << "\"VK_FORMAT_R16G16B16A16_SNORM\"";
        break;
    case 93:
        settings.stream() << "\"VK_FORMAT_R16G16B16A16_USCALED\"";
        break;
    case 94:
        settings.stream() << "\"VK_FORMAT_R16G16B16A16_SSCALED\"";
        break;
    case 95:
        settings.stream() << "\"VK_FORMAT_R16G16B16A16_UINT\"";
        break;
    case 96:
        settings.stream() << "\"VK_FORMAT_R16G16B16A16_SINT\"";
        break;
    case 97:
        settings.stream() << "\"VK_FORMAT_R16G16B16A16_SFLOAT\"";
        break;
    case 98:
        settings.stream() << "\"VK_FORMAT_R32_UINT\"";
        break;
    case 99:
        settings.stream() << "\"VK_FORMAT_R32_SINT\"";
        break;
    case 100:
        settings.stream() << "\"VK_FORMAT_R32_SFLOAT\"";
        break;
    case 101:
        settings.stream() << "\"VK_FORMAT_R32G32_UINT\"";
        break;
    case 102:
        settings.stream() << "\"VK_FORMAT_R32G32_SINT\"";
        break;
    case 103:
        settings.stream() << "\"VK_FORMAT_R32G32_SFLOAT\"";
        break;
    case 104:
        settings.stream() << "\"VK_FORMAT_R32G32B32_UINT\"";
        break;
    case 105:
        settings.stream() << "\"VK_FORMAT_R32G32B32_SINT\"";
        break;
    case 106:
        settings.stream() << "\"VK_FORMAT_R32G32B32_SFLOAT\"";
        break;
    case 107:
        settings.stream() << "\"VK_FORMAT_R32G32B32A32_UINT\"";
        break;
    case 108:
        settings.stream() << "\"VK_FORMAT_R32G32B32A32_SINT\"";
        break;
    case 109:
        settings.stream() << "\"VK_FORMAT_R32G32B32A32_SFLOAT\"";
        break;
    case 110:
        settings.stream() << "\"VK_FORMAT_R64_UINT\"";
        break;
    case 111:
        settings.stream() << "\"VK_FORMAT_R64_SINT\"";
        break;
    case 112:
        settings.stream() << "\"VK_FORMAT_R64_SFLOAT\"";
        break;
    case 113:
        settings.stream() << "\"VK_FORMAT_R64G64_UINT\"";
        break;
    case 114:
        settings.stream() << "\"VK_FORMAT_R64G64_SINT\"";
        break;
    case 115:
        settings.stream() << "\"VK_FORMAT_R64G64_SFLOAT\"";
        break;
    case 116:
        settings.stream() << "\"VK_FORMAT_R64G64B64_UINT\"";
        break;
    case 117:
        settings.stream() << "\"VK_FORMAT_R64G64B64_SINT\"";
        break;
    case 118:
        settings.stream() << "\"VK_FORMAT_R64G64B64_SFLOAT\"";
        break;
    case 119:
        settings.stream() << "\"VK_FORMAT_R64G64B64A64_UINT\"";
        break;
    case 120:
        settings.stream() << "\"VK_FORMAT_R64G64B64A64_SINT\"";
        break;
    case 121:
        settings.stream() << "\"VK_FORMAT_R64G64B64A64_SFLOAT\"";
        break;
    case 122:
        settings.stream() << "\"VK_FORMAT_B10G11R11_UFLOAT_PACK32\"";
        break;
    case 123:
        settings.stream() << "\"VK_FORMAT_E5B9G9R9_UFLOAT_PACK32\"";
        break;
    case 124:
        settings.stream() << "\"VK_FORMAT_D16_UNORM\"";
        break;
    case 125:
        settings.stream() << "\"VK_FORMAT_X8_D24_UNORM_PACK32\"";
        break;
    case 126:
        settings.stream() << "\"VK_FORMAT_D32_SFLOAT\"";
        break;
    case 127:
        settings.stream() << "\"VK_FORMAT_S8_UINT\"";
        break;
    case 128:
        settings.stream() << "\"VK_FORMAT_D16_UNORM_S8_UINT\"";
        break;
    case 129:
        settings.stream() << "\"VK_FORMAT_D24_UNORM_S8_UINT\"";
        break;
    case 130:
        settings.stream() << "\"VK_FORMAT_D32_SFLOAT_S8_UINT\"";
        break;
    case 131:
        settings.stream() << "\"VK_FORMAT_BC1_RGB_UNORM_BLOCK\"";
        break;
    case 132:
        settings.stream() << "\"VK_FORMAT_BC1_RGB_SRGB_BLOCK\"";
        break;
    case 133:
        settings.stream() << "\"VK_FORMAT_BC1_RGBA_UNORM_BLOCK\"";
        break;
    case 134:
        settings.stream() << "\"VK_FORMAT_BC1_RGBA_SRGB_BLOCK\"";
        break;
    case 135:
        settings.stream() << "\"VK_FORMAT_BC2_UNORM_BLOCK\"";
        break;
    case 136:
        settings.stream() << "\"VK_FORMAT_BC2_SRGB_BLOCK\"";
        break;
    case 137:
        settings.stream() << "\"VK_FORMAT_BC3_UNORM_BLOCK\"";
        break;
    case 138:
        settings.stream() << "\"VK_FORMAT_BC3_SRGB_BLOCK\"";
        break;
    case 139:
        settings.stream() << "\"VK_FORMAT_BC4_UNORM_BLOCK\"";
        break;
    case 140:
        settings.stream() << "\"VK_FORMAT_BC4_SNORM_BLOCK\"";
        break;
    case 141:
        settings.stream() << "\"VK_FORMAT_BC5_UNORM_BLOCK\"";
        break;
    case 142:
        settings.stream() << "\"VK_FORMAT_BC5_SNORM_BLOCK\"";
        break;
    case 143:
        settings.stream() << "\"VK_FORMAT_BC6H_UFLOAT_BLOCK\"";
        break;
    case 144:
        settings.stream() << "\"VK_FORMAT_BC6H_SFLOAT_BLOCK\"";
        break;
    case 145:
        settings.stream() << "\"VK_FORMAT_BC7_UNORM_BLOCK\"";
        break;
    case 146:
        settings.stream() << "\"VK_FORMAT_BC7_SRGB_BLOCK\"";
        break;
    case 147:
        settings.stream() << "\"VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK\"";
        break;
    case 148:
        settings.stream() << "\"VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK\"";
        break;
    case 149:
        settings.stream() << "\"VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK\"";
        break;
    case 150:
        settings.stream() << "\"VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK\"";
        break;
    case 151:
        settings.stream() << "\"VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK\"";
        break;
    case 152:
        settings.stream() << "\"VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK\"";
        break;
    case 153:
        settings.stream() << "\"VK_FORMAT_EAC_R11_UNORM_BLOCK\"";
        break;
    case 154:
        settings.stream() << "\"VK_FORMAT_EAC_R11_SNORM_BLOCK\"";
        break;
    case 155:
        settings.stream() << "\"VK_FORMAT_EAC_R11G11_UNORM_BLOCK\"";
        break;
    case 156:
        settings.stream() << "\"VK_FORMAT_EAC_R11G11_SNORM_BLOCK\"";
        break;
    case 157:
        settings.stream() << "\"VK_FORMAT_ASTC_4x4_UNORM_BLOCK\"";
        break;
    case 158:
        settings.stream() << "\"VK_FORMAT_ASTC_4x4_SRGB_BLOCK\"";
        break;
    case 159:
        settings.stream() << "\"VK_FORMAT_ASTC_5x4_UNORM_BLOCK\"";
        break;
    case 160:
        settings.stream() << "\"VK_FORMAT_ASTC_5x4_SRGB_BLOCK\"";
        break;
    case 161:
        settings.stream() << "\"VK_FORMAT_ASTC_5x5_UNORM_BLOCK\"";
        break;
    case 162:
        settings.stream() << "\"VK_FORMAT_ASTC_5x5_SRGB_BLOCK\"";
        break;
    case 163:
        settings.stream() << "\"VK_FORMAT_ASTC_6x5_UNORM_BLOCK\"";
        break;
    case 164:
        settings.stream() << "\"VK_FORMAT_ASTC_6x5_SRGB_BLOCK\"";
        break;
    case 165:
        settings.stream() << "\"VK_FORMAT_ASTC_6x6_UNORM_BLOCK\"";
        break;
    case 166:
        settings.stream() << "\"VK_FORMAT_ASTC_6x6_SRGB_BLOCK\"";
        break;
    case 167:
        settings.stream() << "\"VK_FORMAT_ASTC_8x5_UNORM_BLOCK\"";
        break;
    case 168:
        settings.stream() << "\"VK_FORMAT_ASTC_8x5_SRGB_BLOCK\"";
        break;
    case 169:
        settings.stream() << "\"VK_FORMAT_ASTC_8x6_UNORM_BLOCK\"";
        break;
    case 170:
        settings.stream() << "\"VK_FORMAT_ASTC_8x6_SRGB_BLOCK\"";
        break;
    case 171:
        settings.stream() << "\"VK_FORMAT_ASTC_8x8_UNORM_BLOCK\"";
        break;
    case 172:
        settings.stream() << "\"VK_FORMAT_ASTC_8x8_SRGB_BLOCK\"";
        break;
    case 173:
        settings.stream() << "\"VK_FORMAT_ASTC_10x5_UNORM_BLOCK\"";
        break;
    case 174:
        settings.stream() << "\"VK_FORMAT_ASTC_10x5_SRGB_BLOCK\"";
        break;
    case 175:
        settings.stream() << "\"VK_FORMAT_ASTC_10x6_UNORM_BLOCK\"";
        break;
    case 176:
        settings.stream() << "\"VK_FORMAT_ASTC_10x6_SRGB_BLOCK\"";
        break;
    case 177:
        settings.stream() << "\"VK_FORMAT_ASTC_10x8_UNORM_BLOCK\"";
        break;
    case 178:
        settings.stream() << "\"VK_FORMAT_ASTC_10x8_SRGB_BLOCK\"";
        break;
    case 179:
        settings.stream() << "\"VK_FORMAT_ASTC_10x10_UNORM_BLOCK\"";
        break;
    case 180:
        settings.stream() << "\"VK_FORMAT_ASTC_10x10_SRGB_BLOCK\"";
        break;
    case 181:
        settings.stream() << "\"VK_FORMAT_ASTC_12x10_UNORM_BLOCK\"";
        break;
    case 182:
        settings.stream() << "\"VK_FORMAT_ASTC_12x10_SRGB_BLOCK\"";
        break;
    case 183:
        settings.stream() << "\"VK_FORMAT_ASTC_12x12_UNORM_BLOCK\"";
        break;
    case 184:
        settings.stream() << "\"VK_FORMAT_ASTC_12x12_SRGB_BLOCK\"";
        break;
    case 1000156000:
        settings.stream() << "\"VK_FORMAT_G8B8G8R8_422_UNORM\"";
        break;
    case 1000156001:
        settings.stream() << "\"VK_FORMAT_B8G8R8G8_422_UNORM\"";
        break;
    case 1000156002:
        settings.stream() << "\"VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM\"";
        break;
    case 1000156003:
        settings.stream() << "\"VK_FORMAT_G8_B8R8_2PLANE_420_UNORM\"";
        break;
    case 1000156004:
        settings.stream() << "\"VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM\"";
        break;
    case 1000156005:
        settings.stream() << "\"VK_FORMAT_G8_B8R8_2PLANE_422_UNORM\"";
        break;
    case 1000156006:
        settings.stream() << "\"VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM\"";
        break;
    case 1000156007:
        settings.stream() << "\"VK_FORMAT_R10X6_UNORM_PACK16\"";
        break;
    case 1000156008:
        settings.stream() << "\"VK_FORMAT_R10X6G10X6_UNORM_2PACK16\"";
        break;
    case 1000156009:
        settings.stream() << "\"VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16\"";
        break;
    case 1000156010:
        settings.stream() << "\"VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16\"";
        break;
    case 1000156011:
        settings.stream() << "\"VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16\"";
        break;
    case 1000156012:
        settings.stream() << "\"VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16\"";
        break;
    case 1000156013:
        settings.stream() << "\"VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16\"";
        break;
    case 1000156014:
        settings.stream() << "\"VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16\"";
        break;
    case 1000156015:
        settings.stream() << "\"VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16\"";
        break;
    case 1000156016:
        settings.stream() << "\"VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16\"";
        break;
    case 1000156017:
        settings.stream() << "\"VK_FORMAT_R12X4_UNORM_PACK16\"";
        break;
    case 1000156018:
        settings.stream() << "\"VK_FORMAT_R12X4G12X4_UNORM_2PACK16\"";
        break;
    case 1000156019:
        settings.stream() << "\"VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16\"";
        break;
    case 1000156020:
        settings.stream() << "\"VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16\"";
        break;
    case 1000156021:
        settings.stream() << "\"VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16\"";
        break;
    case 1000156022:
        settings.stream() << "\"VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16\"";
        break;
    case 1000156023:
        settings.stream() << "\"VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16\"";
        break;
    case 1000156024:
        settings.stream() << "\"VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16\"";
        break;
    case 1000156025:
        settings.stream() << "\"VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16\"";
        break;
    case 1000156026:
        settings.stream() << "\"VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16\"";
        break;
    case 1000156027:
        settings.stream() << "\"VK_FORMAT_G16B16G16R16_422_UNORM\"";
        break;
    case 1000156028:
        settings.stream() << "\"VK_FORMAT_B16G16R16G16_422_UNORM\"";
        break;
    case 1000156029:
        settings.stream() << "\"VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM\"";
        break;
    case 1000156030:
        settings.stream() << "\"VK_FORMAT_G16_B16R16_2PLANE_420_UNORM\"";
        break;
    case 1000156031:
        settings.stream() << "\"VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM\"";
        break;
    case 1000156032:
        settings.stream() << "\"VK_FORMAT_G16_B16R16_2PLANE_422_UNORM\"";
        break;
    case 1000156033:
        settings.stream() << "\"VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM\"";
        break;
    case 1000330000:
        settings.stream() << "\"VK_FORMAT_G8_B8R8_2PLANE_444_UNORM\"";
        break;
    case 1000330001:
        settings.stream() << "\"VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16\"";
        break;
    case 1000330002:
        settings.stream() << "\"VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16\"";
        break;
    case 1000330003:
        settings.stream() << "\"VK_FORMAT_G16_B16R16_2PLANE_444_UNORM\"";
        break;
    case 1000340000:
        settings.stream() << "\"VK_FORMAT_A4R4G4B4_UNORM_PACK16\"";
        break;
    case 1000340001:
        settings.stream() << "\"VK_FORMAT_A4B4G4R4_UNORM_PACK16\"";
        break;
    case 1000066000:
        settings.stream() << "\"VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK\"";
        break;
    case 1000066001:
        settings.stream() << "\"VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK\"";
        break;
    case 1000066002:
        settings.stream() << "\"VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK\"";
        break;
    case 1000066003:
        settings.stream() << "\"VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK\"";
        break;
    case 1000066004:
        settings.stream() << "\"VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK\"";
        break;
    case 1000066005:
        settings.stream() << "\"VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK\"";
        break;
    case 1000066006:
        settings.stream() << "\"VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK\"";
        break;
    case 1000066007:
        settings.stream() << "\"VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK\"";
        break;
    case 1000066008:
        settings.stream() << "\"VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK\"";
        break;
    case 1000066009:
        settings.stream() << "\"VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK\"";
        break;
    case 1000066010:
        settings.stream() << "\"VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK\"";
        break;
    case 1000066011:
        settings.stream() << "\"VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK\"";
        break;
    case 1000066012:
        settings.stream() << "\"VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK\"";
        break;
    case 1000066013:
        settings.stream() << "\"VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK\"";
        break;
    case 1000470000:
        settings.stream() << "\"VK_FORMAT_A1B5G5R5_UNORM_PACK16\"";
        break;
    case 1000470001:
        settings.stream() << "\"VK_FORMAT_A8_UNORM\"";
        break;
    case 1000054000:
        settings.stream() << "\"VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG\"";
        break;
    case 1000054001:
        settings.stream() << "\"VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG\"";
        break;
    case 1000054002:
        settings.stream() << "\"VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG\"";
        break;
    case 1000054003:
        settings.stream() << "\"VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG\"";
        break;
    case 1000054004:
        settings.stream() << "\"VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG\"";
        break;
    case 1000054005:
        settings.stream() << "\"VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG\"";
        break;
    case 1000054006:
        settings.stream() << "\"VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG\"";
        break;
    case 1000054007:
        settings.stream() << "\"VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG\"";
        break;
    case 1000288000:
        settings.stream() << "\"VK_FORMAT_ASTC_3x3x3_UNORM_BLOCK_EXT\"";
        break;
    case 1000288001:
        settings.stream() << "\"VK_FORMAT_ASTC_3x3x3_SRGB_BLOCK_EXT\"";
        break;
    case 1000288002:
        settings.stream() << "\"VK_FORMAT_ASTC_3x3x3_SFLOAT_BLOCK_EXT\"";
        break;
    case 1000288003:
        settings.stream() << "\"VK_FORMAT_ASTC_4x3x3_UNORM_BLOCK_EXT\"";
        break;
    case 1000288004:
        settings.stream() << "\"VK_FORMAT_ASTC_4x3x3_SRGB_BLOCK_EXT\"";
        break;
    case 1000288005:
        settings.stream() << "\"VK_FORMAT_ASTC_4x3x3_SFLOAT_BLOCK_EXT\"";
        break;
    case 1000288006:
        settings.stream() << "\"VK_FORMAT_ASTC_4x4x3_UNORM_BLOCK_EXT\"";
        break;
    case 1000288007:
        settings.stream() << "\"VK_FORMAT_ASTC_4x4x3_SRGB_BLOCK_EXT\"";
        break;
    case 1000288008:
        settings.stream() << "\"VK_FORMAT_ASTC_4x4x3_SFLOAT_BLOCK_EXT\"";
        break;
    case 1000288009:
        settings.stream() << "\"VK_FORMAT_ASTC_4x4x4_UNORM_BLOCK_EXT\"";
        break;
    case 1000288010:
        settings.stream() << "\"VK_FORMAT_ASTC_4x4x4_SRGB_BLOCK_EXT\"";
        break;
    case 1000288011:
        settings.stream() << "\"VK_FORMAT_ASTC_4x4x4_SFLOAT_BLOCK_EXT\"";
        break;
    case 1000288012:
        settings.stream() << "\"VK_FORMAT_ASTC_5x4x4_UNORM_BLOCK_EXT\"";
        break;
    case 1000288013:
        settings.stream() << "\"VK_FORMAT_ASTC_5x4x4_SRGB_BLOCK_EXT\"";
        break;
    case 1000288014:
        settings.stream() << "\"VK_FORMAT_ASTC_5x4x4_SFLOAT_BLOCK_EXT\"";
        break;
    case 1000288015:
        settings.stream() << "\"VK_FORMAT_ASTC_5x5x4_UNORM_BLOCK_EXT\"";
        break;
    case 1000288016:
        settings.stream() << "\"VK_FORMAT_ASTC_5x5x4_SRGB_BLOCK_EXT\"";
        break;
    case 1000288017:
        settings.stream() << "\"VK_FORMAT_ASTC_5x5x4_SFLOAT_BLOCK_EXT\"";
        break;
    case 1000288018:
        settings.stream() << "\"VK_FORMAT_ASTC_5x5x5_UNORM_BLOCK_EXT\"";
        break;
    case 1000288019:
        settings.stream() << "\"VK_FORMAT_ASTC_5x5x5_SRGB_BLOCK_EXT\"";
        break;
    case 1000288020:
        settings.stream() << "\"VK_FORMAT_ASTC_5x5x5_SFLOAT_BLOCK_EXT\"";
        break;
    case 1000288021:
        settings.stream() << "\"VK_FORMAT_ASTC_6x5x5_UNORM_BLOCK_EXT\"";
        break;
    case 1000288022:
        settings.stream() << "\"VK_FORMAT_ASTC_6x5x5_SRGB_BLOCK_EXT\"";
        break;
    case 1000288023:
        settings.stream() << "\"VK_FORMAT_ASTC_6x5x5_SFLOAT_BLOCK_EXT\"";
        break;
    case 1000288024:
        settings.stream() << "\"VK_FORMAT_ASTC_6x6x5_UNORM_BLOCK_EXT\"";
        break;
    case 1000288025:
        settings.stream() << "\"VK_FORMAT_ASTC_6x6x5_SRGB_BLOCK_EXT\"";
        break;
    case 1000288026:
        settings.stream() << "\"VK_FORMAT_ASTC_6x6x5_SFLOAT_BLOCK_EXT\"";
        break;
    case 1000288027:
        settings.stream() << "\"VK_FORMAT_ASTC_6x6x6_UNORM_BLOCK_EXT\"";
        break;
    case 1000288028:
        settings.stream() << "\"VK_FORMAT_ASTC_6x6x6_SRGB_BLOCK_EXT\"";
        break;
    case 1000288029:
        settings.stream() << "\"VK_FORMAT_ASTC_6x6x6_SFLOAT_BLOCK_EXT\"";
        break;
    case 1000464000:
        settings.stream() << "\"VK_FORMAT_R16G16_SFIXED5_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkImageTiling(VkImageTiling object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_IMAGE_TILING_OPTIMAL\"";
        break;
    case 1:
        settings.stream() << "\"VK_IMAGE_TILING_LINEAR\"";
        break;
    case 1000158000:
        settings.stream() << "\"VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkImageType(VkImageType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_IMAGE_TYPE_1D\"";
        break;
    case 1:
        settings.stream() << "\"VK_IMAGE_TYPE_2D\"";
        break;
    case 2:
        settings.stream() << "\"VK_IMAGE_TYPE_3D\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPhysicalDeviceType(VkPhysicalDeviceType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PHYSICAL_DEVICE_TYPE_OTHER\"";
        break;
    case 1:
        settings.stream() << "\"VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU\"";
        break;
    case 2:
        settings.stream() << "\"VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU\"";
        break;
    case 3:
        settings.stream() << "\"VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU\"";
        break;
    case 4:
        settings.stream() << "\"VK_PHYSICAL_DEVICE_TYPE_CPU\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkQueryType(VkQueryType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_QUERY_TYPE_OCCLUSION\"";
        break;
    case 1:
        settings.stream() << "\"VK_QUERY_TYPE_PIPELINE_STATISTICS\"";
        break;
    case 2:
        settings.stream() << "\"VK_QUERY_TYPE_TIMESTAMP\"";
        break;
    case 1000023000:
        settings.stream() << "\"VK_QUERY_TYPE_RESULT_STATUS_ONLY_KHR\"";
        break;
    case 1000028004:
        settings.stream() << "\"VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT\"";
        break;
    case 1000116000:
        settings.stream() << "\"VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR\"";
        break;
    case 1000150000:
        settings.stream() << "\"VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR\"";
        break;
    case 1000150001:
        settings.stream() << "\"VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR\"";
        break;
    case 1000165000:
        settings.stream() << "\"VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV\"";
        break;
    case 1000210000:
        settings.stream() << "\"VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL\"";
        break;
    case 1000299000:
        settings.stream() << "\"VK_QUERY_TYPE_VIDEO_ENCODE_FEEDBACK_KHR\"";
        break;
    case 1000328000:
        settings.stream() << "\"VK_QUERY_TYPE_MESH_PRIMITIVES_GENERATED_EXT\"";
        break;
    case 1000382000:
        settings.stream() << "\"VK_QUERY_TYPE_PRIMITIVES_GENERATED_EXT\"";
        break;
    case 1000386000:
        settings.stream() << "\"VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_BOTTOM_LEVEL_POINTERS_KHR\"";
        break;
    case 1000386001:
        settings.stream() << "\"VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SIZE_KHR\"";
        break;
    case 1000396000:
        settings.stream() << "\"VK_QUERY_TYPE_MICROMAP_SERIALIZATION_SIZE_EXT\"";
        break;
    case 1000396001:
        settings.stream() << "\"VK_QUERY_TYPE_MICROMAP_COMPACTED_SIZE_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkSharingMode(VkSharingMode object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SHARING_MODE_EXCLUSIVE\"";
        break;
    case 1:
        settings.stream() << "\"VK_SHARING_MODE_CONCURRENT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkComponentSwizzle(VkComponentSwizzle object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COMPONENT_SWIZZLE_IDENTITY\"";
        break;
    case 1:
        settings.stream() << "\"VK_COMPONENT_SWIZZLE_ZERO\"";
        break;
    case 2:
        settings.stream() << "\"VK_COMPONENT_SWIZZLE_ONE\"";
        break;
    case 3:
        settings.stream() << "\"VK_COMPONENT_SWIZZLE_R\"";
        break;
    case 4:
        settings.stream() << "\"VK_COMPONENT_SWIZZLE_G\"";
        break;
    case 5:
        settings.stream() << "\"VK_COMPONENT_SWIZZLE_B\"";
        break;
    case 6:
        settings.stream() << "\"VK_COMPONENT_SWIZZLE_A\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkImageViewType(VkImageViewType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_IMAGE_VIEW_TYPE_1D\"";
        break;
    case 1:
        settings.stream() << "\"VK_IMAGE_VIEW_TYPE_2D\"";
        break;
    case 2:
        settings.stream() << "\"VK_IMAGE_VIEW_TYPE_3D\"";
        break;
    case 3:
        settings.stream() << "\"VK_IMAGE_VIEW_TYPE_CUBE\"";
        break;
    case 4:
        settings.stream() << "\"VK_IMAGE_VIEW_TYPE_1D_ARRAY\"";
        break;
    case 5:
        settings.stream() << "\"VK_IMAGE_VIEW_TYPE_2D_ARRAY\"";
        break;
    case 6:
        settings.stream() << "\"VK_IMAGE_VIEW_TYPE_CUBE_ARRAY\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkBlendFactor(VkBlendFactor object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_BLEND_FACTOR_ZERO\"";
        break;
    case 1:
        settings.stream() << "\"VK_BLEND_FACTOR_ONE\"";
        break;
    case 2:
        settings.stream() << "\"VK_BLEND_FACTOR_SRC_COLOR\"";
        break;
    case 3:
        settings.stream() << "\"VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR\"";
        break;
    case 4:
        settings.stream() << "\"VK_BLEND_FACTOR_DST_COLOR\"";
        break;
    case 5:
        settings.stream() << "\"VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR\"";
        break;
    case 6:
        settings.stream() << "\"VK_BLEND_FACTOR_SRC_ALPHA\"";
        break;
    case 7:
        settings.stream() << "\"VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA\"";
        break;
    case 8:
        settings.stream() << "\"VK_BLEND_FACTOR_DST_ALPHA\"";
        break;
    case 9:
        settings.stream() << "\"VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA\"";
        break;
    case 10:
        settings.stream() << "\"VK_BLEND_FACTOR_CONSTANT_COLOR\"";
        break;
    case 11:
        settings.stream() << "\"VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR\"";
        break;
    case 12:
        settings.stream() << "\"VK_BLEND_FACTOR_CONSTANT_ALPHA\"";
        break;
    case 13:
        settings.stream() << "\"VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA\"";
        break;
    case 14:
        settings.stream() << "\"VK_BLEND_FACTOR_SRC_ALPHA_SATURATE\"";
        break;
    case 15:
        settings.stream() << "\"VK_BLEND_FACTOR_SRC1_COLOR\"";
        break;
    case 16:
        settings.stream() << "\"VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR\"";
        break;
    case 17:
        settings.stream() << "\"VK_BLEND_FACTOR_SRC1_ALPHA\"";
        break;
    case 18:
        settings.stream() << "\"VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkBlendOp(VkBlendOp object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_BLEND_OP_ADD\"";
        break;
    case 1:
        settings.stream() << "\"VK_BLEND_OP_SUBTRACT\"";
        break;
    case 2:
        settings.stream() << "\"VK_BLEND_OP_REVERSE_SUBTRACT\"";
        break;
    case 3:
        settings.stream() << "\"VK_BLEND_OP_MIN\"";
        break;
    case 4:
        settings.stream() << "\"VK_BLEND_OP_MAX\"";
        break;
    case 1000148000:
        settings.stream() << "\"VK_BLEND_OP_ZERO_EXT\"";
        break;
    case 1000148001:
        settings.stream() << "\"VK_BLEND_OP_SRC_EXT\"";
        break;
    case 1000148002:
        settings.stream() << "\"VK_BLEND_OP_DST_EXT\"";
        break;
    case 1000148003:
        settings.stream() << "\"VK_BLEND_OP_SRC_OVER_EXT\"";
        break;
    case 1000148004:
        settings.stream() << "\"VK_BLEND_OP_DST_OVER_EXT\"";
        break;
    case 1000148005:
        settings.stream() << "\"VK_BLEND_OP_SRC_IN_EXT\"";
        break;
    case 1000148006:
        settings.stream() << "\"VK_BLEND_OP_DST_IN_EXT\"";
        break;
    case 1000148007:
        settings.stream() << "\"VK_BLEND_OP_SRC_OUT_EXT\"";
        break;
    case 1000148008:
        settings.stream() << "\"VK_BLEND_OP_DST_OUT_EXT\"";
        break;
    case 1000148009:
        settings.stream() << "\"VK_BLEND_OP_SRC_ATOP_EXT\"";
        break;
    case 1000148010:
        settings.stream() << "\"VK_BLEND_OP_DST_ATOP_EXT\"";
        break;
    case 1000148011:
        settings.stream() << "\"VK_BLEND_OP_XOR_EXT\"";
        break;
    case 1000148012:
        settings.stream() << "\"VK_BLEND_OP_MULTIPLY_EXT\"";
        break;
    case 1000148013:
        settings.stream() << "\"VK_BLEND_OP_SCREEN_EXT\"";
        break;
    case 1000148014:
        settings.stream() << "\"VK_BLEND_OP_OVERLAY_EXT\"";
        break;
    case 1000148015:
        settings.stream() << "\"VK_BLEND_OP_DARKEN_EXT\"";
        break;
    case 1000148016:
        settings.stream() << "\"VK_BLEND_OP_LIGHTEN_EXT\"";
        break;
    case 1000148017:
        settings.stream() << "\"VK_BLEND_OP_COLORDODGE_EXT\"";
        break;
    case 1000148018:
        settings.stream() << "\"VK_BLEND_OP_COLORBURN_EXT\"";
        break;
    case 1000148019:
        settings.stream() << "\"VK_BLEND_OP_HARDLIGHT_EXT\"";
        break;
    case 1000148020:
        settings.stream() << "\"VK_BLEND_OP_SOFTLIGHT_EXT\"";
        break;
    case 1000148021:
        settings.stream() << "\"VK_BLEND_OP_DIFFERENCE_EXT\"";
        break;
    case 1000148022:
        settings.stream() << "\"VK_BLEND_OP_EXCLUSION_EXT\"";
        break;
    case 1000148023:
        settings.stream() << "\"VK_BLEND_OP_INVERT_EXT\"";
        break;
    case 1000148024:
        settings.stream() << "\"VK_BLEND_OP_INVERT_RGB_EXT\"";
        break;
    case 1000148025:
        settings.stream() << "\"VK_BLEND_OP_LINEARDODGE_EXT\"";
        break;
    case 1000148026:
        settings.stream() << "\"VK_BLEND_OP_LINEARBURN_EXT\"";
        break;
    case 1000148027:
        settings.stream() << "\"VK_BLEND_OP_VIVIDLIGHT_EXT\"";
        break;
    case 1000148028:
        settings.stream() << "\"VK_BLEND_OP_LINEARLIGHT_EXT\"";
        break;
    case 1000148029:
        settings.stream() << "\"VK_BLEND_OP_PINLIGHT_EXT\"";
        break;
    case 1000148030:
        settings.stream() << "\"VK_BLEND_OP_HARDMIX_EXT\"";
        break;
    case 1000148031:
        settings.stream() << "\"VK_BLEND_OP_HSL_HUE_EXT\"";
        break;
    case 1000148032:
        settings.stream() << "\"VK_BLEND_OP_HSL_SATURATION_EXT\"";
        break;
    case 1000148033:
        settings.stream() << "\"VK_BLEND_OP_HSL_COLOR_EXT\"";
        break;
    case 1000148034:
        settings.stream() << "\"VK_BLEND_OP_HSL_LUMINOSITY_EXT\"";
        break;
    case 1000148035:
        settings.stream() << "\"VK_BLEND_OP_PLUS_EXT\"";
        break;
    case 1000148036:
        settings.stream() << "\"VK_BLEND_OP_PLUS_CLAMPED_EXT\"";
        break;
    case 1000148037:
        settings.stream() << "\"VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT\"";
        break;
    case 1000148038:
        settings.stream() << "\"VK_BLEND_OP_PLUS_DARKER_EXT\"";
        break;
    case 1000148039:
        settings.stream() << "\"VK_BLEND_OP_MINUS_EXT\"";
        break;
    case 1000148040:
        settings.stream() << "\"VK_BLEND_OP_MINUS_CLAMPED_EXT\"";
        break;
    case 1000148041:
        settings.stream() << "\"VK_BLEND_OP_CONTRAST_EXT\"";
        break;
    case 1000148042:
        settings.stream() << "\"VK_BLEND_OP_INVERT_OVG_EXT\"";
        break;
    case 1000148043:
        settings.stream() << "\"VK_BLEND_OP_RED_EXT\"";
        break;
    case 1000148044:
        settings.stream() << "\"VK_BLEND_OP_GREEN_EXT\"";
        break;
    case 1000148045:
        settings.stream() << "\"VK_BLEND_OP_BLUE_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkCompareOp(VkCompareOp object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COMPARE_OP_NEVER\"";
        break;
    case 1:
        settings.stream() << "\"VK_COMPARE_OP_LESS\"";
        break;
    case 2:
        settings.stream() << "\"VK_COMPARE_OP_EQUAL\"";
        break;
    case 3:
        settings.stream() << "\"VK_COMPARE_OP_LESS_OR_EQUAL\"";
        break;
    case 4:
        settings.stream() << "\"VK_COMPARE_OP_GREATER\"";
        break;
    case 5:
        settings.stream() << "\"VK_COMPARE_OP_NOT_EQUAL\"";
        break;
    case 6:
        settings.stream() << "\"VK_COMPARE_OP_GREATER_OR_EQUAL\"";
        break;
    case 7:
        settings.stream() << "\"VK_COMPARE_OP_ALWAYS\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDynamicState(VkDynamicState object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DYNAMIC_STATE_VIEWPORT\"";
        break;
    case 1:
        settings.stream() << "\"VK_DYNAMIC_STATE_SCISSOR\"";
        break;
    case 2:
        settings.stream() << "\"VK_DYNAMIC_STATE_LINE_WIDTH\"";
        break;
    case 3:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_BIAS\"";
        break;
    case 4:
        settings.stream() << "\"VK_DYNAMIC_STATE_BLEND_CONSTANTS\"";
        break;
    case 5:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_BOUNDS\"";
        break;
    case 6:
        settings.stream() << "\"VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK\"";
        break;
    case 7:
        settings.stream() << "\"VK_DYNAMIC_STATE_STENCIL_WRITE_MASK\"";
        break;
    case 8:
        settings.stream() << "\"VK_DYNAMIC_STATE_STENCIL_REFERENCE\"";
        break;
    case 1000267000:
        settings.stream() << "\"VK_DYNAMIC_STATE_CULL_MODE\"";
        break;
    case 1000267001:
        settings.stream() << "\"VK_DYNAMIC_STATE_FRONT_FACE\"";
        break;
    case 1000267002:
        settings.stream() << "\"VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY\"";
        break;
    case 1000267003:
        settings.stream() << "\"VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT\"";
        break;
    case 1000267004:
        settings.stream() << "\"VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT\"";
        break;
    case 1000267005:
        settings.stream() << "\"VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE\"";
        break;
    case 1000267006:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE\"";
        break;
    case 1000267007:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE\"";
        break;
    case 1000267008:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_COMPARE_OP\"";
        break;
    case 1000267009:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE\"";
        break;
    case 1000267010:
        settings.stream() << "\"VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE\"";
        break;
    case 1000267011:
        settings.stream() << "\"VK_DYNAMIC_STATE_STENCIL_OP\"";
        break;
    case 1000377001:
        settings.stream() << "\"VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE\"";
        break;
    case 1000377002:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE\"";
        break;
    case 1000377004:
        settings.stream() << "\"VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE\"";
        break;
    case 1000259000:
        settings.stream() << "\"VK_DYNAMIC_STATE_LINE_STIPPLE\"";
        break;
    case 1000087000:
        settings.stream() << "\"VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV\"";
        break;
    case 1000099000:
        settings.stream() << "\"VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT\"";
        break;
    case 1000099001:
        settings.stream() << "\"VK_DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT\"";
        break;
    case 1000099002:
        settings.stream() << "\"VK_DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT\"";
        break;
    case 1000143000:
        settings.stream() << "\"VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT\"";
        break;
    case 1000347000:
        settings.stream() << "\"VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR\"";
        break;
    case 1000164004:
        settings.stream() << "\"VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV\"";
        break;
    case 1000164006:
        settings.stream() << "\"VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV\"";
        break;
    case 1000205000:
        settings.stream() << "\"VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV\"";
        break;
    case 1000205001:
        settings.stream() << "\"VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV\"";
        break;
    case 1000226000:
        settings.stream() << "\"VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR\"";
        break;
    case 1000352000:
        settings.stream() << "\"VK_DYNAMIC_STATE_VERTEX_INPUT_EXT\"";
        break;
    case 1000377000:
        settings.stream() << "\"VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT\"";
        break;
    case 1000377003:
        settings.stream() << "\"VK_DYNAMIC_STATE_LOGIC_OP_EXT\"";
        break;
    case 1000381000:
        settings.stream() << "\"VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT\"";
        break;
    case 1000455003:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT\"";
        break;
    case 1000455004:
        settings.stream() << "\"VK_DYNAMIC_STATE_POLYGON_MODE_EXT\"";
        break;
    case 1000455005:
        settings.stream() << "\"VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT\"";
        break;
    case 1000455006:
        settings.stream() << "\"VK_DYNAMIC_STATE_SAMPLE_MASK_EXT\"";
        break;
    case 1000455007:
        settings.stream() << "\"VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT\"";
        break;
    case 1000455008:
        settings.stream() << "\"VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT\"";
        break;
    case 1000455009:
        settings.stream() << "\"VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT\"";
        break;
    case 1000455010:
        settings.stream() << "\"VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT\"";
        break;
    case 1000455011:
        settings.stream() << "\"VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT\"";
        break;
    case 1000455012:
        settings.stream() << "\"VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT\"";
        break;
    case 1000455002:
        settings.stream() << "\"VK_DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT\"";
        break;
    case 1000455013:
        settings.stream() << "\"VK_DYNAMIC_STATE_RASTERIZATION_STREAM_EXT\"";
        break;
    case 1000455014:
        settings.stream() << "\"VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT\"";
        break;
    case 1000455015:
        settings.stream() << "\"VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT\"";
        break;
    case 1000455016:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT\"";
        break;
    case 1000455017:
        settings.stream() << "\"VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT\"";
        break;
    case 1000455018:
        settings.stream() << "\"VK_DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT\"";
        break;
    case 1000455019:
        settings.stream() << "\"VK_DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT\"";
        break;
    case 1000455020:
        settings.stream() << "\"VK_DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT\"";
        break;
    case 1000455021:
        settings.stream() << "\"VK_DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT\"";
        break;
    case 1000455022:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT\"";
        break;
    case 1000455023:
        settings.stream() << "\"VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV\"";
        break;
    case 1000455024:
        settings.stream() << "\"VK_DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV\"";
        break;
    case 1000455025:
        settings.stream() << "\"VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV\"";
        break;
    case 1000455026:
        settings.stream() << "\"VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV\"";
        break;
    case 1000455027:
        settings.stream() << "\"VK_DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV\"";
        break;
    case 1000455028:
        settings.stream() << "\"VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV\"";
        break;
    case 1000455029:
        settings.stream() << "\"VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV\"";
        break;
    case 1000455030:
        settings.stream() << "\"VK_DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV\"";
        break;
    case 1000455031:
        settings.stream() << "\"VK_DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV\"";
        break;
    case 1000455032:
        settings.stream() << "\"VK_DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV\"";
        break;
    case 1000524000:
        settings.stream() << "\"VK_DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT\"";
        break;
    case 1000582000:
        settings.stream() << "\"VK_DYNAMIC_STATE_DEPTH_CLAMP_RANGE_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkFrontFace(VkFrontFace object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_FRONT_FACE_COUNTER_CLOCKWISE\"";
        break;
    case 1:
        settings.stream() << "\"VK_FRONT_FACE_CLOCKWISE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkVertexInputRate(VkVertexInputRate object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_VERTEX_INPUT_RATE_VERTEX\"";
        break;
    case 1:
        settings.stream() << "\"VK_VERTEX_INPUT_RATE_INSTANCE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPrimitiveTopology(VkPrimitiveTopology object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_POINT_LIST\"";
        break;
    case 1:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_LINE_LIST\"";
        break;
    case 2:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_LINE_STRIP\"";
        break;
    case 3:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST\"";
        break;
    case 4:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP\"";
        break;
    case 5:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN\"";
        break;
    case 6:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY\"";
        break;
    case 7:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY\"";
        break;
    case 8:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY\"";
        break;
    case 9:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY\"";
        break;
    case 10:
        settings.stream() << "\"VK_PRIMITIVE_TOPOLOGY_PATCH_LIST\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPolygonMode(VkPolygonMode object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_POLYGON_MODE_FILL\"";
        break;
    case 1:
        settings.stream() << "\"VK_POLYGON_MODE_LINE\"";
        break;
    case 2:
        settings.stream() << "\"VK_POLYGON_MODE_POINT\"";
        break;
    case 1000153000:
        settings.stream() << "\"VK_POLYGON_MODE_FILL_RECTANGLE_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkStencilOp(VkStencilOp object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_STENCIL_OP_KEEP\"";
        break;
    case 1:
        settings.stream() << "\"VK_STENCIL_OP_ZERO\"";
        break;
    case 2:
        settings.stream() << "\"VK_STENCIL_OP_REPLACE\"";
        break;
    case 3:
        settings.stream() << "\"VK_STENCIL_OP_INCREMENT_AND_CLAMP\"";
        break;
    case 4:
        settings.stream() << "\"VK_STENCIL_OP_DECREMENT_AND_CLAMP\"";
        break;
    case 5:
        settings.stream() << "\"VK_STENCIL_OP_INVERT\"";
        break;
    case 6:
        settings.stream() << "\"VK_STENCIL_OP_INCREMENT_AND_WRAP\"";
        break;
    case 7:
        settings.stream() << "\"VK_STENCIL_OP_DECREMENT_AND_WRAP\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkLogicOp(VkLogicOp object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_LOGIC_OP_CLEAR\"";
        break;
    case 1:
        settings.stream() << "\"VK_LOGIC_OP_AND\"";
        break;
    case 2:
        settings.stream() << "\"VK_LOGIC_OP_AND_REVERSE\"";
        break;
    case 3:
        settings.stream() << "\"VK_LOGIC_OP_COPY\"";
        break;
    case 4:
        settings.stream() << "\"VK_LOGIC_OP_AND_INVERTED\"";
        break;
    case 5:
        settings.stream() << "\"VK_LOGIC_OP_NO_OP\"";
        break;
    case 6:
        settings.stream() << "\"VK_LOGIC_OP_XOR\"";
        break;
    case 7:
        settings.stream() << "\"VK_LOGIC_OP_OR\"";
        break;
    case 8:
        settings.stream() << "\"VK_LOGIC_OP_NOR\"";
        break;
    case 9:
        settings.stream() << "\"VK_LOGIC_OP_EQUIVALENT\"";
        break;
    case 10:
        settings.stream() << "\"VK_LOGIC_OP_INVERT\"";
        break;
    case 11:
        settings.stream() << "\"VK_LOGIC_OP_OR_REVERSE\"";
        break;
    case 12:
        settings.stream() << "\"VK_LOGIC_OP_COPY_INVERTED\"";
        break;
    case 13:
        settings.stream() << "\"VK_LOGIC_OP_OR_INVERTED\"";
        break;
    case 14:
        settings.stream() << "\"VK_LOGIC_OP_NAND\"";
        break;
    case 15:
        settings.stream() << "\"VK_LOGIC_OP_SET\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkBorderColor(VkBorderColor object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK\"";
        break;
    case 1:
        settings.stream() << "\"VK_BORDER_COLOR_INT_TRANSPARENT_BLACK\"";
        break;
    case 2:
        settings.stream() << "\"VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK\"";
        break;
    case 3:
        settings.stream() << "\"VK_BORDER_COLOR_INT_OPAQUE_BLACK\"";
        break;
    case 4:
        settings.stream() << "\"VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE\"";
        break;
    case 5:
        settings.stream() << "\"VK_BORDER_COLOR_INT_OPAQUE_WHITE\"";
        break;
    case 1000287003:
        settings.stream() << "\"VK_BORDER_COLOR_FLOAT_CUSTOM_EXT\"";
        break;
    case 1000287004:
        settings.stream() << "\"VK_BORDER_COLOR_INT_CUSTOM_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkFilter(VkFilter object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_FILTER_NEAREST\"";
        break;
    case 1:
        settings.stream() << "\"VK_FILTER_LINEAR\"";
        break;
    case 1000015000:
        settings.stream() << "\"VK_FILTER_CUBIC_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkSamplerAddressMode(VkSamplerAddressMode object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SAMPLER_ADDRESS_MODE_REPEAT\"";
        break;
    case 1:
        settings.stream() << "\"VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT\"";
        break;
    case 2:
        settings.stream() << "\"VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE\"";
        break;
    case 3:
        settings.stream() << "\"VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER\"";
        break;
    case 4:
        settings.stream() << "\"VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkSamplerMipmapMode(VkSamplerMipmapMode object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SAMPLER_MIPMAP_MODE_NEAREST\"";
        break;
    case 1:
        settings.stream() << "\"VK_SAMPLER_MIPMAP_MODE_LINEAR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDescriptorType(VkDescriptorType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_SAMPLER\"";
        break;
    case 1:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER\"";
        break;
    case 2:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE\"";
        break;
    case 3:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_STORAGE_IMAGE\"";
        break;
    case 4:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER\"";
        break;
    case 5:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER\"";
        break;
    case 6:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER\"";
        break;
    case 7:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_STORAGE_BUFFER\"";
        break;
    case 8:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC\"";
        break;
    case 9:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC\"";
        break;
    case 10:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT\"";
        break;
    case 1000138000:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK\"";
        break;
    case 1000150000:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR\"";
        break;
    case 1000165000:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV\"";
        break;
    case 1000440000:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM\"";
        break;
    case 1000440001:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM\"";
        break;
    case 1000351000:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_MUTABLE_EXT\"";
        break;
    case 1000570000:
        settings.stream() << "\"VK_DESCRIPTOR_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkAttachmentLoadOp(VkAttachmentLoadOp object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_ATTACHMENT_LOAD_OP_LOAD\"";
        break;
    case 1:
        settings.stream() << "\"VK_ATTACHMENT_LOAD_OP_CLEAR\"";
        break;
    case 2:
        settings.stream() << "\"VK_ATTACHMENT_LOAD_OP_DONT_CARE\"";
        break;
    case 1000400000:
        settings.stream() << "\"VK_ATTACHMENT_LOAD_OP_NONE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkAttachmentStoreOp(VkAttachmentStoreOp object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_ATTACHMENT_STORE_OP_STORE\"";
        break;
    case 1:
        settings.stream() << "\"VK_ATTACHMENT_STORE_OP_DONT_CARE\"";
        break;
    case 1000301000:
        settings.stream() << "\"VK_ATTACHMENT_STORE_OP_NONE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPipelineBindPoint(VkPipelineBindPoint object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PIPELINE_BIND_POINT_GRAPHICS\"";
        break;
    case 1:
        settings.stream() << "\"VK_PIPELINE_BIND_POINT_COMPUTE\"";
        break;
    case 1000134000:
        settings.stream() << "\"VK_PIPELINE_BIND_POINT_EXECUTION_GRAPH_AMDX\"";
        break;
    case 1000165000:
        settings.stream() << "\"VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR\"";
        break;
    case 1000369003:
        settings.stream() << "\"VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkCommandBufferLevel(VkCommandBufferLevel object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COMMAND_BUFFER_LEVEL_PRIMARY\"";
        break;
    case 1:
        settings.stream() << "\"VK_COMMAND_BUFFER_LEVEL_SECONDARY\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkIndexType(VkIndexType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_INDEX_TYPE_UINT16\"";
        break;
    case 1:
        settings.stream() << "\"VK_INDEX_TYPE_UINT32\"";
        break;
    case 1000265000:
        settings.stream() << "\"VK_INDEX_TYPE_UINT8\"";
        break;
    case 1000165000:
        settings.stream() << "\"VK_INDEX_TYPE_NONE_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkSubpassContents(VkSubpassContents object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SUBPASS_CONTENTS_INLINE\"";
        break;
    case 1:
        settings.stream() << "\"VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS\"";
        break;
    case 1000451000:
        settings.stream() << "\"VK_SUBPASS_CONTENTS_INLINE_AND_SECONDARY_COMMAND_BUFFERS_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPointClippingBehavior(VkPointClippingBehavior object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES\"";
        break;
    case 1:
        settings.stream() << "\"VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkTessellationDomainOrigin(VkTessellationDomainOrigin object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT\"";
        break;
    case 1:
        settings.stream() << "\"VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkSamplerYcbcrModelConversion(VkSamplerYcbcrModelConversion object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY\"";
        break;
    case 1:
        settings.stream() << "\"VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY\"";
        break;
    case 2:
        settings.stream() << "\"VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709\"";
        break;
    case 3:
        settings.stream() << "\"VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601\"";
        break;
    case 4:
        settings.stream() << "\"VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkSamplerYcbcrRange(VkSamplerYcbcrRange object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SAMPLER_YCBCR_RANGE_ITU_FULL\"";
        break;
    case 1:
        settings.stream() << "\"VK_SAMPLER_YCBCR_RANGE_ITU_NARROW\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkChromaLocation(VkChromaLocation object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_CHROMA_LOCATION_COSITED_EVEN\"";
        break;
    case 1:
        settings.stream() << "\"VK_CHROMA_LOCATION_MIDPOINT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDescriptorUpdateTemplateType(VkDescriptorUpdateTemplateType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET\"";
        break;
    case 1:
        settings.stream() << "\"VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDriverId(VkDriverId object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "\"VK_DRIVER_ID_AMD_PROPRIETARY\"";
        break;
    case 2:
        settings.stream() << "\"VK_DRIVER_ID_AMD_OPEN_SOURCE\"";
        break;
    case 3:
        settings.stream() << "\"VK_DRIVER_ID_MESA_RADV\"";
        break;
    case 4:
        settings.stream() << "\"VK_DRIVER_ID_NVIDIA_PROPRIETARY\"";
        break;
    case 5:
        settings.stream() << "\"VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS\"";
        break;
    case 6:
        settings.stream() << "\"VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA\"";
        break;
    case 7:
        settings.stream() << "\"VK_DRIVER_ID_IMAGINATION_PROPRIETARY\"";
        break;
    case 8:
        settings.stream() << "\"VK_DRIVER_ID_QUALCOMM_PROPRIETARY\"";
        break;
    case 9:
        settings.stream() << "\"VK_DRIVER_ID_ARM_PROPRIETARY\"";
        break;
    case 10:
        settings.stream() << "\"VK_DRIVER_ID_GOOGLE_SWIFTSHADER\"";
        break;
    case 11:
        settings.stream() << "\"VK_DRIVER_ID_GGP_PROPRIETARY\"";
        break;
    case 12:
        settings.stream() << "\"VK_DRIVER_ID_BROADCOM_PROPRIETARY\"";
        break;
    case 13:
        settings.stream() << "\"VK_DRIVER_ID_MESA_LLVMPIPE\"";
        break;
    case 14:
        settings.stream() << "\"VK_DRIVER_ID_MOLTENVK\"";
        break;
    case 15:
        settings.stream() << "\"VK_DRIVER_ID_COREAVI_PROPRIETARY\"";
        break;
    case 16:
        settings.stream() << "\"VK_DRIVER_ID_JUICE_PROPRIETARY\"";
        break;
    case 17:
        settings.stream() << "\"VK_DRIVER_ID_VERISILICON_PROPRIETARY\"";
        break;
    case 18:
        settings.stream() << "\"VK_DRIVER_ID_MESA_TURNIP\"";
        break;
    case 19:
        settings.stream() << "\"VK_DRIVER_ID_MESA_V3DV\"";
        break;
    case 20:
        settings.stream() << "\"VK_DRIVER_ID_MESA_PANVK\"";
        break;
    case 21:
        settings.stream() << "\"VK_DRIVER_ID_SAMSUNG_PROPRIETARY\"";
        break;
    case 22:
        settings.stream() << "\"VK_DRIVER_ID_MESA_VENUS\"";
        break;
    case 23:
        settings.stream() << "\"VK_DRIVER_ID_MESA_DOZEN\"";
        break;
    case 24:
        settings.stream() << "\"VK_DRIVER_ID_MESA_NVK\"";
        break;
    case 25:
        settings.stream() << "\"VK_DRIVER_ID_IMAGINATION_OPEN_SOURCE_MESA\"";
        break;
    case 26:
        settings.stream() << "\"VK_DRIVER_ID_MESA_HONEYKRISP\"";
        break;
    case 27:
        settings.stream() << "\"VK_DRIVER_ID_VULKAN_SC_EMULATION_ON_VULKAN\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkShaderFloatControlsIndependence(VkShaderFloatControlsIndependence object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY\"";
        break;
    case 1:
        settings.stream() << "\"VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL\"";
        break;
    case 2:
        settings.stream() << "\"VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkSamplerReductionMode(VkSamplerReductionMode object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE\"";
        break;
    case 1:
        settings.stream() << "\"VK_SAMPLER_REDUCTION_MODE_MIN\"";
        break;
    case 2:
        settings.stream() << "\"VK_SAMPLER_REDUCTION_MODE_MAX\"";
        break;
    case 1000521000:
        settings.stream() << "\"VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_RANGECLAMP_QCOM\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkSemaphoreType(VkSemaphoreType object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SEMAPHORE_TYPE_BINARY\"";
        break;
    case 1:
        settings.stream() << "\"VK_SEMAPHORE_TYPE_TIMELINE\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPipelineRobustnessBufferBehavior(VkPipelineRobustnessBufferBehavior object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_DEVICE_DEFAULT\"";
        break;
    case 1:
        settings.stream() << "\"VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_DISABLED\"";
        break;
    case 2:
        settings.stream() << "\"VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_ROBUST_BUFFER_ACCESS\"";
        break;
    case 3:
        settings.stream() << "\"VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_ROBUST_BUFFER_ACCESS_2\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPipelineRobustnessImageBehavior(VkPipelineRobustnessImageBehavior object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_DEVICE_DEFAULT\"";
        break;
    case 1:
        settings.stream() << "\"VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_DISABLED\"";
        break;
    case 2:
        settings.stream() << "\"VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_ROBUST_IMAGE_ACCESS\"";
        break;
    case 3:
        settings.stream() << "\"VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_ROBUST_IMAGE_ACCESS_2\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkQueueGlobalPriority(VkQueueGlobalPriority object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 128:
        settings.stream() << "\"VK_QUEUE_GLOBAL_PRIORITY_LOW\"";
        break;
    case 256:
        settings.stream() << "\"VK_QUEUE_GLOBAL_PRIORITY_MEDIUM\"";
        break;
    case 512:
        settings.stream() << "\"VK_QUEUE_GLOBAL_PRIORITY_HIGH\"";
        break;
    case 1024:
        settings.stream() << "\"VK_QUEUE_GLOBAL_PRIORITY_REALTIME\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkLineRasterizationMode(VkLineRasterizationMode object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_LINE_RASTERIZATION_MODE_DEFAULT\"";
        break;
    case 1:
        settings.stream() << "\"VK_LINE_RASTERIZATION_MODE_RECTANGULAR\"";
        break;
    case 2:
        settings.stream() << "\"VK_LINE_RASTERIZATION_MODE_BRESENHAM\"";
        break;
    case 3:
        settings.stream() << "\"VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPresentModeKHR(VkPresentModeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PRESENT_MODE_IMMEDIATE_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_PRESENT_MODE_MAILBOX_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_PRESENT_MODE_FIFO_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_PRESENT_MODE_FIFO_RELAXED_KHR\"";
        break;
    case 1000111000:
        settings.stream() << "\"VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR\"";
        break;
    case 1000111001:
        settings.stream() << "\"VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR\"";
        break;
    case 1000361000:
        settings.stream() << "\"VK_PRESENT_MODE_FIFO_LATEST_READY_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkColorSpaceKHR(VkColorSpaceKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COLOR_SPACE_SRGB_NONLINEAR_KHR\"";
        break;
    case 1000104001:
        settings.stream() << "\"VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT\"";
        break;
    case 1000104002:
        settings.stream() << "\"VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT\"";
        break;
    case 1000104003:
        settings.stream() << "\"VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT\"";
        break;
    case 1000104004:
        settings.stream() << "\"VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT\"";
        break;
    case 1000104005:
        settings.stream() << "\"VK_COLOR_SPACE_BT709_LINEAR_EXT\"";
        break;
    case 1000104006:
        settings.stream() << "\"VK_COLOR_SPACE_BT709_NONLINEAR_EXT\"";
        break;
    case 1000104007:
        settings.stream() << "\"VK_COLOR_SPACE_BT2020_LINEAR_EXT\"";
        break;
    case 1000104008:
        settings.stream() << "\"VK_COLOR_SPACE_HDR10_ST2084_EXT\"";
        break;
    case 1000104009:
        settings.stream() << "\"VK_COLOR_SPACE_DOLBYVISION_EXT\"";
        break;
    case 1000104010:
        settings.stream() << "\"VK_COLOR_SPACE_HDR10_HLG_EXT\"";
        break;
    case 1000104011:
        settings.stream() << "\"VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT\"";
        break;
    case 1000104012:
        settings.stream() << "\"VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT\"";
        break;
    case 1000104013:
        settings.stream() << "\"VK_COLOR_SPACE_PASS_THROUGH_EXT\"";
        break;
    case 1000104014:
        settings.stream() << "\"VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT\"";
        break;
    case 1000213000:
        settings.stream() << "\"VK_COLOR_SPACE_DISPLAY_NATIVE_AMD\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDebugReportObjectTypeEXT(VkDebugReportObjectTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT\"";
        break;
    case 3:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT\"";
        break;
    case 4:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT\"";
        break;
    case 5:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT\"";
        break;
    case 6:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT\"";
        break;
    case 7:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT\"";
        break;
    case 8:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT\"";
        break;
    case 9:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT\"";
        break;
    case 10:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT\"";
        break;
    case 11:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT\"";
        break;
    case 12:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT\"";
        break;
    case 13:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT\"";
        break;
    case 14:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT\"";
        break;
    case 15:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT\"";
        break;
    case 16:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT\"";
        break;
    case 17:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT\"";
        break;
    case 18:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT\"";
        break;
    case 19:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT\"";
        break;
    case 20:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT\"";
        break;
    case 21:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT\"";
        break;
    case 22:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT\"";
        break;
    case 23:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT\"";
        break;
    case 24:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT\"";
        break;
    case 25:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT\"";
        break;
    case 26:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT\"";
        break;
    case 27:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT\"";
        break;
    case 28:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT_EXT\"";
        break;
    case 29:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_KHR_EXT\"";
        break;
    case 30:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_MODE_KHR_EXT\"";
        break;
    case 33:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT_EXT\"";
        break;
    case 1000156000:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_EXT\"";
        break;
    case 1000085000:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_EXT\"";
        break;
    case 1000029000:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_CU_MODULE_NVX_EXT\"";
        break;
    case 1000029001:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_CU_FUNCTION_NVX_EXT\"";
        break;
    case 1000150000:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR_EXT\"";
        break;
    case 1000165000:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV_EXT\"";
        break;
    case 1000307000:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_CUDA_MODULE_NV_EXT\"";
        break;
    case 1000307001:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_CUDA_FUNCTION_NV_EXT\"";
        break;
    case 1000366000:
        settings.stream() << "\"VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkRasterizationOrderAMD(VkRasterizationOrderAMD object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_RASTERIZATION_ORDER_STRICT_AMD\"";
        break;
    case 1:
        settings.stream() << "\"VK_RASTERIZATION_ORDER_RELAXED_AMD\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkQueryResultStatusKHR(VkQueryResultStatusKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case -1:
        settings.stream() << "\"VK_QUERY_RESULT_STATUS_ERROR_KHR\"";
        break;
    case 0:
        settings.stream() << "\"VK_QUERY_RESULT_STATUS_NOT_READY_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_QUERY_RESULT_STATUS_COMPLETE_KHR\"";
        break;
    case -1000299000:
        settings.stream() << "\"VK_QUERY_RESULT_STATUS_INSUFFICIENT_BITSTREAM_BUFFER_RANGE_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkShaderInfoTypeAMD(VkShaderInfoTypeAMD object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SHADER_INFO_TYPE_STATISTICS_AMD\"";
        break;
    case 1:
        settings.stream() << "\"VK_SHADER_INFO_TYPE_BINARY_AMD\"";
        break;
    case 2:
        settings.stream() << "\"VK_SHADER_INFO_TYPE_DISASSEMBLY_AMD\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkValidationCheckEXT(VkValidationCheckEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_VALIDATION_CHECK_ALL_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_VALIDATION_CHECK_SHADERS_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDisplayPowerStateEXT(VkDisplayPowerStateEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DISPLAY_POWER_STATE_OFF_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_DISPLAY_POWER_STATE_SUSPEND_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_DISPLAY_POWER_STATE_ON_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDeviceEventTypeEXT(VkDeviceEventTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDisplayEventTypeEXT(VkDisplayEventTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkViewportCoordinateSwizzleNV(VkViewportCoordinateSwizzleNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_X_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_X_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Y_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Y_NV\"";
        break;
    case 4:
        settings.stream() << "\"VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Z_NV\"";
        break;
    case 5:
        settings.stream() << "\"VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Z_NV\"";
        break;
    case 6:
        settings.stream() << "\"VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_W_NV\"";
        break;
    case 7:
        settings.stream() << "\"VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_W_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDiscardRectangleModeEXT(VkDiscardRectangleModeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DISCARD_RECTANGLE_MODE_INCLUSIVE_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_DISCARD_RECTANGLE_MODE_EXCLUSIVE_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkConservativeRasterizationModeEXT(VkConservativeRasterizationModeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPerformanceCounterUnitKHR(VkPerformanceCounterUnitKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_GENERIC_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_BYTES_KHR\"";
        break;
    case 4:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR\"";
        break;
    case 5:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_KELVIN_KHR\"";
        break;
    case 6:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_WATTS_KHR\"";
        break;
    case 7:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_VOLTS_KHR\"";
        break;
    case 8:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_AMPS_KHR\"";
        break;
    case 9:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_HERTZ_KHR\"";
        break;
    case 10:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_UNIT_CYCLES_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPerformanceCounterScopeKHR(VkPerformanceCounterScopeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPerformanceCounterStorageKHR(VkPerformanceCounterStorageKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_STORAGE_INT32_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_STORAGE_INT64_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_STORAGE_UINT32_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_STORAGE_UINT64_KHR\"";
        break;
    case 4:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR\"";
        break;
    case 5:
        settings.stream() << "\"VK_PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkBlendOverlapEXT(VkBlendOverlapEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_BLEND_OVERLAP_UNCORRELATED_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_BLEND_OVERLAP_DISJOINT_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_BLEND_OVERLAP_CONJOINT_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkAccelerationStructureTypeKHR(VkAccelerationStructureTypeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkBuildAccelerationStructureModeKHR(VkBuildAccelerationStructureModeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkGeometryTypeKHR(VkGeometryTypeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_GEOMETRY_TYPE_TRIANGLES_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_GEOMETRY_TYPE_AABBS_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_GEOMETRY_TYPE_INSTANCES_KHR\"";
        break;
    case 1000429004:
        settings.stream() << "\"VK_GEOMETRY_TYPE_SPHERES_NV\"";
        break;
    case 1000429005:
        settings.stream() << "\"VK_GEOMETRY_TYPE_LINEAR_SWEPT_SPHERES_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkAccelerationStructureBuildTypeKHR(VkAccelerationStructureBuildTypeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkCopyAccelerationStructureModeKHR(VkCopyAccelerationStructureModeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkAccelerationStructureCompatibilityKHR(VkAccelerationStructureCompatibilityKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkCoverageModulationModeNV(VkCoverageModulationModeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COVERAGE_MODULATION_MODE_NONE_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_COVERAGE_MODULATION_MODE_RGB_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_COVERAGE_MODULATION_MODE_ALPHA_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_COVERAGE_MODULATION_MODE_RGBA_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkValidationCacheHeaderVersionEXT(VkValidationCacheHeaderVersionEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "\"VK_VALIDATION_CACHE_HEADER_VERSION_ONE_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkShadingRatePaletteEntryNV(VkShadingRatePaletteEntryNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_NO_INVOCATIONS_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_16_INVOCATIONS_PER_PIXEL_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_8_INVOCATIONS_PER_PIXEL_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_4_INVOCATIONS_PER_PIXEL_NV\"";
        break;
    case 4:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_2_INVOCATIONS_PER_PIXEL_NV\"";
        break;
    case 5:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_PIXEL_NV\"";
        break;
    case 6:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X1_PIXELS_NV\"";
        break;
    case 7:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_1X2_PIXELS_NV\"";
        break;
    case 8:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X2_PIXELS_NV\"";
        break;
    case 9:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X2_PIXELS_NV\"";
        break;
    case 10:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X4_PIXELS_NV\"";
        break;
    case 11:
        settings.stream() << "\"VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X4_PIXELS_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkCoarseSampleOrderTypeNV(VkCoarseSampleOrderTypeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_COARSE_SAMPLE_ORDER_TYPE_PIXEL_MAJOR_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_COARSE_SAMPLE_ORDER_TYPE_SAMPLE_MAJOR_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkRayTracingShaderGroupTypeKHR(VkRayTracingShaderGroupTypeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkAccelerationStructureMemoryRequirementsTypeNV(VkAccelerationStructureMemoryRequirementsTypeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkTimeDomainKHR(VkTimeDomainKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_TIME_DOMAIN_DEVICE_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_TIME_DOMAIN_CLOCK_MONOTONIC_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkMemoryOverallocationBehaviorAMD(VkMemoryOverallocationBehaviorAMD object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_MEMORY_OVERALLOCATION_BEHAVIOR_DEFAULT_AMD\"";
        break;
    case 1:
        settings.stream() << "\"VK_MEMORY_OVERALLOCATION_BEHAVIOR_ALLOWED_AMD\"";
        break;
    case 2:
        settings.stream() << "\"VK_MEMORY_OVERALLOCATION_BEHAVIOR_DISALLOWED_AMD\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPerformanceConfigurationTypeINTEL(VkPerformanceConfigurationTypeINTEL object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PERFORMANCE_CONFIGURATION_TYPE_COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED_INTEL\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkQueryPoolSamplingModeINTEL(VkQueryPoolSamplingModeINTEL object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_QUERY_POOL_SAMPLING_MODE_MANUAL_INTEL\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPerformanceOverrideTypeINTEL(VkPerformanceOverrideTypeINTEL object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PERFORMANCE_OVERRIDE_TYPE_NULL_HARDWARE_INTEL\"";
        break;
    case 1:
        settings.stream() << "\"VK_PERFORMANCE_OVERRIDE_TYPE_FLUSH_GPU_CACHES_INTEL\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPerformanceParameterTypeINTEL(VkPerformanceParameterTypeINTEL object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PERFORMANCE_PARAMETER_TYPE_HW_COUNTERS_SUPPORTED_INTEL\"";
        break;
    case 1:
        settings.stream() << "\"VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPerformanceValueTypeINTEL(VkPerformanceValueTypeINTEL object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PERFORMANCE_VALUE_TYPE_UINT32_INTEL\"";
        break;
    case 1:
        settings.stream() << "\"VK_PERFORMANCE_VALUE_TYPE_UINT64_INTEL\"";
        break;
    case 2:
        settings.stream() << "\"VK_PERFORMANCE_VALUE_TYPE_FLOAT_INTEL\"";
        break;
    case 3:
        settings.stream() << "\"VK_PERFORMANCE_VALUE_TYPE_BOOL_INTEL\"";
        break;
    case 4:
        settings.stream() << "\"VK_PERFORMANCE_VALUE_TYPE_STRING_INTEL\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkFragmentShadingRateCombinerOpKHR(VkFragmentShadingRateCombinerOpKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_KHR\"";
        break;
    case 4:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkValidationFeatureEnableEXT(VkValidationFeatureEnableEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_VALIDATION_FEATURE_ENABLE_BEST_PRACTICES_EXT\"";
        break;
    case 3:
        settings.stream() << "\"VK_VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT\"";
        break;
    case 4:
        settings.stream() << "\"VK_VALIDATION_FEATURE_ENABLE_SYNCHRONIZATION_VALIDATION_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkValidationFeatureDisableEXT(VkValidationFeatureDisableEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_VALIDATION_FEATURE_DISABLE_ALL_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_VALIDATION_FEATURE_DISABLE_SHADERS_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_VALIDATION_FEATURE_DISABLE_THREAD_SAFETY_EXT\"";
        break;
    case 3:
        settings.stream() << "\"VK_VALIDATION_FEATURE_DISABLE_API_PARAMETERS_EXT\"";
        break;
    case 4:
        settings.stream() << "\"VK_VALIDATION_FEATURE_DISABLE_OBJECT_LIFETIMES_EXT\"";
        break;
    case 5:
        settings.stream() << "\"VK_VALIDATION_FEATURE_DISABLE_CORE_CHECKS_EXT\"";
        break;
    case 6:
        settings.stream() << "\"VK_VALIDATION_FEATURE_DISABLE_UNIQUE_HANDLES_EXT\"";
        break;
    case 7:
        settings.stream() << "\"VK_VALIDATION_FEATURE_DISABLE_SHADER_VALIDATION_CACHE_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkComponentTypeKHR(VkComponentTypeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COMPONENT_TYPE_FLOAT16_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_COMPONENT_TYPE_FLOAT32_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_COMPONENT_TYPE_FLOAT64_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_COMPONENT_TYPE_SINT8_KHR\"";
        break;
    case 4:
        settings.stream() << "\"VK_COMPONENT_TYPE_SINT16_KHR\"";
        break;
    case 5:
        settings.stream() << "\"VK_COMPONENT_TYPE_SINT32_KHR\"";
        break;
    case 6:
        settings.stream() << "\"VK_COMPONENT_TYPE_SINT64_KHR\"";
        break;
    case 7:
        settings.stream() << "\"VK_COMPONENT_TYPE_UINT8_KHR\"";
        break;
    case 8:
        settings.stream() << "\"VK_COMPONENT_TYPE_UINT16_KHR\"";
        break;
    case 9:
        settings.stream() << "\"VK_COMPONENT_TYPE_UINT32_KHR\"";
        break;
    case 10:
        settings.stream() << "\"VK_COMPONENT_TYPE_UINT64_KHR\"";
        break;
    case 1000141000:
        settings.stream() << "\"VK_COMPONENT_TYPE_BFLOAT16_KHR\"";
        break;
    case 1000491000:
        settings.stream() << "\"VK_COMPONENT_TYPE_SINT8_PACKED_NV\"";
        break;
    case 1000491001:
        settings.stream() << "\"VK_COMPONENT_TYPE_UINT8_PACKED_NV\"";
        break;
    case 1000491002:
        settings.stream() << "\"VK_COMPONENT_TYPE_FLOAT_E4M3_NV\"";
        break;
    case 1000491003:
        settings.stream() << "\"VK_COMPONENT_TYPE_FLOAT_E5M2_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkScopeKHR(VkScopeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "\"VK_SCOPE_DEVICE_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_SCOPE_WORKGROUP_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_SCOPE_SUBGROUP_KHR\"";
        break;
    case 5:
        settings.stream() << "\"VK_SCOPE_QUEUE_FAMILY_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkCoverageReductionModeNV(VkCoverageReductionModeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COVERAGE_REDUCTION_MODE_MERGE_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_COVERAGE_REDUCTION_MODE_TRUNCATE_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkProvokingVertexModeEXT(VkProvokingVertexModeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PROVOKING_VERTEX_MODE_FIRST_VERTEX_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_PROVOKING_VERTEX_MODE_LAST_VERTEX_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_json_VkFullScreenExclusiveEXT(VkFullScreenExclusiveEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_FULL_SCREEN_EXCLUSIVE_DEFAULT_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_FULL_SCREEN_EXCLUSIVE_ALLOWED_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_FULL_SCREEN_EXCLUSIVE_DISALLOWED_EXT\"";
        break;
    case 3:
        settings.stream() << "\"VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR
void dump_json_VkPipelineExecutableStatisticFormatKHR(VkPipelineExecutableStatisticFormatKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkIndirectCommandsTokenTypeNV(VkIndirectCommandsTokenTypeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV\"";
        break;
    case 4:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV\"";
        break;
    case 5:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV\"";
        break;
    case 6:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV\"";
        break;
    case 7:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV\"";
        break;
    case 1000328000:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_NV\"";
        break;
    case 1000428003:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV\"";
        break;
    case 1000428004:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DISPATCH_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDepthBiasRepresentationEXT(VkDepthBiasRepresentationEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DEPTH_BIAS_REPRESENTATION_LEAST_REPRESENTABLE_VALUE_FORMAT_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_DEPTH_BIAS_REPRESENTATION_LEAST_REPRESENTABLE_VALUE_FORCE_UNORM_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_DEPTH_BIAS_REPRESENTATION_FLOAT_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDeviceMemoryReportEventTypeEXT(VkDeviceMemoryReportEventTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATE_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_FREE_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_IMPORT_EXT\"";
        break;
    case 3:
        settings.stream() << "\"VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_UNIMPORT_EXT\"";
        break;
    case 4:
        settings.stream() << "\"VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATION_FAILED_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkVideoEncodeTuningModeKHR(VkVideoEncodeTuningModeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_VIDEO_ENCODE_TUNING_MODE_DEFAULT_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_VIDEO_ENCODE_TUNING_MODE_HIGH_QUALITY_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_VIDEO_ENCODE_TUNING_MODE_LOW_LATENCY_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_VIDEO_ENCODE_TUNING_MODE_ULTRA_LOW_LATENCY_KHR\"";
        break;
    case 4:
        settings.stream() << "\"VK_VIDEO_ENCODE_TUNING_MODE_LOSSLESS_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkFragmentShadingRateTypeNV(VkFragmentShadingRateTypeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_TYPE_ENUMS_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkFragmentShadingRateNV(VkFragmentShadingRateNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV\"";
        break;
    case 4:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV\"";
        break;
    case 5:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV\"";
        break;
    case 6:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV\"";
        break;
    case 9:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV\"";
        break;
    case 10:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV\"";
        break;
    case 11:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV\"";
        break;
    case 12:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV\"";
        break;
    case 13:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV\"";
        break;
    case 14:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV\"";
        break;
    case 15:
        settings.stream() << "\"VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkAccelerationStructureMotionInstanceTypeNV(VkAccelerationStructureMotionInstanceTypeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDeviceFaultAddressTypeEXT(VkDeviceFaultAddressTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DEVICE_FAULT_ADDRESS_TYPE_NONE_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_DEVICE_FAULT_ADDRESS_TYPE_READ_INVALID_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_DEVICE_FAULT_ADDRESS_TYPE_WRITE_INVALID_EXT\"";
        break;
    case 3:
        settings.stream() << "\"VK_DEVICE_FAULT_ADDRESS_TYPE_EXECUTE_INVALID_EXT\"";
        break;
    case 4:
        settings.stream() << "\"VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_UNKNOWN_EXT\"";
        break;
    case 5:
        settings.stream() << "\"VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_INVALID_EXT\"";
        break;
    case 6:
        settings.stream() << "\"VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_FAULT_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDeviceFaultVendorBinaryHeaderVersionEXT(VkDeviceFaultVendorBinaryHeaderVersionEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "\"VK_DEVICE_FAULT_VENDOR_BINARY_HEADER_VERSION_ONE_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkShaderGroupShaderKHR(VkShaderGroupShaderKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SHADER_GROUP_SHADER_GENERAL_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_SHADER_GROUP_SHADER_CLOSEST_HIT_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_SHADER_GROUP_SHADER_ANY_HIT_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_SHADER_GROUP_SHADER_INTERSECTION_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDeviceAddressBindingTypeEXT(VkDeviceAddressBindingTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DEVICE_ADDRESS_BINDING_TYPE_BIND_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_DEVICE_ADDRESS_BINDING_TYPE_UNBIND_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkMicromapTypeEXT(VkMicromapTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_MICROMAP_TYPE_OPACITY_MICROMAP_EXT\"";
        break;
    case 1000397000:
        settings.stream() << "\"VK_MICROMAP_TYPE_DISPLACEMENT_MICROMAP_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkBuildMicromapModeEXT(VkBuildMicromapModeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_BUILD_MICROMAP_MODE_BUILD_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkCopyMicromapModeEXT(VkCopyMicromapModeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COPY_MICROMAP_MODE_CLONE_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_COPY_MICROMAP_MODE_SERIALIZE_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_COPY_MICROMAP_MODE_DESERIALIZE_EXT\"";
        break;
    case 3:
        settings.stream() << "\"VK_COPY_MICROMAP_MODE_COMPACT_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkOpacityMicromapFormatEXT(VkOpacityMicromapFormatEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "\"VK_OPACITY_MICROMAP_FORMAT_2_STATE_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_OPACITY_MICROMAP_FORMAT_4_STATE_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkOpacityMicromapSpecialIndexEXT(VkOpacityMicromapSpecialIndexEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case -1:
        settings.stream() << "\"VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_TRANSPARENT_EXT\"";
        break;
    case -2:
        settings.stream() << "\"VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_OPAQUE_EXT\"";
        break;
    case -3:
        settings.stream() << "\"VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_UNKNOWN_TRANSPARENT_EXT\"";
        break;
    case -4:
        settings.stream() << "\"VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_UNKNOWN_OPAQUE_EXT\"";
        break;
    case -5:
        settings.stream() << "\"VK_OPACITY_MICROMAP_SPECIAL_INDEX_CLUSTER_GEOMETRY_DISABLE_OPACITY_MICROMAP_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
void dump_json_VkDisplacementMicromapFormatNV(VkDisplacementMicromapFormatNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 1:
        settings.stream() << "\"VK_DISPLACEMENT_MICROMAP_FORMAT_64_TRIANGLES_64_BYTES_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_DISPLACEMENT_MICROMAP_FORMAT_256_TRIANGLES_128_BYTES_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_DISPLACEMENT_MICROMAP_FORMAT_1024_TRIANGLES_128_BYTES_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS
void dump_json_VkRayTracingLssIndexingModeNV(VkRayTracingLssIndexingModeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_RAY_TRACING_LSS_INDEXING_MODE_LIST_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_RAY_TRACING_LSS_INDEXING_MODE_SUCCESSIVE_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkRayTracingLssPrimitiveEndCapsModeNV(VkRayTracingLssPrimitiveEndCapsModeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_RAY_TRACING_LSS_PRIMITIVE_END_CAPS_MODE_NONE_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_RAY_TRACING_LSS_PRIMITIVE_END_CAPS_MODE_CHAINED_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkSubpassMergeStatusEXT(VkSubpassMergeStatusEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_MERGED_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_DISALLOWED_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SIDE_EFFECTS_EXT\"";
        break;
    case 3:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SAMPLES_MISMATCH_EXT\"";
        break;
    case 4:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_VIEWS_MISMATCH_EXT\"";
        break;
    case 5:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_ALIASING_EXT\"";
        break;
    case 6:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_DEPENDENCIES_EXT\"";
        break;
    case 7:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_INCOMPATIBLE_INPUT_ATTACHMENT_EXT\"";
        break;
    case 8:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_TOO_MANY_ATTACHMENTS_EXT\"";
        break;
    case 9:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_INSUFFICIENT_STORAGE_EXT\"";
        break;
    case 10:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_DEPTH_STENCIL_COUNT_EXT\"";
        break;
    case 11:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_RESOLVE_ATTACHMENT_REUSE_EXT\"";
        break;
    case 12:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SINGLE_SUBPASS_EXT\"";
        break;
    case 13:
        settings.stream() << "\"VK_SUBPASS_MERGE_STATUS_NOT_MERGED_UNSPECIFIED_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDirectDriverLoadingModeLUNARG(VkDirectDriverLoadingModeLUNARG object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DIRECT_DRIVER_LOADING_MODE_EXCLUSIVE_LUNARG\"";
        break;
    case 1:
        settings.stream() << "\"VK_DIRECT_DRIVER_LOADING_MODE_INCLUSIVE_LUNARG\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkOpticalFlowPerformanceLevelNV(VkOpticalFlowPerformanceLevelNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_UNKNOWN_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_SLOW_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_MEDIUM_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_FAST_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkOpticalFlowSessionBindingPointNV(VkOpticalFlowSessionBindingPointNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_OPTICAL_FLOW_SESSION_BINDING_POINT_UNKNOWN_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_OPTICAL_FLOW_SESSION_BINDING_POINT_INPUT_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_OPTICAL_FLOW_SESSION_BINDING_POINT_REFERENCE_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_OPTICAL_FLOW_SESSION_BINDING_POINT_HINT_NV\"";
        break;
    case 4:
        settings.stream() << "\"VK_OPTICAL_FLOW_SESSION_BINDING_POINT_FLOW_VECTOR_NV\"";
        break;
    case 5:
        settings.stream() << "\"VK_OPTICAL_FLOW_SESSION_BINDING_POINT_BACKWARD_FLOW_VECTOR_NV\"";
        break;
    case 6:
        settings.stream() << "\"VK_OPTICAL_FLOW_SESSION_BINDING_POINT_COST_NV\"";
        break;
    case 7:
        settings.stream() << "\"VK_OPTICAL_FLOW_SESSION_BINDING_POINT_BACKWARD_COST_NV\"";
        break;
    case 8:
        settings.stream() << "\"VK_OPTICAL_FLOW_SESSION_BINDING_POINT_GLOBAL_FLOW_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkAntiLagModeAMD(VkAntiLagModeAMD object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_ANTI_LAG_MODE_DRIVER_CONTROL_AMD\"";
        break;
    case 1:
        settings.stream() << "\"VK_ANTI_LAG_MODE_ON_AMD\"";
        break;
    case 2:
        settings.stream() << "\"VK_ANTI_LAG_MODE_OFF_AMD\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkAntiLagStageAMD(VkAntiLagStageAMD object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_ANTI_LAG_STAGE_INPUT_AMD\"";
        break;
    case 1:
        settings.stream() << "\"VK_ANTI_LAG_STAGE_PRESENT_AMD\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkShaderCodeTypeEXT(VkShaderCodeTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_SHADER_CODE_TYPE_BINARY_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_SHADER_CODE_TYPE_SPIRV_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDepthClampModeEXT(VkDepthClampModeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DEPTH_CLAMP_MODE_VIEWPORT_RANGE_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_DEPTH_CLAMP_MODE_USER_DEFINED_RANGE_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkRayTracingInvocationReorderModeNV(VkRayTracingInvocationReorderModeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_RAY_TRACING_INVOCATION_REORDER_MODE_NONE_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_RAY_TRACING_INVOCATION_REORDER_MODE_REORDER_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkCooperativeVectorMatrixLayoutNV(VkCooperativeVectorMatrixLayoutNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_ROW_MAJOR_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_COLUMN_MAJOR_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_INFERENCING_OPTIMAL_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_TRAINING_OPTIMAL_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkLayerSettingTypeEXT(VkLayerSettingTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_LAYER_SETTING_TYPE_BOOL32_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_LAYER_SETTING_TYPE_INT32_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_LAYER_SETTING_TYPE_INT64_EXT\"";
        break;
    case 3:
        settings.stream() << "\"VK_LAYER_SETTING_TYPE_UINT32_EXT\"";
        break;
    case 4:
        settings.stream() << "\"VK_LAYER_SETTING_TYPE_UINT64_EXT\"";
        break;
    case 5:
        settings.stream() << "\"VK_LAYER_SETTING_TYPE_FLOAT32_EXT\"";
        break;
    case 6:
        settings.stream() << "\"VK_LAYER_SETTING_TYPE_FLOAT64_EXT\"";
        break;
    case 7:
        settings.stream() << "\"VK_LAYER_SETTING_TYPE_STRING_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkLatencyMarkerNV(VkLatencyMarkerNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_LATENCY_MARKER_SIMULATION_START_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_LATENCY_MARKER_SIMULATION_END_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_LATENCY_MARKER_RENDERSUBMIT_START_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_LATENCY_MARKER_RENDERSUBMIT_END_NV\"";
        break;
    case 4:
        settings.stream() << "\"VK_LATENCY_MARKER_PRESENT_START_NV\"";
        break;
    case 5:
        settings.stream() << "\"VK_LATENCY_MARKER_PRESENT_END_NV\"";
        break;
    case 6:
        settings.stream() << "\"VK_LATENCY_MARKER_INPUT_SAMPLE_NV\"";
        break;
    case 7:
        settings.stream() << "\"VK_LATENCY_MARKER_TRIGGER_FLASH_NV\"";
        break;
    case 8:
        settings.stream() << "\"VK_LATENCY_MARKER_OUT_OF_BAND_RENDERSUBMIT_START_NV\"";
        break;
    case 9:
        settings.stream() << "\"VK_LATENCY_MARKER_OUT_OF_BAND_RENDERSUBMIT_END_NV\"";
        break;
    case 10:
        settings.stream() << "\"VK_LATENCY_MARKER_OUT_OF_BAND_PRESENT_START_NV\"";
        break;
    case 11:
        settings.stream() << "\"VK_LATENCY_MARKER_OUT_OF_BAND_PRESENT_END_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkOutOfBandQueueTypeNV(VkOutOfBandQueueTypeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_OUT_OF_BAND_QUEUE_TYPE_RENDER_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_OUT_OF_BAND_QUEUE_TYPE_PRESENT_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkVideoEncodeAV1PredictionModeKHR(VkVideoEncodeAV1PredictionModeKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_INTRA_ONLY_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_SINGLE_REFERENCE_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_UNIDIRECTIONAL_COMPOUND_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_BIDIRECTIONAL_COMPOUND_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkVideoEncodeAV1RateControlGroupKHR(VkVideoEncodeAV1RateControlGroupKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_VIDEO_ENCODE_AV1_RATE_CONTROL_GROUP_INTRA_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_VIDEO_ENCODE_AV1_RATE_CONTROL_GROUP_PREDICTIVE_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_VIDEO_ENCODE_AV1_RATE_CONTROL_GROUP_BIPREDICTIVE_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkBlockMatchWindowCompareModeQCOM(VkBlockMatchWindowCompareModeQCOM object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_BLOCK_MATCH_WINDOW_COMPARE_MODE_MIN_QCOM\"";
        break;
    case 1:
        settings.stream() << "\"VK_BLOCK_MATCH_WINDOW_COMPARE_MODE_MAX_QCOM\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkCubicFilterWeightsQCOM(VkCubicFilterWeightsQCOM object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_CUBIC_FILTER_WEIGHTS_CATMULL_ROM_QCOM\"";
        break;
    case 1:
        settings.stream() << "\"VK_CUBIC_FILTER_WEIGHTS_ZERO_TANGENT_CARDINAL_QCOM\"";
        break;
    case 2:
        settings.stream() << "\"VK_CUBIC_FILTER_WEIGHTS_B_SPLINE_QCOM\"";
        break;
    case 3:
        settings.stream() << "\"VK_CUBIC_FILTER_WEIGHTS_MITCHELL_NETRAVALI_QCOM\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkLayeredDriverUnderlyingApiMSFT(VkLayeredDriverUnderlyingApiMSFT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_LAYERED_DRIVER_UNDERLYING_API_NONE_MSFT\"";
        break;
    case 1:
        settings.stream() << "\"VK_LAYERED_DRIVER_UNDERLYING_API_D3D12_MSFT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkDisplaySurfaceStereoTypeNV(VkDisplaySurfaceStereoTypeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_DISPLAY_SURFACE_STEREO_TYPE_NONE_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_DISPLAY_SURFACE_STEREO_TYPE_ONBOARD_DIN_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_DISPLAY_SURFACE_STEREO_TYPE_HDMI_3D_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_DISPLAY_SURFACE_STEREO_TYPE_INBAND_DISPLAYPORT_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPhysicalDeviceLayeredApiKHR(VkPhysicalDeviceLayeredApiKHR object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PHYSICAL_DEVICE_LAYERED_API_VULKAN_KHR\"";
        break;
    case 1:
        settings.stream() << "\"VK_PHYSICAL_DEVICE_LAYERED_API_D3D12_KHR\"";
        break;
    case 2:
        settings.stream() << "\"VK_PHYSICAL_DEVICE_LAYERED_API_METAL_KHR\"";
        break;
    case 3:
        settings.stream() << "\"VK_PHYSICAL_DEVICE_LAYERED_API_OPENGL_KHR\"";
        break;
    case 4:
        settings.stream() << "\"VK_PHYSICAL_DEVICE_LAYERED_API_OPENGLES_KHR\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkClusterAccelerationStructureTypeNV(VkClusterAccelerationStructureTypeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_TYPE_CLUSTERS_BOTTOM_LEVEL_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_TYPE_TRIANGLE_CLUSTER_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_TYPE_TRIANGLE_CLUSTER_TEMPLATE_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkClusterAccelerationStructureOpTypeNV(VkClusterAccelerationStructureOpTypeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_CLUSTERS_BOTTOM_LEVEL_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_NV\"";
        break;
    case 3:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_TEMPLATE_NV\"";
        break;
    case 4:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_INSTANTIATE_TRIANGLE_CLUSTER_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkClusterAccelerationStructureOpModeNV(VkClusterAccelerationStructureOpModeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_IMPLICIT_DESTINATIONS_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_EXPLICIT_DESTINATIONS_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_COMPUTE_SIZES_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkPartitionedAccelerationStructureOpTypeNV(VkPartitionedAccelerationStructureOpTypeNV object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_PARTITIONED_ACCELERATION_STRUCTURE_OP_TYPE_WRITE_INSTANCE_NV\"";
        break;
    case 1:
        settings.stream() << "\"VK_PARTITIONED_ACCELERATION_STRUCTURE_OP_TYPE_UPDATE_INSTANCE_NV\"";
        break;
    case 2:
        settings.stream() << "\"VK_PARTITIONED_ACCELERATION_STRUCTURE_OP_TYPE_WRITE_PARTITION_TRANSLATION_NV\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkIndirectExecutionSetInfoTypeEXT(VkIndirectExecutionSetInfoTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_INDIRECT_EXECUTION_SET_INFO_TYPE_PIPELINES_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_INDIRECT_EXECUTION_SET_INFO_TYPE_SHADER_OBJECTS_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}
void dump_json_VkIndirectCommandsTokenTypeEXT(VkIndirectCommandsTokenTypeEXT object, const ApiDumpSettings& settings, int indents)
{
    switch((int64_t) object)
    {
    case 0:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_EXECUTION_SET_EXT\"";
        break;
    case 1:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_EXT\"";
        break;
    case 2:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_SEQUENCE_INDEX_EXT\"";
        break;
    case 3:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_EXT\"";
        break;
    case 4:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_EXT\"";
        break;
    case 5:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_EXT\"";
        break;
    case 6:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_EXT\"";
        break;
    case 7:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_COUNT_EXT\"";
        break;
    case 8:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_COUNT_EXT\"";
        break;
    case 9:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DISPATCH_EXT\"";
        break;
    case 1000202002:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_NV_EXT\"";
        break;
    case 1000202003:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_COUNT_NV_EXT\"";
        break;
    case 1000328000:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_EXT\"";
        break;
    case 1000328001:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_COUNT_EXT\"";
        break;
    case 1000386004:
        settings.stream() << "\"VK_INDIRECT_COMMANDS_TOKEN_TYPE_TRACE_RAYS2_EXT\"";
        break;
    default:
        settings.stream() << "\"UNKNOWN (" << object << ")\"";
    }
}

//========================= Bitmask Implementations =========================//

void dump_json_VkAccessFlagBits(VkAccessFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_INDIRECT_COMMAND_READ_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_INDEX_READ_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_UNIFORM_READ_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_INPUT_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_SHADER_READ_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_SHADER_WRITE_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COLOR_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFER_READ_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFER_WRITE_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_HOST_READ_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_HOST_WRITE_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_MEMORY_READ_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_MEMORY_WRITE_BIT"; is_first = false;
    }
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_NONE"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkImageAspectFlagBits(VkImageAspectFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_COLOR_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_DEPTH_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_STENCIL_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_METADATA_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_PLANE_0_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_PLANE_1_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_PLANE_2_BIT"; is_first = false;
    }
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_NONE"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkFormatFeatureFlagBits(VkFormatFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_BLIT_SRC_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_BLIT_DST_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_TRANSFER_SRC_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_TRANSFER_DST_BIT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_DISJOINT_BIT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR"; is_first = false;
    }
    if(object & 536870912) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT"; is_first = false;
    }
    if(object & 1073741824) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkImageCreateFlagBits(VkImageCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPARSE_BINDING_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPARSE_ALIASED_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_ALIAS_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_EXTENDED_USAGE_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_PROTECTED_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_DISJOINT_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_RESERVED_19_BIT_EXT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSampleCountFlagBits(VkSampleCountFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_1_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_2_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_4_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_8_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_16_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_32_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_64_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkImageUsageFlagBits(VkImageUsageFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TRANSFER_SRC_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TRANSFER_DST_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_SAMPLED_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_STORAGE_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_HOST_TRANSFER_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_SAMPLE_WEIGHT_BIT_QCOM"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_SAMPLE_BLOCK_MATCH_BIT_QCOM"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_RESERVED_24_BIT_COREAVI"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_RESERVED_23_BIT_EXT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TILE_MEMORY_QCOM"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkInstanceCreateFlagBits(VkInstanceCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INSTANCE_CREATE_ENUMERATE_PORTABILITY_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkMemoryHeapFlagBits(VkMemoryHeapFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_HEAP_DEVICE_LOCAL_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_HEAP_MULTI_INSTANCE_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkMemoryPropertyFlagBits(VkMemoryPropertyFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_HOST_COHERENT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_HOST_CACHED_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_PROTECTED_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkQueueFlagBits(VkQueueFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_GRAPHICS_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_COMPUTE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_TRANSFER_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_SPARSE_BINDING_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_PROTECTED_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_VIDEO_DECODE_BIT_KHR"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_RESERVED_9_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_VIDEO_ENCODE_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_RESERVED_7_BIT_QCOM"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_RESERVED_11_BIT_ARM"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_OPTICAL_FLOW_BIT_NV"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_RESERVED_10_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDeviceQueueCreateFlagBits(VkDeviceQueueCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_QUEUE_CREATE_RESERVED_1_BIT_QCOM"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_QUEUE_CREATE_RESERVED_2_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineStageFlagBits(VkPipelineStageFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_VERTEX_INPUT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_VERTEX_SHADER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TRANSFER_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_HOST_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_ALL_COMMANDS_BIT"; is_first = false;
    }
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_NONE"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TASK_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_MESH_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkMemoryMapFlagBits(VkMemoryMapFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_MAP_PLACED_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSparseMemoryBindFlagBits(VkSparseMemoryBindFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_MEMORY_BIND_METADATA_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSparseImageFormatFlagBits(VkSparseImageFormatFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkFenceCreateFlagBits(VkFenceCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FENCE_CREATE_SIGNALED_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkEventCreateFlagBits(VkEventCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EVENT_CREATE_DEVICE_ONLY_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkQueryPipelineStatisticFlagBits(VkQueryPipelineStatisticFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_TASK_SHADER_INVOCATIONS_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_MESH_SHADER_INVOCATIONS_BIT_EXT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_CLUSTER_CULLING_SHADER_INVOCATIONS_BIT_HUAWEI"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkQueryResultFlagBits(VkQueryResultFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_64_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_WAIT_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_WITH_AVAILABILITY_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_PARTIAL_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_WITH_STATUS_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkBufferCreateFlagBits(VkBufferCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_SPARSE_BINDING_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_SPARSE_ALIASED_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_PROTECTED_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkBufferUsageFlagBits(VkBufferUsageFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFER_SRC_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFER_DST_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_STORAGE_BUFFER_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_INDEX_BUFFER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VERTEX_BUFFER_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_EXECUTION_GRAPH_SCRATCH_BIT_AMDX"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_RESERVED_28_BIT_KHR"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_MICROMAP_STORAGE_BIT_EXT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TILE_MEMORY_QCOM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkImageViewCreateFlagBits(VkImageViewCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineCacheCreateFlagBits(VkPipelineCacheCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CACHE_CREATE_INTERNALLY_SYNCHRONIZED_MERGE_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkColorComponentFlagBits(VkColorComponentFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_R_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_G_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_B_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_A_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineCreateFlagBits(VkPipelineCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DERIVATIVE_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DISPATCH_BASE_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT"; is_first = false;
    }
    if(object & 1073741824) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_LIBRARY_BIT_KHR"; is_first = false;
    }
    if(object & 536870912) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineShaderStageCreateFlagBits(VkPipelineShaderStageCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_SHADER_STAGE_CREATE_RESERVED_3_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkShaderStageFlagBits(VkShaderStageFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_VERTEX_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_GEOMETRY_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_FRAGMENT_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_COMPUTE_BIT"; is_first = false;
    }
    if(object == 0x0000001F) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_ALL_GRAPHICS"; is_first = false;
    }
    if(object == 0x7FFFFFFF) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_ALL"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_RAYGEN_BIT_KHR"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_ANY_HIT_BIT_KHR"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_MISS_BIT_KHR"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_INTERSECTION_BIT_KHR"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_CALLABLE_BIT_KHR"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_TASK_BIT_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_MESH_BIT_EXT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_SUBPASS_SHADING_BIT_HUAWEI"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_CLUSTER_CULLING_BIT_HUAWEI"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_RESERVED_15_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkCullModeFlagBits(VkCullModeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_NONE"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_FRONT_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_BACK_BIT"; is_first = false;
    }
    if(object == 0x00000003) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_FRONT_AND_BACK"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineDepthStencilStateCreateFlagBits(VkPipelineDepthStencilStateCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineColorBlendStateCreateFlagBits(VkPipelineColorBlendStateCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineLayoutCreateFlagBits(VkPipelineLayoutCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_LAYOUT_CREATE_RESERVED_0_BIT_AMD"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSamplerCreateFlagBits(VkSamplerCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_NON_SEAMLESS_CUBE_MAP_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDescriptorPoolCreateFlagBits(VkDescriptorPoolCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_POOLS_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDescriptorSetLayoutCreateFlagBits(VkDescriptorSetLayoutCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_RESERVED_3_BIT_AMD"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_INDIRECT_BINDABLE_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkAttachmentDescriptionFlagBits(VkAttachmentDescriptionFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDependencyFlagBits(VkDependencyFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_BY_REGION_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_DEVICE_GROUP_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_VIEW_LOCAL_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_FEEDBACK_LOOP_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_QUEUE_FAMILY_OWNERSHIP_TRANSFER_USE_ALL_STAGES_BIT_KHR"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_EXTENSION_585_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_EXTENSION_586_BIT_IMG"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkFramebufferCreateFlagBits(VkFramebufferCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkRenderPassCreateFlagBits(VkRenderPassCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDER_PASS_CREATE_RESERVED_0_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDER_PASS_CREATE_RESERVED_2_BIT_VALVE"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSubpassDescriptionFlagBits(VkSubpassDescriptionFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_TILE_SHADING_APRON_BIT_QCOM"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_ENABLE_LEGACY_DITHERING_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkCommandPoolCreateFlagBits(VkCommandPoolCreateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_CREATE_TRANSIENT_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_CREATE_PROTECTED_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkCommandPoolResetFlagBits(VkCommandPoolResetFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_RESET_RESERVED_1_BIT_COREAVI"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkCommandBufferUsageFlagBits(VkCommandBufferUsageFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkQueryControlFlagBits(VkQueryControlFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_CONTROL_PRECISE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkCommandBufferResetFlagBits(VkCommandBufferResetFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkStencilFaceFlagBits(VkStencilFaceFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_STENCIL_FACE_FRONT_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_STENCIL_FACE_BACK_BIT"; is_first = false;
    }
    if(object == 0x00000003) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_STENCIL_FACE_FRONT_AND_BACK"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSubgroupFeatureFlagBits(VkSubgroupFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_BASIC_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_VOTE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_ARITHMETIC_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_BALLOT_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_SHUFFLE_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_CLUSTERED_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_QUAD_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_ROTATE_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_ROTATE_CLUSTERED_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_PARTITIONED_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPeerMemoryFeatureFlagBits(VkPeerMemoryFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_COPY_DST_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkMemoryAllocateFlagBits(VkMemoryAllocateFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_EXTENSION_621_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkExternalMemoryHandleTypeFlagBits(VkExternalMemoryHandleTypeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCI_BUF_BIT_NV"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCREEN_BUFFER_BIT_QNX"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_590_BIT_HUAWEI"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_MTLBUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_MTLTEXTURE_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_MTLHEAP_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkExternalMemoryFeatureFlagBits(VkExternalMemoryFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkExternalFenceHandleTypeFlagBits(VkExternalFenceHandleTypeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SCI_SYNC_OBJ_BIT_NV"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SCI_SYNC_FENCE_BIT_NV"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SCI_SYNC_OBJ_BIT_NV"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SCI_SYNC_FENCE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkExternalFenceFeatureFlagBits(VkExternalFenceFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkFenceImportFlagBits(VkFenceImportFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FENCE_IMPORT_TEMPORARY_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSemaphoreImportFlagBits(VkSemaphoreImportFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SEMAPHORE_IMPORT_TEMPORARY_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkExternalSemaphoreHandleTypeFlagBits(VkExternalSemaphoreHandleTypeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_ZIRCON_EVENT_BIT_FUCHSIA"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SCI_SYNC_OBJ_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkExternalSemaphoreFeatureFlagBits(VkExternalSemaphoreFeatureFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkResolveModeFlagBits(VkResolveModeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_NONE"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_SAMPLE_ZERO_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_AVERAGE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_MIN_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_MAX_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_EXTERNAL_FORMAT_DOWNSAMPLE_ANDROID"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDescriptorBindingFlagBits(VkDescriptorBindingFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_RESERVED_4_BIT_QCOM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSemaphoreWaitFlagBits(VkSemaphoreWaitFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SEMAPHORE_WAIT_ANY_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineCreationFeedbackFlagBits(VkPipelineCreationFeedbackFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATION_FEEDBACK_VALID_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkToolPurposeFlagBits(VkToolPurposeFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_VALIDATION_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_PROFILING_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_TRACING_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineStageFlagBits2(VkPipelineStageFlagBits2 object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_NONE"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_HOST_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT"; is_first = false;
    }
    if(object & 4294967296) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COPY_BIT"; is_first = false;
    }
    if(object & 8589934592) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RESOLVE_BIT"; is_first = false;
    }
    if(object & 17179869184) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_BLIT_BIT"; is_first = false;
    }
    if(object & 34359738368) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CLEAR_BIT"; is_first = false;
    }
    if(object & 68719476736) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT"; is_first = false;
    }
    if(object & 137438953472) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT"; is_first = false;
    }
    if(object & 274877906944) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_EXT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 549755813888) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI"; is_first = false;
    }
    if(object & 1099511627776) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR"; is_first = false;
    }
    if(object & 1073741824) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT"; is_first = false;
    }
    if(object & 2199023255552) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI"; is_first = false;
    }
    if(object & 8796093022208) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RESERVED_43_BIT_ARM"; is_first = false;
    }
    if(object & 536870912) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV"; is_first = false;
    }
    if(object & 17592186044416) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV"; is_first = false;
    }
    if(object & 4398046511104) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RESERVED_42_BIT_EXT"; is_first = false;
    }
    if(object & 70368744177664) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RESERVED_46_BIT_NV"; is_first = false;
    }
    if(object & 35184372088832) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RESERVED_45_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkAccessFlagBits2(VkAccessFlagBits2 object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_NONE"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INDEX_READ_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_UNIFORM_READ_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_READ_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_WRITE_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFER_READ_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFER_WRITE_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_HOST_READ_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_HOST_WRITE_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MEMORY_READ_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MEMORY_WRITE_BIT"; is_first = false;
    }
    if(object & 4294967296) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_SAMPLED_READ_BIT"; is_first = false;
    }
    if(object & 8589934592) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_STORAGE_READ_BIT"; is_first = false;
    }
    if(object & 17179869184) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT"; is_first = false;
    }
    if(object & 34359738368) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR"; is_first = false;
    }
    if(object & 68719476736) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR"; is_first = false;
    }
    if(object & 144115188075855872) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_57_BIT_KHR"; is_first = false;
    }
    if(object & 288230376151711744) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_58_BIT_KHR"; is_first = false;
    }
    if(object & 576460752303423488) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_59_BIT_KHR"; is_first = false;
    }
    if(object & 70368744177664) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_46_BIT_INTEL"; is_first = false;
    }
    if(object & 137438953472) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR"; is_first = false;
    }
    if(object & 274877906944) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR"; is_first = false;
    }
    if(object & 2251799813685248) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_TILE_ATTACHMENT_READ_BIT_QCOM"; is_first = false;
    }
    if(object & 4503599627370496) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_TILE_ATTACHMENT_WRITE_BIT_QCOM"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT"; is_first = false;
    }
    if(object & 2199023255552) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT"; is_first = false;
    }
    if(object & 549755813888) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI"; is_first = false;
    }
    if(object & 1099511627776) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR"; is_first = false;
    }
    if(object & 17592186044416) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MICROMAP_READ_BIT_EXT"; is_first = false;
    }
    if(object & 35184372088832) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT"; is_first = false;
    }
    if(object & 562949953421312) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_49_BIT_ARM"; is_first = false;
    }
    if(object & 1125899906842624) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_50_BIT_ARM"; is_first = false;
    }
    if(object & 4398046511104) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV"; is_first = false;
    }
    if(object & 8796093022208) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV"; is_first = false;
    }
    if(object & 140737488355328) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_47_BIT_EXT"; is_first = false;
    }
    if(object & 281474976710656) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_48_BIT_EXT"; is_first = false;
    }
    if(object & 36028797018963968) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_55_BIT_NV"; is_first = false;
    }
    if(object & 72057594037927936) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESERVED_56_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSubmitFlagBits(VkSubmitFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBMIT_PROTECTED_BIT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkRenderingFlagBits(VkRenderingFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_SUSPENDING_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_RESUMING_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_ENABLE_LEGACY_DITHERING_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_CONTENTS_INLINE_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_RESERVED_5_BIT_VALVE"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkFormatFeatureFlagBits2(VkFormatFeatureFlagBits2 object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_IMAGE_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_IMAGE_ATOMIC_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_UNIFORM_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_ATOMIC_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VERTEX_BUFFER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BLEND_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_DEPTH_STENCIL_ATTACHMENT_BIT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BLIT_SRC_BIT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BLIT_DST_BIT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_LINEAR_BIT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_TRANSFER_SRC_BIT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_TRANSFER_DST_BIT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_MINMAX_BIT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_MIDPOINT_CHROMA_SAMPLES_BIT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_DISJOINT_BIT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_COSITED_CHROMA_SAMPLES_BIT"; is_first = false;
    }
    if(object & 2147483648) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_READ_WITHOUT_FORMAT_BIT"; is_first = false;
    }
    if(object & 4294967296) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_WRITE_WITHOUT_FORMAT_BIT"; is_first = false;
    }
    if(object & 8589934592) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_DEPTH_COMPARISON_BIT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_CUBIC_BIT"; is_first = false;
    }
    if(object & 70368744177664) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_HOST_IMAGE_TRANSFER_BIT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_DECODE_OUTPUT_BIT_KHR"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_DECODE_DPB_BIT_KHR"; is_first = false;
    }
    if(object & 536870912) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_FRAGMENT_DENSITY_MAP_BIT_EXT"; is_first = false;
    }
    if(object & 1073741824) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 17592186044416) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_RESERVED_44_BIT_EXT"; is_first = false;
    }
    if(object & 35184372088832) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_RESERVED_45_BIT_EXT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_ENCODE_INPUT_BIT_KHR"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_ENCODE_DPB_BIT_KHR"; is_first = false;
    }
    if(object & 2251799813685248) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_RADIUS_BUFFER_BIT_NV"; is_first = false;
    }
    if(object & 274877906944) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV"; is_first = false;
    }
    if(object & 17179869184) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_WEIGHT_IMAGE_BIT_QCOM"; is_first = false;
    }
    if(object & 34359738368) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_WEIGHT_SAMPLED_IMAGE_BIT_QCOM"; is_first = false;
    }
    if(object & 68719476736) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BLOCK_MATCHING_BIT_QCOM"; is_first = false;
    }
    if(object & 137438953472) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BOX_FILTER_SAMPLED_BIT_QCOM"; is_first = false;
    }
    if(object & 140737488355328) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_RESERVED_47_BIT_ARM"; is_first = false;
    }
    if(object & 549755813888) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_RESERVED_39_BIT_EXT"; is_first = false;
    }
    if(object & 8796093022208) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_RESERVED_43_BIT_EXT"; is_first = false;
    }
    if(object & 1099511627776) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_OPTICAL_FLOW_IMAGE_BIT_NV"; is_first = false;
    }
    if(object & 2199023255552) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_OPTICAL_FLOW_VECTOR_BIT_NV"; is_first = false;
    }
    if(object & 4398046511104) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_OPTICAL_FLOW_COST_BIT_NV"; is_first = false;
    }
    if(object & 281474976710656) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_RESERVED_48_BIT_EXT"; is_first = false;
    }
    if(object & 562949953421312) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR"; is_first = false;
    }
    if(object & 1125899906842624) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkMemoryUnmapFlagBits(VkMemoryUnmapFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_UNMAP_RESERVE_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineCreateFlagBits2(VkPipelineCreateFlagBits2 object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DISABLE_OPTIMIZATION_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_ALLOW_DERIVATIVES_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DERIVATIVE_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_VIEW_INDEX_FROM_DEVICE_INDEX_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DISPATCH_BASE_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_EARLY_RETURN_ON_FAILURE_BIT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_NO_PROTECTED_ACCESS_BIT"; is_first = false;
    }
    if(object & 1073741824) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_PROTECTED_ACCESS_ONLY_BIT"; is_first = false;
    }
    if(object & 4294967296) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX"; is_first = false;
    }
    if(object & 68719476736) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RESERVED_36_BIT_KHR"; is_first = false;
    }
    if(object & 549755813888) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RESERVED_39_BIT_KHR"; is_first = false;
    }
    if(object & 8589934592) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_ALLOW_SPHERES_AND_LINEAR_SWEPT_SPHERES_BIT_NV"; is_first = false;
    }
    if(object & 17179869184) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_ENABLE_LEGACY_DITHERING_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DEFER_COMPILE_BIT_NV"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_CAPTURE_STATISTICS_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_LINK_TIME_OPTIMIZATION_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_LIBRARY_BIT_KHR"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_SKIP_AABBS_BIT_KHR"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_NV"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_ALLOW_MOTION_BIT_NV"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV"; is_first = false;
    }
    if(object & 536870912) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 137438953472) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DISALLOW_OPACITY_MICROMAP_BIT_ARM"; is_first = false;
    }
    if(object & 2147483648) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_CAPTURE_DATA_BIT_KHR"; is_first = false;
    }
    if(object & 274877906944) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT"; is_first = false;
    }
    if(object & 34359738368) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RESERVED_35_BIT_KHR"; is_first = false;
    }
    if(object & 137438953472) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DISALLOW_OPACITY_MICROMAP_BIT_ARM"; is_first = false;
    }
    if(object & 1099511627776) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RESERVED_40_BIT_VALVE"; is_first = false;
    }
    if(object & 2199023255552) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RESERVED_41_BIT_KHR"; is_first = false;
    }
    if(object & 4398046511104) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RESERVED_42_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkBufferUsageFlagBits2(VkBufferUsageFlagBits2 object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_TRANSFER_SRC_BIT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_TRANSFER_DST_BIT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_UNIFORM_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_STORAGE_TEXEL_BUFFER_BIT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_UNIFORM_BUFFER_BIT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_STORAGE_BUFFER_BIT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_INDEX_BUFFER_BIT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_VERTEX_BUFFER_BIT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_INDIRECT_BUFFER_BIT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_SHADER_DEVICE_ADDRESS_BIT"; is_first = false;
    }
    if(object & 33554432) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_EXECUTION_GRAPH_SCRATCH_BIT_AMDX"; is_first = false;
    }
    if(object & 268435456) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_RESERVED_28_BIT_KHR"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_CONDITIONAL_RENDERING_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_SHADER_BINDING_TABLE_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_VIDEO_DECODE_SRC_BIT_KHR"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_VIDEO_DECODE_DST_BIT_KHR"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_VIDEO_ENCODE_DST_BIT_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_VIDEO_ENCODE_SRC_BIT_KHR"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 67108864) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT"; is_first = false;
    }
    if(object & 16777216) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_MICROMAP_STORAGE_BIT_EXT"; is_first = false;
    }
    if(object & 134217728) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_TILE_MEMORY_QCOM"; is_first = false;
    }
    if(object & 4294967296) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_RESERVED_32_BIT_NV"; is_first = false;
    }
    if(object & 2147483648) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_PREPROCESS_BUFFER_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkHostImageCopyFlagBits(VkHostImageCopyFlagBits object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_HOST_IMAGE_COPY_MEMCPY"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSurfaceTransformFlagBitsKHR(VkSurfaceTransformFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkCompositeAlphaFlagBitsKHR(VkCompositeAlphaFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSwapchainCreateFlagBitsKHR(VkSwapchainCreateFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_DEFERRED_MEMORY_ALLOCATION_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_RESERVED_4_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDeviceGroupPresentModeFlagBitsKHR(VkDeviceGroupPresentModeFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDisplayPlaneAlphaFlagBitsKHR(VkDisplayPlaneAlphaFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDebugReportFlagBitsEXT(VkDebugReportFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_INFORMATION_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_WARNING_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_ERROR_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_DEBUG_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoCodecOperationFlagBitsKHR(VkVideoCodecOperationFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_NONE_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_DECODE_AV1_BIT_KHR"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoChromaSubsamplingFlagBitsKHR(VkVideoChromaSubsamplingFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_INVALID_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_MONOCHROME_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_420_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_422_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_444_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoComponentBitDepthFlagBitsKHR(VkVideoComponentBitDepthFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_INVALID_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_8_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_10_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_12_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoCapabilityFlagBitsKHR(VkVideoCapabilityFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CAPABILITY_PROTECTED_CONTENT_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CAPABILITY_SEPARATE_REFERENCE_IMAGES_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoSessionCreateFlagBitsKHR(VkVideoSessionCreateFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_PROTECTED_CONTENT_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_ALLOW_ENCODE_PARAMETER_OPTIMIZATIONS_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_INLINE_QUERIES_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_ALLOW_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_ALLOW_ENCODE_EMPHASIS_MAP_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_INLINE_SESSION_PARAMETERS_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoSessionParametersCreateFlagBitsKHR(VkVideoSessionParametersCreateFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoCodingControlFlagBitsKHR(VkVideoCodingControlFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODING_CONTROL_RESET_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODING_CONTROL_ENCODE_RATE_CONTROL_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODING_CONTROL_ENCODE_QUALITY_LEVEL_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoDecodeCapabilityFlagBitsKHR(VkVideoDecodeCapabilityFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_COINCIDE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_DISTINCT_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoDecodeUsageFlagBitsKHR(VkVideoDecodeUsageFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_DEFAULT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_TRANSCODING_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_OFFLINE_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_STREAMING_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeH264CapabilityFlagBitsKHR(VkVideoEncodeH264CapabilityFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_HRD_COMPLIANCE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_PREDICTION_WEIGHT_TABLE_GENERATED_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_ROW_UNALIGNED_SLICE_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_DIFFERENT_SLICE_TYPE_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_B_FRAME_IN_L0_LIST_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_KHR"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_PER_PICTURE_TYPE_MIN_MAX_QP_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_PER_SLICE_CONSTANT_QP_BIT_KHR"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_GENERATE_PREFIX_NALU_BIT_KHR"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_RESERVED_10_BIT_KHR"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_MB_QP_DIFF_WRAPAROUND_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeH264StdFlagBitsKHR(VkVideoEncodeH264StdFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_SEPARATE_COLOR_PLANE_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_QPPRIME_Y_ZERO_TRANSFORM_BYPASS_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_SCALING_MATRIX_PRESENT_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_CHROMA_QP_INDEX_OFFSET_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_SECOND_CHROMA_QP_INDEX_OFFSET_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_PIC_INIT_QP_MINUS26_BIT_KHR"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_WEIGHTED_PRED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_WEIGHTED_BIPRED_IDC_EXPLICIT_BIT_KHR"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_WEIGHTED_BIPRED_IDC_IMPLICIT_BIT_KHR"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_TRANSFORM_8X8_MODE_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DIRECT_SPATIAL_MV_PRED_FLAG_UNSET_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_ENTROPY_CODING_MODE_FLAG_UNSET_BIT_KHR"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_ENTROPY_CODING_MODE_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DIRECT_8X8_INFERENCE_FLAG_UNSET_BIT_KHR"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_CONSTRAINED_INTRA_PRED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DEBLOCKING_FILTER_DISABLED_BIT_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DEBLOCKING_FILTER_ENABLED_BIT_KHR"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DEBLOCKING_FILTER_PARTIAL_BIT_KHR"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_SLICE_QP_DELTA_BIT_KHR"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DIFFERENT_SLICE_QP_DELTA_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeH264RateControlFlagBitsKHR(VkVideoEncodeH264RateControlFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_ATTEMPT_HRD_COMPLIANCE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_REGULAR_GOP_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_TEMPORAL_LAYER_PATTERN_DYADIC_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeH265CapabilityFlagBitsKHR(VkVideoEncodeH265CapabilityFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_HRD_COMPLIANCE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_PREDICTION_WEIGHT_TABLE_GENERATED_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_ROW_UNALIGNED_SLICE_SEGMENT_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_DIFFERENT_SLICE_SEGMENT_TYPE_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_B_FRAME_IN_L0_LIST_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_KHR"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_PER_PICTURE_TYPE_MIN_MAX_QP_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_PER_SLICE_SEGMENT_CONSTANT_QP_BIT_KHR"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_TILES_PER_SLICE_SEGMENT_BIT_KHR"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_SLICE_SEGMENTS_PER_TILE_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_RESERVED_11_BIT_KHR"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_CU_QP_DIFF_WRAPAROUND_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeH265StdFlagBitsKHR(VkVideoEncodeH265StdFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SEPARATE_COLOR_PLANE_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SAMPLE_ADAPTIVE_OFFSET_ENABLED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SCALING_LIST_DATA_PRESENT_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_PCM_ENABLED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SPS_TEMPORAL_MVP_ENABLED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_INIT_QP_MINUS26_BIT_KHR"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_WEIGHTED_PRED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_WEIGHTED_BIPRED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_LOG2_PARALLEL_MERGE_LEVEL_MINUS2_BIT_KHR"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SIGN_DATA_HIDING_ENABLED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_TRANSFORM_SKIP_ENABLED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_TRANSFORM_SKIP_ENABLED_FLAG_UNSET_BIT_KHR"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_PPS_SLICE_CHROMA_QP_OFFSETS_PRESENT_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_TRANSQUANT_BYPASS_ENABLED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_CONSTRAINED_INTRA_PRED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_ENTROPY_CODING_SYNC_ENABLED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_DEBLOCKING_FILTER_OVERRIDE_ENABLED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_DEPENDENT_SLICE_SEGMENTS_ENABLED_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_DEPENDENT_SLICE_SEGMENT_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SLICE_QP_DELTA_BIT_KHR"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_DIFFERENT_SLICE_QP_DELTA_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeH265CtbSizeFlagBitsKHR(VkVideoEncodeH265CtbSizeFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CTB_SIZE_16_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CTB_SIZE_32_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CTB_SIZE_64_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeH265TransformBlockSizeFlagBitsKHR(VkVideoEncodeH265TransformBlockSizeFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_4_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_8_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_16_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_32_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeH265RateControlFlagBitsKHR(VkVideoEncodeH265RateControlFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_ATTEMPT_HRD_COMPLIANCE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_REGULAR_GOP_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_TEMPORAL_SUB_LAYER_PATTERN_DYADIC_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoDecodeH264PictureLayoutFlagBitsKHR(VkVideoDecodeH264PictureLayoutFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_PROGRESSIVE_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_INTERLEAVED_LINES_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_SEPARATE_PLANES_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkExternalMemoryHandleTypeFlagBitsNV(VkExternalMemoryHandleTypeFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkExternalMemoryFeatureFlagBitsNV(VkExternalMemoryFeatureFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkConditionalRenderingFlagBitsEXT(VkConditionalRenderingFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CONDITIONAL_RENDERING_INVERTED_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkSurfaceCounterFlagBitsEXT(VkSurfaceCounterFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_COUNTER_VBLANK_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPerformanceCounterDescriptionFlagBitsKHR(VkPerformanceCounterDescriptionFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkAcquireProfilingLockFlagBitsKHR(VkAcquireProfilingLockFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDebugUtilsMessageSeverityFlagBitsEXT(VkDebugUtilsMessageSeverityFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDebugUtilsMessageTypeFlagBitsEXT(VkDebugUtilsMessageTypeFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_DEVICE_ADDRESS_BINDING_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkBuildAccelerationStructureFlagBitsKHR(VkBuildAccelerationStructureFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_UPDATE_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DISABLE_OPACITY_MICROMAPS_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_DATA_UPDATE_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DISPLACEMENT_MICROMAP_UPDATE_NV"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkGeometryFlagBitsKHR(VkGeometryFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_OPAQUE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkGeometryInstanceFlagBitsKHR(VkGeometryInstanceFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_FORCE_OPACITY_MICROMAP_2_STATE_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_DISABLE_OPACITY_MICROMAPS_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkAccelerationStructureCreateFlagBitsKHR(VkAccelerationStructureCreateFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPipelineCompilerControlFlagBitsAMD(VkPipelineCompilerControlFlagBitsAMD object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkShaderCorePropertiesFlagBitsAMD(VkShaderCorePropertiesFlagBitsAMD object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPresentScalingFlagBitsEXT(VkPresentScalingFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_SCALING_ONE_TO_ONE_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_SCALING_ASPECT_RATIO_STRETCH_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_SCALING_STRETCH_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPresentGravityFlagBitsEXT(VkPresentGravityFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_GRAVITY_MIN_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_GRAVITY_MAX_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_GRAVITY_CENTERED_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkIndirectStateFlagBitsNV(VkIndirectStateFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_STATE_FLAG_FRONTFACE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkIndirectCommandsLayoutUsageFlagBitsNV(VkIndirectCommandsLayoutUsageFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeFlagBitsKHR(VkVideoEncodeFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RESERVED_2_BIT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_WITH_QUANTIZATION_DELTA_MAP_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_WITH_EMPHASIS_MAP_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeCapabilityFlagBitsKHR(VkVideoEncodeCapabilityFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CAPABILITY_PRECEDING_EXTERNALLY_ENCODED_BYTES_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CAPABILITY_INSUFFICIENT_BITSTREAM_BUFFER_RANGE_DETECTION_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CAPABILITY_QUANTIZATION_DELTA_MAP_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CAPABILITY_EMPHASIS_MAP_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeRateControlModeFlagBitsKHR(VkVideoEncodeRateControlModeFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_DEFAULT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_DISABLED_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_CBR_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_VBR_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeFeedbackFlagBitsKHR(VkVideoEncodeFeedbackFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_BUFFER_OFFSET_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_BYTES_WRITTEN_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_HAS_OVERRIDES_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeUsageFlagBitsKHR(VkVideoEncodeUsageFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_DEFAULT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_TRANSCODING_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_STREAMING_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_RECORDING_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_CONFERENCING_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeContentFlagBitsKHR(VkVideoEncodeContentFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_DEFAULT_KHR"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_CAMERA_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_DESKTOP_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_RENDERED_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDeviceDiagnosticsConfigFlagBitsNV(VkDeviceDiagnosticsConfigFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_DEBUG_INFO_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_RESOURCE_TRACKING_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_AUTOMATIC_CHECKPOINTS_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_ERROR_REPORTING_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkTileShadingRenderPassFlagBitsQCOM(VkTileShadingRenderPassFlagBitsQCOM object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TILE_SHADING_RENDER_PASS_ENABLE_BIT_QCOM"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TILE_SHADING_RENDER_PASS_PER_TILE_EXECUTION_BIT_QCOM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_json_VkExportMetalObjectTypeFlagBitsEXT(VkExportMetalObjectTypeFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_DEVICE_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_COMMAND_QUEUE_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_BUFFER_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_IOSURFACE_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
#endif // VK_USE_PLATFORM_METAL_EXT
void dump_json_VkGraphicsPipelineLibraryFlagBitsEXT(VkGraphicsPipelineLibraryFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkImageCompressionFlagBitsEXT(VkImageCompressionFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_DEFAULT_EXT"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_DEFAULT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_DISABLED_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkImageCompressionFixedRateFlagBitsEXT(VkImageCompressionFixedRateFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_NONE_EXT"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_1BPC_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_2BPC_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_3BPC_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_4BPC_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_5BPC_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_6BPC_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_7BPC_BIT_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_8BPC_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_9BPC_BIT_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_10BPC_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_11BPC_BIT_EXT"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_12BPC_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_13BPC_BIT_EXT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_14BPC_BIT_EXT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_15BPC_BIT_EXT"; is_first = false;
    }
    if(object & 32768) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_16BPC_BIT_EXT"; is_first = false;
    }
    if(object & 65536) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_17BPC_BIT_EXT"; is_first = false;
    }
    if(object & 131072) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_18BPC_BIT_EXT"; is_first = false;
    }
    if(object & 262144) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_19BPC_BIT_EXT"; is_first = false;
    }
    if(object & 524288) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_20BPC_BIT_EXT"; is_first = false;
    }
    if(object & 1048576) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_21BPC_BIT_EXT"; is_first = false;
    }
    if(object & 2097152) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_22BPC_BIT_EXT"; is_first = false;
    }
    if(object & 4194304) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_23BPC_BIT_EXT"; is_first = false;
    }
    if(object & 8388608) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_24BPC_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkDeviceAddressBindingFlagBitsEXT(VkDeviceAddressBindingFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_ADDRESS_BINDING_INTERNAL_OBJECT_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_json_VkImageConstraintsInfoFlagBitsFUCHSIA(VkImageConstraintsInfoFlagBitsFUCHSIA object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_READ_RARELY_FUCHSIA"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_READ_OFTEN_FUCHSIA"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_WRITE_RARELY_FUCHSIA"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_WRITE_OFTEN_FUCHSIA"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_PROTECTED_OPTIONAL_FUCHSIA"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
#endif // VK_USE_PLATFORM_FUCHSIA
void dump_json_VkFrameBoundaryFlagBitsEXT(VkFrameBoundaryFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FRAME_BOUNDARY_FRAME_END_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkBuildMicromapFlagBitsEXT(VkBuildMicromapFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_MICROMAP_PREFER_FAST_TRACE_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_MICROMAP_PREFER_FAST_BUILD_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_MICROMAP_ALLOW_COMPACTION_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkMicromapCreateFlagBitsEXT(VkMicromapCreateFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MICROMAP_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPhysicalDeviceSchedulingControlsFlagBitsARM(VkPhysicalDeviceSchedulingControlsFlagBitsARM object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkMemoryDecompressionMethodFlagBitsNV(VkMemoryDecompressionMethodFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_DECOMPRESSION_METHOD_GDEFLATE_1_0_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkOpticalFlowGridSizeFlagBitsNV(VkOpticalFlowGridSizeFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_UNKNOWN_NV"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_1X1_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_2X2_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_4X4_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_8X8_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkOpticalFlowUsageFlagBitsNV(VkOpticalFlowUsageFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_UNKNOWN_NV"; is_first = false;
    }
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_INPUT_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_OUTPUT_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_HINT_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_COST_BIT_NV"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_GLOBAL_FLOW_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkOpticalFlowSessionCreateFlagBitsNV(VkOpticalFlowSessionCreateFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_HINT_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_COST_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_GLOBAL_FLOW_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ALLOW_REGIONS_BIT_NV"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_BOTH_DIRECTIONS_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkOpticalFlowExecuteFlagBitsNV(VkOpticalFlowExecuteFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_EXECUTE_DISABLE_TEMPORAL_HINTS_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkShaderCreateFlagBitsEXT(VkShaderCreateFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_LINK_STAGE_BIT_EXT"; is_first = false;
    }
    if(object & 1024) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_RESERVED_10_BIT_KHR"; is_first = false;
    }
    if(object & 2048) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_RESERVED_11_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_NO_TASK_SHADER_BIT_EXT"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_DISPATCH_BASE_BIT_EXT"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_EXT"; is_first = false;
    }
    if(object & 64) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT"; is_first = false;
    }
    if(object & 128) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_INDIRECT_BINDABLE_BIT_EXT"; is_first = false;
    }
    if(object & 256) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_RESERVED_8_BIT_EXT"; is_first = false;
    }
    if(object & 512) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_RESERVED_9_BIT_EXT"; is_first = false;
    }
    if(object & 4096) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_RESERVED_12_BIT_EXT"; is_first = false;
    }
    if(object & 8192) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_RESERVED_13_BIT_EXT"; is_first = false;
    }
    if(object & 16384) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_RESERVED_14_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeAV1CapabilityFlagBitsKHR(VkVideoEncodeAV1CapabilityFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_PER_RATE_CONTROL_GROUP_MIN_MAX_Q_INDEX_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_GENERATE_OBU_EXTENSION_HEADER_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_PRIMARY_REFERENCE_CDF_ONLY_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_FRAME_SIZE_OVERRIDE_BIT_KHR"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_MOTION_VECTOR_SCALING_BIT_KHR"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_RESERVED_5_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeAV1StdFlagBitsKHR(VkVideoEncodeAV1StdFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_STD_UNIFORM_TILE_SPACING_FLAG_SET_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_STD_SKIP_MODE_PRESENT_UNSET_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_STD_PRIMARY_REF_FRAME_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_STD_DELTA_Q_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeAV1SuperblockSizeFlagBitsKHR(VkVideoEncodeAV1SuperblockSizeFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_SUPERBLOCK_SIZE_64_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_SUPERBLOCK_SIZE_128_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkVideoEncodeAV1RateControlFlagBitsKHR(VkVideoEncodeAV1RateControlFlagBitsKHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_REGULAR_GOP_BIT_KHR"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_TEMPORAL_LAYER_PATTERN_DYADIC_BIT_KHR"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkClusterAccelerationStructureAddressResolutionFlagBitsNV(VkClusterAccelerationStructureAddressResolutionFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_IMPLICIT_DATA_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SCRATCH_DATA_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_ADDRESS_ARRAY_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_SIZES_ARRAY_BIT_NV"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SRC_INFOS_ARRAY_BIT_NV"; is_first = false;
    }
    if(object & 32) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SRC_INFOS_COUNT_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkClusterAccelerationStructureClusterFlagBitsNV(VkClusterAccelerationStructureClusterFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_CLUSTER_ALLOW_DISABLE_OPACITY_MICROMAPS_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkClusterAccelerationStructureGeometryFlagBitsNV(VkClusterAccelerationStructureGeometryFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_GEOMETRY_CULL_DISABLE_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_GEOMETRY_NO_DUPLICATE_ANYHIT_INVOCATION_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_GEOMETRY_OPAQUE_BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkClusterAccelerationStructureIndexFormatFlagBitsNV(VkClusterAccelerationStructureIndexFormatFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_INDEX_FORMAT_8BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_INDEX_FORMAT_16BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_INDEX_FORMAT_32BIT_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkPartitionedAccelerationStructureInstanceFlagBitsNV(VkPartitionedAccelerationStructureInstanceFlagBitsNV object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_TRIANGLE_FACING_CULL_DISABLE_BIT_NV"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_TRIANGLE_FLIP_FACING_BIT_NV"; is_first = false;
    }
    if(object & 4) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_FORCE_OPAQUE_BIT_NV"; is_first = false;
    }
    if(object & 8) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_FORCE_NO_OPAQUE_BIT_NV"; is_first = false;
    }
    if(object & 16) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_ENABLE_EXPLICIT_BOUNDING_BOX_NV"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkIndirectCommandsInputModeFlagBitsEXT(VkIndirectCommandsInputModeFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_INPUT_MODE_VULKAN_INDEX_BUFFER_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_INPUT_MODE_DXGI_INDEX_BUFFER_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkIndirectCommandsLayoutUsageFlagBitsEXT(VkIndirectCommandsLayoutUsageFlagBitsEXT object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object & 1) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_EXT"; is_first = false;
    }
    if(object & 2) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_EXT"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}
void dump_json_VkAccessFlagBits3KHR(VkAccessFlagBits3KHR object, const ApiDumpSettings& settings, int indents)
{
    bool is_first = true;
    settings.stream() << '"' << object;
    if(object == 0) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_3_NONE_KHR"; is_first = false;
    }
    if(!is_first)
        settings.stream() << ')';
    settings.stream() << "\"";
}

//=========================== Flag Implementations ==========================//

void dump_json_VkAccessFlags(VkAccessFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkAccessFlagBits((VkAccessFlagBits) object, settings, indents);
}
void dump_json_VkImageAspectFlags(VkImageAspectFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkImageAspectFlagBits((VkImageAspectFlagBits) object, settings, indents);
}
void dump_json_VkFormatFeatureFlags(VkFormatFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkFormatFeatureFlagBits((VkFormatFeatureFlagBits) object, settings, indents);
}
void dump_json_VkImageCreateFlags(VkImageCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkImageCreateFlagBits((VkImageCreateFlagBits) object, settings, indents);
}
void dump_json_VkSampleCountFlags(VkSampleCountFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSampleCountFlagBits((VkSampleCountFlagBits) object, settings, indents);
}
void dump_json_VkImageUsageFlags(VkImageUsageFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkImageUsageFlagBits((VkImageUsageFlagBits) object, settings, indents);
}
void dump_json_VkInstanceCreateFlags(VkInstanceCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkInstanceCreateFlagBits((VkInstanceCreateFlagBits) object, settings, indents);
}
void dump_json_VkMemoryHeapFlags(VkMemoryHeapFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkMemoryHeapFlagBits((VkMemoryHeapFlagBits) object, settings, indents);
}
void dump_json_VkMemoryPropertyFlags(VkMemoryPropertyFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkMemoryPropertyFlagBits((VkMemoryPropertyFlagBits) object, settings, indents);
}
void dump_json_VkQueueFlags(VkQueueFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkQueueFlagBits((VkQueueFlagBits) object, settings, indents);
}
void dump_json_VkDeviceQueueCreateFlags(VkDeviceQueueCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDeviceQueueCreateFlagBits((VkDeviceQueueCreateFlagBits) object, settings, indents);
}
void dump_json_VkPipelineStageFlags(VkPipelineStageFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineStageFlagBits((VkPipelineStageFlagBits) object, settings, indents);
}
void dump_json_VkMemoryMapFlags(VkMemoryMapFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkMemoryMapFlagBits((VkMemoryMapFlagBits) object, settings, indents);
}
void dump_json_VkSparseMemoryBindFlags(VkSparseMemoryBindFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSparseMemoryBindFlagBits((VkSparseMemoryBindFlagBits) object, settings, indents);
}
void dump_json_VkSparseImageFormatFlags(VkSparseImageFormatFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSparseImageFormatFlagBits((VkSparseImageFormatFlagBits) object, settings, indents);
}
void dump_json_VkFenceCreateFlags(VkFenceCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkFenceCreateFlagBits((VkFenceCreateFlagBits) object, settings, indents);
}
void dump_json_VkEventCreateFlags(VkEventCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkEventCreateFlagBits((VkEventCreateFlagBits) object, settings, indents);
}
void dump_json_VkQueryPipelineStatisticFlags(VkQueryPipelineStatisticFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkQueryPipelineStatisticFlagBits((VkQueryPipelineStatisticFlagBits) object, settings, indents);
}
void dump_json_VkQueryResultFlags(VkQueryResultFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkQueryResultFlagBits((VkQueryResultFlagBits) object, settings, indents);
}
void dump_json_VkBufferCreateFlags(VkBufferCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkBufferCreateFlagBits((VkBufferCreateFlagBits) object, settings, indents);
}
void dump_json_VkBufferUsageFlags(VkBufferUsageFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkBufferUsageFlagBits((VkBufferUsageFlagBits) object, settings, indents);
}
void dump_json_VkImageViewCreateFlags(VkImageViewCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkImageViewCreateFlagBits((VkImageViewCreateFlagBits) object, settings, indents);
}
void dump_json_VkPipelineCacheCreateFlags(VkPipelineCacheCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineCacheCreateFlagBits((VkPipelineCacheCreateFlagBits) object, settings, indents);
}
void dump_json_VkColorComponentFlags(VkColorComponentFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkColorComponentFlagBits((VkColorComponentFlagBits) object, settings, indents);
}
void dump_json_VkPipelineCreateFlags(VkPipelineCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineCreateFlagBits((VkPipelineCreateFlagBits) object, settings, indents);
}
void dump_json_VkPipelineShaderStageCreateFlags(VkPipelineShaderStageCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineShaderStageCreateFlagBits((VkPipelineShaderStageCreateFlagBits) object, settings, indents);
}
void dump_json_VkCullModeFlags(VkCullModeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkCullModeFlagBits((VkCullModeFlagBits) object, settings, indents);
}
void dump_json_VkPipelineDepthStencilStateCreateFlags(VkPipelineDepthStencilStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineDepthStencilStateCreateFlagBits((VkPipelineDepthStencilStateCreateFlagBits) object, settings, indents);
}
void dump_json_VkPipelineColorBlendStateCreateFlags(VkPipelineColorBlendStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineColorBlendStateCreateFlagBits((VkPipelineColorBlendStateCreateFlagBits) object, settings, indents);
}
void dump_json_VkPipelineLayoutCreateFlags(VkPipelineLayoutCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineLayoutCreateFlagBits((VkPipelineLayoutCreateFlagBits) object, settings, indents);
}
void dump_json_VkShaderStageFlags(VkShaderStageFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkShaderStageFlagBits((VkShaderStageFlagBits) object, settings, indents);
}
void dump_json_VkSamplerCreateFlags(VkSamplerCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSamplerCreateFlagBits((VkSamplerCreateFlagBits) object, settings, indents);
}
void dump_json_VkDescriptorPoolCreateFlags(VkDescriptorPoolCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDescriptorPoolCreateFlagBits((VkDescriptorPoolCreateFlagBits) object, settings, indents);
}
void dump_json_VkDescriptorSetLayoutCreateFlags(VkDescriptorSetLayoutCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDescriptorSetLayoutCreateFlagBits((VkDescriptorSetLayoutCreateFlagBits) object, settings, indents);
}
void dump_json_VkAttachmentDescriptionFlags(VkAttachmentDescriptionFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkAttachmentDescriptionFlagBits((VkAttachmentDescriptionFlagBits) object, settings, indents);
}
void dump_json_VkDependencyFlags(VkDependencyFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDependencyFlagBits((VkDependencyFlagBits) object, settings, indents);
}
void dump_json_VkFramebufferCreateFlags(VkFramebufferCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkFramebufferCreateFlagBits((VkFramebufferCreateFlagBits) object, settings, indents);
}
void dump_json_VkRenderPassCreateFlags(VkRenderPassCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkRenderPassCreateFlagBits((VkRenderPassCreateFlagBits) object, settings, indents);
}
void dump_json_VkSubpassDescriptionFlags(VkSubpassDescriptionFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSubpassDescriptionFlagBits((VkSubpassDescriptionFlagBits) object, settings, indents);
}
void dump_json_VkCommandPoolCreateFlags(VkCommandPoolCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkCommandPoolCreateFlagBits((VkCommandPoolCreateFlagBits) object, settings, indents);
}
void dump_json_VkCommandPoolResetFlags(VkCommandPoolResetFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkCommandPoolResetFlagBits((VkCommandPoolResetFlagBits) object, settings, indents);
}
void dump_json_VkCommandBufferUsageFlags(VkCommandBufferUsageFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkCommandBufferUsageFlagBits((VkCommandBufferUsageFlagBits) object, settings, indents);
}
void dump_json_VkQueryControlFlags(VkQueryControlFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkQueryControlFlagBits((VkQueryControlFlagBits) object, settings, indents);
}
void dump_json_VkCommandBufferResetFlags(VkCommandBufferResetFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkCommandBufferResetFlagBits((VkCommandBufferResetFlagBits) object, settings, indents);
}
void dump_json_VkStencilFaceFlags(VkStencilFaceFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkStencilFaceFlagBits((VkStencilFaceFlagBits) object, settings, indents);
}
void dump_json_VkSubgroupFeatureFlags(VkSubgroupFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSubgroupFeatureFlagBits((VkSubgroupFeatureFlagBits) object, settings, indents);
}
void dump_json_VkPeerMemoryFeatureFlags(VkPeerMemoryFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPeerMemoryFeatureFlagBits((VkPeerMemoryFeatureFlagBits) object, settings, indents);
}
void dump_json_VkMemoryAllocateFlags(VkMemoryAllocateFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkMemoryAllocateFlagBits((VkMemoryAllocateFlagBits) object, settings, indents);
}
void dump_json_VkExternalMemoryHandleTypeFlags(VkExternalMemoryHandleTypeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkExternalMemoryHandleTypeFlagBits((VkExternalMemoryHandleTypeFlagBits) object, settings, indents);
}
void dump_json_VkExternalMemoryFeatureFlags(VkExternalMemoryFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkExternalMemoryFeatureFlagBits((VkExternalMemoryFeatureFlagBits) object, settings, indents);
}
void dump_json_VkExternalFenceHandleTypeFlags(VkExternalFenceHandleTypeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkExternalFenceHandleTypeFlagBits((VkExternalFenceHandleTypeFlagBits) object, settings, indents);
}
void dump_json_VkExternalFenceFeatureFlags(VkExternalFenceFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkExternalFenceFeatureFlagBits((VkExternalFenceFeatureFlagBits) object, settings, indents);
}
void dump_json_VkFenceImportFlags(VkFenceImportFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkFenceImportFlagBits((VkFenceImportFlagBits) object, settings, indents);
}
void dump_json_VkSemaphoreImportFlags(VkSemaphoreImportFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSemaphoreImportFlagBits((VkSemaphoreImportFlagBits) object, settings, indents);
}
void dump_json_VkExternalSemaphoreHandleTypeFlags(VkExternalSemaphoreHandleTypeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkExternalSemaphoreHandleTypeFlagBits((VkExternalSemaphoreHandleTypeFlagBits) object, settings, indents);
}
void dump_json_VkExternalSemaphoreFeatureFlags(VkExternalSemaphoreFeatureFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkExternalSemaphoreFeatureFlagBits((VkExternalSemaphoreFeatureFlagBits) object, settings, indents);
}
void dump_json_VkResolveModeFlags(VkResolveModeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkResolveModeFlagBits((VkResolveModeFlagBits) object, settings, indents);
}
void dump_json_VkDescriptorBindingFlags(VkDescriptorBindingFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDescriptorBindingFlagBits((VkDescriptorBindingFlagBits) object, settings, indents);
}
void dump_json_VkSemaphoreWaitFlags(VkSemaphoreWaitFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSemaphoreWaitFlagBits((VkSemaphoreWaitFlagBits) object, settings, indents);
}
void dump_json_VkPipelineCreationFeedbackFlags(VkPipelineCreationFeedbackFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineCreationFeedbackFlagBits((VkPipelineCreationFeedbackFlagBits) object, settings, indents);
}
void dump_json_VkToolPurposeFlags(VkToolPurposeFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkToolPurposeFlagBits((VkToolPurposeFlagBits) object, settings, indents);
}
void dump_json_VkPipelineStageFlags2(VkPipelineStageFlags2 object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineStageFlagBits2((VkPipelineStageFlagBits2) object, settings, indents);
}
void dump_json_VkAccessFlags2(VkAccessFlags2 object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkAccessFlagBits2((VkAccessFlagBits2) object, settings, indents);
}
void dump_json_VkSubmitFlags(VkSubmitFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSubmitFlagBits((VkSubmitFlagBits) object, settings, indents);
}
void dump_json_VkRenderingFlags(VkRenderingFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkRenderingFlagBits((VkRenderingFlagBits) object, settings, indents);
}
void dump_json_VkFormatFeatureFlags2(VkFormatFeatureFlags2 object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkFormatFeatureFlagBits2((VkFormatFeatureFlagBits2) object, settings, indents);
}
void dump_json_VkMemoryUnmapFlags(VkMemoryUnmapFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkMemoryUnmapFlagBits((VkMemoryUnmapFlagBits) object, settings, indents);
}
void dump_json_VkPipelineCreateFlags2(VkPipelineCreateFlags2 object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineCreateFlagBits2((VkPipelineCreateFlagBits2) object, settings, indents);
}
void dump_json_VkBufferUsageFlags2(VkBufferUsageFlags2 object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkBufferUsageFlagBits2((VkBufferUsageFlagBits2) object, settings, indents);
}
void dump_json_VkHostImageCopyFlags(VkHostImageCopyFlags object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkHostImageCopyFlagBits((VkHostImageCopyFlagBits) object, settings, indents);
}
void dump_json_VkCompositeAlphaFlagsKHR(VkCompositeAlphaFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkCompositeAlphaFlagBitsKHR((VkCompositeAlphaFlagBitsKHR) object, settings, indents);
}
void dump_json_VkSurfaceTransformFlagsKHR(VkSurfaceTransformFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSurfaceTransformFlagBitsKHR((VkSurfaceTransformFlagBitsKHR) object, settings, indents);
}
void dump_json_VkSwapchainCreateFlagsKHR(VkSwapchainCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSwapchainCreateFlagBitsKHR((VkSwapchainCreateFlagBitsKHR) object, settings, indents);
}
void dump_json_VkDeviceGroupPresentModeFlagsKHR(VkDeviceGroupPresentModeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDeviceGroupPresentModeFlagBitsKHR((VkDeviceGroupPresentModeFlagBitsKHR) object, settings, indents);
}
void dump_json_VkDisplayPlaneAlphaFlagsKHR(VkDisplayPlaneAlphaFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDisplayPlaneAlphaFlagBitsKHR((VkDisplayPlaneAlphaFlagBitsKHR) object, settings, indents);
}
void dump_json_VkDebugReportFlagsEXT(VkDebugReportFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDebugReportFlagBitsEXT((VkDebugReportFlagBitsEXT) object, settings, indents);
}
void dump_json_VkVideoCodecOperationFlagsKHR(VkVideoCodecOperationFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoCodecOperationFlagBitsKHR((VkVideoCodecOperationFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoChromaSubsamplingFlagsKHR(VkVideoChromaSubsamplingFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoChromaSubsamplingFlagBitsKHR((VkVideoChromaSubsamplingFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoComponentBitDepthFlagsKHR(VkVideoComponentBitDepthFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoComponentBitDepthFlagBitsKHR((VkVideoComponentBitDepthFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoCapabilityFlagsKHR(VkVideoCapabilityFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoCapabilityFlagBitsKHR((VkVideoCapabilityFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoSessionCreateFlagsKHR(VkVideoSessionCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoSessionCreateFlagBitsKHR((VkVideoSessionCreateFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoSessionParametersCreateFlagsKHR(VkVideoSessionParametersCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoSessionParametersCreateFlagBitsKHR((VkVideoSessionParametersCreateFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoCodingControlFlagsKHR(VkVideoCodingControlFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoCodingControlFlagBitsKHR((VkVideoCodingControlFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoDecodeCapabilityFlagsKHR(VkVideoDecodeCapabilityFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoDecodeCapabilityFlagBitsKHR((VkVideoDecodeCapabilityFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoDecodeUsageFlagsKHR(VkVideoDecodeUsageFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoDecodeUsageFlagBitsKHR((VkVideoDecodeUsageFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeH264CapabilityFlagsKHR(VkVideoEncodeH264CapabilityFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeH264CapabilityFlagBitsKHR((VkVideoEncodeH264CapabilityFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeH264StdFlagsKHR(VkVideoEncodeH264StdFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeH264StdFlagBitsKHR((VkVideoEncodeH264StdFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeH264RateControlFlagsKHR(VkVideoEncodeH264RateControlFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeH264RateControlFlagBitsKHR((VkVideoEncodeH264RateControlFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeH265CapabilityFlagsKHR(VkVideoEncodeH265CapabilityFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeH265CapabilityFlagBitsKHR((VkVideoEncodeH265CapabilityFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeH265StdFlagsKHR(VkVideoEncodeH265StdFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeH265StdFlagBitsKHR((VkVideoEncodeH265StdFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeH265CtbSizeFlagsKHR(VkVideoEncodeH265CtbSizeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeH265CtbSizeFlagBitsKHR((VkVideoEncodeH265CtbSizeFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeH265TransformBlockSizeFlagsKHR(VkVideoEncodeH265TransformBlockSizeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeH265TransformBlockSizeFlagBitsKHR((VkVideoEncodeH265TransformBlockSizeFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeH265RateControlFlagsKHR(VkVideoEncodeH265RateControlFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeH265RateControlFlagBitsKHR((VkVideoEncodeH265RateControlFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoDecodeH264PictureLayoutFlagsKHR(VkVideoDecodeH264PictureLayoutFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoDecodeH264PictureLayoutFlagBitsKHR((VkVideoDecodeH264PictureLayoutFlagBitsKHR) object, settings, indents);
}
void dump_json_VkExternalMemoryHandleTypeFlagsNV(VkExternalMemoryHandleTypeFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkExternalMemoryHandleTypeFlagBitsNV((VkExternalMemoryHandleTypeFlagBitsNV) object, settings, indents);
}
void dump_json_VkExternalMemoryFeatureFlagsNV(VkExternalMemoryFeatureFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkExternalMemoryFeatureFlagBitsNV((VkExternalMemoryFeatureFlagBitsNV) object, settings, indents);
}
void dump_json_VkConditionalRenderingFlagsEXT(VkConditionalRenderingFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkConditionalRenderingFlagBitsEXT((VkConditionalRenderingFlagBitsEXT) object, settings, indents);
}
void dump_json_VkSurfaceCounterFlagsEXT(VkSurfaceCounterFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkSurfaceCounterFlagBitsEXT((VkSurfaceCounterFlagBitsEXT) object, settings, indents);
}
void dump_json_VkPerformanceCounterDescriptionFlagsKHR(VkPerformanceCounterDescriptionFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPerformanceCounterDescriptionFlagBitsKHR((VkPerformanceCounterDescriptionFlagBitsKHR) object, settings, indents);
}
void dump_json_VkAcquireProfilingLockFlagsKHR(VkAcquireProfilingLockFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkAcquireProfilingLockFlagBitsKHR((VkAcquireProfilingLockFlagBitsKHR) object, settings, indents);
}
void dump_json_VkDebugUtilsMessageTypeFlagsEXT(VkDebugUtilsMessageTypeFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDebugUtilsMessageTypeFlagBitsEXT((VkDebugUtilsMessageTypeFlagBitsEXT) object, settings, indents);
}
void dump_json_VkDebugUtilsMessageSeverityFlagsEXT(VkDebugUtilsMessageSeverityFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDebugUtilsMessageSeverityFlagBitsEXT((VkDebugUtilsMessageSeverityFlagBitsEXT) object, settings, indents);
}
void dump_json_VkBuildAccelerationStructureFlagsKHR(VkBuildAccelerationStructureFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkBuildAccelerationStructureFlagBitsKHR((VkBuildAccelerationStructureFlagBitsKHR) object, settings, indents);
}
void dump_json_VkGeometryFlagsKHR(VkGeometryFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkGeometryFlagBitsKHR((VkGeometryFlagBitsKHR) object, settings, indents);
}
void dump_json_VkGeometryInstanceFlagsKHR(VkGeometryInstanceFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkGeometryInstanceFlagBitsKHR((VkGeometryInstanceFlagBitsKHR) object, settings, indents);
}
void dump_json_VkAccelerationStructureCreateFlagsKHR(VkAccelerationStructureCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkAccelerationStructureCreateFlagBitsKHR((VkAccelerationStructureCreateFlagBitsKHR) object, settings, indents);
}
void dump_json_VkPipelineCompilerControlFlagsAMD(VkPipelineCompilerControlFlagsAMD object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPipelineCompilerControlFlagBitsAMD((VkPipelineCompilerControlFlagBitsAMD) object, settings, indents);
}
void dump_json_VkShaderCorePropertiesFlagsAMD(VkShaderCorePropertiesFlagsAMD object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkShaderCorePropertiesFlagBitsAMD((VkShaderCorePropertiesFlagBitsAMD) object, settings, indents);
}
void dump_json_VkPresentScalingFlagsEXT(VkPresentScalingFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPresentScalingFlagBitsEXT((VkPresentScalingFlagBitsEXT) object, settings, indents);
}
void dump_json_VkPresentGravityFlagsEXT(VkPresentGravityFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPresentGravityFlagBitsEXT((VkPresentGravityFlagBitsEXT) object, settings, indents);
}
void dump_json_VkIndirectStateFlagsNV(VkIndirectStateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkIndirectStateFlagBitsNV((VkIndirectStateFlagBitsNV) object, settings, indents);
}
void dump_json_VkIndirectCommandsLayoutUsageFlagsNV(VkIndirectCommandsLayoutUsageFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkIndirectCommandsLayoutUsageFlagBitsNV((VkIndirectCommandsLayoutUsageFlagBitsNV) object, settings, indents);
}
void dump_json_VkVideoEncodeFlagsKHR(VkVideoEncodeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeFlagBitsKHR((VkVideoEncodeFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeCapabilityFlagsKHR(VkVideoEncodeCapabilityFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeCapabilityFlagBitsKHR((VkVideoEncodeCapabilityFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeRateControlModeFlagsKHR(VkVideoEncodeRateControlModeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeRateControlModeFlagBitsKHR((VkVideoEncodeRateControlModeFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeFeedbackFlagsKHR(VkVideoEncodeFeedbackFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeFeedbackFlagBitsKHR((VkVideoEncodeFeedbackFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeUsageFlagsKHR(VkVideoEncodeUsageFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeUsageFlagBitsKHR((VkVideoEncodeUsageFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeContentFlagsKHR(VkVideoEncodeContentFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeContentFlagBitsKHR((VkVideoEncodeContentFlagBitsKHR) object, settings, indents);
}
void dump_json_VkDeviceDiagnosticsConfigFlagsNV(VkDeviceDiagnosticsConfigFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDeviceDiagnosticsConfigFlagBitsNV((VkDeviceDiagnosticsConfigFlagBitsNV) object, settings, indents);
}
void dump_json_VkTileShadingRenderPassFlagsQCOM(VkTileShadingRenderPassFlagsQCOM object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkTileShadingRenderPassFlagBitsQCOM((VkTileShadingRenderPassFlagBitsQCOM) object, settings, indents);
}
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_json_VkExportMetalObjectTypeFlagsEXT(VkExportMetalObjectTypeFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkExportMetalObjectTypeFlagBitsEXT((VkExportMetalObjectTypeFlagBitsEXT) object, settings, indents);
}
#endif // VK_USE_PLATFORM_METAL_EXT
void dump_json_VkGraphicsPipelineLibraryFlagsEXT(VkGraphicsPipelineLibraryFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkGraphicsPipelineLibraryFlagBitsEXT((VkGraphicsPipelineLibraryFlagBitsEXT) object, settings, indents);
}
void dump_json_VkImageCompressionFlagsEXT(VkImageCompressionFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkImageCompressionFlagBitsEXT((VkImageCompressionFlagBitsEXT) object, settings, indents);
}
void dump_json_VkImageCompressionFixedRateFlagsEXT(VkImageCompressionFixedRateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkImageCompressionFixedRateFlagBitsEXT((VkImageCompressionFixedRateFlagBitsEXT) object, settings, indents);
}
void dump_json_VkDeviceAddressBindingFlagsEXT(VkDeviceAddressBindingFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkDeviceAddressBindingFlagBitsEXT((VkDeviceAddressBindingFlagBitsEXT) object, settings, indents);
}
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_json_VkImageConstraintsInfoFlagsFUCHSIA(VkImageConstraintsInfoFlagsFUCHSIA object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkImageConstraintsInfoFlagBitsFUCHSIA((VkImageConstraintsInfoFlagBitsFUCHSIA) object, settings, indents);
}
#endif // VK_USE_PLATFORM_FUCHSIA
void dump_json_VkFrameBoundaryFlagsEXT(VkFrameBoundaryFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkFrameBoundaryFlagBitsEXT((VkFrameBoundaryFlagBitsEXT) object, settings, indents);
}
void dump_json_VkBuildMicromapFlagsEXT(VkBuildMicromapFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkBuildMicromapFlagBitsEXT((VkBuildMicromapFlagBitsEXT) object, settings, indents);
}
void dump_json_VkMicromapCreateFlagsEXT(VkMicromapCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkMicromapCreateFlagBitsEXT((VkMicromapCreateFlagBitsEXT) object, settings, indents);
}
void dump_json_VkPhysicalDeviceSchedulingControlsFlagsARM(VkPhysicalDeviceSchedulingControlsFlagsARM object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPhysicalDeviceSchedulingControlsFlagBitsARM((VkPhysicalDeviceSchedulingControlsFlagBitsARM) object, settings, indents);
}
void dump_json_VkMemoryDecompressionMethodFlagsNV(VkMemoryDecompressionMethodFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkMemoryDecompressionMethodFlagBitsNV((VkMemoryDecompressionMethodFlagBitsNV) object, settings, indents);
}
void dump_json_VkOpticalFlowGridSizeFlagsNV(VkOpticalFlowGridSizeFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkOpticalFlowGridSizeFlagBitsNV((VkOpticalFlowGridSizeFlagBitsNV) object, settings, indents);
}
void dump_json_VkOpticalFlowUsageFlagsNV(VkOpticalFlowUsageFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkOpticalFlowUsageFlagBitsNV((VkOpticalFlowUsageFlagBitsNV) object, settings, indents);
}
void dump_json_VkOpticalFlowSessionCreateFlagsNV(VkOpticalFlowSessionCreateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkOpticalFlowSessionCreateFlagBitsNV((VkOpticalFlowSessionCreateFlagBitsNV) object, settings, indents);
}
void dump_json_VkOpticalFlowExecuteFlagsNV(VkOpticalFlowExecuteFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkOpticalFlowExecuteFlagBitsNV((VkOpticalFlowExecuteFlagBitsNV) object, settings, indents);
}
void dump_json_VkShaderCreateFlagsEXT(VkShaderCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkShaderCreateFlagBitsEXT((VkShaderCreateFlagBitsEXT) object, settings, indents);
}
void dump_json_VkVideoEncodeAV1CapabilityFlagsKHR(VkVideoEncodeAV1CapabilityFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeAV1CapabilityFlagBitsKHR((VkVideoEncodeAV1CapabilityFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeAV1StdFlagsKHR(VkVideoEncodeAV1StdFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeAV1StdFlagBitsKHR((VkVideoEncodeAV1StdFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeAV1SuperblockSizeFlagsKHR(VkVideoEncodeAV1SuperblockSizeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeAV1SuperblockSizeFlagBitsKHR((VkVideoEncodeAV1SuperblockSizeFlagBitsKHR) object, settings, indents);
}
void dump_json_VkVideoEncodeAV1RateControlFlagsKHR(VkVideoEncodeAV1RateControlFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkVideoEncodeAV1RateControlFlagBitsKHR((VkVideoEncodeAV1RateControlFlagBitsKHR) object, settings, indents);
}
void dump_json_VkClusterAccelerationStructureAddressResolutionFlagsNV(VkClusterAccelerationStructureAddressResolutionFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkClusterAccelerationStructureAddressResolutionFlagBitsNV((VkClusterAccelerationStructureAddressResolutionFlagBitsNV) object, settings, indents);
}
void dump_json_VkClusterAccelerationStructureClusterFlagsNV(VkClusterAccelerationStructureClusterFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkClusterAccelerationStructureClusterFlagBitsNV((VkClusterAccelerationStructureClusterFlagBitsNV) object, settings, indents);
}
void dump_json_VkClusterAccelerationStructureGeometryFlagsNV(VkClusterAccelerationStructureGeometryFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkClusterAccelerationStructureGeometryFlagBitsNV((VkClusterAccelerationStructureGeometryFlagBitsNV) object, settings, indents);
}
void dump_json_VkClusterAccelerationStructureIndexFormatFlagsNV(VkClusterAccelerationStructureIndexFormatFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkClusterAccelerationStructureIndexFormatFlagBitsNV((VkClusterAccelerationStructureIndexFormatFlagBitsNV) object, settings, indents);
}
void dump_json_VkPartitionedAccelerationStructureInstanceFlagsNV(VkPartitionedAccelerationStructureInstanceFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkPartitionedAccelerationStructureInstanceFlagBitsNV((VkPartitionedAccelerationStructureInstanceFlagBitsNV) object, settings, indents);
}
void dump_json_VkIndirectCommandsInputModeFlagsEXT(VkIndirectCommandsInputModeFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkIndirectCommandsInputModeFlagBitsEXT((VkIndirectCommandsInputModeFlagBitsEXT) object, settings, indents);
}
void dump_json_VkIndirectCommandsLayoutUsageFlagsEXT(VkIndirectCommandsLayoutUsageFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkIndirectCommandsLayoutUsageFlagBitsEXT((VkIndirectCommandsLayoutUsageFlagBitsEXT) object, settings, indents);
}
void dump_json_VkAccessFlags3KHR(VkAccessFlags3KHR object, const ApiDumpSettings& settings, int indents)
{
    dump_json_VkAccessFlagBits3KHR((VkAccessFlagBits3KHR) object, settings, indents);
}


void dump_json_VkDeviceCreateFlags(VkDeviceCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkSemaphoreCreateFlags(VkSemaphoreCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkQueryPoolCreateFlags(VkQueryPoolCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkBufferViewCreateFlags(VkBufferViewCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkShaderModuleCreateFlags(VkShaderModuleCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineVertexInputStateCreateFlags(VkPipelineVertexInputStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineInputAssemblyStateCreateFlags(VkPipelineInputAssemblyStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineTessellationStateCreateFlags(VkPipelineTessellationStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineViewportStateCreateFlags(VkPipelineViewportStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineRasterizationStateCreateFlags(VkPipelineRasterizationStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineMultisampleStateCreateFlags(VkPipelineMultisampleStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineDynamicStateCreateFlags(VkPipelineDynamicStateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkDescriptorPoolResetFlags(VkDescriptorPoolResetFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkCommandPoolTrimFlags(VkCommandPoolTrimFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkDescriptorUpdateTemplateCreateFlags(VkDescriptorUpdateTemplateCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPrivateDataSlotCreateFlags(VkPrivateDataSlotCreateFlags object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkDisplayModeCreateFlagsKHR(VkDisplayModeCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkDisplaySurfaceCreateFlagsKHR(VkDisplaySurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#if defined(VK_USE_PLATFORM_XLIB_KHR)
void dump_json_VkXlibSurfaceCreateFlagsKHR(VkXlibSurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_XLIB_KHR
#if defined(VK_USE_PLATFORM_XCB_KHR)
void dump_json_VkXcbSurfaceCreateFlagsKHR(VkXcbSurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_XCB_KHR
#if defined(VK_USE_PLATFORM_WAYLAND_KHR)
void dump_json_VkWaylandSurfaceCreateFlagsKHR(VkWaylandSurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
void dump_json_VkAndroidSurfaceCreateFlagsKHR(VkAndroidSurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_ANDROID_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
void dump_json_VkWin32SurfaceCreateFlagsKHR(VkWin32SurfaceCreateFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_WIN32_KHR
void dump_json_VkVideoBeginCodingFlagsKHR(VkVideoBeginCodingFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkVideoEndCodingFlagsKHR(VkVideoEndCodingFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkVideoDecodeFlagsKHR(VkVideoDecodeFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineRasterizationStateStreamCreateFlagsEXT(VkPipelineRasterizationStateStreamCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#if defined(VK_USE_PLATFORM_GGP)
void dump_json_VkStreamDescriptorSurfaceCreateFlagsGGP(VkStreamDescriptorSurfaceCreateFlagsGGP object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_GGP
#if defined(VK_USE_PLATFORM_VI_NN)
void dump_json_VkViSurfaceCreateFlagsNN(VkViSurfaceCreateFlagsNN object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_VI_NN
void dump_json_VkPipelineViewportSwizzleStateCreateFlagsNV(VkPipelineViewportSwizzleStateCreateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineDiscardRectangleStateCreateFlagsEXT(VkPipelineDiscardRectangleStateCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineRasterizationConservativeStateCreateFlagsEXT(VkPipelineRasterizationConservativeStateCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineRasterizationDepthClipStateCreateFlagsEXT(VkPipelineRasterizationDepthClipStateCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#if defined(VK_USE_PLATFORM_IOS_MVK)
void dump_json_VkIOSSurfaceCreateFlagsMVK(VkIOSSurfaceCreateFlagsMVK object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_IOS_MVK
#if defined(VK_USE_PLATFORM_MACOS_MVK)
void dump_json_VkMacOSSurfaceCreateFlagsMVK(VkMacOSSurfaceCreateFlagsMVK object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_MACOS_MVK
void dump_json_VkDebugUtilsMessengerCallbackDataFlagsEXT(VkDebugUtilsMessengerCallbackDataFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkDebugUtilsMessengerCreateFlagsEXT(VkDebugUtilsMessengerCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineCoverageToColorStateCreateFlagsNV(VkPipelineCoverageToColorStateCreateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkPipelineCoverageModulationStateCreateFlagsNV(VkPipelineCoverageModulationStateCreateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkValidationCacheCreateFlagsEXT(VkValidationCacheCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_json_VkImagePipeSurfaceCreateFlagsFUCHSIA(VkImagePipeSurfaceCreateFlagsFUCHSIA object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_FUCHSIA
#if defined(VK_USE_PLATFORM_METAL_EXT)
void dump_json_VkMetalSurfaceCreateFlagsEXT(VkMetalSurfaceCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_METAL_EXT
void dump_json_VkPipelineCoverageReductionStateCreateFlagsNV(VkPipelineCoverageReductionStateCreateFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkHeadlessSurfaceCreateFlagsEXT(VkHeadlessSurfaceCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkDeviceMemoryReportFlagsEXT(VkDeviceMemoryReportFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkVideoEncodeRateControlFlagsKHR(VkVideoEncodeRateControlFlagsKHR object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkAccelerationStructureMotionInfoFlagsNV(VkAccelerationStructureMotionInfoFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
void dump_json_VkAccelerationStructureMotionInstanceFlagsNV(VkAccelerationStructureMotionInstanceFlagsNV object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#if defined(VK_USE_PLATFORM_DIRECTFB_EXT)
void dump_json_VkDirectFBSurfaceCreateFlagsEXT(VkDirectFBSurfaceCreateFlagsEXT object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#if defined(VK_USE_PLATFORM_FUCHSIA)
void dump_json_VkImageFormatConstraintsFlagsFUCHSIA(VkImageFormatConstraintsFlagsFUCHSIA object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_FUCHSIA
#if defined(VK_USE_PLATFORM_SCREEN_QNX)
void dump_json_VkScreenSurfaceCreateFlagsQNX(VkScreenSurfaceCreateFlagsQNX object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}
#endif // VK_USE_PLATFORM_SCREEN_QNX
void dump_json_VkDirectDriverLoadingFlagsLUNARG(VkDirectDriverLoadingFlagsLUNARG object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << '"' << object << "\"";
}

//======================= Func Pointer Implementations ======================//

void dump_json_PFN_vkAllocationFunction(PFN_vkAllocationFunction object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress())
       settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
void dump_json_PFN_vkFreeFunction(PFN_vkFreeFunction object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress())
       settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
void dump_json_PFN_vkInternalAllocationNotification(PFN_vkInternalAllocationNotification object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress())
       settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
void dump_json_PFN_vkInternalFreeNotification(PFN_vkInternalFreeNotification object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress())
       settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
void dump_json_PFN_vkReallocationFunction(PFN_vkReallocationFunction object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress())
       settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
void dump_json_PFN_vkVoidFunction(PFN_vkVoidFunction object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress())
       settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
void dump_json_PFN_vkDebugReportCallbackEXT(PFN_vkDebugReportCallbackEXT object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress())
       settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
void dump_json_PFN_vkDebugUtilsMessengerCallbackEXT(PFN_vkDebugUtilsMessengerCallbackEXT object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress())
       settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
void dump_json_PFN_vkDeviceMemoryReportCallbackEXT(PFN_vkDeviceMemoryReportCallbackEXT object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress())
       settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}
void dump_json_PFN_vkGetInstanceProcAddrLUNARG(PFN_vkGetInstanceProcAddrLUNARG object, const ApiDumpSettings& settings, int indents)
{
    if(settings.showAddress())
       settings.stream() << "\"" << object << "\"";
    else
        settings.stream() << "\"address\"";
}

//========================== Struct Implementations =========================//

void dump_json_VkExtent2D(const VkExtent2D& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.width, NULL, settings, "uint32_t", "width", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.height, NULL, settings, "uint32_t", "height", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExtent3D(const VkExtent3D& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.width, NULL, settings, "uint32_t", "width", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.height, NULL, settings, "uint32_t", "height", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.depth, NULL, settings, "uint32_t", "depth", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkOffset2D(const VkOffset2D& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const int32_t>(object.x, NULL, settings, "int32_t", "x", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.y, NULL, settings, "int32_t", "y", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkOffset3D(const VkOffset3D& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const int32_t>(object.x, NULL, settings, "int32_t", "x", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.y, NULL, settings, "int32_t", "y", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.z, NULL, settings, "int32_t", "z", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkRect2D(const VkRect2D& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkOffset2D>(object.offset, NULL, settings, "VkOffset2D", "offset", true, false, indents + 1, dump_json_VkOffset2D);
    settings.stream() << ",\n";
    dump_json_value<const VkExtent2D>(object.extent, NULL, settings, "VkExtent2D", "extent", true, false, indents + 1, dump_json_VkExtent2D);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBaseInStructure(const VkBaseInStructure& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    dump_json_pointer<const VkBaseInStructure>(object.pNext, settings, "const struct VkBaseInStructure*", "pNext", true, false, indents + 1, dump_json_VkBaseInStructure);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBaseOutStructure(const VkBaseOutStructure& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    dump_json_pointer<const VkBaseOutStructure>(object.pNext, settings, "struct VkBaseOutStructure*", "pNext", true, false, indents + 1, dump_json_VkBaseOutStructure);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferMemoryBarrier(const VkBufferMemoryBarrier& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags>(object.srcAccessMask, NULL, settings, "VkAccessFlags", "srcAccessMask", false, false, indents + 1, dump_json_VkAccessFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags>(object.dstAccessMask, NULL, settings, "VkAccessFlags", "dstAccessMask", false, false, indents + 1, dump_json_VkAccessFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.srcQueueFamilyIndex, NULL, settings, "uint32_t", "srcQueueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstQueueFamilyIndex, NULL, settings, "uint32_t", "dstQueueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.buffer, NULL, settings, "VkBuffer", "buffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.offset, NULL, settings, "VkDeviceSize", "offset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.size, NULL, settings, "VkDeviceSize", "size", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDispatchIndirectCommand(const VkDispatchIndirectCommand& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.x, NULL, settings, "uint32_t", "x", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.y, NULL, settings, "uint32_t", "y", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.z, NULL, settings, "uint32_t", "z", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDrawIndexedIndirectCommand(const VkDrawIndexedIndirectCommand& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.indexCount, NULL, settings, "uint32_t", "indexCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.instanceCount, NULL, settings, "uint32_t", "instanceCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.firstIndex, NULL, settings, "uint32_t", "firstIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.vertexOffset, NULL, settings, "int32_t", "vertexOffset", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.firstInstance, NULL, settings, "uint32_t", "firstInstance", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDrawIndirectCommand(const VkDrawIndirectCommand& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.vertexCount, NULL, settings, "uint32_t", "vertexCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.instanceCount, NULL, settings, "uint32_t", "instanceCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.firstVertex, NULL, settings, "uint32_t", "firstVertex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.firstInstance, NULL, settings, "uint32_t", "firstInstance", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageSubresourceRange(const VkImageSubresourceRange& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImageAspectFlags>(object.aspectMask, NULL, settings, "VkImageAspectFlags", "aspectMask", false, false, indents + 1, dump_json_VkImageAspectFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.baseMipLevel, NULL, settings, "uint32_t", "baseMipLevel", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.levelCount, NULL, settings, "uint32_t", "levelCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.baseArrayLayer, NULL, settings, "uint32_t", "baseArrayLayer", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.layerCount, NULL, settings, "uint32_t", "layerCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageMemoryBarrier(const VkImageMemoryBarrier& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags>(object.srcAccessMask, NULL, settings, "VkAccessFlags", "srcAccessMask", false, false, indents + 1, dump_json_VkAccessFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags>(object.dstAccessMask, NULL, settings, "VkAccessFlags", "dstAccessMask", false, false, indents + 1, dump_json_VkAccessFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.oldLayout, NULL, settings, "VkImageLayout", "oldLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.newLayout, NULL, settings, "VkImageLayout", "newLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.srcQueueFamilyIndex, NULL, settings, "uint32_t", "srcQueueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstQueueFamilyIndex, NULL, settings, "uint32_t", "dstQueueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.image, NULL, settings, "VkImage", "image", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceRange>(object.subresourceRange, NULL, settings, "VkImageSubresourceRange", "subresourceRange", true, false, indents + 1, dump_json_VkImageSubresourceRange);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryBarrier(const VkMemoryBarrier& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags>(object.srcAccessMask, NULL, settings, "VkAccessFlags", "srcAccessMask", false, false, indents + 1, dump_json_VkAccessFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags>(object.dstAccessMask, NULL, settings, "VkAccessFlags", "dstAccessMask", false, false, indents + 1, dump_json_VkAccessFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineCacheHeaderVersionOne(const VkPipelineCacheHeaderVersionOne& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.headerSize, NULL, settings, "uint32_t", "headerSize", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineCacheHeaderVersion>(object.headerVersion, NULL, settings, "VkPipelineCacheHeaderVersion", "headerVersion", false, false, indents + 1, dump_json_VkPipelineCacheHeaderVersion);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vendorID, NULL, settings, "uint32_t", "vendorID", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceID, NULL, settings, "uint32_t", "deviceID", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.pipelineCacheUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "pipelineCacheUUID", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkAllocationCallbacks(const VkAllocationCallbacks& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const void*>(object.pUserData, NULL, settings, "void*", "pUserData", false, false, indents + 1, dump_json_void);
    settings.stream() << ",\n";
    dump_json_value<const PFN_vkAllocationFunction>(object.pfnAllocation, NULL, settings, "PFN_vkAllocationFunction", "pfnAllocation", false, false, indents + 1, dump_json_PFN_vkAllocationFunction);
    settings.stream() << ",\n";
    dump_json_value<const PFN_vkReallocationFunction>(object.pfnReallocation, NULL, settings, "PFN_vkReallocationFunction", "pfnReallocation", false, false, indents + 1, dump_json_PFN_vkReallocationFunction);
    settings.stream() << ",\n";
    dump_json_value<const PFN_vkFreeFunction>(object.pfnFree, NULL, settings, "PFN_vkFreeFunction", "pfnFree", false, false, indents + 1, dump_json_PFN_vkFreeFunction);
    settings.stream() << ",\n";
    dump_json_value<const PFN_vkInternalAllocationNotification>(object.pfnInternalAllocation, NULL, settings, "PFN_vkInternalAllocationNotification", "pfnInternalAllocation", false, false, indents + 1, dump_json_PFN_vkInternalAllocationNotification);
    settings.stream() << ",\n";
    dump_json_value<const PFN_vkInternalFreeNotification>(object.pfnInternalFree, NULL, settings, "PFN_vkInternalFreeNotification", "pfnInternalFree", false, false, indents + 1, dump_json_PFN_vkInternalFreeNotification);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkApplicationInfo(const VkApplicationInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.pApplicationName, NULL, settings, "const char*", "pApplicationName", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.applicationVersion, NULL, settings, "uint32_t", "applicationVersion", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.pEngineName, NULL, settings, "const char*", "pEngineName", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.engineVersion, NULL, settings, "uint32_t", "engineVersion", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.apiVersion, NULL, settings, "uint32_t", "apiVersion", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkFormatProperties(const VkFormatProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkFormatFeatureFlags>(object.linearTilingFeatures, NULL, settings, "VkFormatFeatureFlags", "linearTilingFeatures", false, false, indents + 1, dump_json_VkFormatFeatureFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkFormatFeatureFlags>(object.optimalTilingFeatures, NULL, settings, "VkFormatFeatureFlags", "optimalTilingFeatures", false, false, indents + 1, dump_json_VkFormatFeatureFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkFormatFeatureFlags>(object.bufferFeatures, NULL, settings, "VkFormatFeatureFlags", "bufferFeatures", false, false, indents + 1, dump_json_VkFormatFeatureFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageFormatProperties(const VkImageFormatProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkExtent3D>(object.maxExtent, NULL, settings, "VkExtent3D", "maxExtent", true, false, indents + 1, dump_json_VkExtent3D);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxMipLevels, NULL, settings, "uint32_t", "maxMipLevels", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxArrayLayers, NULL, settings, "uint32_t", "maxArrayLayers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.sampleCounts, NULL, settings, "VkSampleCountFlags", "sampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.maxResourceSize, NULL, settings, "VkDeviceSize", "maxResourceSize", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkInstanceCreateInfo(const VkInstanceCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkInstanceCreateFlags>(object.flags, NULL, settings, "VkInstanceCreateFlags", "flags", false, false, indents + 1, dump_json_VkInstanceCreateFlags);
    settings.stream() << ",\n";
    dump_json_pointer<const VkApplicationInfo>(object.pApplicationInfo, settings, "const VkApplicationInfo*", "pApplicationInfo", true, false, indents + 1, dump_json_VkApplicationInfo);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.enabledLayerCount, NULL, settings, "uint32_t", "enabledLayerCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const char*>(object.ppEnabledLayerNames, object.enabledLayerCount, settings, "const char* const*", "const char* const", "ppEnabledLayerNames", false, false, indents + 1, dump_json_cstring); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.enabledExtensionCount, NULL, settings, "uint32_t", "enabledExtensionCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const char*>(object.ppEnabledExtensionNames, object.enabledExtensionCount, settings, "const char* const*", "const char* const", "ppEnabledExtensionNames", false, false, indents + 1, dump_json_cstring); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryHeap(const VkMemoryHeap& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkDeviceSize>(object.size, NULL, settings, "VkDeviceSize", "size", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkMemoryHeapFlags>(object.flags, NULL, settings, "VkMemoryHeapFlags", "flags", false, false, indents + 1, dump_json_VkMemoryHeapFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryType(const VkMemoryType& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkMemoryPropertyFlags>(object.propertyFlags, NULL, settings, "VkMemoryPropertyFlags", "propertyFlags", false, false, indents + 1, dump_json_VkMemoryPropertyFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.heapIndex, NULL, settings, "uint32_t", "heapIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceFeatures(const VkPhysicalDeviceFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkBool32>(object.robustBufferAccess, NULL, settings, "VkBool32", "robustBufferAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.fullDrawIndexUint32, NULL, settings, "VkBool32", "fullDrawIndexUint32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.imageCubeArray, NULL, settings, "VkBool32", "imageCubeArray", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.independentBlend, NULL, settings, "VkBool32", "independentBlend", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.geometryShader, NULL, settings, "VkBool32", "geometryShader", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.tessellationShader, NULL, settings, "VkBool32", "tessellationShader", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sampleRateShading, NULL, settings, "VkBool32", "sampleRateShading", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.dualSrcBlend, NULL, settings, "VkBool32", "dualSrcBlend", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.logicOp, NULL, settings, "VkBool32", "logicOp", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.multiDrawIndirect, NULL, settings, "VkBool32", "multiDrawIndirect", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.drawIndirectFirstInstance, NULL, settings, "VkBool32", "drawIndirectFirstInstance", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.depthClamp, NULL, settings, "VkBool32", "depthClamp", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.depthBiasClamp, NULL, settings, "VkBool32", "depthBiasClamp", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.fillModeNonSolid, NULL, settings, "VkBool32", "fillModeNonSolid", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.depthBounds, NULL, settings, "VkBool32", "depthBounds", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.wideLines, NULL, settings, "VkBool32", "wideLines", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.largePoints, NULL, settings, "VkBool32", "largePoints", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.alphaToOne, NULL, settings, "VkBool32", "alphaToOne", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.multiViewport, NULL, settings, "VkBool32", "multiViewport", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.samplerAnisotropy, NULL, settings, "VkBool32", "samplerAnisotropy", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.textureCompressionETC2, NULL, settings, "VkBool32", "textureCompressionETC2", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.textureCompressionASTC_LDR, NULL, settings, "VkBool32", "textureCompressionASTC_LDR", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.textureCompressionBC, NULL, settings, "VkBool32", "textureCompressionBC", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.occlusionQueryPrecise, NULL, settings, "VkBool32", "occlusionQueryPrecise", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.pipelineStatisticsQuery, NULL, settings, "VkBool32", "pipelineStatisticsQuery", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.vertexPipelineStoresAndAtomics, NULL, settings, "VkBool32", "vertexPipelineStoresAndAtomics", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.fragmentStoresAndAtomics, NULL, settings, "VkBool32", "fragmentStoresAndAtomics", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderTessellationAndGeometryPointSize, NULL, settings, "VkBool32", "shaderTessellationAndGeometryPointSize", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderImageGatherExtended, NULL, settings, "VkBool32", "shaderImageGatherExtended", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageImageExtendedFormats, NULL, settings, "VkBool32", "shaderStorageImageExtendedFormats", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageImageMultisample, NULL, settings, "VkBool32", "shaderStorageImageMultisample", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageImageReadWithoutFormat, NULL, settings, "VkBool32", "shaderStorageImageReadWithoutFormat", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageImageWriteWithoutFormat, NULL, settings, "VkBool32", "shaderStorageImageWriteWithoutFormat", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderUniformBufferArrayDynamicIndexing, NULL, settings, "VkBool32", "shaderUniformBufferArrayDynamicIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSampledImageArrayDynamicIndexing, NULL, settings, "VkBool32", "shaderSampledImageArrayDynamicIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageBufferArrayDynamicIndexing, NULL, settings, "VkBool32", "shaderStorageBufferArrayDynamicIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageImageArrayDynamicIndexing, NULL, settings, "VkBool32", "shaderStorageImageArrayDynamicIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderClipDistance, NULL, settings, "VkBool32", "shaderClipDistance", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderCullDistance, NULL, settings, "VkBool32", "shaderCullDistance", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderFloat64, NULL, settings, "VkBool32", "shaderFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderInt64, NULL, settings, "VkBool32", "shaderInt64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderInt16, NULL, settings, "VkBool32", "shaderInt16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderResourceResidency, NULL, settings, "VkBool32", "shaderResourceResidency", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderResourceMinLod, NULL, settings, "VkBool32", "shaderResourceMinLod", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sparseBinding, NULL, settings, "VkBool32", "sparseBinding", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sparseResidencyBuffer, NULL, settings, "VkBool32", "sparseResidencyBuffer", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sparseResidencyImage2D, NULL, settings, "VkBool32", "sparseResidencyImage2D", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sparseResidencyImage3D, NULL, settings, "VkBool32", "sparseResidencyImage3D", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sparseResidency2Samples, NULL, settings, "VkBool32", "sparseResidency2Samples", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sparseResidency4Samples, NULL, settings, "VkBool32", "sparseResidency4Samples", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sparseResidency8Samples, NULL, settings, "VkBool32", "sparseResidency8Samples", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sparseResidency16Samples, NULL, settings, "VkBool32", "sparseResidency16Samples", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sparseResidencyAliased, NULL, settings, "VkBool32", "sparseResidencyAliased", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.variableMultisampleRate, NULL, settings, "VkBool32", "variableMultisampleRate", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.inheritedQueries, NULL, settings, "VkBool32", "inheritedQueries", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceLimits(const VkPhysicalDeviceLimits& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.maxImageDimension1D, NULL, settings, "uint32_t", "maxImageDimension1D", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxImageDimension2D, NULL, settings, "uint32_t", "maxImageDimension2D", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxImageDimension3D, NULL, settings, "uint32_t", "maxImageDimension3D", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxImageDimensionCube, NULL, settings, "uint32_t", "maxImageDimensionCube", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxImageArrayLayers, NULL, settings, "uint32_t", "maxImageArrayLayers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTexelBufferElements, NULL, settings, "uint32_t", "maxTexelBufferElements", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxUniformBufferRange, NULL, settings, "uint32_t", "maxUniformBufferRange", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxStorageBufferRange, NULL, settings, "uint32_t", "maxStorageBufferRange", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPushConstantsSize, NULL, settings, "uint32_t", "maxPushConstantsSize", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxMemoryAllocationCount, NULL, settings, "uint32_t", "maxMemoryAllocationCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxSamplerAllocationCount, NULL, settings, "uint32_t", "maxSamplerAllocationCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.bufferImageGranularity, NULL, settings, "VkDeviceSize", "bufferImageGranularity", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.sparseAddressSpaceSize, NULL, settings, "VkDeviceSize", "sparseAddressSpaceSize", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxBoundDescriptorSets, NULL, settings, "uint32_t", "maxBoundDescriptorSets", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorSamplers, NULL, settings, "uint32_t", "maxPerStageDescriptorSamplers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUniformBuffers, NULL, settings, "uint32_t", "maxPerStageDescriptorUniformBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorStorageBuffers, NULL, settings, "uint32_t", "maxPerStageDescriptorStorageBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorSampledImages, NULL, settings, "uint32_t", "maxPerStageDescriptorSampledImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorStorageImages, NULL, settings, "uint32_t", "maxPerStageDescriptorStorageImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorInputAttachments, NULL, settings, "uint32_t", "maxPerStageDescriptorInputAttachments", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageResources, NULL, settings, "uint32_t", "maxPerStageResources", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetSamplers, NULL, settings, "uint32_t", "maxDescriptorSetSamplers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUniformBuffers, NULL, settings, "uint32_t", "maxDescriptorSetUniformBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUniformBuffersDynamic, NULL, settings, "uint32_t", "maxDescriptorSetUniformBuffersDynamic", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetStorageBuffers, NULL, settings, "uint32_t", "maxDescriptorSetStorageBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetStorageBuffersDynamic, NULL, settings, "uint32_t", "maxDescriptorSetStorageBuffersDynamic", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetSampledImages, NULL, settings, "uint32_t", "maxDescriptorSetSampledImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetStorageImages, NULL, settings, "uint32_t", "maxDescriptorSetStorageImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetInputAttachments, NULL, settings, "uint32_t", "maxDescriptorSetInputAttachments", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxVertexInputAttributes, NULL, settings, "uint32_t", "maxVertexInputAttributes", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxVertexInputBindings, NULL, settings, "uint32_t", "maxVertexInputBindings", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxVertexInputAttributeOffset, NULL, settings, "uint32_t", "maxVertexInputAttributeOffset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxVertexInputBindingStride, NULL, settings, "uint32_t", "maxVertexInputBindingStride", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxVertexOutputComponents, NULL, settings, "uint32_t", "maxVertexOutputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTessellationGenerationLevel, NULL, settings, "uint32_t", "maxTessellationGenerationLevel", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTessellationPatchSize, NULL, settings, "uint32_t", "maxTessellationPatchSize", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTessellationControlPerVertexInputComponents, NULL, settings, "uint32_t", "maxTessellationControlPerVertexInputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTessellationControlPerVertexOutputComponents, NULL, settings, "uint32_t", "maxTessellationControlPerVertexOutputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTessellationControlPerPatchOutputComponents, NULL, settings, "uint32_t", "maxTessellationControlPerPatchOutputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTessellationControlTotalOutputComponents, NULL, settings, "uint32_t", "maxTessellationControlTotalOutputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTessellationEvaluationInputComponents, NULL, settings, "uint32_t", "maxTessellationEvaluationInputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTessellationEvaluationOutputComponents, NULL, settings, "uint32_t", "maxTessellationEvaluationOutputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxGeometryShaderInvocations, NULL, settings, "uint32_t", "maxGeometryShaderInvocations", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxGeometryInputComponents, NULL, settings, "uint32_t", "maxGeometryInputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxGeometryOutputComponents, NULL, settings, "uint32_t", "maxGeometryOutputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxGeometryOutputVertices, NULL, settings, "uint32_t", "maxGeometryOutputVertices", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxGeometryTotalOutputComponents, NULL, settings, "uint32_t", "maxGeometryTotalOutputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxFragmentInputComponents, NULL, settings, "uint32_t", "maxFragmentInputComponents", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxFragmentOutputAttachments, NULL, settings, "uint32_t", "maxFragmentOutputAttachments", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxFragmentDualSrcAttachments, NULL, settings, "uint32_t", "maxFragmentDualSrcAttachments", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxFragmentCombinedOutputResources, NULL, settings, "uint32_t", "maxFragmentCombinedOutputResources", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxComputeSharedMemorySize, NULL, settings, "uint32_t", "maxComputeSharedMemorySize", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.maxComputeWorkGroupCount, 3, settings, "uint32_t[3]", "uint32_t", "maxComputeWorkGroupCount", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxComputeWorkGroupInvocations, NULL, settings, "uint32_t", "maxComputeWorkGroupInvocations", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.maxComputeWorkGroupSize, 3, settings, "uint32_t[3]", "uint32_t", "maxComputeWorkGroupSize", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.subPixelPrecisionBits, NULL, settings, "uint32_t", "subPixelPrecisionBits", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.subTexelPrecisionBits, NULL, settings, "uint32_t", "subTexelPrecisionBits", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.mipmapPrecisionBits, NULL, settings, "uint32_t", "mipmapPrecisionBits", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDrawIndexedIndexValue, NULL, settings, "uint32_t", "maxDrawIndexedIndexValue", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDrawIndirectCount, NULL, settings, "uint32_t", "maxDrawIndirectCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.maxSamplerLodBias, NULL, settings, "float", "maxSamplerLodBias", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.maxSamplerAnisotropy, NULL, settings, "float", "maxSamplerAnisotropy", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxViewports, NULL, settings, "uint32_t", "maxViewports", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.maxViewportDimensions, 2, settings, "uint32_t[2]", "uint32_t", "maxViewportDimensions", false, false, indents + 1, dump_json_uint32_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const float>(object.viewportBoundsRange, 2, settings, "float[2]", "float", "viewportBoundsRange", false, false, indents + 1, dump_json_float); // IQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.viewportSubPixelBits, NULL, settings, "uint32_t", "viewportSubPixelBits", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const size_t>(object.minMemoryMapAlignment, NULL, settings, "size_t", "minMemoryMapAlignment", false, false, indents + 1, dump_json_size_t);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.minTexelBufferOffsetAlignment, NULL, settings, "VkDeviceSize", "minTexelBufferOffsetAlignment", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.minUniformBufferOffsetAlignment, NULL, settings, "VkDeviceSize", "minUniformBufferOffsetAlignment", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.minStorageBufferOffsetAlignment, NULL, settings, "VkDeviceSize", "minStorageBufferOffsetAlignment", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.minTexelOffset, NULL, settings, "int32_t", "minTexelOffset", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTexelOffset, NULL, settings, "uint32_t", "maxTexelOffset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.minTexelGatherOffset, NULL, settings, "int32_t", "minTexelGatherOffset", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxTexelGatherOffset, NULL, settings, "uint32_t", "maxTexelGatherOffset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.minInterpolationOffset, NULL, settings, "float", "minInterpolationOffset", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.maxInterpolationOffset, NULL, settings, "float", "maxInterpolationOffset", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.subPixelInterpolationOffsetBits, NULL, settings, "uint32_t", "subPixelInterpolationOffsetBits", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxFramebufferWidth, NULL, settings, "uint32_t", "maxFramebufferWidth", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxFramebufferHeight, NULL, settings, "uint32_t", "maxFramebufferHeight", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxFramebufferLayers, NULL, settings, "uint32_t", "maxFramebufferLayers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.framebufferColorSampleCounts, NULL, settings, "VkSampleCountFlags", "framebufferColorSampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.framebufferDepthSampleCounts, NULL, settings, "VkSampleCountFlags", "framebufferDepthSampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.framebufferStencilSampleCounts, NULL, settings, "VkSampleCountFlags", "framebufferStencilSampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.framebufferNoAttachmentsSampleCounts, NULL, settings, "VkSampleCountFlags", "framebufferNoAttachmentsSampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxColorAttachments, NULL, settings, "uint32_t", "maxColorAttachments", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.sampledImageColorSampleCounts, NULL, settings, "VkSampleCountFlags", "sampledImageColorSampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.sampledImageIntegerSampleCounts, NULL, settings, "VkSampleCountFlags", "sampledImageIntegerSampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.sampledImageDepthSampleCounts, NULL, settings, "VkSampleCountFlags", "sampledImageDepthSampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.sampledImageStencilSampleCounts, NULL, settings, "VkSampleCountFlags", "sampledImageStencilSampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.storageImageSampleCounts, NULL, settings, "VkSampleCountFlags", "storageImageSampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxSampleMaskWords, NULL, settings, "uint32_t", "maxSampleMaskWords", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.timestampComputeAndGraphics, NULL, settings, "VkBool32", "timestampComputeAndGraphics", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.timestampPeriod, NULL, settings, "float", "timestampPeriod", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxClipDistances, NULL, settings, "uint32_t", "maxClipDistances", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxCullDistances, NULL, settings, "uint32_t", "maxCullDistances", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxCombinedClipAndCullDistances, NULL, settings, "uint32_t", "maxCombinedClipAndCullDistances", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.discreteQueuePriorities, NULL, settings, "uint32_t", "discreteQueuePriorities", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const float>(object.pointSizeRange, 2, settings, "float[2]", "float", "pointSizeRange", false, false, indents + 1, dump_json_float); // IQA
    settings.stream() << ",\n";
    dump_json_array<const float>(object.lineWidthRange, 2, settings, "float[2]", "float", "lineWidthRange", false, false, indents + 1, dump_json_float); // IQA
    settings.stream() << ",\n";
    dump_json_value<const float>(object.pointSizeGranularity, NULL, settings, "float", "pointSizeGranularity", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.lineWidthGranularity, NULL, settings, "float", "lineWidthGranularity", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.strictLines, NULL, settings, "VkBool32", "strictLines", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.standardSampleLocations, NULL, settings, "VkBool32", "standardSampleLocations", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.optimalBufferCopyOffsetAlignment, NULL, settings, "VkDeviceSize", "optimalBufferCopyOffsetAlignment", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.optimalBufferCopyRowPitchAlignment, NULL, settings, "VkDeviceSize", "optimalBufferCopyRowPitchAlignment", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.nonCoherentAtomSize, NULL, settings, "VkDeviceSize", "nonCoherentAtomSize", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceMemoryProperties(const VkPhysicalDeviceMemoryProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.memoryTypeCount, NULL, settings, "uint32_t", "memoryTypeCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkMemoryType>(object.memoryTypes, object.memoryTypeCount, settings, "VkMemoryType[VK_MAX_MEMORY_TYPES]", "VkMemoryType", "memoryTypes", true, false, indents + 1, dump_json_VkMemoryType); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.memoryHeapCount, NULL, settings, "uint32_t", "memoryHeapCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkMemoryHeap>(object.memoryHeaps, object.memoryHeapCount, settings, "VkMemoryHeap[VK_MAX_MEMORY_HEAPS]", "VkMemoryHeap", "memoryHeaps", true, false, indents + 1, dump_json_VkMemoryHeap); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceSparseProperties(const VkPhysicalDeviceSparseProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkBool32>(object.residencyStandard2DBlockShape, NULL, settings, "VkBool32", "residencyStandard2DBlockShape", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.residencyStandard2DMultisampleBlockShape, NULL, settings, "VkBool32", "residencyStandard2DMultisampleBlockShape", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.residencyStandard3DBlockShape, NULL, settings, "VkBool32", "residencyStandard3DBlockShape", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.residencyAlignedMipSize, NULL, settings, "VkBool32", "residencyAlignedMipSize", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.residencyNonResidentStrict, NULL, settings, "VkBool32", "residencyNonResidentStrict", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceProperties(const VkPhysicalDeviceProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.apiVersion, NULL, settings, "uint32_t", "apiVersion", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.driverVersion, NULL, settings, "uint32_t", "driverVersion", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vendorID, NULL, settings, "uint32_t", "vendorID", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceID, NULL, settings, "uint32_t", "deviceID", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkPhysicalDeviceType>(object.deviceType, NULL, settings, "VkPhysicalDeviceType", "deviceType", false, false, indents + 1, dump_json_VkPhysicalDeviceType);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.deviceName, NULL, settings, "char[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE]", "deviceName", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.pipelineCacheUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "pipelineCacheUUID", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_value<const VkPhysicalDeviceLimits>(object.limits, NULL, settings, "VkPhysicalDeviceLimits", "limits", true, false, indents + 1, dump_json_VkPhysicalDeviceLimits);
    settings.stream() << ",\n";
    dump_json_value<const VkPhysicalDeviceSparseProperties>(object.sparseProperties, NULL, settings, "VkPhysicalDeviceSparseProperties", "sparseProperties", true, false, indents + 1, dump_json_VkPhysicalDeviceSparseProperties);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkQueueFamilyProperties(const VkQueueFamilyProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkQueueFlags>(object.queueFlags, NULL, settings, "VkQueueFlags", "queueFlags", false, false, indents + 1, dump_json_VkQueueFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.queueCount, NULL, settings, "uint32_t", "queueCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.timestampValidBits, NULL, settings, "uint32_t", "timestampValidBits", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkExtent3D>(object.minImageTransferGranularity, NULL, settings, "VkExtent3D", "minImageTransferGranularity", true, false, indents + 1, dump_json_VkExtent3D);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDeviceQueueCreateInfo(const VkDeviceQueueCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceQueueCreateFlags>(object.flags, NULL, settings, "VkDeviceQueueCreateFlags", "flags", false, false, indents + 1, dump_json_VkDeviceQueueCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.queueFamilyIndex, NULL, settings, "uint32_t", "queueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.queueCount, NULL, settings, "uint32_t", "queueCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const float>(object.pQueuePriorities, object.queueCount, settings, "const float*", "const float", "pQueuePriorities", false, false, indents + 1, dump_json_float); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDeviceCreateInfo(const VkDeviceCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceCreateFlags>(object.flags, NULL, settings, "VkDeviceCreateFlags", "flags", false, false, indents + 1, dump_json_VkDeviceCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.queueCreateInfoCount, NULL, settings, "uint32_t", "queueCreateInfoCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkDeviceQueueCreateInfo>(object.pQueueCreateInfos, object.queueCreateInfoCount, settings, "const VkDeviceQueueCreateInfo*", "const VkDeviceQueueCreateInfo", "pQueueCreateInfos", true, false, indents + 1, dump_json_VkDeviceQueueCreateInfo); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.enabledLayerCount, NULL, settings, "uint32_t", "enabledLayerCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const char*>(object.ppEnabledLayerNames, object.enabledLayerCount, settings, "const char* const*", "const char* const", "ppEnabledLayerNames", false, false, indents + 1, dump_json_cstring); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.enabledExtensionCount, NULL, settings, "uint32_t", "enabledExtensionCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const char*>(object.ppEnabledExtensionNames, object.enabledExtensionCount, settings, "const char* const*", "const char* const", "ppEnabledExtensionNames", false, false, indents + 1, dump_json_cstring); // JQA
    settings.stream() << ",\n";
    dump_json_pointer<const VkPhysicalDeviceFeatures>(object.pEnabledFeatures, settings, "const VkPhysicalDeviceFeatures*", "pEnabledFeatures", true, false, indents + 1, dump_json_VkPhysicalDeviceFeatures);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExtensionProperties(const VkExtensionProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const char*>(object.extensionName, NULL, settings, "char[VK_MAX_EXTENSION_NAME_SIZE]", "extensionName", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.specVersion, NULL, settings, "uint32_t", "specVersion", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkLayerProperties(const VkLayerProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const char*>(object.layerName, NULL, settings, "char[VK_MAX_EXTENSION_NAME_SIZE]", "layerName", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.specVersion, NULL, settings, "uint32_t", "specVersion", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.implementationVersion, NULL, settings, "uint32_t", "implementationVersion", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.description, NULL, settings, "char[VK_MAX_DESCRIPTION_SIZE]", "description", false, false, indents + 1, dump_json_cstring);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSubmitInfo(const VkSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.waitSemaphoreCount, NULL, settings, "uint32_t", "waitSemaphoreCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSemaphore>(object.pWaitSemaphores, object.waitSemaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pWaitSemaphores", false, false, indents + 1, dump_json_VkSemaphore); // JQA
    settings.stream() << ",\n";
    dump_json_array<const VkPipelineStageFlags>(object.pWaitDstStageMask, object.waitSemaphoreCount, settings, "const VkPipelineStageFlags*", "const VkPipelineStageFlags", "pWaitDstStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.commandBufferCount, NULL, settings, "uint32_t", "commandBufferCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkCommandBuffer>(object.pCommandBuffers, object.commandBufferCount, settings, "const VkCommandBuffer*", "const VkCommandBuffer", "pCommandBuffers", false, false, indents + 1, dump_json_VkCommandBuffer); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.signalSemaphoreCount, NULL, settings, "uint32_t", "signalSemaphoreCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSemaphore>(object.pSignalSemaphores, object.signalSemaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pSignalSemaphores", false, false, indents + 1, dump_json_VkSemaphore); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMappedMemoryRange(const VkMappedMemoryRange& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceMemory>(object.memory, NULL, settings, "VkDeviceMemory", "memory", false, false, indents + 1, dump_json_VkDeviceMemory);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.offset, NULL, settings, "VkDeviceSize", "offset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.size, NULL, settings, "VkDeviceSize", "size", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryAllocateInfo(const VkMemoryAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.allocationSize, NULL, settings, "VkDeviceSize", "allocationSize", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.memoryTypeIndex, NULL, settings, "uint32_t", "memoryTypeIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryRequirements(const VkMemoryRequirements& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkDeviceSize>(object.size, NULL, settings, "VkDeviceSize", "size", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.alignment, NULL, settings, "VkDeviceSize", "alignment", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.memoryTypeBits, NULL, settings, "uint32_t", "memoryTypeBits", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSparseMemoryBind(const VkSparseMemoryBind& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkDeviceSize>(object.resourceOffset, NULL, settings, "VkDeviceSize", "resourceOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.size, NULL, settings, "VkDeviceSize", "size", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceMemory>(object.memory, NULL, settings, "VkDeviceMemory", "memory", false, false, indents + 1, dump_json_VkDeviceMemory);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.memoryOffset, NULL, settings, "VkDeviceSize", "memoryOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkSparseMemoryBindFlags>(object.flags, NULL, settings, "VkSparseMemoryBindFlags", "flags", false, false, indents + 1, dump_json_VkSparseMemoryBindFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSparseBufferMemoryBindInfo(const VkSparseBufferMemoryBindInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkBuffer>(object.buffer, NULL, settings, "VkBuffer", "buffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bindCount, NULL, settings, "uint32_t", "bindCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSparseMemoryBind>(object.pBinds, object.bindCount, settings, "const VkSparseMemoryBind*", "const VkSparseMemoryBind", "pBinds", true, false, indents + 1, dump_json_VkSparseMemoryBind); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSparseImageOpaqueMemoryBindInfo(const VkSparseImageOpaqueMemoryBindInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImage>(object.image, NULL, settings, "VkImage", "image", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bindCount, NULL, settings, "uint32_t", "bindCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSparseMemoryBind>(object.pBinds, object.bindCount, settings, "const VkSparseMemoryBind*", "const VkSparseMemoryBind", "pBinds", true, false, indents + 1, dump_json_VkSparseMemoryBind); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageSubresource(const VkImageSubresource& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImageAspectFlags>(object.aspectMask, NULL, settings, "VkImageAspectFlags", "aspectMask", false, false, indents + 1, dump_json_VkImageAspectFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.mipLevel, NULL, settings, "uint32_t", "mipLevel", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.arrayLayer, NULL, settings, "uint32_t", "arrayLayer", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSparseImageMemoryBind(const VkSparseImageMemoryBind& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImageSubresource>(object.subresource, NULL, settings, "VkImageSubresource", "subresource", true, false, indents + 1, dump_json_VkImageSubresource);
    settings.stream() << ",\n";
    dump_json_value<const VkOffset3D>(object.offset, NULL, settings, "VkOffset3D", "offset", true, false, indents + 1, dump_json_VkOffset3D);
    settings.stream() << ",\n";
    dump_json_value<const VkExtent3D>(object.extent, NULL, settings, "VkExtent3D", "extent", true, false, indents + 1, dump_json_VkExtent3D);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceMemory>(object.memory, NULL, settings, "VkDeviceMemory", "memory", false, false, indents + 1, dump_json_VkDeviceMemory);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.memoryOffset, NULL, settings, "VkDeviceSize", "memoryOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkSparseMemoryBindFlags>(object.flags, NULL, settings, "VkSparseMemoryBindFlags", "flags", false, false, indents + 1, dump_json_VkSparseMemoryBindFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSparseImageMemoryBindInfo(const VkSparseImageMemoryBindInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImage>(object.image, NULL, settings, "VkImage", "image", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bindCount, NULL, settings, "uint32_t", "bindCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSparseImageMemoryBind>(object.pBinds, object.bindCount, settings, "const VkSparseImageMemoryBind*", "const VkSparseImageMemoryBind", "pBinds", true, false, indents + 1, dump_json_VkSparseImageMemoryBind); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBindSparseInfo(const VkBindSparseInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.waitSemaphoreCount, NULL, settings, "uint32_t", "waitSemaphoreCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSemaphore>(object.pWaitSemaphores, object.waitSemaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pWaitSemaphores", false, false, indents + 1, dump_json_VkSemaphore); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bufferBindCount, NULL, settings, "uint32_t", "bufferBindCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSparseBufferMemoryBindInfo>(object.pBufferBinds, object.bufferBindCount, settings, "const VkSparseBufferMemoryBindInfo*", "const VkSparseBufferMemoryBindInfo", "pBufferBinds", true, false, indents + 1, dump_json_VkSparseBufferMemoryBindInfo); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.imageOpaqueBindCount, NULL, settings, "uint32_t", "imageOpaqueBindCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSparseImageOpaqueMemoryBindInfo>(object.pImageOpaqueBinds, object.imageOpaqueBindCount, settings, "const VkSparseImageOpaqueMemoryBindInfo*", "const VkSparseImageOpaqueMemoryBindInfo", "pImageOpaqueBinds", true, false, indents + 1, dump_json_VkSparseImageOpaqueMemoryBindInfo); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.imageBindCount, NULL, settings, "uint32_t", "imageBindCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSparseImageMemoryBindInfo>(object.pImageBinds, object.imageBindCount, settings, "const VkSparseImageMemoryBindInfo*", "const VkSparseImageMemoryBindInfo", "pImageBinds", true, false, indents + 1, dump_json_VkSparseImageMemoryBindInfo); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.signalSemaphoreCount, NULL, settings, "uint32_t", "signalSemaphoreCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSemaphore>(object.pSignalSemaphores, object.signalSemaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pSignalSemaphores", false, false, indents + 1, dump_json_VkSemaphore); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSparseImageFormatProperties(const VkSparseImageFormatProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImageAspectFlags>(object.aspectMask, NULL, settings, "VkImageAspectFlags", "aspectMask", false, false, indents + 1, dump_json_VkImageAspectFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkExtent3D>(object.imageGranularity, NULL, settings, "VkExtent3D", "imageGranularity", true, false, indents + 1, dump_json_VkExtent3D);
    settings.stream() << ",\n";
    dump_json_value<const VkSparseImageFormatFlags>(object.flags, NULL, settings, "VkSparseImageFormatFlags", "flags", false, false, indents + 1, dump_json_VkSparseImageFormatFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSparseImageMemoryRequirements(const VkSparseImageMemoryRequirements& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkSparseImageFormatProperties>(object.formatProperties, NULL, settings, "VkSparseImageFormatProperties", "formatProperties", true, false, indents + 1, dump_json_VkSparseImageFormatProperties);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.imageMipTailFirstLod, NULL, settings, "uint32_t", "imageMipTailFirstLod", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.imageMipTailSize, NULL, settings, "VkDeviceSize", "imageMipTailSize", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.imageMipTailOffset, NULL, settings, "VkDeviceSize", "imageMipTailOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.imageMipTailStride, NULL, settings, "VkDeviceSize", "imageMipTailStride", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkFenceCreateInfo(const VkFenceCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkFenceCreateFlags>(object.flags, NULL, settings, "VkFenceCreateFlags", "flags", false, false, indents + 1, dump_json_VkFenceCreateFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSemaphoreCreateInfo(const VkSemaphoreCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSemaphoreCreateFlags>(object.flags, NULL, settings, "VkSemaphoreCreateFlags", "flags", false, false, indents + 1, dump_json_VkSemaphoreCreateFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkEventCreateInfo(const VkEventCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkEventCreateFlags>(object.flags, NULL, settings, "VkEventCreateFlags", "flags", false, false, indents + 1, dump_json_VkEventCreateFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkQueryPoolCreateInfo(const VkQueryPoolCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkQueryPoolCreateFlags>(object.flags, NULL, settings, "VkQueryPoolCreateFlags", "flags", false, false, indents + 1, dump_json_VkQueryPoolCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkQueryType>(object.queryType, NULL, settings, "VkQueryType", "queryType", false, false, indents + 1, dump_json_VkQueryType);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.queryCount, NULL, settings, "uint32_t", "queryCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkQueryPipelineStatisticFlags>(object.pipelineStatistics, NULL, settings, "VkQueryPipelineStatisticFlags", "pipelineStatistics", false, false, indents + 1, dump_json_VkQueryPipelineStatisticFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferCreateInfo(const VkBufferCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBufferCreateFlags>(object.flags, NULL, settings, "VkBufferCreateFlags", "flags", false, false, indents + 1, dump_json_VkBufferCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.size, NULL, settings, "VkDeviceSize", "size", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkBufferUsageFlags>(object.usage, NULL, settings, "VkBufferUsageFlags", "usage", false, false, indents + 1, dump_json_VkBufferUsageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSharingMode>(object.sharingMode, NULL, settings, "VkSharingMode", "sharingMode", false, false, indents + 1, dump_json_VkSharingMode);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.queueFamilyIndexCount, NULL, settings, "uint32_t", "queueFamilyIndexCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    if(object.sharingMode == VK_SHARING_MODE_CONCURRENT)
    dump_json_array<const uint32_t>(object.pQueueFamilyIndices, object.queueFamilyIndexCount, settings, "const uint32_t*", "const uint32_t", "pQueueFamilyIndices", false, false, indents + 1, dump_json_uint32_t); // JQA
    else
        dump_json_UNUSED(settings, "const uint32_t*", "pQueueFamilyIndices", indents + 1);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferViewCreateInfo(const VkBufferViewCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBufferViewCreateFlags>(object.flags, NULL, settings, "VkBufferViewCreateFlags", "flags", false, false, indents + 1, dump_json_VkBufferViewCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.buffer, NULL, settings, "VkBuffer", "buffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << ",\n";
    dump_json_value<const VkFormat>(object.format, NULL, settings, "VkFormat", "format", false, false, indents + 1, dump_json_VkFormat);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.offset, NULL, settings, "VkDeviceSize", "offset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.range, NULL, settings, "VkDeviceSize", "range", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageCreateInfo(const VkImageCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageCreateFlags>(object.flags, NULL, settings, "VkImageCreateFlags", "flags", false, false, indents + 1, dump_json_VkImageCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkImageType>(object.imageType, NULL, settings, "VkImageType", "imageType", false, false, indents + 1, dump_json_VkImageType);
    settings.stream() << ",\n";
    dump_json_value<const VkFormat>(object.format, NULL, settings, "VkFormat", "format", false, false, indents + 1, dump_json_VkFormat);
    settings.stream() << ",\n";
    dump_json_value<const VkExtent3D>(object.extent, NULL, settings, "VkExtent3D", "extent", true, false, indents + 1, dump_json_VkExtent3D);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.mipLevels, NULL, settings, "uint32_t", "mipLevels", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.arrayLayers, NULL, settings, "uint32_t", "arrayLayers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlagBits>(object.samples, NULL, settings, "VkSampleCountFlagBits", "samples", false, false, indents + 1, dump_json_VkSampleCountFlagBits);
    settings.stream() << ",\n";
    dump_json_value<const VkImageTiling>(object.tiling, NULL, settings, "VkImageTiling", "tiling", false, false, indents + 1, dump_json_VkImageTiling);
    settings.stream() << ",\n";
    dump_json_value<const VkImageUsageFlags>(object.usage, NULL, settings, "VkImageUsageFlags", "usage", false, false, indents + 1, dump_json_VkImageUsageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSharingMode>(object.sharingMode, NULL, settings, "VkSharingMode", "sharingMode", false, false, indents + 1, dump_json_VkSharingMode);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.queueFamilyIndexCount, NULL, settings, "uint32_t", "queueFamilyIndexCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    if(object.sharingMode == VK_SHARING_MODE_CONCURRENT)
    dump_json_array<const uint32_t>(object.pQueueFamilyIndices, object.queueFamilyIndexCount, settings, "const uint32_t*", "const uint32_t", "pQueueFamilyIndices", false, false, indents + 1, dump_json_uint32_t); // JQA
    else
        dump_json_UNUSED(settings, "const uint32_t*", "pQueueFamilyIndices", indents + 1);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.initialLayout, NULL, settings, "VkImageLayout", "initialLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSubresourceLayout(const VkSubresourceLayout& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkDeviceSize>(object.offset, NULL, settings, "VkDeviceSize", "offset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.size, NULL, settings, "VkDeviceSize", "size", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.rowPitch, NULL, settings, "VkDeviceSize", "rowPitch", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.arrayPitch, NULL, settings, "VkDeviceSize", "arrayPitch", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.depthPitch, NULL, settings, "VkDeviceSize", "depthPitch", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkComponentMapping(const VkComponentMapping& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkComponentSwizzle>(object.r, NULL, settings, "VkComponentSwizzle", "r", false, false, indents + 1, dump_json_VkComponentSwizzle);
    settings.stream() << ",\n";
    dump_json_value<const VkComponentSwizzle>(object.g, NULL, settings, "VkComponentSwizzle", "g", false, false, indents + 1, dump_json_VkComponentSwizzle);
    settings.stream() << ",\n";
    dump_json_value<const VkComponentSwizzle>(object.b, NULL, settings, "VkComponentSwizzle", "b", false, false, indents + 1, dump_json_VkComponentSwizzle);
    settings.stream() << ",\n";
    dump_json_value<const VkComponentSwizzle>(object.a, NULL, settings, "VkComponentSwizzle", "a", false, false, indents + 1, dump_json_VkComponentSwizzle);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageViewCreateInfo(const VkImageViewCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageViewCreateFlags>(object.flags, NULL, settings, "VkImageViewCreateFlags", "flags", false, false, indents + 1, dump_json_VkImageViewCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.image, NULL, settings, "VkImage", "image", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const VkImageViewType>(object.viewType, NULL, settings, "VkImageViewType", "viewType", false, false, indents + 1, dump_json_VkImageViewType);
    settings.stream() << ",\n";
    dump_json_value<const VkFormat>(object.format, NULL, settings, "VkFormat", "format", false, false, indents + 1, dump_json_VkFormat);
    settings.stream() << ",\n";
    dump_json_value<const VkComponentMapping>(object.components, NULL, settings, "VkComponentMapping", "components", true, false, indents + 1, dump_json_VkComponentMapping);
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceRange>(object.subresourceRange, NULL, settings, "VkImageSubresourceRange", "subresourceRange", true, false, indents + 1, dump_json_VkImageSubresourceRange);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkShaderModuleCreateInfo(const VkShaderModuleCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkShaderModuleCreateFlags>(object.flags, NULL, settings, "VkShaderModuleCreateFlags", "flags", false, false, indents + 1, dump_json_VkShaderModuleCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const size_t>(object.codeSize, NULL, settings, "size_t", "codeSize", false, false, indents + 1, dump_json_size_t);
    settings.stream() << ",\n";
    if(settings.showShader())
        dump_json_array<const uint32_t>(object.pCode, object.codeSize / 4, settings, "const uint32_t*", "const uint32_t", "pCode", false, false, indents + 1, dump_json_uint32_t); // KQA
    else
        dump_json_special("SHADER DATA", settings, "const uint32_t*", "pCode", indents + 1);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineCacheCreateInfo(const VkPipelineCacheCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineCacheCreateFlags>(object.flags, NULL, settings, "VkPipelineCacheCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineCacheCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const size_t>(object.initialDataSize, NULL, settings, "size_t", "initialDataSize", false, false, indents + 1, dump_json_size_t);
    settings.stream() << ",\n";
    dump_json_value<const void*>(object.pInitialData, NULL, settings, "const void*", "pInitialData", false, false, indents + 1, dump_json_void);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSpecializationMapEntry(const VkSpecializationMapEntry& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.constantID, NULL, settings, "uint32_t", "constantID", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.offset, NULL, settings, "uint32_t", "offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const size_t>(object.size, NULL, settings, "size_t", "size", false, false, indents + 1, dump_json_size_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSpecializationInfo(const VkSpecializationInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.mapEntryCount, NULL, settings, "uint32_t", "mapEntryCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSpecializationMapEntry>(object.pMapEntries, object.mapEntryCount, settings, "const VkSpecializationMapEntry*", "const VkSpecializationMapEntry", "pMapEntries", true, false, indents + 1, dump_json_VkSpecializationMapEntry); // JQA
    settings.stream() << ",\n";
    dump_json_value<const size_t>(object.dataSize, NULL, settings, "size_t", "dataSize", false, false, indents + 1, dump_json_size_t);
    settings.stream() << ",\n";
    dump_json_value<const void*>(object.pData, NULL, settings, "const void*", "pData", false, false, indents + 1, dump_json_void);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineShaderStageCreateInfo(const VkPipelineShaderStageCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineShaderStageCreateFlags>(object.flags, NULL, settings, "VkPipelineShaderStageCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineShaderStageCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkShaderStageFlagBits>(object.stage, NULL, settings, "VkShaderStageFlagBits", "stage", false, false, indents + 1, dump_json_VkShaderStageFlagBits);
    settings.stream() << ",\n";
    dump_json_value<const VkShaderModule>(object.module, NULL, settings, "VkShaderModule", "module", false, false, indents + 1, dump_json_VkShaderModule);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.pName, NULL, settings, "const char*", "pName", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_pointer<const VkSpecializationInfo>(object.pSpecializationInfo, settings, "const VkSpecializationInfo*", "pSpecializationInfo", true, false, indents + 1, dump_json_VkSpecializationInfo);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkComputePipelineCreateInfo(const VkComputePipelineCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineCreateFlags>(object.flags, NULL, settings, "VkPipelineCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineShaderStageCreateInfo>(object.stage, NULL, settings, "VkPipelineShaderStageCreateInfo", "stage", true, false, indents + 1, dump_json_VkPipelineShaderStageCreateInfo);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineLayout>(object.layout, NULL, settings, "VkPipelineLayout", "layout", false, false, indents + 1, dump_json_VkPipelineLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkPipeline>(object.basePipelineHandle, NULL, settings, "VkPipeline", "basePipelineHandle", false, false, indents + 1, dump_json_VkPipeline);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.basePipelineIndex, NULL, settings, "int32_t", "basePipelineIndex", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkVertexInputBindingDescription(const VkVertexInputBindingDescription& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.binding, NULL, settings, "uint32_t", "binding", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.stride, NULL, settings, "uint32_t", "stride", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkVertexInputRate>(object.inputRate, NULL, settings, "VkVertexInputRate", "inputRate", false, false, indents + 1, dump_json_VkVertexInputRate);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkVertexInputAttributeDescription(const VkVertexInputAttributeDescription& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.location, NULL, settings, "uint32_t", "location", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.binding, NULL, settings, "uint32_t", "binding", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkFormat>(object.format, NULL, settings, "VkFormat", "format", false, false, indents + 1, dump_json_VkFormat);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.offset, NULL, settings, "uint32_t", "offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineVertexInputStateCreateInfo(const VkPipelineVertexInputStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineVertexInputStateCreateFlags>(object.flags, NULL, settings, "VkPipelineVertexInputStateCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineVertexInputStateCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vertexBindingDescriptionCount, NULL, settings, "uint32_t", "vertexBindingDescriptionCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkVertexInputBindingDescription>(object.pVertexBindingDescriptions, object.vertexBindingDescriptionCount, settings, "const VkVertexInputBindingDescription*", "const VkVertexInputBindingDescription", "pVertexBindingDescriptions", true, false, indents + 1, dump_json_VkVertexInputBindingDescription); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.vertexAttributeDescriptionCount, NULL, settings, "uint32_t", "vertexAttributeDescriptionCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkVertexInputAttributeDescription>(object.pVertexAttributeDescriptions, object.vertexAttributeDescriptionCount, settings, "const VkVertexInputAttributeDescription*", "const VkVertexInputAttributeDescription", "pVertexAttributeDescriptions", true, false, indents + 1, dump_json_VkVertexInputAttributeDescription); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineInputAssemblyStateCreateInfo(const VkPipelineInputAssemblyStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineInputAssemblyStateCreateFlags>(object.flags, NULL, settings, "VkPipelineInputAssemblyStateCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineInputAssemblyStateCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkPrimitiveTopology>(object.topology, NULL, settings, "VkPrimitiveTopology", "topology", false, false, indents + 1, dump_json_VkPrimitiveTopology);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.primitiveRestartEnable, NULL, settings, "VkBool32", "primitiveRestartEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineTessellationStateCreateInfo(const VkPipelineTessellationStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineTessellationStateCreateFlags>(object.flags, NULL, settings, "VkPipelineTessellationStateCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineTessellationStateCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.patchControlPoints, NULL, settings, "uint32_t", "patchControlPoints", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkViewport(const VkViewport& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const float>(object.x, NULL, settings, "float", "x", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.y, NULL, settings, "float", "y", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.width, NULL, settings, "float", "width", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.height, NULL, settings, "float", "height", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.minDepth, NULL, settings, "float", "minDepth", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.maxDepth, NULL, settings, "float", "maxDepth", false, false, indents + 1, dump_json_float);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineViewportStateCreateInfo(const VkPipelineViewportStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineViewportStateCreateFlags>(object.flags, NULL, settings, "VkPipelineViewportStateCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineViewportStateCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.viewportCount, NULL, settings, "uint32_t", "viewportCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    if(!ApiDumpInstance::current().getIsDynamicViewport())
    dump_json_array<const VkViewport>(object.pViewports, object.viewportCount, settings, "const VkViewport*", "const VkViewport", "pViewports", true, false, indents + 1, dump_json_VkViewport); // JQA
    else
        dump_json_UNUSED(settings, "const VkViewport*", "pViewports", indents + 1);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.scissorCount, NULL, settings, "uint32_t", "scissorCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    if(!ApiDumpInstance::current().getIsDynamicScissor())
    dump_json_array<const VkRect2D>(object.pScissors, object.scissorCount, settings, "const VkRect2D*", "const VkRect2D", "pScissors", true, false, indents + 1, dump_json_VkRect2D); // JQA
    else
        dump_json_UNUSED(settings, "const VkRect2D*", "pScissors", indents + 1);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineRasterizationStateCreateInfo(const VkPipelineRasterizationStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineRasterizationStateCreateFlags>(object.flags, NULL, settings, "VkPipelineRasterizationStateCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineRasterizationStateCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.depthClampEnable, NULL, settings, "VkBool32", "depthClampEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.rasterizerDiscardEnable, NULL, settings, "VkBool32", "rasterizerDiscardEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkPolygonMode>(object.polygonMode, NULL, settings, "VkPolygonMode", "polygonMode", false, false, indents + 1, dump_json_VkPolygonMode);
    settings.stream() << ",\n";
    dump_json_value<const VkCullModeFlags>(object.cullMode, NULL, settings, "VkCullModeFlags", "cullMode", false, false, indents + 1, dump_json_VkCullModeFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkFrontFace>(object.frontFace, NULL, settings, "VkFrontFace", "frontFace", false, false, indents + 1, dump_json_VkFrontFace);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.depthBiasEnable, NULL, settings, "VkBool32", "depthBiasEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.depthBiasConstantFactor, NULL, settings, "float", "depthBiasConstantFactor", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.depthBiasClamp, NULL, settings, "float", "depthBiasClamp", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.depthBiasSlopeFactor, NULL, settings, "float", "depthBiasSlopeFactor", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.lineWidth, NULL, settings, "float", "lineWidth", false, false, indents + 1, dump_json_float);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineMultisampleStateCreateInfo(const VkPipelineMultisampleStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineMultisampleStateCreateFlags>(object.flags, NULL, settings, "VkPipelineMultisampleStateCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineMultisampleStateCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlagBits>(object.rasterizationSamples, NULL, settings, "VkSampleCountFlagBits", "rasterizationSamples", false, false, indents + 1, dump_json_VkSampleCountFlagBits);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.sampleShadingEnable, NULL, settings, "VkBool32", "sampleShadingEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.minSampleShading, NULL, settings, "float", "minSampleShading", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_array<const VkSampleMask>(object.pSampleMask, (object.rasterizationSamples + 31) / 32, settings, "const VkSampleMask*", "const VkSampleMask", "pSampleMask", false, false, indents + 1, dump_json_VkSampleMask); // JQA
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.alphaToCoverageEnable, NULL, settings, "VkBool32", "alphaToCoverageEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.alphaToOneEnable, NULL, settings, "VkBool32", "alphaToOneEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkStencilOpState(const VkStencilOpState& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStencilOp>(object.failOp, NULL, settings, "VkStencilOp", "failOp", false, false, indents + 1, dump_json_VkStencilOp);
    settings.stream() << ",\n";
    dump_json_value<const VkStencilOp>(object.passOp, NULL, settings, "VkStencilOp", "passOp", false, false, indents + 1, dump_json_VkStencilOp);
    settings.stream() << ",\n";
    dump_json_value<const VkStencilOp>(object.depthFailOp, NULL, settings, "VkStencilOp", "depthFailOp", false, false, indents + 1, dump_json_VkStencilOp);
    settings.stream() << ",\n";
    dump_json_value<const VkCompareOp>(object.compareOp, NULL, settings, "VkCompareOp", "compareOp", false, false, indents + 1, dump_json_VkCompareOp);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.compareMask, NULL, settings, "uint32_t", "compareMask", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.writeMask, NULL, settings, "uint32_t", "writeMask", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.reference, NULL, settings, "uint32_t", "reference", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineDepthStencilStateCreateInfo(const VkPipelineDepthStencilStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineDepthStencilStateCreateFlags>(object.flags, NULL, settings, "VkPipelineDepthStencilStateCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineDepthStencilStateCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.depthTestEnable, NULL, settings, "VkBool32", "depthTestEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.depthWriteEnable, NULL, settings, "VkBool32", "depthWriteEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkCompareOp>(object.depthCompareOp, NULL, settings, "VkCompareOp", "depthCompareOp", false, false, indents + 1, dump_json_VkCompareOp);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.depthBoundsTestEnable, NULL, settings, "VkBool32", "depthBoundsTestEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.stencilTestEnable, NULL, settings, "VkBool32", "stencilTestEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkStencilOpState>(object.front, NULL, settings, "VkStencilOpState", "front", true, false, indents + 1, dump_json_VkStencilOpState);
    settings.stream() << ",\n";
    dump_json_value<const VkStencilOpState>(object.back, NULL, settings, "VkStencilOpState", "back", true, false, indents + 1, dump_json_VkStencilOpState);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.minDepthBounds, NULL, settings, "float", "minDepthBounds", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.maxDepthBounds, NULL, settings, "float", "maxDepthBounds", false, false, indents + 1, dump_json_float);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineColorBlendAttachmentState(const VkPipelineColorBlendAttachmentState& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkBool32>(object.blendEnable, NULL, settings, "VkBool32", "blendEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBlendFactor>(object.srcColorBlendFactor, NULL, settings, "VkBlendFactor", "srcColorBlendFactor", false, false, indents + 1, dump_json_VkBlendFactor);
    settings.stream() << ",\n";
    dump_json_value<const VkBlendFactor>(object.dstColorBlendFactor, NULL, settings, "VkBlendFactor", "dstColorBlendFactor", false, false, indents + 1, dump_json_VkBlendFactor);
    settings.stream() << ",\n";
    dump_json_value<const VkBlendOp>(object.colorBlendOp, NULL, settings, "VkBlendOp", "colorBlendOp", false, false, indents + 1, dump_json_VkBlendOp);
    settings.stream() << ",\n";
    dump_json_value<const VkBlendFactor>(object.srcAlphaBlendFactor, NULL, settings, "VkBlendFactor", "srcAlphaBlendFactor", false, false, indents + 1, dump_json_VkBlendFactor);
    settings.stream() << ",\n";
    dump_json_value<const VkBlendFactor>(object.dstAlphaBlendFactor, NULL, settings, "VkBlendFactor", "dstAlphaBlendFactor", false, false, indents + 1, dump_json_VkBlendFactor);
    settings.stream() << ",\n";
    dump_json_value<const VkBlendOp>(object.alphaBlendOp, NULL, settings, "VkBlendOp", "alphaBlendOp", false, false, indents + 1, dump_json_VkBlendOp);
    settings.stream() << ",\n";
    dump_json_value<const VkColorComponentFlags>(object.colorWriteMask, NULL, settings, "VkColorComponentFlags", "colorWriteMask", false, false, indents + 1, dump_json_VkColorComponentFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineColorBlendStateCreateInfo(const VkPipelineColorBlendStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineColorBlendStateCreateFlags>(object.flags, NULL, settings, "VkPipelineColorBlendStateCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineColorBlendStateCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.logicOpEnable, NULL, settings, "VkBool32", "logicOpEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkLogicOp>(object.logicOp, NULL, settings, "VkLogicOp", "logicOp", false, false, indents + 1, dump_json_VkLogicOp);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.attachmentCount, NULL, settings, "uint32_t", "attachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkPipelineColorBlendAttachmentState>(object.pAttachments, object.attachmentCount, settings, "const VkPipelineColorBlendAttachmentState*", "const VkPipelineColorBlendAttachmentState", "pAttachments", true, false, indents + 1, dump_json_VkPipelineColorBlendAttachmentState); // JQA
    settings.stream() << ",\n";
    dump_json_array<const float>(object.blendConstants, 4, settings, "float[4]", "float", "blendConstants", false, false, indents + 1, dump_json_float); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineDynamicStateCreateInfo(const VkPipelineDynamicStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineDynamicStateCreateFlags>(object.flags, NULL, settings, "VkPipelineDynamicStateCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineDynamicStateCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dynamicStateCount, NULL, settings, "uint32_t", "dynamicStateCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkDynamicState>(object.pDynamicStates, object.dynamicStateCount, settings, "const VkDynamicState*", "const VkDynamicState", "pDynamicStates", false, false, indents + 1, dump_json_VkDynamicState); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkGraphicsPipelineCreateInfo(const VkGraphicsPipelineCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    ApiDumpInstance::current().setIsDynamicViewport(object.pDynamicState && std::count(object.pDynamicState->pDynamicStates, object.pDynamicState->pDynamicStates + object.pDynamicState->dynamicStateCount, VK_DYNAMIC_STATE_VIEWPORT) > 0);ApiDumpInstance::current().setIsDynamicScissor(object.pDynamicState && std::count(object.pDynamicState->pDynamicStates, object.pDynamicState->pDynamicStates + object.pDynamicState->dynamicStateCount, VK_DYNAMIC_STATE_SCISSOR));ApiDumpInstance::current().setIsGPLPreRasterOrFragmentShader(checkForGPLPreRasterOrFragmentShader(object));
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineCreateFlags>(object.flags, NULL, settings, "VkPipelineCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.stageCount, NULL, settings, "uint32_t", "stageCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkPipelineShaderStageCreateInfo>(object.pStages, object.stageCount, settings, "const VkPipelineShaderStageCreateInfo*", "const VkPipelineShaderStageCreateInfo", "pStages", true, false, indents + 1, dump_json_VkPipelineShaderStageCreateInfo); // JQA
    settings.stream() << ",\n";
    dump_json_pointer<const VkPipelineVertexInputStateCreateInfo>(object.pVertexInputState, settings, "const VkPipelineVertexInputStateCreateInfo*", "pVertexInputState", true, false, indents + 1, dump_json_VkPipelineVertexInputStateCreateInfo);
    settings.stream() << ",\n";
    dump_json_pointer<const VkPipelineInputAssemblyStateCreateInfo>(object.pInputAssemblyState, settings, "const VkPipelineInputAssemblyStateCreateInfo*", "pInputAssemblyState", true, false, indents + 1, dump_json_VkPipelineInputAssemblyStateCreateInfo);
    settings.stream() << ",\n";
    dump_json_pointer<const VkPipelineTessellationStateCreateInfo>(object.pTessellationState, settings, "const VkPipelineTessellationStateCreateInfo*", "pTessellationState", true, false, indents + 1, dump_json_VkPipelineTessellationStateCreateInfo);
    settings.stream() << ",\n";
    dump_json_pointer<const VkPipelineViewportStateCreateInfo>(object.pViewportState, settings, "const VkPipelineViewportStateCreateInfo*", "pViewportState", true, false, indents + 1, dump_json_VkPipelineViewportStateCreateInfo);
    settings.stream() << ",\n";
    dump_json_pointer<const VkPipelineRasterizationStateCreateInfo>(object.pRasterizationState, settings, "const VkPipelineRasterizationStateCreateInfo*", "pRasterizationState", true, false, indents + 1, dump_json_VkPipelineRasterizationStateCreateInfo);
    settings.stream() << ",\n";
    dump_json_pointer<const VkPipelineMultisampleStateCreateInfo>(object.pMultisampleState, settings, "const VkPipelineMultisampleStateCreateInfo*", "pMultisampleState", true, false, indents + 1, dump_json_VkPipelineMultisampleStateCreateInfo);
    settings.stream() << ",\n";
    dump_json_pointer<const VkPipelineDepthStencilStateCreateInfo>(object.pDepthStencilState, settings, "const VkPipelineDepthStencilStateCreateInfo*", "pDepthStencilState", true, false, indents + 1, dump_json_VkPipelineDepthStencilStateCreateInfo);
    settings.stream() << ",\n";
    dump_json_pointer<const VkPipelineColorBlendStateCreateInfo>(object.pColorBlendState, settings, "const VkPipelineColorBlendStateCreateInfo*", "pColorBlendState", true, false, indents + 1, dump_json_VkPipelineColorBlendStateCreateInfo);
    settings.stream() << ",\n";
    dump_json_pointer<const VkPipelineDynamicStateCreateInfo>(object.pDynamicState, settings, "const VkPipelineDynamicStateCreateInfo*", "pDynamicState", true, false, indents + 1, dump_json_VkPipelineDynamicStateCreateInfo);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineLayout>(object.layout, NULL, settings, "VkPipelineLayout", "layout", false, false, indents + 1, dump_json_VkPipelineLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkRenderPass>(object.renderPass, NULL, settings, "VkRenderPass", "renderPass", false, false, indents + 1, dump_json_VkRenderPass);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.subpass, NULL, settings, "uint32_t", "subpass", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkPipeline>(object.basePipelineHandle, NULL, settings, "VkPipeline", "basePipelineHandle", false, false, indents + 1, dump_json_VkPipeline);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.basePipelineIndex, NULL, settings, "int32_t", "basePipelineIndex", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPushConstantRange(const VkPushConstantRange& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkShaderStageFlags>(object.stageFlags, NULL, settings, "VkShaderStageFlags", "stageFlags", false, false, indents + 1, dump_json_VkShaderStageFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.offset, NULL, settings, "uint32_t", "offset", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.size, NULL, settings, "uint32_t", "size", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineLayoutCreateInfo(const VkPipelineLayoutCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineLayoutCreateFlags>(object.flags, NULL, settings, "VkPipelineLayoutCreateFlags", "flags", false, false, indents + 1, dump_json_VkPipelineLayoutCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.setLayoutCount, NULL, settings, "uint32_t", "setLayoutCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkDescriptorSetLayout>(object.pSetLayouts, object.setLayoutCount, settings, "const VkDescriptorSetLayout*", "const VkDescriptorSetLayout", "pSetLayouts", false, false, indents + 1, dump_json_VkDescriptorSetLayout); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pushConstantRangeCount, NULL, settings, "uint32_t", "pushConstantRangeCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkPushConstantRange>(object.pPushConstantRanges, object.pushConstantRangeCount, settings, "const VkPushConstantRange*", "const VkPushConstantRange", "pPushConstantRanges", true, false, indents + 1, dump_json_VkPushConstantRange); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSamplerCreateInfo(const VkSamplerCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSamplerCreateFlags>(object.flags, NULL, settings, "VkSamplerCreateFlags", "flags", false, false, indents + 1, dump_json_VkSamplerCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkFilter>(object.magFilter, NULL, settings, "VkFilter", "magFilter", false, false, indents + 1, dump_json_VkFilter);
    settings.stream() << ",\n";
    dump_json_value<const VkFilter>(object.minFilter, NULL, settings, "VkFilter", "minFilter", false, false, indents + 1, dump_json_VkFilter);
    settings.stream() << ",\n";
    dump_json_value<const VkSamplerMipmapMode>(object.mipmapMode, NULL, settings, "VkSamplerMipmapMode", "mipmapMode", false, false, indents + 1, dump_json_VkSamplerMipmapMode);
    settings.stream() << ",\n";
    dump_json_value<const VkSamplerAddressMode>(object.addressModeU, NULL, settings, "VkSamplerAddressMode", "addressModeU", false, false, indents + 1, dump_json_VkSamplerAddressMode);
    settings.stream() << ",\n";
    dump_json_value<const VkSamplerAddressMode>(object.addressModeV, NULL, settings, "VkSamplerAddressMode", "addressModeV", false, false, indents + 1, dump_json_VkSamplerAddressMode);
    settings.stream() << ",\n";
    dump_json_value<const VkSamplerAddressMode>(object.addressModeW, NULL, settings, "VkSamplerAddressMode", "addressModeW", false, false, indents + 1, dump_json_VkSamplerAddressMode);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.mipLodBias, NULL, settings, "float", "mipLodBias", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.anisotropyEnable, NULL, settings, "VkBool32", "anisotropyEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.maxAnisotropy, NULL, settings, "float", "maxAnisotropy", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.compareEnable, NULL, settings, "VkBool32", "compareEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkCompareOp>(object.compareOp, NULL, settings, "VkCompareOp", "compareOp", false, false, indents + 1, dump_json_VkCompareOp);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.minLod, NULL, settings, "float", "minLod", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const float>(object.maxLod, NULL, settings, "float", "maxLod", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const VkBorderColor>(object.borderColor, NULL, settings, "VkBorderColor", "borderColor", false, false, indents + 1, dump_json_VkBorderColor);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.unnormalizedCoordinates, NULL, settings, "VkBool32", "unnormalizedCoordinates", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkCopyDescriptorSet(const VkCopyDescriptorSet& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorSet>(object.srcSet, NULL, settings, "VkDescriptorSet", "srcSet", false, false, indents + 1, dump_json_VkDescriptorSet);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.srcBinding, NULL, settings, "uint32_t", "srcBinding", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.srcArrayElement, NULL, settings, "uint32_t", "srcArrayElement", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorSet>(object.dstSet, NULL, settings, "VkDescriptorSet", "dstSet", false, false, indents + 1, dump_json_VkDescriptorSet);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstBinding, NULL, settings, "uint32_t", "dstBinding", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstArrayElement, NULL, settings, "uint32_t", "dstArrayElement", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.descriptorCount, NULL, settings, "uint32_t", "descriptorCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorBufferInfo(const VkDescriptorBufferInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkBuffer>(object.buffer, NULL, settings, "VkBuffer", "buffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.offset, NULL, settings, "VkDeviceSize", "offset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.range, NULL, settings, "VkDeviceSize", "range", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorImageInfo(const VkDescriptorImageInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkSampler>(object.sampler, NULL, settings, "VkSampler", "sampler", false, false, indents + 1, dump_json_VkSampler);
    settings.stream() << ",\n";
    dump_json_value<const VkImageView>(object.imageView, NULL, settings, "VkImageView", "imageView", false, false, indents + 1, dump_json_VkImageView);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.imageLayout, NULL, settings, "VkImageLayout", "imageLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorPoolSize(const VkDescriptorPoolSize& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkDescriptorType>(object.type, NULL, settings, "VkDescriptorType", "type", false, false, indents + 1, dump_json_VkDescriptorType);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.descriptorCount, NULL, settings, "uint32_t", "descriptorCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorPoolCreateInfo(const VkDescriptorPoolCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorPoolCreateFlags>(object.flags, NULL, settings, "VkDescriptorPoolCreateFlags", "flags", false, false, indents + 1, dump_json_VkDescriptorPoolCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxSets, NULL, settings, "uint32_t", "maxSets", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.poolSizeCount, NULL, settings, "uint32_t", "poolSizeCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkDescriptorPoolSize>(object.pPoolSizes, object.poolSizeCount, settings, "const VkDescriptorPoolSize*", "const VkDescriptorPoolSize", "pPoolSizes", true, false, indents + 1, dump_json_VkDescriptorPoolSize); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorSetAllocateInfo(const VkDescriptorSetAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorPool>(object.descriptorPool, NULL, settings, "VkDescriptorPool", "descriptorPool", false, false, indents + 1, dump_json_VkDescriptorPool);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.descriptorSetCount, NULL, settings, "uint32_t", "descriptorSetCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkDescriptorSetLayout>(object.pSetLayouts, object.descriptorSetCount, settings, "const VkDescriptorSetLayout*", "const VkDescriptorSetLayout", "pSetLayouts", false, false, indents + 1, dump_json_VkDescriptorSetLayout); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorSetLayoutBinding(const VkDescriptorSetLayoutBinding& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.binding, NULL, settings, "uint32_t", "binding", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorType>(object.descriptorType, NULL, settings, "VkDescriptorType", "descriptorType", false, false, indents + 1, dump_json_VkDescriptorType);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.descriptorCount, NULL, settings, "uint32_t", "descriptorCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkShaderStageFlags>(object.stageFlags, NULL, settings, "VkShaderStageFlags", "stageFlags", false, false, indents + 1, dump_json_VkShaderStageFlags);
    settings.stream() << ",\n";
    if((object.descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER))
    dump_json_array<const VkSampler>(object.pImmutableSamplers, object.descriptorCount, settings, "const VkSampler*", "const VkSampler", "pImmutableSamplers", false, false, indents + 1, dump_json_VkSampler); // JQA
    else
        dump_json_UNUSED(settings, "const VkSampler*", "pImmutableSamplers", indents + 1);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorSetLayoutCreateInfo(const VkDescriptorSetLayoutCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorSetLayoutCreateFlags>(object.flags, NULL, settings, "VkDescriptorSetLayoutCreateFlags", "flags", false, false, indents + 1, dump_json_VkDescriptorSetLayoutCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bindingCount, NULL, settings, "uint32_t", "bindingCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkDescriptorSetLayoutBinding>(object.pBindings, object.bindingCount, settings, "const VkDescriptorSetLayoutBinding*", "const VkDescriptorSetLayoutBinding", "pBindings", true, false, indents + 1, dump_json_VkDescriptorSetLayoutBinding); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkWriteDescriptorSet(const VkWriteDescriptorSet& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorSet>(object.dstSet, NULL, settings, "VkDescriptorSet", "dstSet", false, false, indents + 1, dump_json_VkDescriptorSet);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstBinding, NULL, settings, "uint32_t", "dstBinding", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstArrayElement, NULL, settings, "uint32_t", "dstArrayElement", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.descriptorCount, NULL, settings, "uint32_t", "descriptorCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorType>(object.descriptorType, NULL, settings, "VkDescriptorType", "descriptorType", false, false, indents + 1, dump_json_VkDescriptorType);
    settings.stream() << ",\n";
    if((object.descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE) || (object.descriptorType == VK_DESCRIPTOR_TYPE_STORAGE_IMAGE) || (object.descriptorType == VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT))
    dump_json_array<const VkDescriptorImageInfo>(object.pImageInfo, object.descriptorCount, settings, "const VkDescriptorImageInfo*", "const VkDescriptorImageInfo", "pImageInfo", true, false, indents + 1, dump_json_VkDescriptorImageInfo); // JQA
    else
        dump_json_UNUSED(settings, "const VkDescriptorImageInfo*", "pImageInfo", indents + 1);
    settings.stream() << ",\n";
    if((object.descriptorType == VK_DESCRIPTOR_TYPE_STORAGE_BUFFER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC) || (object.descriptorType == VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC))
    dump_json_array<const VkDescriptorBufferInfo>(object.pBufferInfo, object.descriptorCount, settings, "const VkDescriptorBufferInfo*", "const VkDescriptorBufferInfo", "pBufferInfo", true, false, indents + 1, dump_json_VkDescriptorBufferInfo); // JQA
    else
        dump_json_UNUSED(settings, "const VkDescriptorBufferInfo*", "pBufferInfo", indents + 1);
    settings.stream() << ",\n";
    if((object.descriptorType == VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER) || (object.descriptorType == VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER))
    dump_json_array<const VkBufferView>(object.pTexelBufferView, object.descriptorCount, settings, "const VkBufferView*", "const VkBufferView", "pTexelBufferView", false, false, indents + 1, dump_json_VkBufferView); // JQA
    else
        dump_json_UNUSED(settings, "const VkBufferView*", "pTexelBufferView", indents + 1);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkAttachmentDescription(const VkAttachmentDescription& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkAttachmentDescriptionFlags>(object.flags, NULL, settings, "VkAttachmentDescriptionFlags", "flags", false, false, indents + 1, dump_json_VkAttachmentDescriptionFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkFormat>(object.format, NULL, settings, "VkFormat", "format", false, false, indents + 1, dump_json_VkFormat);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlagBits>(object.samples, NULL, settings, "VkSampleCountFlagBits", "samples", false, false, indents + 1, dump_json_VkSampleCountFlagBits);
    settings.stream() << ",\n";
    dump_json_value<const VkAttachmentLoadOp>(object.loadOp, NULL, settings, "VkAttachmentLoadOp", "loadOp", false, false, indents + 1, dump_json_VkAttachmentLoadOp);
    settings.stream() << ",\n";
    dump_json_value<const VkAttachmentStoreOp>(object.storeOp, NULL, settings, "VkAttachmentStoreOp", "storeOp", false, false, indents + 1, dump_json_VkAttachmentStoreOp);
    settings.stream() << ",\n";
    dump_json_value<const VkAttachmentLoadOp>(object.stencilLoadOp, NULL, settings, "VkAttachmentLoadOp", "stencilLoadOp", false, false, indents + 1, dump_json_VkAttachmentLoadOp);
    settings.stream() << ",\n";
    dump_json_value<const VkAttachmentStoreOp>(object.stencilStoreOp, NULL, settings, "VkAttachmentStoreOp", "stencilStoreOp", false, false, indents + 1, dump_json_VkAttachmentStoreOp);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.initialLayout, NULL, settings, "VkImageLayout", "initialLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.finalLayout, NULL, settings, "VkImageLayout", "finalLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkAttachmentReference(const VkAttachmentReference& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.attachment, NULL, settings, "uint32_t", "attachment", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.layout, NULL, settings, "VkImageLayout", "layout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkFramebufferCreateInfo(const VkFramebufferCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkFramebufferCreateFlags>(object.flags, NULL, settings, "VkFramebufferCreateFlags", "flags", false, false, indents + 1, dump_json_VkFramebufferCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkRenderPass>(object.renderPass, NULL, settings, "VkRenderPass", "renderPass", false, false, indents + 1, dump_json_VkRenderPass);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.attachmentCount, NULL, settings, "uint32_t", "attachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkImageView>(object.pAttachments, object.attachmentCount, settings, "const VkImageView*", "const VkImageView", "pAttachments", false, false, indents + 1, dump_json_VkImageView); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.width, NULL, settings, "uint32_t", "width", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.height, NULL, settings, "uint32_t", "height", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.layers, NULL, settings, "uint32_t", "layers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSubpassDescription(const VkSubpassDescription& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkSubpassDescriptionFlags>(object.flags, NULL, settings, "VkSubpassDescriptionFlags", "flags", false, false, indents + 1, dump_json_VkSubpassDescriptionFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineBindPoint>(object.pipelineBindPoint, NULL, settings, "VkPipelineBindPoint", "pipelineBindPoint", false, false, indents + 1, dump_json_VkPipelineBindPoint);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.inputAttachmentCount, NULL, settings, "uint32_t", "inputAttachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkAttachmentReference>(object.pInputAttachments, object.inputAttachmentCount, settings, "const VkAttachmentReference*", "const VkAttachmentReference", "pInputAttachments", true, false, indents + 1, dump_json_VkAttachmentReference); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.colorAttachmentCount, NULL, settings, "uint32_t", "colorAttachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkAttachmentReference>(object.pColorAttachments, object.colorAttachmentCount, settings, "const VkAttachmentReference*", "const VkAttachmentReference", "pColorAttachments", true, false, indents + 1, dump_json_VkAttachmentReference); // JQA
    settings.stream() << ",\n";
    dump_json_array<const VkAttachmentReference>(object.pResolveAttachments, object.colorAttachmentCount, settings, "const VkAttachmentReference*", "const VkAttachmentReference", "pResolveAttachments", true, false, indents + 1, dump_json_VkAttachmentReference); // JQA
    settings.stream() << ",\n";
    dump_json_pointer<const VkAttachmentReference>(object.pDepthStencilAttachment, settings, "const VkAttachmentReference*", "pDepthStencilAttachment", true, false, indents + 1, dump_json_VkAttachmentReference);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.preserveAttachmentCount, NULL, settings, "uint32_t", "preserveAttachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pPreserveAttachments, object.preserveAttachmentCount, settings, "const uint32_t*", "const uint32_t", "pPreserveAttachments", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSubpassDependency(const VkSubpassDependency& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.srcSubpass, NULL, settings, "uint32_t", "srcSubpass", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstSubpass, NULL, settings, "uint32_t", "dstSubpass", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags>(object.srcStageMask, NULL, settings, "VkPipelineStageFlags", "srcStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags>(object.dstStageMask, NULL, settings, "VkPipelineStageFlags", "dstStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags>(object.srcAccessMask, NULL, settings, "VkAccessFlags", "srcAccessMask", false, false, indents + 1, dump_json_VkAccessFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags>(object.dstAccessMask, NULL, settings, "VkAccessFlags", "dstAccessMask", false, false, indents + 1, dump_json_VkAccessFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkDependencyFlags>(object.dependencyFlags, NULL, settings, "VkDependencyFlags", "dependencyFlags", false, false, indents + 1, dump_json_VkDependencyFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkRenderPassCreateInfo(const VkRenderPassCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkRenderPassCreateFlags>(object.flags, NULL, settings, "VkRenderPassCreateFlags", "flags", false, false, indents + 1, dump_json_VkRenderPassCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.attachmentCount, NULL, settings, "uint32_t", "attachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkAttachmentDescription>(object.pAttachments, object.attachmentCount, settings, "const VkAttachmentDescription*", "const VkAttachmentDescription", "pAttachments", true, false, indents + 1, dump_json_VkAttachmentDescription); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.subpassCount, NULL, settings, "uint32_t", "subpassCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSubpassDescription>(object.pSubpasses, object.subpassCount, settings, "const VkSubpassDescription*", "const VkSubpassDescription", "pSubpasses", true, false, indents + 1, dump_json_VkSubpassDescription); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dependencyCount, NULL, settings, "uint32_t", "dependencyCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSubpassDependency>(object.pDependencies, object.dependencyCount, settings, "const VkSubpassDependency*", "const VkSubpassDependency", "pDependencies", true, false, indents + 1, dump_json_VkSubpassDependency); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkCommandPoolCreateInfo(const VkCommandPoolCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkCommandPoolCreateFlags>(object.flags, NULL, settings, "VkCommandPoolCreateFlags", "flags", false, false, indents + 1, dump_json_VkCommandPoolCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.queueFamilyIndex, NULL, settings, "uint32_t", "queueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkCommandBufferAllocateInfo(const VkCommandBufferAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkCommandPool>(object.commandPool, NULL, settings, "VkCommandPool", "commandPool", false, false, indents + 1, dump_json_VkCommandPool);
    settings.stream() << ",\n";
    dump_json_value<const VkCommandBufferLevel>(object.level, NULL, settings, "VkCommandBufferLevel", "level", false, false, indents + 1, dump_json_VkCommandBufferLevel);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.commandBufferCount, NULL, settings, "uint32_t", "commandBufferCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkCommandBufferInheritanceInfo(const VkCommandBufferInheritanceInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkRenderPass>(object.renderPass, NULL, settings, "VkRenderPass", "renderPass", false, false, indents + 1, dump_json_VkRenderPass);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.subpass, NULL, settings, "uint32_t", "subpass", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkFramebuffer>(object.framebuffer, NULL, settings, "VkFramebuffer", "framebuffer", false, false, indents + 1, dump_json_VkFramebuffer);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.occlusionQueryEnable, NULL, settings, "VkBool32", "occlusionQueryEnable", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkQueryControlFlags>(object.queryFlags, NULL, settings, "VkQueryControlFlags", "queryFlags", false, false, indents + 1, dump_json_VkQueryControlFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkQueryPipelineStatisticFlags>(object.pipelineStatistics, NULL, settings, "VkQueryPipelineStatisticFlags", "pipelineStatistics", false, false, indents + 1, dump_json_VkQueryPipelineStatisticFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkCommandBufferBeginInfo(const VkCommandBufferBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkCommandBufferUsageFlags>(object.flags, NULL, settings, "VkCommandBufferUsageFlags", "flags", false, false, indents + 1, dump_json_VkCommandBufferUsageFlags);
    settings.stream() << ",\n";
    if(ApiDumpInstance::current().getCmdBufferLevel() == VK_COMMAND_BUFFER_LEVEL_SECONDARY)
    dump_json_pointer<const VkCommandBufferInheritanceInfo>(object.pInheritanceInfo, settings, "const VkCommandBufferInheritanceInfo*", "pInheritanceInfo", true, false, indents + 1, dump_json_VkCommandBufferInheritanceInfo);
    else
        dump_json_UNUSED(settings, "const VkCommandBufferInheritanceInfo*", "pInheritanceInfo", indents + 1);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferCopy(const VkBufferCopy& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkDeviceSize>(object.srcOffset, NULL, settings, "VkDeviceSize", "srcOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.dstOffset, NULL, settings, "VkDeviceSize", "dstOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.size, NULL, settings, "VkDeviceSize", "size", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageSubresourceLayers(const VkImageSubresourceLayers& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImageAspectFlags>(object.aspectMask, NULL, settings, "VkImageAspectFlags", "aspectMask", false, false, indents + 1, dump_json_VkImageAspectFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.mipLevel, NULL, settings, "uint32_t", "mipLevel", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.baseArrayLayer, NULL, settings, "uint32_t", "baseArrayLayer", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.layerCount, NULL, settings, "uint32_t", "layerCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferImageCopy(const VkBufferImageCopy& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkDeviceSize>(object.bufferOffset, NULL, settings, "VkDeviceSize", "bufferOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bufferRowLength, NULL, settings, "uint32_t", "bufferRowLength", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bufferImageHeight, NULL, settings, "uint32_t", "bufferImageHeight", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceLayers>(object.imageSubresource, NULL, settings, "VkImageSubresourceLayers", "imageSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_value<const VkOffset3D>(object.imageOffset, NULL, settings, "VkOffset3D", "imageOffset", true, false, indents + 1, dump_json_VkOffset3D);
    settings.stream() << ",\n";
    dump_json_value<const VkExtent3D>(object.imageExtent, NULL, settings, "VkExtent3D", "imageExtent", true, false, indents + 1, dump_json_VkExtent3D);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkClearDepthStencilValue(const VkClearDepthStencilValue& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const float>(object.depth, NULL, settings, "float", "depth", false, false, indents + 1, dump_json_float);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.stencil, NULL, settings, "uint32_t", "stencil", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkClearAttachment(const VkClearAttachment& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImageAspectFlags>(object.aspectMask, NULL, settings, "VkImageAspectFlags", "aspectMask", false, false, indents + 1, dump_json_VkImageAspectFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.colorAttachment, NULL, settings, "uint32_t", "colorAttachment", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkClearValue>(object.clearValue, NULL, settings, "VkClearValue", "clearValue", false, true, indents + 1, dump_json_VkClearValue);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkClearRect(const VkClearRect& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkRect2D>(object.rect, NULL, settings, "VkRect2D", "rect", true, false, indents + 1, dump_json_VkRect2D);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.baseArrayLayer, NULL, settings, "uint32_t", "baseArrayLayer", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.layerCount, NULL, settings, "uint32_t", "layerCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageBlit(const VkImageBlit& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImageSubresourceLayers>(object.srcSubresource, NULL, settings, "VkImageSubresourceLayers", "srcSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_array<const VkOffset3D>(object.srcOffsets, 2, settings, "VkOffset3D[2]", "VkOffset3D", "srcOffsets", true, false, indents + 1, dump_json_VkOffset3D); // IQA
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceLayers>(object.dstSubresource, NULL, settings, "VkImageSubresourceLayers", "dstSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_array<const VkOffset3D>(object.dstOffsets, 2, settings, "VkOffset3D[2]", "VkOffset3D", "dstOffsets", true, false, indents + 1, dump_json_VkOffset3D); // IQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageCopy(const VkImageCopy& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImageSubresourceLayers>(object.srcSubresource, NULL, settings, "VkImageSubresourceLayers", "srcSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_value<const VkOffset3D>(object.srcOffset, NULL, settings, "VkOffset3D", "srcOffset", true, false, indents + 1, dump_json_VkOffset3D);
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceLayers>(object.dstSubresource, NULL, settings, "VkImageSubresourceLayers", "dstSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_value<const VkOffset3D>(object.dstOffset, NULL, settings, "VkOffset3D", "dstOffset", true, false, indents + 1, dump_json_VkOffset3D);
    settings.stream() << ",\n";
    dump_json_value<const VkExtent3D>(object.extent, NULL, settings, "VkExtent3D", "extent", true, false, indents + 1, dump_json_VkExtent3D);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageResolve(const VkImageResolve& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkImageSubresourceLayers>(object.srcSubresource, NULL, settings, "VkImageSubresourceLayers", "srcSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_value<const VkOffset3D>(object.srcOffset, NULL, settings, "VkOffset3D", "srcOffset", true, false, indents + 1, dump_json_VkOffset3D);
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceLayers>(object.dstSubresource, NULL, settings, "VkImageSubresourceLayers", "dstSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_value<const VkOffset3D>(object.dstOffset, NULL, settings, "VkOffset3D", "dstOffset", true, false, indents + 1, dump_json_VkOffset3D);
    settings.stream() << ",\n";
    dump_json_value<const VkExtent3D>(object.extent, NULL, settings, "VkExtent3D", "extent", true, false, indents + 1, dump_json_VkExtent3D);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkRenderPassBeginInfo(const VkRenderPassBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkRenderPass>(object.renderPass, NULL, settings, "VkRenderPass", "renderPass", false, false, indents + 1, dump_json_VkRenderPass);
    settings.stream() << ",\n";
    dump_json_value<const VkFramebuffer>(object.framebuffer, NULL, settings, "VkFramebuffer", "framebuffer", false, false, indents + 1, dump_json_VkFramebuffer);
    settings.stream() << ",\n";
    dump_json_value<const VkRect2D>(object.renderArea, NULL, settings, "VkRect2D", "renderArea", true, false, indents + 1, dump_json_VkRect2D);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.clearValueCount, NULL, settings, "uint32_t", "clearValueCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkClearValue>(object.pClearValues, object.clearValueCount, settings, "const VkClearValue*", "const VkClearValue", "pClearValues", false, true, indents + 1, dump_json_VkClearValue); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceSubgroupProperties(const VkPhysicalDeviceSubgroupProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.subgroupSize, NULL, settings, "uint32_t", "subgroupSize", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkShaderStageFlags>(object.supportedStages, NULL, settings, "VkShaderStageFlags", "supportedStages", false, false, indents + 1, dump_json_VkShaderStageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSubgroupFeatureFlags>(object.supportedOperations, NULL, settings, "VkSubgroupFeatureFlags", "supportedOperations", false, false, indents + 1, dump_json_VkSubgroupFeatureFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.quadOperationsInAllStages, NULL, settings, "VkBool32", "quadOperationsInAllStages", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBindBufferMemoryInfo(const VkBindBufferMemoryInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.buffer, NULL, settings, "VkBuffer", "buffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceMemory>(object.memory, NULL, settings, "VkDeviceMemory", "memory", false, false, indents + 1, dump_json_VkDeviceMemory);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.memoryOffset, NULL, settings, "VkDeviceSize", "memoryOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBindImageMemoryInfo(const VkBindImageMemoryInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.image, NULL, settings, "VkImage", "image", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceMemory>(object.memory, NULL, settings, "VkDeviceMemory", "memory", false, false, indents + 1, dump_json_VkDeviceMemory);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.memoryOffset, NULL, settings, "VkDeviceSize", "memoryOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDevice16BitStorageFeatures(const VkPhysicalDevice16BitStorageFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storageBuffer16BitAccess, NULL, settings, "VkBool32", "storageBuffer16BitAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.uniformAndStorageBuffer16BitAccess, NULL, settings, "VkBool32", "uniformAndStorageBuffer16BitAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storagePushConstant16, NULL, settings, "VkBool32", "storagePushConstant16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storageInputOutput16, NULL, settings, "VkBool32", "storageInputOutput16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryDedicatedRequirements(const VkMemoryDedicatedRequirements& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.prefersDedicatedAllocation, NULL, settings, "VkBool32", "prefersDedicatedAllocation", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.requiresDedicatedAllocation, NULL, settings, "VkBool32", "requiresDedicatedAllocation", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryDedicatedAllocateInfo(const VkMemoryDedicatedAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.image, NULL, settings, "VkImage", "image", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.buffer, NULL, settings, "VkBuffer", "buffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryAllocateFlagsInfo(const VkMemoryAllocateFlagsInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkMemoryAllocateFlags>(object.flags, NULL, settings, "VkMemoryAllocateFlags", "flags", false, false, indents + 1, dump_json_VkMemoryAllocateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceMask, NULL, settings, "uint32_t", "deviceMask", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDeviceGroupRenderPassBeginInfo(const VkDeviceGroupRenderPassBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceMask, NULL, settings, "uint32_t", "deviceMask", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceRenderAreaCount, NULL, settings, "uint32_t", "deviceRenderAreaCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkRect2D>(object.pDeviceRenderAreas, object.deviceRenderAreaCount, settings, "const VkRect2D*", "const VkRect2D", "pDeviceRenderAreas", true, false, indents + 1, dump_json_VkRect2D); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDeviceGroupCommandBufferBeginInfo(const VkDeviceGroupCommandBufferBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceMask, NULL, settings, "uint32_t", "deviceMask", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDeviceGroupSubmitInfo(const VkDeviceGroupSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.waitSemaphoreCount, NULL, settings, "uint32_t", "waitSemaphoreCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pWaitSemaphoreDeviceIndices, object.waitSemaphoreCount, settings, "const uint32_t*", "const uint32_t", "pWaitSemaphoreDeviceIndices", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.commandBufferCount, NULL, settings, "uint32_t", "commandBufferCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pCommandBufferDeviceMasks, object.commandBufferCount, settings, "const uint32_t*", "const uint32_t", "pCommandBufferDeviceMasks", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.signalSemaphoreCount, NULL, settings, "uint32_t", "signalSemaphoreCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pSignalSemaphoreDeviceIndices, object.signalSemaphoreCount, settings, "const uint32_t*", "const uint32_t", "pSignalSemaphoreDeviceIndices", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDeviceGroupBindSparseInfo(const VkDeviceGroupBindSparseInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.resourceDeviceIndex, NULL, settings, "uint32_t", "resourceDeviceIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.memoryDeviceIndex, NULL, settings, "uint32_t", "memoryDeviceIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBindBufferMemoryDeviceGroupInfo(const VkBindBufferMemoryDeviceGroupInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceIndexCount, NULL, settings, "uint32_t", "deviceIndexCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pDeviceIndices, object.deviceIndexCount, settings, "const uint32_t*", "const uint32_t", "pDeviceIndices", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBindImageMemoryDeviceGroupInfo(const VkBindImageMemoryDeviceGroupInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceIndexCount, NULL, settings, "uint32_t", "deviceIndexCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pDeviceIndices, object.deviceIndexCount, settings, "const uint32_t*", "const uint32_t", "pDeviceIndices", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.splitInstanceBindRegionCount, NULL, settings, "uint32_t", "splitInstanceBindRegionCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkRect2D>(object.pSplitInstanceBindRegions, object.splitInstanceBindRegionCount, settings, "const VkRect2D*", "const VkRect2D", "pSplitInstanceBindRegions", true, false, indents + 1, dump_json_VkRect2D); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceGroupProperties(const VkPhysicalDeviceGroupProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.physicalDeviceCount, NULL, settings, "uint32_t", "physicalDeviceCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkPhysicalDevice>(object.physicalDevices, object.physicalDeviceCount, settings, "VkPhysicalDevice[VK_MAX_DEVICE_GROUP_SIZE]", "VkPhysicalDevice", "physicalDevices", false, false, indents + 1, dump_json_VkPhysicalDevice); // JQA
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.subsetAllocation, NULL, settings, "VkBool32", "subsetAllocation", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDeviceGroupDeviceCreateInfo(const VkDeviceGroupDeviceCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.physicalDeviceCount, NULL, settings, "uint32_t", "physicalDeviceCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkPhysicalDevice>(object.pPhysicalDevices, object.physicalDeviceCount, settings, "const VkPhysicalDevice*", "const VkPhysicalDevice", "pPhysicalDevices", false, false, indents + 1, dump_json_VkPhysicalDevice); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferMemoryRequirementsInfo2(const VkBufferMemoryRequirementsInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.buffer, NULL, settings, "VkBuffer", "buffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageMemoryRequirementsInfo2(const VkImageMemoryRequirementsInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.image, NULL, settings, "VkImage", "image", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageSparseMemoryRequirementsInfo2(const VkImageSparseMemoryRequirementsInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.image, NULL, settings, "VkImage", "image", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryRequirements2(const VkMemoryRequirements2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkMemoryRequirements>(object.memoryRequirements, NULL, settings, "VkMemoryRequirements", "memoryRequirements", true, false, indents + 1, dump_json_VkMemoryRequirements);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSparseImageMemoryRequirements2(const VkSparseImageMemoryRequirements2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSparseImageMemoryRequirements>(object.memoryRequirements, NULL, settings, "VkSparseImageMemoryRequirements", "memoryRequirements", true, false, indents + 1, dump_json_VkSparseImageMemoryRequirements);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceFeatures2(const VkPhysicalDeviceFeatures2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPhysicalDeviceFeatures>(object.features, NULL, settings, "VkPhysicalDeviceFeatures", "features", true, false, indents + 1, dump_json_VkPhysicalDeviceFeatures);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceProperties2(const VkPhysicalDeviceProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPhysicalDeviceProperties>(object.properties, NULL, settings, "VkPhysicalDeviceProperties", "properties", true, false, indents + 1, dump_json_VkPhysicalDeviceProperties);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkFormatProperties2(const VkFormatProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkFormatProperties>(object.formatProperties, NULL, settings, "VkFormatProperties", "formatProperties", true, false, indents + 1, dump_json_VkFormatProperties);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageFormatProperties2(const VkImageFormatProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageFormatProperties>(object.imageFormatProperties, NULL, settings, "VkImageFormatProperties", "imageFormatProperties", true, false, indents + 1, dump_json_VkImageFormatProperties);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceImageFormatInfo2(const VkPhysicalDeviceImageFormatInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkFormat>(object.format, NULL, settings, "VkFormat", "format", false, false, indents + 1, dump_json_VkFormat);
    settings.stream() << ",\n";
    dump_json_value<const VkImageType>(object.type, NULL, settings, "VkImageType", "type", false, false, indents + 1, dump_json_VkImageType);
    settings.stream() << ",\n";
    dump_json_value<const VkImageTiling>(object.tiling, NULL, settings, "VkImageTiling", "tiling", false, false, indents + 1, dump_json_VkImageTiling);
    settings.stream() << ",\n";
    dump_json_value<const VkImageUsageFlags>(object.usage, NULL, settings, "VkImageUsageFlags", "usage", false, false, indents + 1, dump_json_VkImageUsageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkImageCreateFlags>(object.flags, NULL, settings, "VkImageCreateFlags", "flags", false, false, indents + 1, dump_json_VkImageCreateFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkQueueFamilyProperties2(const VkQueueFamilyProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkQueueFamilyProperties>(object.queueFamilyProperties, NULL, settings, "VkQueueFamilyProperties", "queueFamilyProperties", true, false, indents + 1, dump_json_VkQueueFamilyProperties);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceMemoryProperties2(const VkPhysicalDeviceMemoryProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    ApiDumpInstance::current().setMemoryHeapCount(object.memoryProperties.memoryHeapCount);
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPhysicalDeviceMemoryProperties>(object.memoryProperties, NULL, settings, "VkPhysicalDeviceMemoryProperties", "memoryProperties", true, false, indents + 1, dump_json_VkPhysicalDeviceMemoryProperties);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSparseImageFormatProperties2(const VkSparseImageFormatProperties2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSparseImageFormatProperties>(object.properties, NULL, settings, "VkSparseImageFormatProperties", "properties", true, false, indents + 1, dump_json_VkSparseImageFormatProperties);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceSparseImageFormatInfo2(const VkPhysicalDeviceSparseImageFormatInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkFormat>(object.format, NULL, settings, "VkFormat", "format", false, false, indents + 1, dump_json_VkFormat);
    settings.stream() << ",\n";
    dump_json_value<const VkImageType>(object.type, NULL, settings, "VkImageType", "type", false, false, indents + 1, dump_json_VkImageType);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlagBits>(object.samples, NULL, settings, "VkSampleCountFlagBits", "samples", false, false, indents + 1, dump_json_VkSampleCountFlagBits);
    settings.stream() << ",\n";
    dump_json_value<const VkImageUsageFlags>(object.usage, NULL, settings, "VkImageUsageFlags", "usage", false, false, indents + 1, dump_json_VkImageUsageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkImageTiling>(object.tiling, NULL, settings, "VkImageTiling", "tiling", false, false, indents + 1, dump_json_VkImageTiling);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDevicePointClippingProperties(const VkPhysicalDevicePointClippingProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPointClippingBehavior>(object.pointClippingBehavior, NULL, settings, "VkPointClippingBehavior", "pointClippingBehavior", false, false, indents + 1, dump_json_VkPointClippingBehavior);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkInputAttachmentAspectReference(const VkInputAttachmentAspectReference& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.subpass, NULL, settings, "uint32_t", "subpass", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.inputAttachmentIndex, NULL, settings, "uint32_t", "inputAttachmentIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkImageAspectFlags>(object.aspectMask, NULL, settings, "VkImageAspectFlags", "aspectMask", false, false, indents + 1, dump_json_VkImageAspectFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkRenderPassInputAttachmentAspectCreateInfo(const VkRenderPassInputAttachmentAspectCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.aspectReferenceCount, NULL, settings, "uint32_t", "aspectReferenceCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkInputAttachmentAspectReference>(object.pAspectReferences, object.aspectReferenceCount, settings, "const VkInputAttachmentAspectReference*", "const VkInputAttachmentAspectReference", "pAspectReferences", true, false, indents + 1, dump_json_VkInputAttachmentAspectReference); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageViewUsageCreateInfo(const VkImageViewUsageCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageUsageFlags>(object.usage, NULL, settings, "VkImageUsageFlags", "usage", false, false, indents + 1, dump_json_VkImageUsageFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineTessellationDomainOriginStateCreateInfo(const VkPipelineTessellationDomainOriginStateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkTessellationDomainOrigin>(object.domainOrigin, NULL, settings, "VkTessellationDomainOrigin", "domainOrigin", false, false, indents + 1, dump_json_VkTessellationDomainOrigin);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkRenderPassMultiviewCreateInfo(const VkRenderPassMultiviewCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.subpassCount, NULL, settings, "uint32_t", "subpassCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pViewMasks, object.subpassCount, settings, "const uint32_t*", "const uint32_t", "pViewMasks", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dependencyCount, NULL, settings, "uint32_t", "dependencyCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const int32_t>(object.pViewOffsets, object.dependencyCount, settings, "const int32_t*", "const int32_t", "pViewOffsets", false, false, indents + 1, dump_json_int32_t); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.correlationMaskCount, NULL, settings, "uint32_t", "correlationMaskCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pCorrelationMasks, object.correlationMaskCount, settings, "const uint32_t*", "const uint32_t", "pCorrelationMasks", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceMultiviewFeatures(const VkPhysicalDeviceMultiviewFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.multiview, NULL, settings, "VkBool32", "multiview", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.multiviewGeometryShader, NULL, settings, "VkBool32", "multiviewGeometryShader", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.multiviewTessellationShader, NULL, settings, "VkBool32", "multiviewTessellationShader", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceMultiviewProperties(const VkPhysicalDeviceMultiviewProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxMultiviewViewCount, NULL, settings, "uint32_t", "maxMultiviewViewCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxMultiviewInstanceIndex, NULL, settings, "uint32_t", "maxMultiviewInstanceIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceVariablePointersFeatures(const VkPhysicalDeviceVariablePointersFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.variablePointersStorageBuffer, NULL, settings, "VkBool32", "variablePointersStorageBuffer", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.variablePointers, NULL, settings, "VkBool32", "variablePointers", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceProtectedMemoryFeatures(const VkPhysicalDeviceProtectedMemoryFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.protectedMemory, NULL, settings, "VkBool32", "protectedMemory", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceProtectedMemoryProperties(const VkPhysicalDeviceProtectedMemoryProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.protectedNoFault, NULL, settings, "VkBool32", "protectedNoFault", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDeviceQueueInfo2(const VkDeviceQueueInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceQueueCreateFlags>(object.flags, NULL, settings, "VkDeviceQueueCreateFlags", "flags", false, false, indents + 1, dump_json_VkDeviceQueueCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.queueFamilyIndex, NULL, settings, "uint32_t", "queueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.queueIndex, NULL, settings, "uint32_t", "queueIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkProtectedSubmitInfo(const VkProtectedSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.protectedSubmit, NULL, settings, "VkBool32", "protectedSubmit", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSamplerYcbcrConversionCreateInfo(const VkSamplerYcbcrConversionCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkFormat>(object.format, NULL, settings, "VkFormat", "format", false, false, indents + 1, dump_json_VkFormat);
    settings.stream() << ",\n";
    dump_json_value<const VkSamplerYcbcrModelConversion>(object.ycbcrModel, NULL, settings, "VkSamplerYcbcrModelConversion", "ycbcrModel", false, false, indents + 1, dump_json_VkSamplerYcbcrModelConversion);
    settings.stream() << ",\n";
    dump_json_value<const VkSamplerYcbcrRange>(object.ycbcrRange, NULL, settings, "VkSamplerYcbcrRange", "ycbcrRange", false, false, indents + 1, dump_json_VkSamplerYcbcrRange);
    settings.stream() << ",\n";
    dump_json_value<const VkComponentMapping>(object.components, NULL, settings, "VkComponentMapping", "components", true, false, indents + 1, dump_json_VkComponentMapping);
    settings.stream() << ",\n";
    dump_json_value<const VkChromaLocation>(object.xChromaOffset, NULL, settings, "VkChromaLocation", "xChromaOffset", false, false, indents + 1, dump_json_VkChromaLocation);
    settings.stream() << ",\n";
    dump_json_value<const VkChromaLocation>(object.yChromaOffset, NULL, settings, "VkChromaLocation", "yChromaOffset", false, false, indents + 1, dump_json_VkChromaLocation);
    settings.stream() << ",\n";
    dump_json_value<const VkFilter>(object.chromaFilter, NULL, settings, "VkFilter", "chromaFilter", false, false, indents + 1, dump_json_VkFilter);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.forceExplicitReconstruction, NULL, settings, "VkBool32", "forceExplicitReconstruction", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSamplerYcbcrConversionInfo(const VkSamplerYcbcrConversionInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSamplerYcbcrConversion>(object.conversion, NULL, settings, "VkSamplerYcbcrConversion", "conversion", false, false, indents + 1, dump_json_VkSamplerYcbcrConversion);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBindImagePlaneMemoryInfo(const VkBindImagePlaneMemoryInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageAspectFlagBits>(object.planeAspect, NULL, settings, "VkImageAspectFlagBits", "planeAspect", false, false, indents + 1, dump_json_VkImageAspectFlagBits);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImagePlaneMemoryRequirementsInfo(const VkImagePlaneMemoryRequirementsInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageAspectFlagBits>(object.planeAspect, NULL, settings, "VkImageAspectFlagBits", "planeAspect", false, false, indents + 1, dump_json_VkImageAspectFlagBits);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceSamplerYcbcrConversionFeatures(const VkPhysicalDeviceSamplerYcbcrConversionFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.samplerYcbcrConversion, NULL, settings, "VkBool32", "samplerYcbcrConversion", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSamplerYcbcrConversionImageFormatProperties(const VkSamplerYcbcrConversionImageFormatProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.combinedImageSamplerDescriptorCount, NULL, settings, "uint32_t", "combinedImageSamplerDescriptorCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorUpdateTemplateEntry(const VkDescriptorUpdateTemplateEntry& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint32_t>(object.dstBinding, NULL, settings, "uint32_t", "dstBinding", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstArrayElement, NULL, settings, "uint32_t", "dstArrayElement", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.descriptorCount, NULL, settings, "uint32_t", "descriptorCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorType>(object.descriptorType, NULL, settings, "VkDescriptorType", "descriptorType", false, false, indents + 1, dump_json_VkDescriptorType);
    settings.stream() << ",\n";
    dump_json_value<const size_t>(object.offset, NULL, settings, "size_t", "offset", false, false, indents + 1, dump_json_size_t);
    settings.stream() << ",\n";
    dump_json_value<const size_t>(object.stride, NULL, settings, "size_t", "stride", false, false, indents + 1, dump_json_size_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorUpdateTemplateCreateInfo(const VkDescriptorUpdateTemplateCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorUpdateTemplateCreateFlags>(object.flags, NULL, settings, "VkDescriptorUpdateTemplateCreateFlags", "flags", false, false, indents + 1, dump_json_VkDescriptorUpdateTemplateCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.descriptorUpdateEntryCount, NULL, settings, "uint32_t", "descriptorUpdateEntryCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkDescriptorUpdateTemplateEntry>(object.pDescriptorUpdateEntries, object.descriptorUpdateEntryCount, settings, "const VkDescriptorUpdateTemplateEntry*", "const VkDescriptorUpdateTemplateEntry", "pDescriptorUpdateEntries", true, false, indents + 1, dump_json_VkDescriptorUpdateTemplateEntry); // JQA
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorUpdateTemplateType>(object.templateType, NULL, settings, "VkDescriptorUpdateTemplateType", "templateType", false, false, indents + 1, dump_json_VkDescriptorUpdateTemplateType);
    settings.stream() << ",\n";
    dump_json_value<const VkDescriptorSetLayout>(object.descriptorSetLayout, NULL, settings, "VkDescriptorSetLayout", "descriptorSetLayout", false, false, indents + 1, dump_json_VkDescriptorSetLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineBindPoint>(object.pipelineBindPoint, NULL, settings, "VkPipelineBindPoint", "pipelineBindPoint", false, false, indents + 1, dump_json_VkPipelineBindPoint);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineLayout>(object.pipelineLayout, NULL, settings, "VkPipelineLayout", "pipelineLayout", false, false, indents + 1, dump_json_VkPipelineLayout);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.set, NULL, settings, "uint32_t", "set", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExternalMemoryProperties(const VkExternalMemoryProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkExternalMemoryFeatureFlags>(object.externalMemoryFeatures, NULL, settings, "VkExternalMemoryFeatureFlags", "externalMemoryFeatures", false, false, indents + 1, dump_json_VkExternalMemoryFeatureFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkExternalMemoryHandleTypeFlags>(object.exportFromImportedHandleTypes, NULL, settings, "VkExternalMemoryHandleTypeFlags", "exportFromImportedHandleTypes", false, false, indents + 1, dump_json_VkExternalMemoryHandleTypeFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkExternalMemoryHandleTypeFlags>(object.compatibleHandleTypes, NULL, settings, "VkExternalMemoryHandleTypeFlags", "compatibleHandleTypes", false, false, indents + 1, dump_json_VkExternalMemoryHandleTypeFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceExternalImageFormatInfo(const VkPhysicalDeviceExternalImageFormatInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalMemoryHandleTypeFlagBits>(object.handleType, NULL, settings, "VkExternalMemoryHandleTypeFlagBits", "handleType", false, false, indents + 1, dump_json_VkExternalMemoryHandleTypeFlagBits);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExternalImageFormatProperties(const VkExternalImageFormatProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalMemoryProperties>(object.externalMemoryProperties, NULL, settings, "VkExternalMemoryProperties", "externalMemoryProperties", true, false, indents + 1, dump_json_VkExternalMemoryProperties);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceExternalBufferInfo(const VkPhysicalDeviceExternalBufferInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBufferCreateFlags>(object.flags, NULL, settings, "VkBufferCreateFlags", "flags", false, false, indents + 1, dump_json_VkBufferCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkBufferUsageFlags>(object.usage, NULL, settings, "VkBufferUsageFlags", "usage", false, false, indents + 1, dump_json_VkBufferUsageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkExternalMemoryHandleTypeFlagBits>(object.handleType, NULL, settings, "VkExternalMemoryHandleTypeFlagBits", "handleType", false, false, indents + 1, dump_json_VkExternalMemoryHandleTypeFlagBits);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExternalBufferProperties(const VkExternalBufferProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalMemoryProperties>(object.externalMemoryProperties, NULL, settings, "VkExternalMemoryProperties", "externalMemoryProperties", true, false, indents + 1, dump_json_VkExternalMemoryProperties);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceIDProperties(const VkPhysicalDeviceIDProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.deviceUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "deviceUUID", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.driverUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "driverUUID", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.deviceLUID, 8, settings, "uint8_t[VK_LUID_SIZE]", "uint8_t", "deviceLUID", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceNodeMask, NULL, settings, "uint32_t", "deviceNodeMask", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.deviceLUIDValid, NULL, settings, "VkBool32", "deviceLUIDValid", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExternalMemoryImageCreateInfo(const VkExternalMemoryImageCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalMemoryHandleTypeFlags>(object.handleTypes, NULL, settings, "VkExternalMemoryHandleTypeFlags", "handleTypes", false, false, indents + 1, dump_json_VkExternalMemoryHandleTypeFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExternalMemoryBufferCreateInfo(const VkExternalMemoryBufferCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalMemoryHandleTypeFlags>(object.handleTypes, NULL, settings, "VkExternalMemoryHandleTypeFlags", "handleTypes", false, false, indents + 1, dump_json_VkExternalMemoryHandleTypeFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExportMemoryAllocateInfo(const VkExportMemoryAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalMemoryHandleTypeFlags>(object.handleTypes, NULL, settings, "VkExternalMemoryHandleTypeFlags", "handleTypes", false, false, indents + 1, dump_json_VkExternalMemoryHandleTypeFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceExternalFenceInfo(const VkPhysicalDeviceExternalFenceInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalFenceHandleTypeFlagBits>(object.handleType, NULL, settings, "VkExternalFenceHandleTypeFlagBits", "handleType", false, false, indents + 1, dump_json_VkExternalFenceHandleTypeFlagBits);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExternalFenceProperties(const VkExternalFenceProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalFenceHandleTypeFlags>(object.exportFromImportedHandleTypes, NULL, settings, "VkExternalFenceHandleTypeFlags", "exportFromImportedHandleTypes", false, false, indents + 1, dump_json_VkExternalFenceHandleTypeFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkExternalFenceHandleTypeFlags>(object.compatibleHandleTypes, NULL, settings, "VkExternalFenceHandleTypeFlags", "compatibleHandleTypes", false, false, indents + 1, dump_json_VkExternalFenceHandleTypeFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkExternalFenceFeatureFlags>(object.externalFenceFeatures, NULL, settings, "VkExternalFenceFeatureFlags", "externalFenceFeatures", false, false, indents + 1, dump_json_VkExternalFenceFeatureFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExportFenceCreateInfo(const VkExportFenceCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalFenceHandleTypeFlags>(object.handleTypes, NULL, settings, "VkExternalFenceHandleTypeFlags", "handleTypes", false, false, indents + 1, dump_json_VkExternalFenceHandleTypeFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExportSemaphoreCreateInfo(const VkExportSemaphoreCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalSemaphoreHandleTypeFlags>(object.handleTypes, NULL, settings, "VkExternalSemaphoreHandleTypeFlags", "handleTypes", false, false, indents + 1, dump_json_VkExternalSemaphoreHandleTypeFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceExternalSemaphoreInfo(const VkPhysicalDeviceExternalSemaphoreInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalSemaphoreHandleTypeFlagBits>(object.handleType, NULL, settings, "VkExternalSemaphoreHandleTypeFlagBits", "handleType", false, false, indents + 1, dump_json_VkExternalSemaphoreHandleTypeFlagBits);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkExternalSemaphoreProperties(const VkExternalSemaphoreProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkExternalSemaphoreHandleTypeFlags>(object.exportFromImportedHandleTypes, NULL, settings, "VkExternalSemaphoreHandleTypeFlags", "exportFromImportedHandleTypes", false, false, indents + 1, dump_json_VkExternalSemaphoreHandleTypeFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkExternalSemaphoreHandleTypeFlags>(object.compatibleHandleTypes, NULL, settings, "VkExternalSemaphoreHandleTypeFlags", "compatibleHandleTypes", false, false, indents + 1, dump_json_VkExternalSemaphoreHandleTypeFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkExternalSemaphoreFeatureFlags>(object.externalSemaphoreFeatures, NULL, settings, "VkExternalSemaphoreFeatureFlags", "externalSemaphoreFeatures", false, false, indents + 1, dump_json_VkExternalSemaphoreFeatureFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceMaintenance3Properties(const VkPhysicalDeviceMaintenance3Properties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerSetDescriptors, NULL, settings, "uint32_t", "maxPerSetDescriptors", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.maxMemoryAllocationSize, NULL, settings, "VkDeviceSize", "maxMemoryAllocationSize", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorSetLayoutSupport(const VkDescriptorSetLayoutSupport& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.supported, NULL, settings, "VkBool32", "supported", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceShaderDrawParametersFeatures(const VkPhysicalDeviceShaderDrawParametersFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDrawParameters, NULL, settings, "VkBool32", "shaderDrawParameters", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceVulkan11Features(const VkPhysicalDeviceVulkan11Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storageBuffer16BitAccess, NULL, settings, "VkBool32", "storageBuffer16BitAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.uniformAndStorageBuffer16BitAccess, NULL, settings, "VkBool32", "uniformAndStorageBuffer16BitAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storagePushConstant16, NULL, settings, "VkBool32", "storagePushConstant16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storageInputOutput16, NULL, settings, "VkBool32", "storageInputOutput16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.multiview, NULL, settings, "VkBool32", "multiview", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.multiviewGeometryShader, NULL, settings, "VkBool32", "multiviewGeometryShader", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.multiviewTessellationShader, NULL, settings, "VkBool32", "multiviewTessellationShader", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.variablePointersStorageBuffer, NULL, settings, "VkBool32", "variablePointersStorageBuffer", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.variablePointers, NULL, settings, "VkBool32", "variablePointers", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.protectedMemory, NULL, settings, "VkBool32", "protectedMemory", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.samplerYcbcrConversion, NULL, settings, "VkBool32", "samplerYcbcrConversion", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDrawParameters, NULL, settings, "VkBool32", "shaderDrawParameters", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceVulkan11Properties(const VkPhysicalDeviceVulkan11Properties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.deviceUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "deviceUUID", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.driverUUID, 16, settings, "uint8_t[VK_UUID_SIZE]", "uint8_t", "driverUUID", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_array<const uint8_t>(object.deviceLUID, 8, settings, "uint8_t[VK_LUID_SIZE]", "uint8_t", "deviceLUID", false, false, indents + 1, dump_json_uint8_t); // IQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceNodeMask, NULL, settings, "uint32_t", "deviceNodeMask", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.deviceLUIDValid, NULL, settings, "VkBool32", "deviceLUIDValid", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.subgroupSize, NULL, settings, "uint32_t", "subgroupSize", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkShaderStageFlags>(object.subgroupSupportedStages, NULL, settings, "VkShaderStageFlags", "subgroupSupportedStages", false, false, indents + 1, dump_json_VkShaderStageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkSubgroupFeatureFlags>(object.subgroupSupportedOperations, NULL, settings, "VkSubgroupFeatureFlags", "subgroupSupportedOperations", false, false, indents + 1, dump_json_VkSubgroupFeatureFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.subgroupQuadOperationsInAllStages, NULL, settings, "VkBool32", "subgroupQuadOperationsInAllStages", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkPointClippingBehavior>(object.pointClippingBehavior, NULL, settings, "VkPointClippingBehavior", "pointClippingBehavior", false, false, indents + 1, dump_json_VkPointClippingBehavior);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxMultiviewViewCount, NULL, settings, "uint32_t", "maxMultiviewViewCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxMultiviewInstanceIndex, NULL, settings, "uint32_t", "maxMultiviewInstanceIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.protectedNoFault, NULL, settings, "VkBool32", "protectedNoFault", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerSetDescriptors, NULL, settings, "uint32_t", "maxPerSetDescriptors", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.maxMemoryAllocationSize, NULL, settings, "VkDeviceSize", "maxMemoryAllocationSize", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceVulkan12Features(const VkPhysicalDeviceVulkan12Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.samplerMirrorClampToEdge, NULL, settings, "VkBool32", "samplerMirrorClampToEdge", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.drawIndirectCount, NULL, settings, "VkBool32", "drawIndirectCount", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storageBuffer8BitAccess, NULL, settings, "VkBool32", "storageBuffer8BitAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.uniformAndStorageBuffer8BitAccess, NULL, settings, "VkBool32", "uniformAndStorageBuffer8BitAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storagePushConstant8, NULL, settings, "VkBool32", "storagePushConstant8", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderBufferInt64Atomics, NULL, settings, "VkBool32", "shaderBufferInt64Atomics", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSharedInt64Atomics, NULL, settings, "VkBool32", "shaderSharedInt64Atomics", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderFloat16, NULL, settings, "VkBool32", "shaderFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderInt8, NULL, settings, "VkBool32", "shaderInt8", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorIndexing, NULL, settings, "VkBool32", "descriptorIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderInputAttachmentArrayDynamicIndexing, NULL, settings, "VkBool32", "shaderInputAttachmentArrayDynamicIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderUniformTexelBufferArrayDynamicIndexing, NULL, settings, "VkBool32", "shaderUniformTexelBufferArrayDynamicIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageTexelBufferArrayDynamicIndexing, NULL, settings, "VkBool32", "shaderStorageTexelBufferArrayDynamicIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderUniformBufferArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderUniformBufferArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSampledImageArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderSampledImageArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageBufferArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderStorageBufferArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageImageArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderStorageImageArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderInputAttachmentArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderInputAttachmentArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderUniformTexelBufferArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderUniformTexelBufferArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageTexelBufferArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderStorageTexelBufferArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingUniformBufferUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingUniformBufferUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingSampledImageUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingSampledImageUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingStorageImageUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingStorageImageUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingStorageBufferUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingStorageBufferUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingUniformTexelBufferUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingUniformTexelBufferUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingStorageTexelBufferUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingStorageTexelBufferUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingUpdateUnusedWhilePending, NULL, settings, "VkBool32", "descriptorBindingUpdateUnusedWhilePending", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingPartiallyBound, NULL, settings, "VkBool32", "descriptorBindingPartiallyBound", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingVariableDescriptorCount, NULL, settings, "VkBool32", "descriptorBindingVariableDescriptorCount", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.runtimeDescriptorArray, NULL, settings, "VkBool32", "runtimeDescriptorArray", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.samplerFilterMinmax, NULL, settings, "VkBool32", "samplerFilterMinmax", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.scalarBlockLayout, NULL, settings, "VkBool32", "scalarBlockLayout", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.imagelessFramebuffer, NULL, settings, "VkBool32", "imagelessFramebuffer", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.uniformBufferStandardLayout, NULL, settings, "VkBool32", "uniformBufferStandardLayout", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSubgroupExtendedTypes, NULL, settings, "VkBool32", "shaderSubgroupExtendedTypes", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.separateDepthStencilLayouts, NULL, settings, "VkBool32", "separateDepthStencilLayouts", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.hostQueryReset, NULL, settings, "VkBool32", "hostQueryReset", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.timelineSemaphore, NULL, settings, "VkBool32", "timelineSemaphore", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.bufferDeviceAddress, NULL, settings, "VkBool32", "bufferDeviceAddress", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.bufferDeviceAddressCaptureReplay, NULL, settings, "VkBool32", "bufferDeviceAddressCaptureReplay", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.bufferDeviceAddressMultiDevice, NULL, settings, "VkBool32", "bufferDeviceAddressMultiDevice", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.vulkanMemoryModel, NULL, settings, "VkBool32", "vulkanMemoryModel", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.vulkanMemoryModelDeviceScope, NULL, settings, "VkBool32", "vulkanMemoryModelDeviceScope", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.vulkanMemoryModelAvailabilityVisibilityChains, NULL, settings, "VkBool32", "vulkanMemoryModelAvailabilityVisibilityChains", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderOutputViewportIndex, NULL, settings, "VkBool32", "shaderOutputViewportIndex", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderOutputLayer, NULL, settings, "VkBool32", "shaderOutputLayer", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.subgroupBroadcastDynamicId, NULL, settings, "VkBool32", "subgroupBroadcastDynamicId", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkConformanceVersion(const VkConformanceVersion& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const uint8_t>(object.major, NULL, settings, "uint8_t", "major", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.minor, NULL, settings, "uint8_t", "minor", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.subminor, NULL, settings, "uint8_t", "subminor", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << ",\n";
    dump_json_value<const uint8_t>(object.patch, NULL, settings, "uint8_t", "patch", false, false, indents + 1, dump_json_uint8_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceVulkan12Properties(const VkPhysicalDeviceVulkan12Properties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDriverId>(object.driverID, NULL, settings, "VkDriverId", "driverID", false, false, indents + 1, dump_json_VkDriverId);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.driverName, NULL, settings, "char[VK_MAX_DRIVER_NAME_SIZE]", "driverName", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.driverInfo, NULL, settings, "char[VK_MAX_DRIVER_INFO_SIZE]", "driverInfo", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const VkConformanceVersion>(object.conformanceVersion, NULL, settings, "VkConformanceVersion", "conformanceVersion", true, false, indents + 1, dump_json_VkConformanceVersion);
    settings.stream() << ",\n";
    dump_json_value<const VkShaderFloatControlsIndependence>(object.denormBehaviorIndependence, NULL, settings, "VkShaderFloatControlsIndependence", "denormBehaviorIndependence", false, false, indents + 1, dump_json_VkShaderFloatControlsIndependence);
    settings.stream() << ",\n";
    dump_json_value<const VkShaderFloatControlsIndependence>(object.roundingModeIndependence, NULL, settings, "VkShaderFloatControlsIndependence", "roundingModeIndependence", false, false, indents + 1, dump_json_VkShaderFloatControlsIndependence);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat16, NULL, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat32, NULL, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat64, NULL, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormPreserveFloat16, NULL, settings, "VkBool32", "shaderDenormPreserveFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormPreserveFloat32, NULL, settings, "VkBool32", "shaderDenormPreserveFloat32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormPreserveFloat64, NULL, settings, "VkBool32", "shaderDenormPreserveFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormFlushToZeroFloat16, NULL, settings, "VkBool32", "shaderDenormFlushToZeroFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormFlushToZeroFloat32, NULL, settings, "VkBool32", "shaderDenormFlushToZeroFloat32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormFlushToZeroFloat64, NULL, settings, "VkBool32", "shaderDenormFlushToZeroFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTEFloat16, NULL, settings, "VkBool32", "shaderRoundingModeRTEFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTEFloat32, NULL, settings, "VkBool32", "shaderRoundingModeRTEFloat32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTEFloat64, NULL, settings, "VkBool32", "shaderRoundingModeRTEFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTZFloat16, NULL, settings, "VkBool32", "shaderRoundingModeRTZFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTZFloat32, NULL, settings, "VkBool32", "shaderRoundingModeRTZFloat32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTZFloat64, NULL, settings, "VkBool32", "shaderRoundingModeRTZFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxUpdateAfterBindDescriptorsInAllPools, NULL, settings, "uint32_t", "maxUpdateAfterBindDescriptorsInAllPools", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderUniformBufferArrayNonUniformIndexingNative, NULL, settings, "VkBool32", "shaderUniformBufferArrayNonUniformIndexingNative", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSampledImageArrayNonUniformIndexingNative, NULL, settings, "VkBool32", "shaderSampledImageArrayNonUniformIndexingNative", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageBufferArrayNonUniformIndexingNative, NULL, settings, "VkBool32", "shaderStorageBufferArrayNonUniformIndexingNative", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageImageArrayNonUniformIndexingNative, NULL, settings, "VkBool32", "shaderStorageImageArrayNonUniformIndexingNative", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderInputAttachmentArrayNonUniformIndexingNative, NULL, settings, "VkBool32", "shaderInputAttachmentArrayNonUniformIndexingNative", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.robustBufferAccessUpdateAfterBind, NULL, settings, "VkBool32", "robustBufferAccessUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.quadDivergentImplicitLod, NULL, settings, "VkBool32", "quadDivergentImplicitLod", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindSamplers, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindSamplers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindUniformBuffers, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindUniformBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindStorageBuffers, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindStorageBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindSampledImages, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindSampledImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindStorageImages, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindStorageImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindInputAttachments, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindInputAttachments", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageUpdateAfterBindResources, NULL, settings, "uint32_t", "maxPerStageUpdateAfterBindResources", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindSamplers, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindSamplers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindUniformBuffers, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindUniformBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageBuffers, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindSampledImages, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindSampledImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageImages, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindInputAttachments, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindInputAttachments", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkResolveModeFlags>(object.supportedDepthResolveModes, NULL, settings, "VkResolveModeFlags", "supportedDepthResolveModes", false, false, indents + 1, dump_json_VkResolveModeFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkResolveModeFlags>(object.supportedStencilResolveModes, NULL, settings, "VkResolveModeFlags", "supportedStencilResolveModes", false, false, indents + 1, dump_json_VkResolveModeFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.independentResolveNone, NULL, settings, "VkBool32", "independentResolveNone", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.independentResolve, NULL, settings, "VkBool32", "independentResolve", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.filterMinmaxSingleComponentFormats, NULL, settings, "VkBool32", "filterMinmaxSingleComponentFormats", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.filterMinmaxImageComponentMapping, NULL, settings, "VkBool32", "filterMinmaxImageComponentMapping", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const uint64_t>(object.maxTimelineSemaphoreValueDifference, NULL, settings, "uint64_t", "maxTimelineSemaphoreValueDifference", false, false, indents + 1, dump_json_uint64_t);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlags>(object.framebufferIntegerColorSampleCounts, NULL, settings, "VkSampleCountFlags", "framebufferIntegerColorSampleCounts", false, false, indents + 1, dump_json_VkSampleCountFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageFormatListCreateInfo(const VkImageFormatListCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.viewFormatCount, NULL, settings, "uint32_t", "viewFormatCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkFormat>(object.pViewFormats, object.viewFormatCount, settings, "const VkFormat*", "const VkFormat", "pViewFormats", false, false, indents + 1, dump_json_VkFormat); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkAttachmentDescription2(const VkAttachmentDescription2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkAttachmentDescriptionFlags>(object.flags, NULL, settings, "VkAttachmentDescriptionFlags", "flags", false, false, indents + 1, dump_json_VkAttachmentDescriptionFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkFormat>(object.format, NULL, settings, "VkFormat", "format", false, false, indents + 1, dump_json_VkFormat);
    settings.stream() << ",\n";
    dump_json_value<const VkSampleCountFlagBits>(object.samples, NULL, settings, "VkSampleCountFlagBits", "samples", false, false, indents + 1, dump_json_VkSampleCountFlagBits);
    settings.stream() << ",\n";
    dump_json_value<const VkAttachmentLoadOp>(object.loadOp, NULL, settings, "VkAttachmentLoadOp", "loadOp", false, false, indents + 1, dump_json_VkAttachmentLoadOp);
    settings.stream() << ",\n";
    dump_json_value<const VkAttachmentStoreOp>(object.storeOp, NULL, settings, "VkAttachmentStoreOp", "storeOp", false, false, indents + 1, dump_json_VkAttachmentStoreOp);
    settings.stream() << ",\n";
    dump_json_value<const VkAttachmentLoadOp>(object.stencilLoadOp, NULL, settings, "VkAttachmentLoadOp", "stencilLoadOp", false, false, indents + 1, dump_json_VkAttachmentLoadOp);
    settings.stream() << ",\n";
    dump_json_value<const VkAttachmentStoreOp>(object.stencilStoreOp, NULL, settings, "VkAttachmentStoreOp", "stencilStoreOp", false, false, indents + 1, dump_json_VkAttachmentStoreOp);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.initialLayout, NULL, settings, "VkImageLayout", "initialLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.finalLayout, NULL, settings, "VkImageLayout", "finalLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkAttachmentReference2(const VkAttachmentReference2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.attachment, NULL, settings, "uint32_t", "attachment", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.layout, NULL, settings, "VkImageLayout", "layout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkImageAspectFlags>(object.aspectMask, NULL, settings, "VkImageAspectFlags", "aspectMask", false, false, indents + 1, dump_json_VkImageAspectFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSubpassDescription2(const VkSubpassDescription2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSubpassDescriptionFlags>(object.flags, NULL, settings, "VkSubpassDescriptionFlags", "flags", false, false, indents + 1, dump_json_VkSubpassDescriptionFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineBindPoint>(object.pipelineBindPoint, NULL, settings, "VkPipelineBindPoint", "pipelineBindPoint", false, false, indents + 1, dump_json_VkPipelineBindPoint);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.viewMask, NULL, settings, "uint32_t", "viewMask", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.inputAttachmentCount, NULL, settings, "uint32_t", "inputAttachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkAttachmentReference2>(object.pInputAttachments, object.inputAttachmentCount, settings, "const VkAttachmentReference2*", "const VkAttachmentReference2", "pInputAttachments", true, false, indents + 1, dump_json_VkAttachmentReference2); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.colorAttachmentCount, NULL, settings, "uint32_t", "colorAttachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkAttachmentReference2>(object.pColorAttachments, object.colorAttachmentCount, settings, "const VkAttachmentReference2*", "const VkAttachmentReference2", "pColorAttachments", true, false, indents + 1, dump_json_VkAttachmentReference2); // JQA
    settings.stream() << ",\n";
    dump_json_array<const VkAttachmentReference2>(object.pResolveAttachments, object.colorAttachmentCount, settings, "const VkAttachmentReference2*", "const VkAttachmentReference2", "pResolveAttachments", true, false, indents + 1, dump_json_VkAttachmentReference2); // JQA
    settings.stream() << ",\n";
    dump_json_pointer<const VkAttachmentReference2>(object.pDepthStencilAttachment, settings, "const VkAttachmentReference2*", "pDepthStencilAttachment", true, false, indents + 1, dump_json_VkAttachmentReference2);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.preserveAttachmentCount, NULL, settings, "uint32_t", "preserveAttachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pPreserveAttachments, object.preserveAttachmentCount, settings, "const uint32_t*", "const uint32_t", "pPreserveAttachments", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSubpassDependency2(const VkSubpassDependency2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.srcSubpass, NULL, settings, "uint32_t", "srcSubpass", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstSubpass, NULL, settings, "uint32_t", "dstSubpass", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags>(object.srcStageMask, NULL, settings, "VkPipelineStageFlags", "srcStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags>(object.dstStageMask, NULL, settings, "VkPipelineStageFlags", "dstStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags>(object.srcAccessMask, NULL, settings, "VkAccessFlags", "srcAccessMask", false, false, indents + 1, dump_json_VkAccessFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags>(object.dstAccessMask, NULL, settings, "VkAccessFlags", "dstAccessMask", false, false, indents + 1, dump_json_VkAccessFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkDependencyFlags>(object.dependencyFlags, NULL, settings, "VkDependencyFlags", "dependencyFlags", false, false, indents + 1, dump_json_VkDependencyFlags);
    settings.stream() << ",\n";
    dump_json_value<const int32_t>(object.viewOffset, NULL, settings, "int32_t", "viewOffset", false, false, indents + 1, dump_json_int32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkRenderPassCreateInfo2(const VkRenderPassCreateInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkRenderPassCreateFlags>(object.flags, NULL, settings, "VkRenderPassCreateFlags", "flags", false, false, indents + 1, dump_json_VkRenderPassCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.attachmentCount, NULL, settings, "uint32_t", "attachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkAttachmentDescription2>(object.pAttachments, object.attachmentCount, settings, "const VkAttachmentDescription2*", "const VkAttachmentDescription2", "pAttachments", true, false, indents + 1, dump_json_VkAttachmentDescription2); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.subpassCount, NULL, settings, "uint32_t", "subpassCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSubpassDescription2>(object.pSubpasses, object.subpassCount, settings, "const VkSubpassDescription2*", "const VkSubpassDescription2", "pSubpasses", true, false, indents + 1, dump_json_VkSubpassDescription2); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dependencyCount, NULL, settings, "uint32_t", "dependencyCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSubpassDependency2>(object.pDependencies, object.dependencyCount, settings, "const VkSubpassDependency2*", "const VkSubpassDependency2", "pDependencies", true, false, indents + 1, dump_json_VkSubpassDependency2); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.correlatedViewMaskCount, NULL, settings, "uint32_t", "correlatedViewMaskCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pCorrelatedViewMasks, object.correlatedViewMaskCount, settings, "const uint32_t*", "const uint32_t", "pCorrelatedViewMasks", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSubpassBeginInfo(const VkSubpassBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSubpassContents>(object.contents, NULL, settings, "VkSubpassContents", "contents", false, false, indents + 1, dump_json_VkSubpassContents);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSubpassEndInfo(const VkSubpassEndInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDevice8BitStorageFeatures(const VkPhysicalDevice8BitStorageFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storageBuffer8BitAccess, NULL, settings, "VkBool32", "storageBuffer8BitAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.uniformAndStorageBuffer8BitAccess, NULL, settings, "VkBool32", "uniformAndStorageBuffer8BitAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storagePushConstant8, NULL, settings, "VkBool32", "storagePushConstant8", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceDriverProperties(const VkPhysicalDeviceDriverProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDriverId>(object.driverID, NULL, settings, "VkDriverId", "driverID", false, false, indents + 1, dump_json_VkDriverId);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.driverName, NULL, settings, "char[VK_MAX_DRIVER_NAME_SIZE]", "driverName", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.driverInfo, NULL, settings, "char[VK_MAX_DRIVER_INFO_SIZE]", "driverInfo", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const VkConformanceVersion>(object.conformanceVersion, NULL, settings, "VkConformanceVersion", "conformanceVersion", true, false, indents + 1, dump_json_VkConformanceVersion);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceShaderAtomicInt64Features(const VkPhysicalDeviceShaderAtomicInt64Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderBufferInt64Atomics, NULL, settings, "VkBool32", "shaderBufferInt64Atomics", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSharedInt64Atomics, NULL, settings, "VkBool32", "shaderSharedInt64Atomics", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceShaderFloat16Int8Features(const VkPhysicalDeviceShaderFloat16Int8Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderFloat16, NULL, settings, "VkBool32", "shaderFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderInt8, NULL, settings, "VkBool32", "shaderInt8", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceFloatControlsProperties(const VkPhysicalDeviceFloatControlsProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkShaderFloatControlsIndependence>(object.denormBehaviorIndependence, NULL, settings, "VkShaderFloatControlsIndependence", "denormBehaviorIndependence", false, false, indents + 1, dump_json_VkShaderFloatControlsIndependence);
    settings.stream() << ",\n";
    dump_json_value<const VkShaderFloatControlsIndependence>(object.roundingModeIndependence, NULL, settings, "VkShaderFloatControlsIndependence", "roundingModeIndependence", false, false, indents + 1, dump_json_VkShaderFloatControlsIndependence);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat16, NULL, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat32, NULL, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSignedZeroInfNanPreserveFloat64, NULL, settings, "VkBool32", "shaderSignedZeroInfNanPreserveFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormPreserveFloat16, NULL, settings, "VkBool32", "shaderDenormPreserveFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormPreserveFloat32, NULL, settings, "VkBool32", "shaderDenormPreserveFloat32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormPreserveFloat64, NULL, settings, "VkBool32", "shaderDenormPreserveFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormFlushToZeroFloat16, NULL, settings, "VkBool32", "shaderDenormFlushToZeroFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormFlushToZeroFloat32, NULL, settings, "VkBool32", "shaderDenormFlushToZeroFloat32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDenormFlushToZeroFloat64, NULL, settings, "VkBool32", "shaderDenormFlushToZeroFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTEFloat16, NULL, settings, "VkBool32", "shaderRoundingModeRTEFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTEFloat32, NULL, settings, "VkBool32", "shaderRoundingModeRTEFloat32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTEFloat64, NULL, settings, "VkBool32", "shaderRoundingModeRTEFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTZFloat16, NULL, settings, "VkBool32", "shaderRoundingModeRTZFloat16", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTZFloat32, NULL, settings, "VkBool32", "shaderRoundingModeRTZFloat32", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderRoundingModeRTZFloat64, NULL, settings, "VkBool32", "shaderRoundingModeRTZFloat64", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorSetLayoutBindingFlagsCreateInfo(const VkDescriptorSetLayoutBindingFlagsCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bindingCount, NULL, settings, "uint32_t", "bindingCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkDescriptorBindingFlags>(object.pBindingFlags, object.bindingCount, settings, "const VkDescriptorBindingFlags*", "const VkDescriptorBindingFlags", "pBindingFlags", false, false, indents + 1, dump_json_VkDescriptorBindingFlags); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceDescriptorIndexingFeatures(const VkPhysicalDeviceDescriptorIndexingFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderInputAttachmentArrayDynamicIndexing, NULL, settings, "VkBool32", "shaderInputAttachmentArrayDynamicIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderUniformTexelBufferArrayDynamicIndexing, NULL, settings, "VkBool32", "shaderUniformTexelBufferArrayDynamicIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageTexelBufferArrayDynamicIndexing, NULL, settings, "VkBool32", "shaderStorageTexelBufferArrayDynamicIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderUniformBufferArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderUniformBufferArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSampledImageArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderSampledImageArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageBufferArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderStorageBufferArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageImageArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderStorageImageArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderInputAttachmentArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderInputAttachmentArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderUniformTexelBufferArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderUniformTexelBufferArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageTexelBufferArrayNonUniformIndexing, NULL, settings, "VkBool32", "shaderStorageTexelBufferArrayNonUniformIndexing", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingUniformBufferUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingUniformBufferUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingSampledImageUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingSampledImageUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingStorageImageUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingStorageImageUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingStorageBufferUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingStorageBufferUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingUniformTexelBufferUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingUniformTexelBufferUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingStorageTexelBufferUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingStorageTexelBufferUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingUpdateUnusedWhilePending, NULL, settings, "VkBool32", "descriptorBindingUpdateUnusedWhilePending", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingPartiallyBound, NULL, settings, "VkBool32", "descriptorBindingPartiallyBound", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingVariableDescriptorCount, NULL, settings, "VkBool32", "descriptorBindingVariableDescriptorCount", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.runtimeDescriptorArray, NULL, settings, "VkBool32", "runtimeDescriptorArray", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceDescriptorIndexingProperties(const VkPhysicalDeviceDescriptorIndexingProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxUpdateAfterBindDescriptorsInAllPools, NULL, settings, "uint32_t", "maxUpdateAfterBindDescriptorsInAllPools", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderUniformBufferArrayNonUniformIndexingNative, NULL, settings, "VkBool32", "shaderUniformBufferArrayNonUniformIndexingNative", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSampledImageArrayNonUniformIndexingNative, NULL, settings, "VkBool32", "shaderSampledImageArrayNonUniformIndexingNative", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageBufferArrayNonUniformIndexingNative, NULL, settings, "VkBool32", "shaderStorageBufferArrayNonUniformIndexingNative", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderStorageImageArrayNonUniformIndexingNative, NULL, settings, "VkBool32", "shaderStorageImageArrayNonUniformIndexingNative", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderInputAttachmentArrayNonUniformIndexingNative, NULL, settings, "VkBool32", "shaderInputAttachmentArrayNonUniformIndexingNative", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.robustBufferAccessUpdateAfterBind, NULL, settings, "VkBool32", "robustBufferAccessUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.quadDivergentImplicitLod, NULL, settings, "VkBool32", "quadDivergentImplicitLod", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindSamplers, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindSamplers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindUniformBuffers, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindUniformBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindStorageBuffers, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindStorageBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindSampledImages, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindSampledImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindStorageImages, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindStorageImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindInputAttachments, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindInputAttachments", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageUpdateAfterBindResources, NULL, settings, "uint32_t", "maxPerStageUpdateAfterBindResources", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindSamplers, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindSamplers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindUniformBuffers, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindUniformBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageBuffers, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageBuffers", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindSampledImages, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindSampledImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindStorageImages, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindStorageImages", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindInputAttachments, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindInputAttachments", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorSetVariableDescriptorCountAllocateInfo(const VkDescriptorSetVariableDescriptorCountAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.descriptorSetCount, NULL, settings, "uint32_t", "descriptorSetCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint32_t>(object.pDescriptorCounts, object.descriptorSetCount, settings, "const uint32_t*", "const uint32_t", "pDescriptorCounts", false, false, indents + 1, dump_json_uint32_t); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDescriptorSetVariableDescriptorCountLayoutSupport(const VkDescriptorSetVariableDescriptorCountLayoutSupport& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxVariableDescriptorCount, NULL, settings, "uint32_t", "maxVariableDescriptorCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSubpassDescriptionDepthStencilResolve(const VkSubpassDescriptionDepthStencilResolve& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkResolveModeFlagBits>(object.depthResolveMode, NULL, settings, "VkResolveModeFlagBits", "depthResolveMode", false, false, indents + 1, dump_json_VkResolveModeFlagBits);
    settings.stream() << ",\n";
    dump_json_value<const VkResolveModeFlagBits>(object.stencilResolveMode, NULL, settings, "VkResolveModeFlagBits", "stencilResolveMode", false, false, indents + 1, dump_json_VkResolveModeFlagBits);
    settings.stream() << ",\n";
    dump_json_pointer<const VkAttachmentReference2>(object.pDepthStencilResolveAttachment, settings, "const VkAttachmentReference2*", "pDepthStencilResolveAttachment", true, false, indents + 1, dump_json_VkAttachmentReference2);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceDepthStencilResolveProperties(const VkPhysicalDeviceDepthStencilResolveProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkResolveModeFlags>(object.supportedDepthResolveModes, NULL, settings, "VkResolveModeFlags", "supportedDepthResolveModes", false, false, indents + 1, dump_json_VkResolveModeFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkResolveModeFlags>(object.supportedStencilResolveModes, NULL, settings, "VkResolveModeFlags", "supportedStencilResolveModes", false, false, indents + 1, dump_json_VkResolveModeFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.independentResolveNone, NULL, settings, "VkBool32", "independentResolveNone", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.independentResolve, NULL, settings, "VkBool32", "independentResolve", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceScalarBlockLayoutFeatures(const VkPhysicalDeviceScalarBlockLayoutFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.scalarBlockLayout, NULL, settings, "VkBool32", "scalarBlockLayout", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageStencilUsageCreateInfo(const VkImageStencilUsageCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageUsageFlags>(object.stencilUsage, NULL, settings, "VkImageUsageFlags", "stencilUsage", false, false, indents + 1, dump_json_VkImageUsageFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSamplerReductionModeCreateInfo(const VkSamplerReductionModeCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSamplerReductionMode>(object.reductionMode, NULL, settings, "VkSamplerReductionMode", "reductionMode", false, false, indents + 1, dump_json_VkSamplerReductionMode);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceSamplerFilterMinmaxProperties(const VkPhysicalDeviceSamplerFilterMinmaxProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.filterMinmaxSingleComponentFormats, NULL, settings, "VkBool32", "filterMinmaxSingleComponentFormats", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.filterMinmaxImageComponentMapping, NULL, settings, "VkBool32", "filterMinmaxImageComponentMapping", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceVulkanMemoryModelFeatures(const VkPhysicalDeviceVulkanMemoryModelFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.vulkanMemoryModel, NULL, settings, "VkBool32", "vulkanMemoryModel", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.vulkanMemoryModelDeviceScope, NULL, settings, "VkBool32", "vulkanMemoryModelDeviceScope", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.vulkanMemoryModelAvailabilityVisibilityChains, NULL, settings, "VkBool32", "vulkanMemoryModelAvailabilityVisibilityChains", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceImagelessFramebufferFeatures(const VkPhysicalDeviceImagelessFramebufferFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.imagelessFramebuffer, NULL, settings, "VkBool32", "imagelessFramebuffer", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkFramebufferAttachmentImageInfo(const VkFramebufferAttachmentImageInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageCreateFlags>(object.flags, NULL, settings, "VkImageCreateFlags", "flags", false, false, indents + 1, dump_json_VkImageCreateFlags);
    settings.stream() << ",\n";
    dump_json_value<const VkImageUsageFlags>(object.usage, NULL, settings, "VkImageUsageFlags", "usage", false, false, indents + 1, dump_json_VkImageUsageFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.width, NULL, settings, "uint32_t", "width", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.height, NULL, settings, "uint32_t", "height", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.layerCount, NULL, settings, "uint32_t", "layerCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.viewFormatCount, NULL, settings, "uint32_t", "viewFormatCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkFormat>(object.pViewFormats, object.viewFormatCount, settings, "const VkFormat*", "const VkFormat", "pViewFormats", false, false, indents + 1, dump_json_VkFormat); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkFramebufferAttachmentsCreateInfo(const VkFramebufferAttachmentsCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.attachmentImageInfoCount, NULL, settings, "uint32_t", "attachmentImageInfoCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkFramebufferAttachmentImageInfo>(object.pAttachmentImageInfos, object.attachmentImageInfoCount, settings, "const VkFramebufferAttachmentImageInfo*", "const VkFramebufferAttachmentImageInfo", "pAttachmentImageInfos", true, false, indents + 1, dump_json_VkFramebufferAttachmentImageInfo); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkRenderPassAttachmentBeginInfo(const VkRenderPassAttachmentBeginInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.attachmentCount, NULL, settings, "uint32_t", "attachmentCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkImageView>(object.pAttachments, object.attachmentCount, settings, "const VkImageView*", "const VkImageView", "pAttachments", false, false, indents + 1, dump_json_VkImageView); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.uniformBufferStandardLayout, NULL, settings, "VkBool32", "uniformBufferStandardLayout", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderSubgroupExtendedTypes, NULL, settings, "VkBool32", "shaderSubgroupExtendedTypes", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.separateDepthStencilLayouts, NULL, settings, "VkBool32", "separateDepthStencilLayouts", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkAttachmentReferenceStencilLayout(const VkAttachmentReferenceStencilLayout& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.stencilLayout, NULL, settings, "VkImageLayout", "stencilLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkAttachmentDescriptionStencilLayout(const VkAttachmentDescriptionStencilLayout& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.stencilInitialLayout, NULL, settings, "VkImageLayout", "stencilInitialLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.stencilFinalLayout, NULL, settings, "VkImageLayout", "stencilFinalLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceHostQueryResetFeatures(const VkPhysicalDeviceHostQueryResetFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.hostQueryReset, NULL, settings, "VkBool32", "hostQueryReset", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceTimelineSemaphoreFeatures(const VkPhysicalDeviceTimelineSemaphoreFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.timelineSemaphore, NULL, settings, "VkBool32", "timelineSemaphore", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceTimelineSemaphoreProperties(const VkPhysicalDeviceTimelineSemaphoreProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint64_t>(object.maxTimelineSemaphoreValueDifference, NULL, settings, "uint64_t", "maxTimelineSemaphoreValueDifference", false, false, indents + 1, dump_json_uint64_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSemaphoreTypeCreateInfo(const VkSemaphoreTypeCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSemaphoreType>(object.semaphoreType, NULL, settings, "VkSemaphoreType", "semaphoreType", false, false, indents + 1, dump_json_VkSemaphoreType);
    settings.stream() << ",\n";
    dump_json_value<const uint64_t>(object.initialValue, NULL, settings, "uint64_t", "initialValue", false, false, indents + 1, dump_json_uint64_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkTimelineSemaphoreSubmitInfo(const VkTimelineSemaphoreSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.waitSemaphoreValueCount, NULL, settings, "uint32_t", "waitSemaphoreValueCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint64_t>(object.pWaitSemaphoreValues, object.waitSemaphoreValueCount, settings, "const uint64_t*", "const uint64_t", "pWaitSemaphoreValues", false, false, indents + 1, dump_json_uint64_t); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.signalSemaphoreValueCount, NULL, settings, "uint32_t", "signalSemaphoreValueCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const uint64_t>(object.pSignalSemaphoreValues, object.signalSemaphoreValueCount, settings, "const uint64_t*", "const uint64_t", "pSignalSemaphoreValues", false, false, indents + 1, dump_json_uint64_t); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSemaphoreWaitInfo(const VkSemaphoreWaitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSemaphoreWaitFlags>(object.flags, NULL, settings, "VkSemaphoreWaitFlags", "flags", false, false, indents + 1, dump_json_VkSemaphoreWaitFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.semaphoreCount, NULL, settings, "uint32_t", "semaphoreCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSemaphore>(object.pSemaphores, object.semaphoreCount, settings, "const VkSemaphore*", "const VkSemaphore", "pSemaphores", false, false, indents + 1, dump_json_VkSemaphore); // JQA
    settings.stream() << ",\n";
    dump_json_array<const uint64_t>(object.pValues, object.semaphoreCount, settings, "const uint64_t*", "const uint64_t", "pValues", false, false, indents + 1, dump_json_uint64_t); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSemaphoreSignalInfo(const VkSemaphoreSignalInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSemaphore>(object.semaphore, NULL, settings, "VkSemaphore", "semaphore", false, false, indents + 1, dump_json_VkSemaphore);
    settings.stream() << ",\n";
    dump_json_value<const uint64_t>(object.value, NULL, settings, "uint64_t", "value", false, false, indents + 1, dump_json_uint64_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceBufferDeviceAddressFeatures(const VkPhysicalDeviceBufferDeviceAddressFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.bufferDeviceAddress, NULL, settings, "VkBool32", "bufferDeviceAddress", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.bufferDeviceAddressCaptureReplay, NULL, settings, "VkBool32", "bufferDeviceAddressCaptureReplay", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.bufferDeviceAddressMultiDevice, NULL, settings, "VkBool32", "bufferDeviceAddressMultiDevice", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferDeviceAddressInfo(const VkBufferDeviceAddressInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.buffer, NULL, settings, "VkBuffer", "buffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferOpaqueCaptureAddressCreateInfo(const VkBufferOpaqueCaptureAddressCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint64_t>(object.opaqueCaptureAddress, NULL, settings, "uint64_t", "opaqueCaptureAddress", false, false, indents + 1, dump_json_uint64_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryOpaqueCaptureAddressAllocateInfo(const VkMemoryOpaqueCaptureAddressAllocateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint64_t>(object.opaqueCaptureAddress, NULL, settings, "uint64_t", "opaqueCaptureAddress", false, false, indents + 1, dump_json_uint64_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDeviceMemoryOpaqueCaptureAddressInfo(const VkDeviceMemoryOpaqueCaptureAddressInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceMemory>(object.memory, NULL, settings, "VkDeviceMemory", "memory", false, false, indents + 1, dump_json_VkDeviceMemory);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceVulkan13Features(const VkPhysicalDeviceVulkan13Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.robustImageAccess, NULL, settings, "VkBool32", "robustImageAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.inlineUniformBlock, NULL, settings, "VkBool32", "inlineUniformBlock", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.descriptorBindingInlineUniformBlockUpdateAfterBind, NULL, settings, "VkBool32", "descriptorBindingInlineUniformBlockUpdateAfterBind", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.pipelineCreationCacheControl, NULL, settings, "VkBool32", "pipelineCreationCacheControl", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.privateData, NULL, settings, "VkBool32", "privateData", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDemoteToHelperInvocation, NULL, settings, "VkBool32", "shaderDemoteToHelperInvocation", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderTerminateInvocation, NULL, settings, "VkBool32", "shaderTerminateInvocation", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.subgroupSizeControl, NULL, settings, "VkBool32", "subgroupSizeControl", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.computeFullSubgroups, NULL, settings, "VkBool32", "computeFullSubgroups", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.synchronization2, NULL, settings, "VkBool32", "synchronization2", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.textureCompressionASTC_HDR, NULL, settings, "VkBool32", "textureCompressionASTC_HDR", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderZeroInitializeWorkgroupMemory, NULL, settings, "VkBool32", "shaderZeroInitializeWorkgroupMemory", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.dynamicRendering, NULL, settings, "VkBool32", "dynamicRendering", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderIntegerDotProduct, NULL, settings, "VkBool32", "shaderIntegerDotProduct", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.maintenance4, NULL, settings, "VkBool32", "maintenance4", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceVulkan13Properties(const VkPhysicalDeviceVulkan13Properties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.minSubgroupSize, NULL, settings, "uint32_t", "minSubgroupSize", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxSubgroupSize, NULL, settings, "uint32_t", "maxSubgroupSize", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxComputeWorkgroupSubgroups, NULL, settings, "uint32_t", "maxComputeWorkgroupSubgroups", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkShaderStageFlags>(object.requiredSubgroupSizeStages, NULL, settings, "VkShaderStageFlags", "requiredSubgroupSizeStages", false, false, indents + 1, dump_json_VkShaderStageFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxInlineUniformBlockSize, NULL, settings, "uint32_t", "maxInlineUniformBlockSize", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorInlineUniformBlocks, NULL, settings, "uint32_t", "maxPerStageDescriptorInlineUniformBlocks", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks, NULL, settings, "uint32_t", "maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetInlineUniformBlocks, NULL, settings, "uint32_t", "maxDescriptorSetInlineUniformBlocks", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxDescriptorSetUpdateAfterBindInlineUniformBlocks, NULL, settings, "uint32_t", "maxDescriptorSetUpdateAfterBindInlineUniformBlocks", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.maxInlineUniformTotalSize, NULL, settings, "uint32_t", "maxInlineUniformTotalSize", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct8BitUnsignedAccelerated, NULL, settings, "VkBool32", "integerDotProduct8BitUnsignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct8BitSignedAccelerated, NULL, settings, "VkBool32", "integerDotProduct8BitSignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct8BitMixedSignednessAccelerated, NULL, settings, "VkBool32", "integerDotProduct8BitMixedSignednessAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct4x8BitPackedUnsignedAccelerated, NULL, settings, "VkBool32", "integerDotProduct4x8BitPackedUnsignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct4x8BitPackedSignedAccelerated, NULL, settings, "VkBool32", "integerDotProduct4x8BitPackedSignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct4x8BitPackedMixedSignednessAccelerated, NULL, settings, "VkBool32", "integerDotProduct4x8BitPackedMixedSignednessAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct16BitUnsignedAccelerated, NULL, settings, "VkBool32", "integerDotProduct16BitUnsignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct16BitSignedAccelerated, NULL, settings, "VkBool32", "integerDotProduct16BitSignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct16BitMixedSignednessAccelerated, NULL, settings, "VkBool32", "integerDotProduct16BitMixedSignednessAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct32BitUnsignedAccelerated, NULL, settings, "VkBool32", "integerDotProduct32BitUnsignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct32BitSignedAccelerated, NULL, settings, "VkBool32", "integerDotProduct32BitSignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct32BitMixedSignednessAccelerated, NULL, settings, "VkBool32", "integerDotProduct32BitMixedSignednessAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct64BitUnsignedAccelerated, NULL, settings, "VkBool32", "integerDotProduct64BitUnsignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct64BitSignedAccelerated, NULL, settings, "VkBool32", "integerDotProduct64BitSignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProduct64BitMixedSignednessAccelerated, NULL, settings, "VkBool32", "integerDotProduct64BitMixedSignednessAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating8BitUnsignedAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating8BitUnsignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating8BitSignedAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating8BitSignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating16BitUnsignedAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating16BitUnsignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating16BitSignedAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating16BitSignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating32BitUnsignedAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating32BitUnsignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating32BitSignedAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating32BitSignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating64BitUnsignedAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating64BitUnsignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating64BitSignedAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating64BitSignedAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated, NULL, settings, "VkBool32", "integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.storageTexelBufferOffsetAlignmentBytes, NULL, settings, "VkDeviceSize", "storageTexelBufferOffsetAlignmentBytes", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.storageTexelBufferOffsetSingleTexelAlignment, NULL, settings, "VkBool32", "storageTexelBufferOffsetSingleTexelAlignment", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.uniformTexelBufferOffsetAlignmentBytes, NULL, settings, "VkDeviceSize", "uniformTexelBufferOffsetAlignmentBytes", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.uniformTexelBufferOffsetSingleTexelAlignment, NULL, settings, "VkBool32", "uniformTexelBufferOffsetSingleTexelAlignment", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.maxBufferSize, NULL, settings, "VkDeviceSize", "maxBufferSize", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineCreationFeedback(const VkPipelineCreationFeedback& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkPipelineCreationFeedbackFlags>(object.flags, NULL, settings, "VkPipelineCreationFeedbackFlags", "flags", false, false, indents + 1, dump_json_VkPipelineCreationFeedbackFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint64_t>(object.duration, NULL, settings, "uint64_t", "duration", false, false, indents + 1, dump_json_uint64_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPipelineCreationFeedbackCreateInfo(const VkPipelineCreationFeedbackCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_pointer<const VkPipelineCreationFeedback>(object.pPipelineCreationFeedback, settings, "VkPipelineCreationFeedback*", "pPipelineCreationFeedback", true, false, indents + 1, dump_json_VkPipelineCreationFeedback);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.pipelineStageCreationFeedbackCount, NULL, settings, "uint32_t", "pipelineStageCreationFeedbackCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkPipelineCreationFeedback>(object.pPipelineStageCreationFeedbacks, object.pipelineStageCreationFeedbackCount, settings, "VkPipelineCreationFeedback*", "VkPipelineCreationFeedback", "pPipelineStageCreationFeedbacks", true, false, indents + 1, dump_json_VkPipelineCreationFeedback); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceShaderTerminateInvocationFeatures(const VkPhysicalDeviceShaderTerminateInvocationFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderTerminateInvocation, NULL, settings, "VkBool32", "shaderTerminateInvocation", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceToolProperties(const VkPhysicalDeviceToolProperties& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.name, NULL, settings, "char[VK_MAX_EXTENSION_NAME_SIZE]", "name", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.version, NULL, settings, "char[VK_MAX_EXTENSION_NAME_SIZE]", "version", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const VkToolPurposeFlags>(object.purposes, NULL, settings, "VkToolPurposeFlags", "purposes", false, false, indents + 1, dump_json_VkToolPurposeFlags);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.description, NULL, settings, "char[VK_MAX_DESCRIPTION_SIZE]", "description", false, false, indents + 1, dump_json_cstring);
    settings.stream() << ",\n";
    dump_json_value<const char*>(object.layer, NULL, settings, "char[VK_MAX_EXTENSION_NAME_SIZE]", "layer", false, false, indents + 1, dump_json_cstring);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderDemoteToHelperInvocation, NULL, settings, "VkBool32", "shaderDemoteToHelperInvocation", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDevicePrivateDataFeatures(const VkPhysicalDevicePrivateDataFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.privateData, NULL, settings, "VkBool32", "privateData", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDevicePrivateDataCreateInfo(const VkDevicePrivateDataCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.privateDataSlotRequestCount, NULL, settings, "uint32_t", "privateDataSlotRequestCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPrivateDataSlotCreateInfo(const VkPrivateDataSlotCreateInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPrivateDataSlotCreateFlags>(object.flags, NULL, settings, "VkPrivateDataSlotCreateFlags", "flags", false, false, indents + 1, dump_json_VkPrivateDataSlotCreateFlags);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDevicePipelineCreationCacheControlFeatures(const VkPhysicalDevicePipelineCreationCacheControlFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.pipelineCreationCacheControl, NULL, settings, "VkBool32", "pipelineCreationCacheControl", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkMemoryBarrier2(const VkMemoryBarrier2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags2>(object.srcStageMask, NULL, settings, "VkPipelineStageFlags2", "srcStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags2);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags2>(object.srcAccessMask, NULL, settings, "VkAccessFlags2", "srcAccessMask", false, false, indents + 1, dump_json_VkAccessFlags2);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags2>(object.dstStageMask, NULL, settings, "VkPipelineStageFlags2", "dstStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags2);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags2>(object.dstAccessMask, NULL, settings, "VkAccessFlags2", "dstAccessMask", false, false, indents + 1, dump_json_VkAccessFlags2);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferMemoryBarrier2(const VkBufferMemoryBarrier2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags2>(object.srcStageMask, NULL, settings, "VkPipelineStageFlags2", "srcStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags2);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags2>(object.srcAccessMask, NULL, settings, "VkAccessFlags2", "srcAccessMask", false, false, indents + 1, dump_json_VkAccessFlags2);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags2>(object.dstStageMask, NULL, settings, "VkPipelineStageFlags2", "dstStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags2);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags2>(object.dstAccessMask, NULL, settings, "VkAccessFlags2", "dstAccessMask", false, false, indents + 1, dump_json_VkAccessFlags2);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.srcQueueFamilyIndex, NULL, settings, "uint32_t", "srcQueueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstQueueFamilyIndex, NULL, settings, "uint32_t", "dstQueueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.buffer, NULL, settings, "VkBuffer", "buffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.offset, NULL, settings, "VkDeviceSize", "offset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.size, NULL, settings, "VkDeviceSize", "size", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageMemoryBarrier2(const VkImageMemoryBarrier2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags2>(object.srcStageMask, NULL, settings, "VkPipelineStageFlags2", "srcStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags2);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags2>(object.srcAccessMask, NULL, settings, "VkAccessFlags2", "srcAccessMask", false, false, indents + 1, dump_json_VkAccessFlags2);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags2>(object.dstStageMask, NULL, settings, "VkPipelineStageFlags2", "dstStageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags2);
    settings.stream() << ",\n";
    dump_json_value<const VkAccessFlags2>(object.dstAccessMask, NULL, settings, "VkAccessFlags2", "dstAccessMask", false, false, indents + 1, dump_json_VkAccessFlags2);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.oldLayout, NULL, settings, "VkImageLayout", "oldLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.newLayout, NULL, settings, "VkImageLayout", "newLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.srcQueueFamilyIndex, NULL, settings, "uint32_t", "srcQueueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.dstQueueFamilyIndex, NULL, settings, "uint32_t", "dstQueueFamilyIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.image, NULL, settings, "VkImage", "image", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceRange>(object.subresourceRange, NULL, settings, "VkImageSubresourceRange", "subresourceRange", true, false, indents + 1, dump_json_VkImageSubresourceRange);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkDependencyInfo(const VkDependencyInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDependencyFlags>(object.dependencyFlags, NULL, settings, "VkDependencyFlags", "dependencyFlags", false, false, indents + 1, dump_json_VkDependencyFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.memoryBarrierCount, NULL, settings, "uint32_t", "memoryBarrierCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkMemoryBarrier2>(object.pMemoryBarriers, object.memoryBarrierCount, settings, "const VkMemoryBarrier2*", "const VkMemoryBarrier2", "pMemoryBarriers", true, false, indents + 1, dump_json_VkMemoryBarrier2); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bufferMemoryBarrierCount, NULL, settings, "uint32_t", "bufferMemoryBarrierCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkBufferMemoryBarrier2>(object.pBufferMemoryBarriers, object.bufferMemoryBarrierCount, settings, "const VkBufferMemoryBarrier2*", "const VkBufferMemoryBarrier2", "pBufferMemoryBarriers", true, false, indents + 1, dump_json_VkBufferMemoryBarrier2); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.imageMemoryBarrierCount, NULL, settings, "uint32_t", "imageMemoryBarrierCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkImageMemoryBarrier2>(object.pImageMemoryBarriers, object.imageMemoryBarrierCount, settings, "const VkImageMemoryBarrier2*", "const VkImageMemoryBarrier2", "pImageMemoryBarriers", true, false, indents + 1, dump_json_VkImageMemoryBarrier2); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSemaphoreSubmitInfo(const VkSemaphoreSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSemaphore>(object.semaphore, NULL, settings, "VkSemaphore", "semaphore", false, false, indents + 1, dump_json_VkSemaphore);
    settings.stream() << ",\n";
    dump_json_value<const uint64_t>(object.value, NULL, settings, "uint64_t", "value", false, false, indents + 1, dump_json_uint64_t);
    settings.stream() << ",\n";
    dump_json_value<const VkPipelineStageFlags2>(object.stageMask, NULL, settings, "VkPipelineStageFlags2", "stageMask", false, false, indents + 1, dump_json_VkPipelineStageFlags2);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceIndex, NULL, settings, "uint32_t", "deviceIndex", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkCommandBufferSubmitInfo(const VkCommandBufferSubmitInfo& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkCommandBuffer>(object.commandBuffer, NULL, settings, "VkCommandBuffer", "commandBuffer", false, false, indents + 1, dump_json_VkCommandBuffer);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.deviceMask, NULL, settings, "uint32_t", "deviceMask", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkSubmitInfo2(const VkSubmitInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkSubmitFlags>(object.flags, NULL, settings, "VkSubmitFlags", "flags", false, false, indents + 1, dump_json_VkSubmitFlags);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.waitSemaphoreInfoCount, NULL, settings, "uint32_t", "waitSemaphoreInfoCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSemaphoreSubmitInfo>(object.pWaitSemaphoreInfos, object.waitSemaphoreInfoCount, settings, "const VkSemaphoreSubmitInfo*", "const VkSemaphoreSubmitInfo", "pWaitSemaphoreInfos", true, false, indents + 1, dump_json_VkSemaphoreSubmitInfo); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.commandBufferInfoCount, NULL, settings, "uint32_t", "commandBufferInfoCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkCommandBufferSubmitInfo>(object.pCommandBufferInfos, object.commandBufferInfoCount, settings, "const VkCommandBufferSubmitInfo*", "const VkCommandBufferSubmitInfo", "pCommandBufferInfos", true, false, indents + 1, dump_json_VkCommandBufferSubmitInfo); // JQA
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.signalSemaphoreInfoCount, NULL, settings, "uint32_t", "signalSemaphoreInfoCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkSemaphoreSubmitInfo>(object.pSignalSemaphoreInfos, object.signalSemaphoreInfoCount, settings, "const VkSemaphoreSubmitInfo*", "const VkSemaphoreSubmitInfo", "pSignalSemaphoreInfos", true, false, indents + 1, dump_json_VkSemaphoreSubmitInfo); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceSynchronization2Features(const VkPhysicalDeviceSynchronization2Features& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.synchronization2, NULL, settings, "VkBool32", "synchronization2", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.shaderZeroInitializeWorkgroupMemory, NULL, settings, "VkBool32", "shaderZeroInitializeWorkgroupMemory", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkPhysicalDeviceImageRobustnessFeatures(const VkPhysicalDeviceImageRobustnessFeatures& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBool32>(object.robustImageAccess, NULL, settings, "VkBool32", "robustImageAccess", false, false, indents + 1, dump_json_VkBool32);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferCopy2(const VkBufferCopy2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.srcOffset, NULL, settings, "VkDeviceSize", "srcOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.dstOffset, NULL, settings, "VkDeviceSize", "dstOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.size, NULL, settings, "VkDeviceSize", "size", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkCopyBufferInfo2(const VkCopyBufferInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.srcBuffer, NULL, settings, "VkBuffer", "srcBuffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.dstBuffer, NULL, settings, "VkBuffer", "dstBuffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.regionCount, NULL, settings, "uint32_t", "regionCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkBufferCopy2>(object.pRegions, object.regionCount, settings, "const VkBufferCopy2*", "const VkBufferCopy2", "pRegions", true, false, indents + 1, dump_json_VkBufferCopy2); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageCopy2(const VkImageCopy2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceLayers>(object.srcSubresource, NULL, settings, "VkImageSubresourceLayers", "srcSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_value<const VkOffset3D>(object.srcOffset, NULL, settings, "VkOffset3D", "srcOffset", true, false, indents + 1, dump_json_VkOffset3D);
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceLayers>(object.dstSubresource, NULL, settings, "VkImageSubresourceLayers", "dstSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_value<const VkOffset3D>(object.dstOffset, NULL, settings, "VkOffset3D", "dstOffset", true, false, indents + 1, dump_json_VkOffset3D);
    settings.stream() << ",\n";
    dump_json_value<const VkExtent3D>(object.extent, NULL, settings, "VkExtent3D", "extent", true, false, indents + 1, dump_json_VkExtent3D);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkCopyImageInfo2(const VkCopyImageInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.srcImage, NULL, settings, "VkImage", "srcImage", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.srcImageLayout, NULL, settings, "VkImageLayout", "srcImageLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.dstImage, NULL, settings, "VkImage", "dstImage", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.dstImageLayout, NULL, settings, "VkImageLayout", "dstImageLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.regionCount, NULL, settings, "uint32_t", "regionCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkImageCopy2>(object.pRegions, object.regionCount, settings, "const VkImageCopy2*", "const VkImageCopy2", "pRegions", true, false, indents + 1, dump_json_VkImageCopy2); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkBufferImageCopy2(const VkBufferImageCopy2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkDeviceSize>(object.bufferOffset, NULL, settings, "VkDeviceSize", "bufferOffset", false, false, indents + 1, dump_json_VkDeviceSize);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bufferRowLength, NULL, settings, "uint32_t", "bufferRowLength", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.bufferImageHeight, NULL, settings, "uint32_t", "bufferImageHeight", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceLayers>(object.imageSubresource, NULL, settings, "VkImageSubresourceLayers", "imageSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_value<const VkOffset3D>(object.imageOffset, NULL, settings, "VkOffset3D", "imageOffset", true, false, indents + 1, dump_json_VkOffset3D);
    settings.stream() << ",\n";
    dump_json_value<const VkExtent3D>(object.imageExtent, NULL, settings, "VkExtent3D", "imageExtent", true, false, indents + 1, dump_json_VkExtent3D);
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkCopyBufferToImageInfo2(const VkCopyBufferToImageInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.srcBuffer, NULL, settings, "VkBuffer", "srcBuffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.dstImage, NULL, settings, "VkImage", "dstImage", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.dstImageLayout, NULL, settings, "VkImageLayout", "dstImageLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.regionCount, NULL, settings, "uint32_t", "regionCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkBufferImageCopy2>(object.pRegions, object.regionCount, settings, "const VkBufferImageCopy2*", "const VkBufferImageCopy2", "pRegions", true, false, indents + 1, dump_json_VkBufferImageCopy2); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkCopyImageToBufferInfo2(const VkCopyImageToBufferInfo2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImage>(object.srcImage, NULL, settings, "VkImage", "srcImage", false, false, indents + 1, dump_json_VkImage);
    settings.stream() << ",\n";
    dump_json_value<const VkImageLayout>(object.srcImageLayout, NULL, settings, "VkImageLayout", "srcImageLayout", false, false, indents + 1, dump_json_VkImageLayout);
    settings.stream() << ",\n";
    dump_json_value<const VkBuffer>(object.dstBuffer, NULL, settings, "VkBuffer", "dstBuffer", false, false, indents + 1, dump_json_VkBuffer);
    settings.stream() << ",\n";
    dump_json_value<const uint32_t>(object.regionCount, NULL, settings, "uint32_t", "regionCount", false, false, indents + 1, dump_json_uint32_t);
    settings.stream() << ",\n";
    dump_json_array<const VkBufferImageCopy2>(object.pRegions, object.regionCount, settings, "const VkBufferImageCopy2*", "const VkBufferImageCopy2", "pRegions", true, false, indents + 1, dump_json_VkBufferImageCopy2); // JQA
    settings.stream() << "\n" << settings.indentation(indents) << "]";
}
void dump_json_VkImageBlit2(const VkImageBlit2& object, const ApiDumpSettings& settings, int indents)
{
    settings.stream() << settings.indentation(indents) << "[\n";
    dump_json_value<const VkStructureType>(object.sType, NULL, settings, "VkStructureType", "sType", false, false, indents + 1, dump_json_VkStructureType);
    settings.stream() << ",\n";
    if(object.pNext != nullptr){
        dump_json_pNext_trampoline(object.pNext, settings, indents + 1);
    } else {
        dump_json_value<const void*>(object.pNext, object.pNext, settings, "const void*", "pNext", false, false, indents + 1, dump_json_void);
    }
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceLayers>(object.srcSubresource, NULL, settings, "VkImageSubresourceLayers", "srcSubresource", true, false, indents + 1, dump_json_VkImageSubresourceLayers);
    settings.stream() << ",\n";
    dump_json_array<const VkOffset3D>(object.srcOffsets, 2, settings, "VkOffset3D[2]", "VkOffset3D", "srcOffsets", true, false, indents + 1, dump_json_VkOffset3D); // IQA
    settings.stream() << ",\n";
    dump_json_value<const VkImageSubresourceLayers>(object.dstSubreso