//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  When items are fetched from server either by using ItemFetchJob explicitly or
    ///  when it is being used internally by other classes, e.g. ItemModel, the scope
    ///  of the fetch operation can be tailored to the application's current needs.
    ///  There are two supported ways of changing the currently active ItemFetchScope
    ///  of classes:
    ///  - in-place: modify the ItemFetchScope object the other class holds as a member
    ///  - replace: replace the other class' member with a new scope object
    ///  Example: modifying an ItemFetchJob's scope <code>in</code>-place
    ///  @code
    ///  Akonadi.ItemFetchJob job = new Akonadi.ItemFetchJob( collection );
    ///  job.FetchScope().fetchFullPayload();
    ///  job.FetchScope().fetchAttribute<MyAttribute>();
    ///  @endcode
    ///  Example: <code>replacing</code> an ItemFetchJob's scope
    ///  @code
    ///  Akonadi.ItemFetchScope scope;
    ///  scope.fetchFullPayload();
    ///  scope.fetchAttribute<MyAttribute>();
    ///  Akonadi.ItemFetchJob job = new Akonadi.ItemFetchJob( collection );
    ///  job.SetFetchScope( scope );
    ///  @endcode
    ///  This class is implicitly shared.
    /// </remarks>        <author> Kevin Krammer <kevin.krammer@gmx.at>
    ///  </author>
    ///         <short> Specifies which parts of an item should be fetched from the Akonadi storage. </short>
    [SmokeClass("Akonadi::ItemFetchScope")]
    public class ItemFetchScope : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected ItemFetchScope(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ItemFetchScope), this);
        }
        // QSet<QByteArray> payloadParts(); >>>> NOT CONVERTED
        // QSet<QByteArray> attributes(); >>>> NOT CONVERTED
        /// <remarks>
        ///  Creates an empty item fetch scope.
        ///  Using an empty scope will only fetch the very basic meta data of items,
        ///  e.g. local id, remote id and mime type
        ///      </remarks>        <short>    Creates an empty item fetch scope.</short>
        public ItemFetchScope() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemFetchScope", "ItemFetchScope()", typeof(void));
        }
        /// <remarks>
        ///  Creates a new item fetch scope from an <code>other.</code>
        ///      </remarks>        <short>    Creates a new item fetch scope from an <code>other.</code></short>
        public ItemFetchScope(Akonadi.ItemFetchScope other) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemFetchScope#", "ItemFetchScope(const Akonadi::ItemFetchScope&)", typeof(void), typeof(Akonadi.ItemFetchScope), other);
        }
        /// <remarks>
        ///  Returns the payload parts that should be fetched.
        /// </remarks>        <short>    Returns the payload parts that should be fetched.</short>
        ///         <see> fetchPayloadPart</see>
        /// <remarks>
        ///  Sets which payload parts shall be fetched.
        /// <param> name="part" The payload part identifier.
        ///              Valid values depend on the item type.
        /// </param><param> name="fetch" <code>true</code> to fetch this part, <code>false</code> otherwise.
        ///      </param></remarks>        <short>    Sets which payload parts shall be fetched.</short>
        public void FetchPayloadPart(QByteArray part, bool fetch) {
            interceptor.Invoke("fetchPayloadPart#$", "fetchPayloadPart(const QByteArray&, bool)", typeof(void), typeof(QByteArray), part, typeof(bool), fetch);
        }
        public void FetchPayloadPart(QByteArray part) {
            interceptor.Invoke("fetchPayloadPart#", "fetchPayloadPart(const QByteArray&)", typeof(void), typeof(QByteArray), part);
        }
        /// <remarks>
        ///  Returns whether the full payload should be fetched.
        /// </remarks>        <short>    Returns whether the full payload should be fetched.</short>
        ///         <see> fetchFullPayload</see>
        public bool FullPayload() {
            return (bool) interceptor.Invoke("fullPayload", "fullPayload() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets whether the full payload shall be fetched.
        /// <param> name="fetch" <code>true</code> if the full payload should be fetched, <code>false</code> otherwise.
        ///      </param></remarks>        <short>    Sets whether the full payload shall be fetched.</short>
        public void FetchFullPayload(bool fetch) {
            interceptor.Invoke("fetchFullPayload$", "fetchFullPayload(bool)", typeof(void), typeof(bool), fetch);
        }
        public void FetchFullPayload() {
            interceptor.Invoke("fetchFullPayload", "fetchFullPayload()", typeof(void));
        }
        /// <remarks>
        ///  Returns all explicitly fetched attributes.
        ///  Undefined if fetchAllAttributes() returns true.
        /// </remarks>        <short>    Returns all explicitly fetched attributes.</short>
        ///         <see> fetchAttribute</see>
        /// <remarks>
        ///  Sets whether the attribute of the given <code>type</code> should be fetched.
        /// <param> name="type" The attribute type to fetch.
        /// </param><param> name="fetch" <code>true</code> if the attribute should be fetched, <code>false</code> otherwise.
        ///      </param></remarks>        <short>    Sets whether the attribute of the given <code>type</code> should be fetched.</short>
        public void FetchAttribute(QByteArray type, bool fetch) {
            interceptor.Invoke("fetchAttribute#$", "fetchAttribute(const QByteArray&, bool)", typeof(void), typeof(QByteArray), type, typeof(bool), fetch);
        }
        public void FetchAttribute(QByteArray type) {
            interceptor.Invoke("fetchAttribute#", "fetchAttribute(const QByteArray&)", typeof(void), typeof(QByteArray), type);
        }
        /// <remarks>
        ///  Returns whether all available attributes should be fetched.
        /// </remarks>        <short>    Returns whether all available attributes should be fetched.</short>
        ///         <see> fetchAllAttributes</see>
        public bool AllAttributes() {
            return (bool) interceptor.Invoke("allAttributes", "allAttributes() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets whether all available attributes should be fetched.
        /// <param> name="fetch" <code>true</code> if all available attributes should be fetched, <code>false</code> otherwise.
        ///      </param></remarks>        <short>    Sets whether all available attributes should be fetched.</short>
        public void FetchAllAttributes(bool fetch) {
            interceptor.Invoke("fetchAllAttributes$", "fetchAllAttributes(bool)", typeof(void), typeof(bool), fetch);
        }
        public void FetchAllAttributes() {
            interceptor.Invoke("fetchAllAttributes", "fetchAllAttributes()", typeof(void));
        }
        /// <remarks>
        ///  Returns whether payload data should be requested from remote sources or just
        ///  from the local cache.
        /// </remarks>        <short>    Returns whether payload data should be requested from remote sources or just  from the local cache.</short>
        ///         <see> setCacheOnly</see>
        public bool CacheOnly() {
            return (bool) interceptor.Invoke("cacheOnly", "cacheOnly() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets whether payload data should be requested from remote sources or just
        ///  from the local cache.
        /// <param> name="cacheOnly" <code>true</code> if no remote data should be requested,
        ///  <code>false</code> otherwise (the default).
        ///      </param></remarks>        <short>    Sets whether payload data should be requested from remote sources or just  from the local cache.</short>
        public void SetCacheOnly(bool cacheOnly) {
            interceptor.Invoke("setCacheOnly$", "setCacheOnly(bool)", typeof(void), typeof(bool), cacheOnly);
        }
        /// <remarks>
        ///  Returns <code>true</code> if there is nothing to fetch.
        ///      </remarks>        <short>    Returns @c true if there is nothing to fetch.</short>
        public bool IsEmpty() {
            return (bool) interceptor.Invoke("isEmpty", "isEmpty() const", typeof(bool));
        }
        ~ItemFetchScope() {
            interceptor.Invoke("~ItemFetchScope", "~ItemFetchScope()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~ItemFetchScope", "~ItemFetchScope()", typeof(void));
        }
    }
}
