/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.concurrent.locks;

import info.aduna.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLock
implements Lock {
    protected Logger logger = null;
    protected boolean isActive = true;
    protected Throwable creatorTrace;

    public AbstractLock() {
        this(null);
    }

    public AbstractLock(boolean enableTrace) {
        this(null, enableTrace);
    }

    public AbstractLock(Logger logger) {
        this(logger, false);
    }

    public AbstractLock(Logger logger, boolean enableTrace) {
        this.logger = logger;
        if (enableTrace) {
            this.creatorTrace = new Throwable();
        }
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        if (this.isActive) {
            try {
                this.releaseLock();
            }
            finally {
                this.isActive = false;
            }
        }
    }

    protected abstract void releaseLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.isActive) {
            if (this.creatorTrace == null) {
                this.getLogger().warn("Releasing active lock due to object destruction; consider setting the {} system property", (Object)"info.aduna.concurrent.locks.trackLocks");
            } else {
                this.getLogger().warn("Releasing active lock due to object destruction; lock was acquired in", this.creatorTrace);
            }
            try {
                this.releaseLock();
            }
            finally {
                this.isActive = false;
            }
        }
        super.finalize();
    }
}

