/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.properties;

import java.beans.PropertyEditorSupport;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriPropertyEditor
extends PropertyEditorSupport {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ValueFactory valueFactory;

    public UriPropertyEditor(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public String getAsText() {
        String result = null;
        URI uri = (URI)this.getValue();
        if (uri != null) {
            result = Protocol.encodeValue(uri);
            this.logger.debug("Getting uri as " + result);
        }
        return result;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (!"".equals(text)) {
            URI uri = Protocol.decodeURI(text, this.valueFactory);
            this.logger.debug("Setting uri to " + uri);
            this.setValue(uri);
        } else {
            this.setValue(null);
        }
    }
}

