/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.LookAheadIteration;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final EvaluationStrategy strategy;
    private final Join join;
    private CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private CloseableIteration<BindingSet, QueryEvaluationException> rightIter;

    public JoinIterator(EvaluationStrategy strategy, Join join, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join;
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        while (this.rightIter != null || this.leftIter.hasNext()) {
            if (this.rightIter == null) {
                this.rightIter = this.strategy.evaluate(this.join.getRightArg(), (BindingSet)this.leftIter.next());
            }
            if (this.rightIter.hasNext()) {
                return (BindingSet)this.rightIter.next();
            }
            this.rightIter.close();
            this.rightIter = null;
        }
        return null;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        if (this.rightIter != null) {
            this.rightIter.close();
            this.rightIter = null;
        }
        this.leftIter.close();
        super.handleClose();
    }
}

