/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.serql;

import java.util.ArrayList;
import java.util.HashSet;
import org.openrdf.query.parser.serql.ASTVisitorBase;
import org.openrdf.query.parser.serql.ast.ASTProjectionElem;
import org.openrdf.query.parser.serql.ast.ASTSelect;
import org.openrdf.query.parser.serql.ast.ASTString;
import org.openrdf.query.parser.serql.ast.ASTVar;
import org.openrdf.query.parser.serql.ast.Node;
import org.openrdf.query.parser.serql.ast.VisitorException;

class ProjectionAliasProcessor
extends ASTVisitorBase {
    ProjectionAliasProcessor() {
    }

    public Object visit(ASTSelect node, Object data) throws VisitorException {
        HashSet<String> aliases = new HashSet<String>();
        ArrayList<Node> unaliasedNodes = new ArrayList<Node>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node projElem = node.jjtGetChild(i);
            assert (projElem instanceof ASTProjectionElem) : "child node is not a projection element";
            Object result = projElem.jjtAccept(this, aliases);
            if (result instanceof String) {
                String alias = (String)result;
                boolean isUnique = aliases.add(alias);
                if (isUnique) continue;
                throw new VisitorException("Duplicate projection element aliases: '" + alias + "'");
            }
            unaliasedNodes.add(projElem);
        }
        int aliasNo = 1;
        for (Node projElem : unaliasedNodes) {
            String alias;
            String varName;
            Node exprNode = projElem.jjtGetChild(0);
            if (exprNode instanceof ASTVar && !aliases.contains(varName = ((ASTVar)exprNode).getName())) {
                aliases.add(varName);
                continue;
            }
            while (aliases.contains(alias = "_" + aliasNo++)) {
            }
            aliases.add(alias);
            ASTString aliasNode = new ASTString(54);
            aliasNode.setValue(alias);
            aliasNode.jjtSetParent(projElem);
            projElem.jjtAppendChild(aliasNode);
        }
        return data;
    }

    public Object visit(ASTProjectionElem node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() >= 2) {
            return node.jjtGetChild(1).jjtAccept(this, data);
        }
        return data;
    }

    public String visit(ASTString node, Object data) throws VisitorException {
        return node.getValue();
    }
}

